<?php
/*
 * This file is part of Part-DB (https://github.com/Part-DB/Part-DB-symfony).
 *
 *  Copyright (C) 2019 - 2023 Jan Böhmer (https://github.com/jbtronics)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


namespace App\Form\Part;

use App\Entity\Parts\AssociationType;
use App\Entity\Parts\PartAssociation;
use App\Form\Type\PartSelectType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EnumType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PartAssociationType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('other', PartSelectType::class, [
                'label' => 'part_association.edit.other_part',
            ])
            ->add('type', EnumType::class, [
                'class' => AssociationType::class,
                'label' => 'part_association.edit.type',
                'choice_label' => fn(AssociationType $type) => $type->getTranslationKey(),
                'help' => 'part_association.edit.type.help',
                'attr' => [
                    'data-pages--association-edit-type-select-target' => 'select'
                ]
            ])
            ->add('other_type', TextType::class, [
                'required' => false,
                'label' => 'part_association.edit.other_type',
                'row_attr' => [
                    'data-pages--association-edit-type-select-target' => 'display'
                ]
            ])
            ->add('comment', TextType::class, [
                'required' => false,
                'label' => 'part_association.edit.comment'
            ])
        ;

    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => PartAssociation::class,
        ]);
    }
}