<?php
/*
 * This file is part of Part-DB (https://github.com/Part-DB/Part-DB-symfony).
 *
 *  Copyright (C) 2019 - 2023 Jan Böhmer (https://github.com/jbtronics)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


namespace App\EventListener;

use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\HttpKernel\Event\ResponseEvent;

#[AsEventListener]
class DisallowSearchEngineIndexingRequestListener
{
    private const HEADER_NAME = 'X-Robots-Tag';

    private readonly bool $enabled;

    public function __construct(#[Autowire(param: 'partdb.demo_mode')] bool $demo_mode)
    {
        // Disable this listener in demo mode
        $this->enabled = !$demo_mode;
    }

    public function __invoke(ResponseEvent $event): void
    {
        //Skip if disabled
        if (!$this->enabled) {
            return;
        }

        if (!$event->getResponse()->headers->has(self::HEADER_NAME)) {
            $event->getResponse()->headers->set(self::HEADER_NAME, 'noindex');
        }
    }
}