'use strict';var SEA3D={VERSION:180150,getVersion:function(){var a=SEA3D.VERSION.toString(),b=a.length;return a.substring(0,b-4)+"."+a.substring(b-4,b-3)+"."+a.substring(b-3,b-2)+"."+parseFloat(a.substring(b-2,b)).toString()}};console.log("SEA3D "+SEA3D.getVersion());SEA3D.Stream=function(a){this.position=0;this.buffer=a||new ArrayBuffer};SEA3D.Stream.NONE=0;SEA3D.Stream.BOOLEAN=1;SEA3D.Stream.BYTE=2;SEA3D.Stream.UBYTE=3;SEA3D.Stream.SHORT=4;SEA3D.Stream.USHORT=5;SEA3D.Stream.INT24=6;
SEA3D.Stream.UINT24=7;SEA3D.Stream.INT=8;SEA3D.Stream.UINT=9;SEA3D.Stream.FLOAT=10;SEA3D.Stream.DOUBLE=11;SEA3D.Stream.DECIMAL=12;SEA3D.Stream.VECTOR3D=74;SEA3D.Stream.VECTOR4D=106;SEA3D.Stream.STRING_TINY=128;SEA3D.Stream.STRING_SHORT=129;SEA3D.Stream.STRING_LONG=130;SEA3D.Stream.ASSET=200;SEA3D.Stream.GROUP=255;SEA3D.Stream.BLEND_MODE="normal add subtract multiply dividing mix alpha screen darken overlay colorburn linearburn lighten colordodge lineardodge softlight hardlight pinlight spotlight spotlightblend hardmix average difference exclusion hue saturation color value linearlight grainextract reflect glow darkercolor lightercolor phoenix negation".split(" ");
SEA3D.Stream.INTERPOLATION_TABLE="normal linear sine.in sine.out sine.inout cubic.in cubic.out cubic.inout quint.in quint.out quint.inout circ.in circ.out circ.inout back.in back.out back.inout quad.in quad.out quad.inout quart.in quart.out quart.inout expo.in expo.out expo.inout elastic.in elastic.out elastic.inout bounce.in bounce.out bounce.inout".split(" ");SEA3D.Stream.sizeOf=function(a){return 0==a?0:1<=a&&31>=a?1:32<=a&&63>=a?2:64<=a&&95>=a?3:96<=a&&125>=a?4:-1};
SEA3D.Stream.prototype={constructor:SEA3D.Stream,set buffer(a){this.buf=a;this.length=a.byteLength;this.data=new DataView(a)},get buffer(){return this.buf},get bytesAvailable(){return this.length-this.position}};SEA3D.Stream.prototype.getByte=function(a){return this.data.getInt8(a)};SEA3D.Stream.prototype.readBytes=function(a){var b=this.buf.slice(this.position,this.position+a);this.position+=a;return b};SEA3D.Stream.prototype.readByte=function(){return this.data.getInt8(this.position++)};
SEA3D.Stream.prototype.readUByte=function(){return this.data.getUint8(this.position++)};SEA3D.Stream.prototype.readBool=function(){return 0!=this.data.getInt8(this.position++)};SEA3D.Stream.prototype.readShort=function(){var a=this.data.getInt16(this.position,!0);this.position+=2;return a};SEA3D.Stream.prototype.readUShort=function(){var a=this.data.getUint16(this.position,!0);this.position+=2;return a};
SEA3D.Stream.prototype.readUInt24=function(){var a=this.data.getUint32(this.position,!0)&16777215;this.position+=3;return a};SEA3D.Stream.prototype.readUInt24F=function(){return this.readUShort()|this.readUByte()<<16};SEA3D.Stream.prototype.readInt=function(){var a=this.data.getInt32(this.position,!0);this.position+=4;return a};SEA3D.Stream.prototype.readUInt=function(){var a=this.data.getUint32(this.position,!0);this.position+=4;return a};
SEA3D.Stream.prototype.readFloat=function(){var a=this.data.getFloat32(this.position,!0);this.position+=4;return a};SEA3D.Stream.prototype.readUInteger=function(){var a=this.readUByte(),b=a&127;0!=(a&128)&&(a=this.readUByte(),b|=(a&127)<<7,0!=(a&128)&&(a=this.readUByte(),b|=(a&127)<<13));return b};SEA3D.Stream.prototype.readVector2=function(){return{x:this.readFloat(),y:this.readFloat()}};SEA3D.Stream.prototype.readVector3=function(){return{x:this.readFloat(),y:this.readFloat(),z:this.readFloat()}};
SEA3D.Stream.prototype.readVector4=function(){return{x:this.readFloat(),y:this.readFloat(),z:this.readFloat(),w:this.readFloat()}};
SEA3D.Stream.prototype.readMatrix=function(){var a=new Float32Array(16);a[0]=this.readFloat();a[1]=this.readFloat();a[2]=this.readFloat();a[3]=0;a[4]=this.readFloat();a[5]=this.readFloat();a[6]=this.readFloat();a[7]=0;a[8]=this.readFloat();a[9]=this.readFloat();a[10]=this.readFloat();a[11]=0;a[12]=this.readFloat();a[13]=this.readFloat();a[14]=this.readFloat();a[15]=1;return a};SEA3D.Stream.prototype.readUTF8=function(a){a=this.readBytes(a);return String.fromCharCode.apply(void 0,new Uint16Array(new Uint8Array(a)))};
SEA3D.Stream.prototype.readExt=function(){return this.readUTF8(4).replace(/\0/g,"")};SEA3D.Stream.prototype.readUTF8Tiny=function(){return this.readUTF8(this.readUByte())};SEA3D.Stream.prototype.readUTF8Short=function(){return this.readUTF8(this.readUShort())};SEA3D.Stream.prototype.readUTF8Long=function(){return this.readUTF8(this.readUInt())};SEA3D.Stream.prototype.readUByteArray=function(a){var b=new Uint8Array(a);SEA3D.Stream.memcpy(b.buffer,0,this.buffer,this.position,a);this.position+=a;return b};
SEA3D.Stream.prototype.readUShortArray=function(a){var b=new Uint16Array(a);a*=2;SEA3D.Stream.memcpy(b.buffer,0,this.buffer,this.position,a);this.position+=a;return b};SEA3D.Stream.prototype.readUInt24Array=function(a){for(var b=new Uint32Array(a),c=0;c<a;c++)b[c]=this.readUInt24();return b};SEA3D.Stream.prototype.readUIntArray=function(a){var b=new Uint32Array(a);a*=4;SEA3D.Stream.memcpy(b.buffer,0,this.buffer,this.position,a);this.position+=a;return b};
SEA3D.Stream.prototype.readFloatArray=function(a){var b=new Float32Array(a);a*=4;SEA3D.Stream.memcpy(b.buffer,0,this.buffer,this.position,a);this.position+=a;return b};SEA3D.Stream.prototype.readBlendMode=function(){return SEA3D.Stream.BLEND_MODE[this.readUByte()]};SEA3D.Stream.prototype.readInterpolation=function(){return SEA3D.Stream.INTERPOLATION_TABLE[this.readUByte()]};
SEA3D.Stream.prototype.readTags=function(a){for(var b=this.readUByte(),c=0;c<b;++c){var d=this.readUShort(),e=this.readUInt(),f=this.position;a(d,this,e);this.position=f+e}};SEA3D.Stream.prototype.readProperties=function(a){var b=this.readUByte(),c={},d={};c.__type=d;for(var e=0;e<b;e++){var f=this.readUTF8Tiny(),h=this.readUByte();d[f]=h;c[f]=h==SEA3D.Stream.GROUP?this.readProperties(a):this.readToken(h,a)}return c};
SEA3D.Stream.prototype.readAnimationList=function(a){for(var b=[],c=this.readUByte(),d=0;d<c;){var e=this.readUByte(),f={};f.relative=0!=(e&1);e&2&&(f.timeScale=this.readFloat());f.tag=a.getObject(this.readUInt());b[d++]=f}return b};
SEA3D.Stream.prototype.readScriptList=function(a){for(var b=[],c=this.readUByte(),d=0;d<c;){var e=this.readUByte(),f={};f.priority=e&1|e&2;if(e&4){var h=this.readUByte();f.params={};for(var g=0;g<h;g++){var k=this.readUTF8Tiny();f.params[k]=this.readObject(a)}}e&8&&(f.method=this.readUTF8Tiny());f.tag=a.getObject(this.readUInt());b[d++]=f}return b};SEA3D.Stream.prototype.readObject=function(a){return this.readToken(this.readUByte(),a)};
SEA3D.Stream.prototype.readToken=function(a,b){switch(a){case SEA3D.Stream.BOOLEAN:return this.readBool();case SEA3D.Stream.UBYTE:return this.readUByte();case SEA3D.Stream.USHORT:return this.readUShort();case SEA3D.Stream.UINT24:return this.readUInt24();case SEA3D.Stream.INT:return this.readInt();case SEA3D.Stream.UINT:return this.readUInt();case SEA3D.Stream.FLOAT:return this.readFloat();case SEA3D.Stream.VECTOR3D:return this.readVector3();case SEA3D.Stream.VECTOR4D:return this.readVector4();case SEA3D.Stream.STRING_TINY:return this.readUTF8Tiny();
case SEA3D.Stream.STRING_SHORT:return this.readUTF8Short();case SEA3D.Stream.STRING_LONG:return this.readUTF8Long();case SEA3D.Stream.ASSET:var c=this.readUInt();return 0<c?b.getObject(c-1).tag:null;default:console.error("DataType not found!")}return null};
SEA3D.Stream.prototype.readVector=function(a,b,c){var d=SEA3D.Stream.sizeOf(a);b=c*d+b*d;switch(a){case SEA3D.Stream.BOOLEAN:return this.readUByteArray(b);case SEA3D.Stream.UBYTE:return this.readUByteArray(b);case SEA3D.Stream.USHORT:return this.readUShortArray(b);case SEA3D.Stream.UINT24:return this.readUInt24Array(b);case SEA3D.Stream.UINT:return this.readUIntArray(b);case SEA3D.Stream.FLOAT:return this.readFloatArray(b);case SEA3D.Stream.VECTOR3D:return this.readFloatArray(b);case SEA3D.Stream.VECTOR4D:return this.readFloatArray(b)}};
SEA3D.Stream.prototype.append=function(a){var b=new ArrayBuffer(this.data.byteLength+a.byteLength);b.set(new ArrayBuffer(this.data),0);b.set(new ArrayBuffer(a),this.data.byteLength);this.data=b};SEA3D.Stream.prototype.concat=function(a,b){return new SEA3D.Stream(this.buffer.slice(a,a+b))};SEA3D.Stream.memcpy=function(a,b,c,d,e){a=new Uint8Array(a,b,e);c=new Uint8Array(c,d,e);a.set(c)};SEA3D.UByteArray=function(){this.ubytes=[];this.length=0};
SEA3D.UByteArray.prototype={constructor:SEA3D.UByteArray,add:function(a){this.ubytes.push(a);this.length+=a.byteLength},toBuffer:function(){for(var a=new Uint8Array(this.length),b=0,c=0;b<this.ubytes.length;b++)a.set(this.ubytes[b],c),c+=this.ubytes[b].byteLength;return a.buffer}};SEA3D.Math={DEGREES:180/Math.PI,RADIANS:Math.PI/180};SEA3D.Math.angle=function(a){var b=0>a;a=(b?-a:a)%360;180<a&&(a=-180+(a-180));return b?-a:a};
SEA3D.Math.lerpAngle=function(a,b,c){180<Math.abs(a-b)&&(b=a>b?b+360:b-360);return SEA3D.Math.angle(a+(b-a)*c)};SEA3D.Math.lerpColor=function(a,b,c){var d=a>>24&255,e=a>>16&255,f=a>>8&255;a&=255;e+=((b>>16&255)-e)*c;f+=((b>>8&255)-f)*c;a+=((b&255)-a)*c;return d+((b>>24&255)-d)*c<<24|e<<16|f<<8|a};SEA3D.Math.lerp=function(a,b,c){return a+(b-a)*c};SEA3D.Math.lerp1x=function(a,b,c){a[0]+=(b[0]-a[0])*c};SEA3D.Math.lerp3x=function(a,b,c){a[0]+=(b[0]-a[0])*c;a[1]+=(b[1]-a[1])*c;a[2]+=(b[2]-a[2])*c};
SEA3D.Math.lerpAng1x=function(a,b,c){a[0]=SEA3D.Math.lerpAngle(a[0],b[0],c)};SEA3D.Math.lerpColor1x=function(a,b,c){a[0]=SEA3D.Math.lerpColor(a[0],b[0],c)};SEA3D.Math.lerpQuat4x=function(a,b,c){var d=a[0],e=a[1],f=a[2],h=a[3],g=b[0],k=b[1],n=b[2];b=b[3];0>d*g+e*k+f*n+h*b&&(g=-g,k=-k,n=-n,b=-b);d+=c*(g-d);e+=c*(k-e);f+=c*(n-f);c=h+c*(b-h);h=1/Math.sqrt(c*c+d*d+e*e+f*f);a[0]=d*h;a[1]=e*h;a[2]=f*h;a[3]=c*h};SEA3D.Timer=function(){this.time=this.start=Date.now()};
SEA3D.Timer.prototype={constructor:SEA3D.Timer,get now(){return Date.now()},get deltaTime(){return Date.now()-this.time},get elapsedTime(){return Date.now()-this.start},update:function(){this.time=Date.now()}};SEA3D.Object=function(a,b,c,d){this.name=a;this.data=b;this.type=c;this.sea3d=d};
SEA3D.GeometryBase=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.attrib=b.readUShort();this.isBig=0!=(this.attrib&1);b.readVInt=this.isBig?b.readUInt:b.readUShort;this.numVertex=b.readVInt();this.length=3*this.numVertex};
SEA3D.Geometry=function(a,b,c){SEA3D.GeometryBase.call(this,a,b,c);var d;this.attrib&4&&(this.normal=b.readFloatArray(this.length));this.attrib&8&&(this.tangent=b.readFloatArray(this.length));if(this.attrib&32)for(this.uv=[],this.uv.length=b.readUByte(),d=2*this.numVertex,a=0;a<this.uv.length;)this.uv[a++]=b.readFloatArray(d);this.attrib&64&&(this.jointPerVertex=b.readUByte(),a=this.numVertex*this.jointPerVertex,this.joint=b.readUShortArray(a),this.weight=b.readFloatArray(a));if(this.attrib&128)for(c=
b.readUByte(),this.numColor=((c&64)>>6|(c&128)>>6)+1,this.color=[],a=0,d=c&15;a<d;a++)this.color.push(b.readFloatArray(this.numVertex*this.numColor));this.vertex=b.readFloatArray(this.length);var e=b.readUByte();this.groups=[];if(this.attrib&1024){for(d=a=0;a<e;a++)c=3*b.readVInt(),this.groups.push({start:d,count:c}),d+=c;this.indexes=this.isBig?b.readUIntArray(d):b.readUShortArray(d)}else{var f=this.isBig?4:2,h=new SEA3D.UByteArray;for(c=a=0;a<e;a++)d=3*b.readVInt(),this.groups.push({start:c,count:d}),
c+=d,h.add(b.readUByteArray(d*f));this.indexes=this.isBig?new Uint32Array(h.toBuffer()):new Uint16Array(h.toBuffer())}};SEA3D.Geometry.prototype=Object.create(SEA3D.GeometryBase.prototype);SEA3D.Geometry.prototype.constructor=SEA3D.Geometry;SEA3D.Geometry.prototype.type="geo";
SEA3D.Object3D=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.isStatic=!1;this.visible=!0;this.attrib=b.readUShort();this.attrib&1&&(this.parent=c.getObject(b.readUInt()));this.attrib&2&&(this.animations=b.readAnimationList(c));this.attrib&4&&(this.scripts=b.readScriptList(c));this.attrib&16&&(this.attributes=c.getObject(b.readUInt()));this.attrib&32&&(a=b.readUByte(),this.isStatic=0!=(a&1),this.visible=0==(a&2))};SEA3D.Object3D.prototype.readTag=function(a,b,c){};
SEA3D.Entity3D=function(a,b,c){SEA3D.Object3D.call(this,a,b,c);this.castShadows=!0;this.attrib&64&&(this.castShadows=0==(b.readUByte()&1))};SEA3D.Entity3D.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Entity3D.prototype.constructor=SEA3D.Entity3D;SEA3D.Sound3D=function(a,b,c){SEA3D.Object3D.call(this,a,b,c);this.autoPlay=0!=(this.attrib&64);this.attrib&128&&(this.mixer=c.getObject(b.readUInt()));this.sound=c.getObject(b.readUInt());this.volume=b.readFloat()};SEA3D.Sound3D.prototype=Object.create(SEA3D.Object3D.prototype);
SEA3D.Sound3D.prototype.constructor=SEA3D.Sound3D;SEA3D.SoundPoint=function(a,b,c){SEA3D.Sound3D.call(this,a,b,c);this.position=b.readVector3();this.distance=b.readFloat();b.readTags(this.readTag.bind(this))};SEA3D.SoundPoint.prototype=Object.create(SEA3D.Sound3D.prototype);SEA3D.SoundPoint.prototype.constructor=SEA3D.SoundPoint;SEA3D.SoundPoint.prototype.type="sp";SEA3D.Container3D=function(a,b,c){SEA3D.Object3D.call(this,a,b,c);this.transform=b.readMatrix();b.readTags(this.readTag.bind(this))};
SEA3D.Container3D.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Container3D.prototype.constructor=SEA3D.Container3D;SEA3D.Container3D.prototype.type="c3d";SEA3D.ScriptURL=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.url=b.readUTF8(b.length)};SEA3D.ScriptURL.prototype.type="src";SEA3D.TextureURL=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.url=b.readUTF8(b.length)};SEA3D.TextureURL.prototype.type="urlT";
SEA3D.CubeMapURL=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.faces=[];for(a=0;6>a;a++)this.faces[a]=b.readUTF8Tiny()};SEA3D.CubeMapURL.prototype.type="cURL";
SEA3D.Actions=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.count=b.readUInt();this.actions=[];for(a=0;a<this.count;a++){var d=b.readUByte(),e=b.readUShort(),f=b.readUShort(),h=b.position,g=this.actions[a]={kind:e};d&1&&(g.range=[b.readUInt(),b.readUInt()]);d&2&&(g.time=b.readUInt());d&4&&(g.intrpl=b.readInterpolation(),0==g.intrpl.indexOf("back.")?g.intrplParam0=b.readFloat():0==g.intrpl.indexOf("elastic.")&&(g.intrplParam0=b.readFloat(),g.intrplParam1=b.readFloat()));switch(e){case SEA3D.Actions.RTT_TARGET:g.source=
c.getObject(b.readUInt());g.target=c.getObject(b.readUInt());break;case SEA3D.Actions.LOOK_AT:g.source=c.getObject(b.readUInt());g.target=c.getObject(b.readUInt());break;case SEA3D.Actions.PLAY_SOUND:g.sound=c.getObject(b.readUInt());g.offset=b.readUInt();break;case SEA3D.Actions.PLAY_ANIMATION:g.object=c.getObject(b.readUInt());g.name=b.readUTF8Tiny();break;case SEA3D.Actions.FOG:g.color=b.readUInt24();g.min=b.readFloat();g.max=b.readFloat();break;case SEA3D.Actions.ENVIRONMENT:g.texture=c.getObject(b.readUInt());
break;case SEA3D.Actions.ENVIRONMENT_COLOR:g.color=b.readUInt24F();break;case SEA3D.Actions.CAMERA:g.camera=c.getObject(b.readUInt());break;case SEA3D.Actions.SCRIPTS:g.scripts=b.readScriptList(c);break;case SEA3D.Actions.CLASS_OF:g.classof=c.getObject(b.readUInt());break;case SEA3D.Actions.ATTRIBUTES:g.attributes=c.getObject(b.readUInt());break;default:console.log('Action "'+e+'" not found.')}b.position=h+f}};SEA3D.Actions.SCENE=0;SEA3D.Actions.ENVIRONMENT_COLOR=1;SEA3D.Actions.ENVIRONMENT=2;
SEA3D.Actions.FOG=3;SEA3D.Actions.PLAY_ANIMATION=4;SEA3D.Actions.PLAY_SOUND=5;SEA3D.Actions.ANIMATION_AUDIO_SYNC=6;SEA3D.Actions.LOOK_AT=7;SEA3D.Actions.RTT_TARGET=8;SEA3D.Actions.CAMERA=9;SEA3D.Actions.SCRIPTS=10;SEA3D.Actions.CLASS_OF=11;SEA3D.Actions.ATTRIBUTES=12;SEA3D.Actions.prototype.type="act";SEA3D.Properties=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.tag=b.readProperties(c);this.tag.__name=a};SEA3D.Properties.prototype.type="prop";
SEA3D.FileInfo=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.tag=b.readProperties(c);this.tag.__name=a;c.info=this.tag};SEA3D.FileInfo.prototype.type="info";SEA3D.JavaScript=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.src=b.readUTF8(b.length)};SEA3D.JavaScript.prototype.type="js";SEA3D.JavaScriptMethod=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;a=b.readUShort();this.methods={};for(c=0;c<a;c++){b.readUByte();var d=b.readUTF8Tiny();this.methods[d]={src:b.readUTF8Long()}}};
SEA3D.JavaScriptMethod.prototype.type="jsm";SEA3D.GLSL=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.src=b.readUTF8(b.length)};SEA3D.GLSL.prototype.type="glsl";SEA3D.Dummy=function(a,b,c){SEA3D.Object3D.call(this,a,b,c);this.transform=b.readMatrix();this.width=b.readFloat();this.height=b.readFloat();this.depth=b.readFloat();b.readTags(this.readTag.bind(this))};SEA3D.Dummy.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Dummy.prototype.constructor=SEA3D.Dummy;
SEA3D.Dummy.prototype.type="dmy";SEA3D.Line=function(a,b,c){SEA3D.Object3D.call(this,a,b,c);this.count=3*(this.attrib&64?b.readUInt():b.readUShort());this.closed=0!=(this.attrib&128);this.transform=b.readMatrix();this.vertex=[];for(a=0;a<this.count;)this.vertex[a++]=b.readFloat();b.readTags(this.readTag.bind(this))};SEA3D.Line.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Line.prototype.constructor=SEA3D.Line;SEA3D.Line.prototype.type="line";
SEA3D.Sprite=function(a,b,c){SEA3D.Object3D.call(this,a,b,c);this.attrib&256&&(this.material=c.getObject(b.readUInt()));this.position=b.readVector3();this.width=b.readFloat();this.height=b.readFloat();b.readTags(this.readTag.bind(this))};SEA3D.Sprite.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Sprite.prototype.constructor=SEA3D.Sprite;SEA3D.Sprite.prototype.type="m2d";
SEA3D.Mesh=function(a,b,c){SEA3D.Entity3D.call(this,a,b,c);if(this.attrib&256)if(this.material=[],a=b.readUByte(),1==a)this.material[0]=c.getObject(b.readUInt());else for(var d=0;d<a;){var e=b.readUInt();0<e?this.material[d++]=c.getObject(e-1):this.material[d++]=void 0}if(this.attrib&512)for(this.modifiers=[],a=b.readUByte(),d=0;d<a;d++)this.modifiers[d]=c.getObject(b.readUInt());this.attrib&1024&&(this.reference={type:b.readUByte(),ref:c.getObject(b.readUInt())});this.transform=b.readMatrix();this.geometry=
c.getObject(b.readUInt());b.readTags(this.readTag.bind(this))};SEA3D.Mesh.prototype=Object.create(SEA3D.Entity3D.prototype);SEA3D.Mesh.prototype.constructor=SEA3D.Mesh;SEA3D.Mesh.prototype.type="m3d";SEA3D.Skeleton=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;a=b.readUShort();this.joint=[];for(c=0;c<a;c++)this.joint[c]={name:b.readUTF8Tiny(),parentIndex:b.readUShort()-1,inverseBindMatrix:b.readMatrix()}};SEA3D.Skeleton.prototype.type="skl";
SEA3D.SkeletonLocal=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;a=b.readUShort();this.joint=[];for(c=0;c<a;c++)this.joint[c]={name:b.readUTF8Tiny(),parentIndex:b.readUShort()-1,x:b.readFloat(),y:b.readFloat(),z:b.readFloat(),qx:b.readFloat(),qy:b.readFloat(),qz:b.readFloat(),qw:b.readFloat()}};SEA3D.SkeletonLocal.prototype.type="sklq";
SEA3D.AnimationBase=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;a=b.readUByte();this.sequence=[];if(a&1){c=b.readUShort();for(var d=0;d<c;d++)a=b.readUByte(),this.sequence[d]={name:b.readUTF8Tiny(),start:b.readUInt(),count:b.readUInt(),repeat:0!=(a&1),intrpl:0==(a&2)}}this.frameRate=b.readUByte();this.numFrames=b.readUInt();0==this.sequence.length&&(this.sequence[0]={name:"root",start:0,count:this.numFrames,repeat:!0,intrpl:!0})};
SEA3D.Animation=function(a,b,c){SEA3D.AnimationBase.call(this,a,b,c);this.dataList=[];a=0;for(c=b.readUByte();a<c;a++){var d=b.readUShort(),e=b.readUByte(),f=b.readVector(e,this.numFrames,0);this.dataList.push({kind:d,type:e,blockSize:SEA3D.Stream.sizeOf(e),data:f})}};SEA3D.Animation.POSITION=0;SEA3D.Animation.ROTATION=1;SEA3D.Animation.SCALE=2;SEA3D.Animation.COLOR=3;SEA3D.Animation.MULTIPLIER=4;SEA3D.Animation.ATTENUATION_START=5;SEA3D.Animation.ATTENUATION_END=6;SEA3D.Animation.FOV=7;
SEA3D.Animation.OFFSET_U=8;SEA3D.Animation.OFFSET_V=9;SEA3D.Animation.SCALE_U=10;SEA3D.Animation.SCALE_V=11;SEA3D.Animation.ANGLE=12;SEA3D.Animation.ALPHA=13;SEA3D.Animation.VOLUME=14;SEA3D.Animation.DefaultLerpFuncs=[SEA3D.Math.lerp3x,SEA3D.Math.lerpQuat4x,SEA3D.Math.lerp3x,SEA3D.Math.lerpColor1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerpAng1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x];
SEA3D.Animation.prototype=Object.create(SEA3D.AnimationBase.prototype);SEA3D.Animation.prototype.constructor=SEA3D.Animation;SEA3D.Animation.prototype.type="anm";SEA3D.SkeletonAnimation=function(a,b,c){SEA3D.AnimationBase.call(this,a,b,c);this.name=a;this.data=b;this.sea3d=c;this.numJoints=b.readUShort();this.raw=b.readFloatArray(this.numFrames*this.numJoints*7)};SEA3D.SkeletonAnimation.prototype.type="skla";
SEA3D.Morph=function(a,b,c){SEA3D.GeometryBase.call(this,a,b,c);a=0!=(this.attrib&2);c=0!=(this.attrib&4);var d=b.readUShort();this.node=[];for(var e=0;e<d;e++){var f=b.readUTF8Tiny(),h,g;a&&(h=b.readFloatArray(this.length));c&&(g=b.readFloatArray(this.length));this.node[e]={vertex:h,normal:g,name:f}}};SEA3D.Morph.prototype=Object.create(SEA3D.GeometryBase.prototype);SEA3D.Morph.prototype.constructor=SEA3D.Morph;SEA3D.Morph.prototype.type="mph";
SEA3D.VertexAnimation=function(a,b,c){SEA3D.AnimationBase.call(this,a,b,c);c=b.readUByte();this.isBig=0!=(c&1);b.readVInt=this.isBig?b.readUInt:b.readUShort;this.numVertex=b.readVInt();this.length=3*this.numVertex;a=0!=(c&2);c=0!=(c&4);this.frame=[];var d,e,f;for(d=0;d<this.numFrames;d++)a&&(e=b.readFloatArray(this.length)),c&&(f=b.readFloatArray(this.length)),this.frame[d]={vertex:e,normal:f}};SEA3D.VertexAnimation.prototype=Object.create(SEA3D.AnimationBase.prototype);
SEA3D.VertexAnimation.prototype.constructor=SEA3D.VertexAnimation;SEA3D.VertexAnimation.prototype.type="vtxa";SEA3D.Camera=function(a,b,c){SEA3D.Object3D.call(this,a,b,c);this.attrib&64&&(this.dof={distance:b.readFloat(),range:b.readFloat()});this.transform=b.readMatrix();this.fov=b.readFloat();b.readTags(this.readTag.bind(this))};SEA3D.Camera.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Camera.prototype.constructor=SEA3D.Camera;SEA3D.Camera.prototype.type="cam";
SEA3D.OrthographicCamera=function(a,b,c){SEA3D.Object3D.call(this,a,b,c);this.transform=b.readMatrix();this.height=b.readFloat();b.readTags(this.readTag.bind(this))};SEA3D.OrthographicCamera.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.OrthographicCamera.prototype.constructor=SEA3D.OrthographicCamera;SEA3D.OrthographicCamera.prototype.type="camo";SEA3D.JointObject=function(a,b,c){SEA3D.Object3D.call(this,a,b,c);this.target=c.getObject(b.readUInt());this.joint=b.readUShort();b.readTags(this.readTag.bind(this))};
SEA3D.JointObject.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.JointObject.prototype.constructor=SEA3D.JointObject;SEA3D.JointObject.prototype.type="jnt";
SEA3D.Light=function(a,b,c){SEA3D.Object3D.call(this,a,b,c);this.attenEnd=this.attenStart=Number.MAX_VALUE;this.attrib&64&&(a=b.readUByte(),this.shadow={},this.shadow.opacity=a&1?b.readFloat():1,this.shadow.color=a&2?b.readUInt24():0);this.attrib&512&&(this.attenStart=b.readFloat(),this.attenEnd=b.readFloat());this.color=b.readUInt24();this.multiplier=b.readFloat()};SEA3D.Light.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Light.prototype.constructor=SEA3D.Light;
SEA3D.PointLight=function(a,b,c){SEA3D.Light.call(this,a,b,c);this.attrib&128&&(this.attenuation={start:b.readFloat(),end:b.readFloat()});this.position=b.readVector3();b.readTags(this.readTag.bind(this))};SEA3D.PointLight.prototype=Object.create(SEA3D.Light.prototype);SEA3D.PointLight.prototype.constructor=SEA3D.PointLight;SEA3D.PointLight.prototype.type="plht";
SEA3D.HemisphereLight=function(a,b,c){SEA3D.Light.call(this,a,b,c);this.attrib&128&&(this.attenuation={start:b.readFloat(),end:b.readFloat()});this.secondColor=b.readUInt24();b.readTags(this.readTag.bind(this))};SEA3D.HemisphereLight.prototype=Object.create(SEA3D.Light.prototype);SEA3D.HemisphereLight.prototype.constructor=SEA3D.HemisphereLight;SEA3D.HemisphereLight.prototype.type="hlht";SEA3D.AmbientLight=function(a,b,c){SEA3D.Light.call(this,a,b,c);b.readTags(this.readTag.bind(this))};
SEA3D.AmbientLight.prototype=Object.create(SEA3D.Light.prototype);SEA3D.AmbientLight.prototype.constructor=SEA3D.AmbientLight;SEA3D.AmbientLight.prototype.type="alht";SEA3D.DirectionalLight=function(a,b,c){SEA3D.Light.call(this,a,b,c);this.transform=b.readMatrix();b.readTags(this.readTag.bind(this))};SEA3D.DirectionalLight.prototype=Object.create(SEA3D.Light.prototype);SEA3D.DirectionalLight.prototype.constructor=SEA3D.DirectionalLight;SEA3D.DirectionalLight.prototype.type="dlht";
SEA3D.Material=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.technique=[];this.attrib=b.readUShort();this.alpha=1;this.blendMode="normal";this.anisotropy=this.physical=!1;this.bothSides=0!=(this.attrib&1);this.receiveLights=0==(this.attrib&2);this.receiveShadows=0==(this.attrib&4);this.receiveFog=0==(this.attrib&8);this.repeat=0==(this.attrib&16);this.attrib&32&&(this.alpha=b.readFloat());this.attrib&64&&(this.blendMode=b.readBlendMode());this.attrib&128&&(this.animations=b.readAnimationList(c));
this.depthMask=0==(this.attrib&256);this.depthTest=0==(this.attrib&512);a=b.readUByte();for(var d=0;d<a;++d){var e=b.readUShort(),f=b.readUShort(),h=b.position,g,k;switch(e){case SEA3D.Material.PHONG:g={ambientColor:b.readUInt24(),diffuseColor:b.readUInt24(),specularColor:b.readUInt24(),specular:b.readFloat(),gloss:b.readFloat()};break;case SEA3D.Material.PHYSICAL:this.physical=!0;g={color:b.readUInt24(),roughness:b.readFloat(),metalness:b.readFloat()};break;case SEA3D.Material.ANISOTROPIC:this.anisotropy=
!0;break;case SEA3D.Material.COMPOSITE_TEXTURE:g={composite:c.getObject(b.readUInt())};break;case SEA3D.Material.DIFFUSE_MAP:g={texture:c.getObject(b.readUInt())};break;case SEA3D.Material.SPECULAR_MAP:g={texture:c.getObject(b.readUInt())};break;case SEA3D.Material.NORMAL_MAP:g={texture:c.getObject(b.readUInt())};break;case SEA3D.Material.REFLECTION:case SEA3D.Material.FRESNEL_REFLECTION:g={texture:c.getObject(b.readUInt()),alpha:b.readFloat()};e==SEA3D.Material.FRESNEL_REFLECTION&&(g.power=b.readFloat(),
g.normal=b.readFloat());break;case SEA3D.Material.REFRACTION:g={texture:c.getObject(b.readUInt()),alpha:b.readFloat(),ior:b.readFloat()};break;case SEA3D.Material.RIM:g={color:b.readUInt24(),strength:b.readFloat(),power:b.readFloat(),blendMode:b.readBlendMode()};break;case SEA3D.Material.LIGHT_MAP:g={texture:c.getObject(b.readUInt()),channel:b.readUByte(),blendMode:b.readBlendMode()};break;case SEA3D.Material.DETAIL_MAP:g={texture:c.getObject(b.readUInt()),scale:b.readFloat(),blendMode:b.readBlendMode()};
break;case SEA3D.Material.CEL:g={color:b.readUInt24(),levels:b.readUByte(),size:b.readFloat(),specularCutOff:b.readFloat(),smoothness:b.readFloat()};break;case SEA3D.Material.TRANSLUCENT:g={translucency:b.readFloat(),scattering:b.readFloat()};break;case SEA3D.Material.BLEND_NORMAL_MAP:k=b.readUByte();g={texture:c.getObject(b.readUInt()),secondaryTexture:c.getObject(b.readUInt())};k&1?(g.offsetX0=b.readFloat(),g.offsetY0=b.readFloat(),g.offsetX1=b.readFloat(),g.offsetY1=b.readFloat()):g.offsetX0=g.offsetY0=
g.offsetX1=g.offsetY1=0;g.animate=k&2;break;case SEA3D.Material.MIRROR_REFLECTION:g={texture:c.getObject(b.readUInt()),alpha:b.readFloat()};break;case SEA3D.Material.AMBIENT_MAP:g={texture:c.getObject(b.readUInt())};break;case SEA3D.Material.ALPHA_MAP:g={texture:c.getObject(b.readUInt())};break;case SEA3D.Material.EMISSIVE:g={color:b.readUInt24()};break;case SEA3D.Material.EMISSIVE_MAP:g={texture:c.getObject(b.readUInt())};break;case SEA3D.Material.ROUGHNESS_MAP:case SEA3D.Material.METALNESS_MAP:g=
{texture:c.getObject(b.readUInt())};break;case SEA3D.Material.VERTEX_COLOR:g={blendMode:b.readBlendMode()};break;case SEA3D.Material.WRAP_LIGHTING:g={color:b.readUInt24(),strength:b.readFloat()};break;case SEA3D.Material.COLOR_REPLACE:k=b.readUByte();g={red:b.readUInt24(),green:b.readUInt24(),blue:b.readUInt24F()};k&1&&(g.mask=c.getObject(b.readUInt()));k&2&&(g.alpha=b.readFloat());break;case SEA3D.Material.REFLECTION_SPHERICAL:g={texture:c.getObject(b.readUInt()),alpha:b.readFloat()};break;default:console.warn("SEA3D: MaterialTechnique not found:",
e.toString(16));b.position=h+f;continue}g.kind=e;this.technique.push(g);b.position=h+f}};SEA3D.Material.PHONG=0;SEA3D.Material.COMPOSITE_TEXTURE=1;SEA3D.Material.DIFFUSE_MAP=2;SEA3D.Material.SPECULAR_MAP=3;SEA3D.Material.REFLECTION=4;SEA3D.Material.REFRACTION=5;SEA3D.Material.NORMAL_MAP=6;SEA3D.Material.FRESNEL_REFLECTION=7;SEA3D.Material.RIM=8;SEA3D.Material.LIGHT_MAP=9;SEA3D.Material.DETAIL_MAP=10;SEA3D.Material.CEL=11;SEA3D.Material.TRANSLUCENT=12;SEA3D.Material.BLEND_NORMAL_MAP=13;
SEA3D.Material.MIRROR_REFLECTION=14;SEA3D.Material.AMBIENT_MAP=15;SEA3D.Material.ALPHA_MAP=16;SEA3D.Material.EMISSIVE_MAP=17;SEA3D.Material.VERTEX_COLOR=18;SEA3D.Material.WRAP_LIGHTING=19;SEA3D.Material.COLOR_REPLACE=20;SEA3D.Material.REFLECTION_SPHERICAL=21;SEA3D.Material.ANISOTROPIC=22;SEA3D.Material.EMISSIVE=23;SEA3D.Material.PHYSICAL=24;SEA3D.Material.ROUGHNESS_MAP=25;SEA3D.Material.METALNESS_MAP=26;SEA3D.Material.prototype.type="mat";
SEA3D.Composite=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;a=b.readUByte();this.layer=[];for(var d=0;d<a;d++)this.layer[d]=new SEA3D.Composite.prototype.Layer(b,c)};SEA3D.Composite.prototype.getLayerByName=function(a){for(var b=0;b<this.layer.length;b++)if(this.layer[b].name==a)return this.layer[b]};
SEA3D.Composite.prototype.Layer=function(a,b){var c=a.readUShort();c&1?this.texture=new SEA3D.Composite.LayerBitmap(a,b):this.color=a.readUInt24();c&2&&(this.mask=new SEA3D.Composite.LayerBitmap(a,b));c&4&&(this.name=a.readUTF8Tiny());this.blendMode=c&8?a.readBlendMode():"normal";this.opacity=c&16?a.readFloat():1};
SEA3D.Composite.LayerBitmap=function(a,b){this.map=b.getObject(a.readUInt());var c=a.readUShort();this.channel=c&1?a.readUByte():0;this.repeat=c&0;this.offsetU=c&4?a.readFloat():0;this.offsetV=c&8?a.readFloat():0;this.scaleU=c&16?a.readFloat():1;this.scaleV=c&32?a.readFloat():1;this.rotation=c&64?a.readFloat():0;c&128&&(this.animation=a.readAnimationList(b))};SEA3D.Composite.prototype.type="ctex";
SEA3D.PlanarRender=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.attrib=b.readUByte();this.quality=this.attrib&1|this.attrib&2;this.transform=b.readMatrix()};SEA3D.PlanarRender.prototype.type="rttp";SEA3D.CubeRender=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.attrib=b.readUByte();this.quality=this.attrib&1|this.attrib&2;this.position=b.readVector3()};SEA3D.CubeRender.prototype.type="rttc";
SEA3D.CubeMap=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.transparent=!1;b.readExt();this.faces=[];for(a=0;6>a;a++)c=b.readUInt(),this.faces[a]=b.concat(b.position,c),b.position+=c};SEA3D.CubeMap.prototype.type="cmap";SEA3D.JPEG=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.transparent=!1};SEA3D.JPEG.prototype.type="jpg";SEA3D.JPEG_XR=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.transparent=!0};SEA3D.JPEG_XR.prototype.type="wdp";
SEA3D.PNG=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.transparent=6==b.getByte(25)};SEA3D.PNG.prototype.type="png";SEA3D.GIF=function(a,b,c){this.name=a;this.data=b;this.sea3d=c;this.transparent=0<b.getByte(11)};SEA3D.GIF.prototype.type="gif";SEA3D.OGG=function(a,b,c){this.name=a;this.data=b;this.sea3d=c};SEA3D.OGG.prototype.type="ogg";SEA3D.MP3=function(a,b,c){this.name=a;this.data=b;this.sea3d=c};SEA3D.MP3.prototype.type="mp3";
SEA3D.File=function(a){this.config={streaming:!0,timeLimit:60};a&&(void 0!==a.streaming&&(this.config.streaming=a.streaming),void 0!==a.timeLimit&&(this.config.timeLimit=a.timeLimit));this.version=SEA3D.VERSION;this.objects=[];this.typeClass={};this.typeRead={};this.typeUnique={};this.position=this.dataPosition=0;this.scope=this;this.addClass(SEA3D.FileInfo,!0);this.addClass(SEA3D.Geometry,!0);this.addClass(SEA3D.Mesh);this.addClass(SEA3D.Sprite);this.addClass(SEA3D.Material);this.addClass(SEA3D.Composite);
this.addClass(SEA3D.PointLight);this.addClass(SEA3D.DirectionalLight);this.addClass(SEA3D.HemisphereLight);this.addClass(SEA3D.AmbientLight);this.addClass(SEA3D.Skeleton,!0);this.addClass(SEA3D.SkeletonLocal,!0);this.addClass(SEA3D.SkeletonAnimation,!0);this.addClass(SEA3D.JointObject);this.addClass(SEA3D.Camera);this.addClass(SEA3D.OrthographicCamera);this.addClass(SEA3D.Morph,!0);this.addClass(SEA3D.VertexAnimation,!0);this.addClass(SEA3D.CubeMap,!0);this.addClass(SEA3D.Animation);this.addClass(SEA3D.Dummy);
this.addClass(SEA3D.Line);this.addClass(SEA3D.SoundPoint);this.addClass(SEA3D.PlanarRender);this.addClass(SEA3D.CubeRender);this.addClass(SEA3D.Actions);this.addClass(SEA3D.Container3D);this.addClass(SEA3D.Properties);this.addClass(SEA3D.ScriptURL,!0);this.addClass(SEA3D.TextureURL,!0);this.addClass(SEA3D.CubeMapURL,!0);this.addClass(SEA3D.JPEG,!0);this.addClass(SEA3D.JPEG_XR,!0);this.addClass(SEA3D.PNG,!0);this.addClass(SEA3D.GIF,!0);this.addClass(SEA3D.OGG,!0);this.addClass(SEA3D.MP3,!0);this.addClass(SEA3D.JavaScript,
!0);this.addClass(SEA3D.JavaScriptMethod,!0);this.addClass(SEA3D.GLSL,!0);for(a=SEA3D.File.Extensions.length;a--;)SEA3D.File.Extensions[a].call(this)};SEA3D.File.Extensions=[];SEA3D.File.CompressionLibs={};SEA3D.File.DecompressionMethod={};SEA3D.File.setExtension=function(a){SEA3D.File.Extensions.push(a)};SEA3D.File.setDecompressionEngine=function(a,b,c){SEA3D.File.CompressionLibs[a]=b;SEA3D.File.DecompressionMethod[a]=c};
SEA3D.File.prototype.addClass=function(a,b){this.typeClass[a.prototype.type]=a;this.typeUnique[a.prototype.type]=!0===b};
SEA3D.File.prototype.readHead=function(){if(16>this.stream.bytesAvailable)return!1;if("SEA"!=this.stream.readUTF8(3))throw Error("Invalid SEA3D format.");this.sign=this.stream.readUTF8(3);this.version=this.stream.readUInt24();if(0!=this.stream.readUByte())throw Error("Protection algorithm not compatible.");this.compressionID=this.stream.readUByte();this.compressionAlgorithm=SEA3D.File.CompressionLibs[this.compressionID];this.decompressionMethod=SEA3D.File.DecompressionMethod[this.compressionID];if(0<
this.compressionID&&!this.decompressionMethod)throw Error("Compression algorithm not compatible.");this.length=this.stream.readUInt();this.dataPosition=this.stream.position;this.objects.length=0;this.state=this.readBody;if(this.onHead)this.onHead({file:this,sign:this.sign});return!0};SEA3D.File.prototype.getObject=function(a){return this.objects[a]};SEA3D.File.prototype.getObjectByName=function(a){return this.objects[a]};
SEA3D.File.prototype.readSEAObject=function(){if(4>this.stream.bytesAvailable)return null;var a=this.stream.readUInt(),b=this.stream.position;if(this.stream.bytesAvailable<a)return null;var c=this.stream.readUByte(),d=this.stream.readExt(),e=null,f=c&1?this.stream.readUTF8Tiny():"",h=0!=(c&2),g=0!=(c&4);c&8&&(e=this.stream.readUShort(),c=this.stream.concat(this.stream.position,e),this.stream.position+=e,h&&this.decompressionMethod&&(c.buffer=this.decompressionMethod(c.buffer)),e=c.readProperties(this));
a-=this.stream.position-b;b=this.stream.position;c=this.stream.concat(b,a);this.typeClass[d]?(h&&this.decompressionMethod&&(c.buffer=this.decompressionMethod(c.buffer)),h=new this.typeClass[d](f,c,this),(this.config.streaming&&g||this.config.forceStreaming)&&this.typeRead[d]&&this.typeRead[d].call(this.scope,h)):(h=new SEA3D.Object(f,c,d,this),console.warn('SEA3D: Unknown format "'+d+'" of file "'+f+'". Add a module referring for this format.'));h.streaming=g;h.metadata=e;this.objects.push(this.objects[h.name+
"."+h.type]=h);this.dataPosition=b+a;++this.position;return h};SEA3D.File.prototype.isDone=function(){return this.position==this.length};SEA3D.File.prototype.readBody=function(){this.timer.update();if(!this.resume)return!1;for(;this.position<this.length;)if(this.timer.deltaTime<this.config.timeLimit){this.stream.position=this.dataPosition;var a=this.readSEAObject();if(a)this.dispatchCompleteObject(a);else return!1}else return!1;this.state=this.readComplete;return!0};
SEA3D.File.prototype.initParse=function(){this.timer=new SEA3D.Timer;this.position=0;this.resume=!0};SEA3D.File.prototype.parse=function(){this.initParse();isFinite(this.config.timeLimit)?setTimeout(this.parseObject.bind(this),10):this.parseObject()};
SEA3D.File.prototype.parseObject=function(){for(this.timer.update();this.position<this.length&&this.timer.deltaTime<this.config.timeLimit;){var a=this.objects[this.position++],b=a.type;this.typeUnique[b]||delete a.tag;(a.streaming||this.config.forceStreaming)&&this.typeRead[b]&&void 0==a.tag&&this.typeRead[b].call(this.scope,a)}if(this.position==this.length)if(a=this.timer.elapsedTime,b=a+"ms, "+this.objects.length+" objects",this.onParseComplete)this.onParseComplete({file:this,timeTotal:a,message:b});
else console.log("SEA3D Parse Complete:",b);else{if(this.onParseProgress)this.onParseProgress({file:this,loaded:this.position,total:this.length});setTimeout(this.parseObject.bind(this),10)}};SEA3D.File.prototype.readComplete=function(){this.stream.position=this.dataPosition;6202321!=this.stream.readUInt24F()&&console.warn("SEA3D file is corrupted.");delete this.state;return!1};
SEA3D.File.prototype.readState=function(){for(;this.state(););this.state?(requestAnimationFrame(this.readState.bind(this)),this.dispatchProgress()):(this.dispatchProgress(),this.dispatchComplete())};SEA3D.File.prototype.read=function(a){a||Error("No data found.");this.initParse();this.stream=new SEA3D.Stream(a);this.state=this.readHead;this.readState()};SEA3D.File.prototype.dispatchCompleteObject=function(a){if(this.onCompleteObject)this.onCompleteObject({file:this,object:a})};
SEA3D.File.prototype.dispatchProgress=function(){if(this.onProgress)this.onProgress({file:this,loaded:this.position,total:this.length})};SEA3D.File.prototype.dispatchDownloadProgress=function(a,b){if(this.onDownloadProgress)this.onDownloadProgress({file:this,loaded:a,total:b})};SEA3D.File.prototype.dispatchComplete=function(){var a=this.timer.elapsedTime,b=a+"ms, "+this.objects.length+" objects";if(this.onComplete)this.onComplete({file:this,timeTotal:a,message:b});else console.log("SEA3D:",b)};
SEA3D.File.prototype.dispatchError=function(a,b){if(this.onError)this.onError({file:this,id:a,message:b});else console.error("SEA3D: #"+a,b)};
SEA3D.File.prototype.load=function(a){var b=this,c=new XMLHttpRequest;c.open("GET",a,!0);c.responseType="arraybuffer";c.onprogress=function(a){a.lengthComputable&&b.dispatchDownloadProgress(a.loaded,a.total)};c.onreadystatechange=function(){2!==c.readyState&&3!==c.readyState&&4===c.readyState&&(200===c.status||0===c.status?b.read(this.response):this.dispatchError(1001,"Couldn't load ["+a+"] ["+c.status+"]"))};c.send()};SEA3D.LZMA=function(){var a=a||{};a.OutWindow=function(){this._windowSize=0};a.OutWindow.prototype.create=function(a){this._buffer&&this._windowSize===a||(this._buffer=[]);this._windowSize=a;this._streamPos=this._pos=0};a.OutWindow.prototype.flush=function(){var a=this._pos-this._streamPos;if(0!==a){for(;a--;)this._stream.writeByte(this._buffer[this._streamPos++]);this._pos>=this._windowSize&&(this._pos=0);this._streamPos=this._pos}};a.OutWindow.prototype.releaseStream=function(){this.flush();this._stream=
null};a.OutWindow.prototype.setStream=function(a){this.releaseStream();this._stream=a};a.OutWindow.prototype.init=function(a){a||(this._pos=this._streamPos=0)};a.OutWindow.prototype.copyBlock=function(a,c){var d=this._pos-a-1;for(0>d&&(d+=this._windowSize);c--;)d>=this._windowSize&&(d=0),this._buffer[this._pos++]=this._buffer[d++],this._pos>=this._windowSize&&this.flush()};a.OutWindow.prototype.putByte=function(a){this._buffer[this._pos++]=a;this._pos>=this._windowSize&&this.flush()};a.OutWindow.prototype.getByte=
function(a){a=this._pos-a-1;0>a&&(a+=this._windowSize);return this._buffer[a]};a.RangeDecoder=function(){};a.RangeDecoder.prototype.setStream=function(a){this._stream=a};a.RangeDecoder.prototype.releaseStream=function(){this._stream=null};a.RangeDecoder.prototype.init=function(){var a=5;this._code=0;for(this._range=-1;a--;)this._code=this._code<<8|this._stream.readByte()};a.RangeDecoder.prototype.decodeDirectBits=function(a){for(var c=0,d;a--;)this._range>>>=1,d=this._code-this._range>>>31,this._code-=
this._range&d-1,c=c<<1|1-d,0===(this._range&4278190080)&&(this._code=this._code<<8|this._stream.readByte(),this._range<<=8);return c};a.RangeDecoder.prototype.decodeBit=function(a,c){var d=a[c],e=(this._range>>>11)*d;if((this._code^2147483648)<(e^2147483648))return this._range=e,a[c]+=2048-d>>>5,0===(this._range&4278190080)&&(this._code=this._code<<8|this._stream.readByte(),this._range<<=8),0;this._range-=e;this._code-=e;a[c]-=d>>>5;0===(this._range&4278190080)&&(this._code=this._code<<8|this._stream.readByte(),
this._range<<=8);return 1};a.initBitModels=function(a,c){for(;c--;)a[c]=1024};a.BitTreeDecoder=function(a){this._models=[];this._numBitLevels=a};a.BitTreeDecoder.prototype.init=function(){a.initBitModels(this._models,1<<this._numBitLevels)};a.BitTreeDecoder.prototype.decode=function(a){for(var c=1,d=this._numBitLevels;d--;)c=c<<1|a.decodeBit(this._models,c);return c-(1<<this._numBitLevels)};a.BitTreeDecoder.prototype.reverseDecode=function(a){for(var c=1,d=0,e=0,f;e<this._numBitLevels;++e)f=a.decodeBit(this._models,
c),c=c<<1|f,d|=f<<e;return d};a.reverseDecode2=function(a,c,d,e){for(var f=1,h=0,g=0,k;g<e;++g)k=d.decodeBit(a,c+f),f=f<<1|k,h|=k<<g;return h};a.LenDecoder=function(){this._choice=[];this._lowCoder=[];this._midCoder=[];this._highCoder=new a.BitTreeDecoder(8);this._numPosStates=0};a.LenDecoder.prototype.create=function(b){for(;this._numPosStates<b;++this._numPosStates)this._lowCoder[this._numPosStates]=new a.BitTreeDecoder(3),this._midCoder[this._numPosStates]=new a.BitTreeDecoder(3)};a.LenDecoder.prototype.init=
function(){var b=this._numPosStates;for(a.initBitModels(this._choice,2);b--;)this._lowCoder[b].init(),this._midCoder[b].init();this._highCoder.init()};a.LenDecoder.prototype.decode=function(a,c){return 0===a.decodeBit(this._choice,0)?this._lowCoder[c].decode(a):0===a.decodeBit(this._choice,1)?8+this._midCoder[c].decode(a):16+this._highCoder.decode(a)};a.Decoder2=function(){this._decoders=[]};a.Decoder2.prototype.init=function(){a.initBitModels(this._decoders,768)};a.Decoder2.prototype.decodeNormal=
function(a){var c=1;do c=c<<1|a.decodeBit(this._decoders,c);while(256>c);return c&255};a.Decoder2.prototype.decodeWithMatchByte=function(a,c){var d=1,e,f;do if(e=c>>7&1,c<<=1,f=a.decodeBit(this._decoders,(1+e<<8)+d),d=d<<1|f,e!==f){for(;256>d;)d=d<<1|a.decodeBit(this._decoders,d);break}while(256>d);return d&255};a.LiteralDecoder=function(){};a.LiteralDecoder.prototype.create=function(b,c){var d;if(!this._coders||this._numPrevBits!==c||this._numPosBits!==b)for(this._numPosBits=b,this._posMask=(1<<
b)-1,this._numPrevBits=c,this._coders=[],d=1<<this._numPrevBits+this._numPosBits;d--;)this._coders[d]=new a.Decoder2};a.LiteralDecoder.prototype.init=function(){for(var a=1<<this._numPrevBits+this._numPosBits;a--;)this._coders[a].init()};a.LiteralDecoder.prototype.getDecoder=function(a,c){return this._coders[((a&this._posMask)<<this._numPrevBits)+((c&255)>>>8-this._numPrevBits)]};a.Decoder=function(){this._outWindow=new a.OutWindow;this._rangeDecoder=new a.RangeDecoder;this._isMatchDecoders=[];this._isRepDecoders=
[];this._isRepG0Decoders=[];this._isRepG1Decoders=[];this._isRepG2Decoders=[];this._isRep0LongDecoders=[];this._posSlotDecoder=[];this._posDecoders=[];this._posAlignDecoder=new a.BitTreeDecoder(4);this._lenDecoder=new a.LenDecoder;this._repLenDecoder=new a.LenDecoder;this._literalDecoder=new a.LiteralDecoder;this._dictionarySizeCheck=this._dictionarySize=-1;this._posSlotDecoder[0]=new a.BitTreeDecoder(6);this._posSlotDecoder[1]=new a.BitTreeDecoder(6);this._posSlotDecoder[2]=new a.BitTreeDecoder(6);
this._posSlotDecoder[3]=new a.BitTreeDecoder(6)};a.Decoder.prototype.setDictionarySize=function(a){if(0>a)return!1;this._dictionarySize!==a&&(this._dictionarySize=a,this._dictionarySizeCheck=Math.max(this._dictionarySize,1),this._outWindow.create(Math.max(this._dictionarySizeCheck,4096)));return!0};a.Decoder.prototype.setLcLpPb=function(a,c,d){var e=1<<d;if(8<a||4<c||4<d)return!1;this._literalDecoder.create(c,a);this._lenDecoder.create(e);this._repLenDecoder.create(e);this._posStateMask=e-1;return!0};
a.Decoder.prototype.init=function(){var b=4;this._outWindow.init(!1);a.initBitModels(this._isMatchDecoders,192);a.initBitModels(this._isRep0LongDecoders,192);a.initBitModels(this._isRepDecoders,12);a.initBitModels(this._isRepG0Decoders,12);a.initBitModels(this._isRepG1Decoders,12);a.initBitModels(this._isRepG2Decoders,12);a.initBitModels(this._posDecoders,114);for(this._literalDecoder.init();b--;)this._posSlotDecoder[b].init();this._lenDecoder.init();this._repLenDecoder.init();this._posAlignDecoder.init();
this._rangeDecoder.init()};a.Decoder.prototype.decode=function(b,c,d){var e=0,f=0,h=0,g=0,k=0,n=0,l=0;this._rangeDecoder.setStream(b);this._outWindow.setStream(c);for(this.init();0>d||n<d;)if(b=n&this._posStateMask,0===this._rangeDecoder.decodeBit(this._isMatchDecoders,(e<<4)+b))l=this._literalDecoder.getDecoder(n++,l),l=7<=e?l.decodeWithMatchByte(this._rangeDecoder,this._outWindow.getByte(f)):l.decodeNormal(this._rangeDecoder),this._outWindow.putByte(l),e=4>e?0:e-(10>e?3:6);else{if(1===this._rangeDecoder.decodeBit(this._isRepDecoders,
e))l=0,0===this._rangeDecoder.decodeBit(this._isRepG0Decoders,e)?0===this._rangeDecoder.decodeBit(this._isRep0LongDecoders,(e<<4)+b)&&(e=7>e?9:11,l=1):(0===this._rangeDecoder.decodeBit(this._isRepG1Decoders,e)?c=h:(0===this._rangeDecoder.decodeBit(this._isRepG2Decoders,e)?c=g:(c=k,k=g),g=h),h=f,f=c),0===l&&(l=2+this._repLenDecoder.decode(this._rangeDecoder,b),e=7>e?8:11);else if(k=g,g=h,h=f,l=2+this._lenDecoder.decode(this._rangeDecoder,b),e=7>e?7:10,b=this._posSlotDecoder[5>=l?l-2:3].decode(this._rangeDecoder),
4<=b)if(c=(b>>1)-1,f=(2|b&1)<<c,14>b)f+=a.reverseDecode2(this._posDecoders,f-b-1,this._rangeDecoder,c);else{if(f+=this._rangeDecoder.decodeDirectBits(c-4)<<4,f+=this._posAlignDecoder.reverseDecode(this._rangeDecoder),0>f){if(-1===f)break;return!1}}else f=b;if(f>=n||f>=this._dictionarySizeCheck)return!1;this._outWindow.copyBlock(f,l);n+=l;l=this._outWindow.getByte(0)}this._outWindow.flush();this._outWindow.releaseStream();this._rangeDecoder.releaseStream();return!0};a.Decoder.prototype.setDecoderProperties=
function(a){var c,d;if(5>a.size)return!1;c=a.readByte();d=c%9;c=~~(c/9);if(!this.setLcLpPb(d,c%5,~~(c/5)))return!1;c=a.readByte();c|=a.readByte()<<8;c|=a.readByte()<<16;c+=16777216*a.readByte();return this.setDictionarySize(c)};a.decompress=function(b,c,d,e){var f=new a.Decoder;if(!f.setDecoderProperties(b))throw"Incorrect stream properties";if(!f.decode(c,d,e))throw"Error in data stream";return!0};a.decompressFile=function(b,c){var d=new a.Decoder,e;if(!d.setDecoderProperties(b))throw"Incorrect stream properties";
e=b.readByte();e|=b.readByte()<<8;e|=b.readByte()<<16;e+=16777216*b.readByte();b.readByte();b.readByte();b.readByte();b.readByte();if(!d.decode(b,c,e))throw"Error in data stream";return!0};return a}();SEA3D.File.LZMAUncompress=function(a){a=new Uint8Array(a);var b={data:[],position:0,writeByte:function(a){this.data[this.position++]=a}};SEA3D.LZMA.decompressFile({data:a,position:0,readByte:function(){return this.data[this.position++]}},b);return(new Uint8Array(b.data)).buffer};
SEA3D.File.setDecompressionEngine(2,"lzma",SEA3D.File.LZMAUncompress);THREE.SEA3D=function(a){this.config={id:"",scripts:!0,runScripts:!0,autoPlay:!1,dummys:!0,multiplier:1,bounding:!0,audioRolloffFactor:10,lights:!0,useEnvironment:!0,useVertexTexture:!0,forceStatic:!1,streaming:!0,async:!0,paths:{},timeLimit:10,premultipliedAlpha:!1,stageWidth:window?window.innerWidth:1024,stageHeight:window?window.innerHeight:1024};a&&this.loadConfig(a)};
THREE.SEA3D.prototype=Object.assign(Object.create(THREE.EventDispatcher.prototype),{constructor:THREE.SEA3D,container:{set:function(a){this.config.container=a},get:function(){return this.config.container}}});THREE.SEA3D.Domain=function(a,b,c){this.id=a;this.objects=b;this.container=c;this.sources=[];this.global={};this.scriptTargets=[];this.events=new THREE.EventDispatcher};
Object.assign(THREE.SEA3D.Domain.prototype,{add:function(a){this.sources.push(a)},remove:function(a){this.sources.splice(this.sources.indexOf(a),1)},contains:function(a){return-1!=this.sources.indexOf(a)},addEventListener:function(a,b){this.events.addEventListener(a,b)},hasEventListener:function(a,b){return this.events.hasEventListener(a,b)},removeEventListener:function(a,b){this.events.removeEventListener(a,b)},print:function(){console.log.apply(console,arguments)},watch:function(){console.log.apply(console,
"watch:",arguments)},runScripts:function(){for(var a=0;a<this.scriptTargets.length;a++)this.runJSMList(this.scriptTargets[a])},runJSMList:function(a){for(var b=a.scripts,c=0;c<b.length;c++)this.runJSM(a,b[c]);return b},runJSM:function(a,b){void 0==a.local&&(a.local={});var c={print:this.print,watch:this.watch,sea3d:this,scene:this.container,source:new THREE.SEA3D.ScriptDomain(this,a instanceof THREE.SEA3D.Domain)};Object.freeze(c.source);THREE.SEA3D.ScriptHandler.add(c.source);try{this.methods[b.method](c,
this.getReference,this.global,a.local,a,b.params)}catch(d){console.error('SEA3D JavaScript: Error running method "'+b.method+'".'),console.error(d)}},getReference:function(a){return eval(a)},disposeList:function(a){if(a&&a.length){a=a.concat();for(var b=a.length;b--;)a[b].dispose()}},dispatchEvent:function(a){a.domain=this;for(var b=this.sources.concat(),c=b.length;c--;)b[c].dispatchEvent(a);this.events.dispatchEvent(a)},dispose:function(){for(this.disposeList(this.sources);this.container.children.length;)this.container.remove(this.container.children[0]);
for(var a=THREE.SEA3D.EXTENSIONS_DOMAIN.length;a--;){var b=THREE.SEA3D.EXTENSIONS_DOMAIN[a];b.dispose&&b.dispose.call(this)}this.disposeList(this.materials);this.disposeList(this.dummys);this.dispatchEvent({type:"dispose"})}});THREE.SEA3D.DomainManager=function(a){this.domains=[];this.autoDisposeRootDomain=void 0==a?!0:!1};
Object.assign(THREE.SEA3D.DomainManager.prototype,{onDisposeDomain:function(a){this.remove(a.domain);this.autoDisposeRootDomain&&1==this.domains.length&&this.dispose()},add:function(a){this._onDisposeDomain=this._onDisposeDomain||this.onDisposeDomain.bind(this);a.on("dispose",this._onDisposeDomain);this.domains.push(a);this.textures=this.textures||a.textures;this.cubemaps=this.cubemaps||a.cubemaps;this.geometries=this.geometries||a.geometries},remove:function(a){a.removeEvent("dispose",this._onDisposeDomain);
this.domains.splice(this.domains.indexOf(a),1)},contains:function(a){return-1!=this.domains.indexOf(a)},disposeList:function(a){if(a&&a.length){a=a.concat();for(var b=a.length;b--;)a[b].dispose()}},dispose:function(){this.disposeList(this.domains);this.disposeList(this.textures);this.disposeList(this.cubemaps);this.disposeList(this.geometries)}});
THREE.SEA3D.ScriptDomain=function(a,b){a=a||new THREE.SEA3D.Domain;a.add(this);var c=new THREE.EventDispatcher;this.getId=function(){return a.id};this.isRoot=function(){return b};this.addEventListener=function(a,b){c.addEventListener(a,b)};this.hasEventListener=function(a,b){return c.hasEventListener(a,b)};this.removeEventListener=function(a,b){c.removeEventListener(a,b)};this.dispatchEvent=function(a){a.script=this;c.dispatchEvent(a)};this.dispose=function(){a.remove(this);b&&a.dispose();this.dispatchEvent({type:"dispose"})}};
THREE.SEA3D.ScriptManager=function(){this.scripts=[];var a=function(a){this.remove(a.script)}.bind(this);this.add=function(b){b.addEventListener("dispose",a);this.scripts.push(b)};this.remove=function(b){b.removeEventListener("dispose",a);this.scripts.splice(this.scripts.indexOf(b),1)};this.contains=function(a){return-1<this.scripts.indexOf(a)};this.dispatchEvent=function(a){for(var c=this.scripts.concat(),d=c.length;d--;)c[d].dispatchEvent(a)}};THREE.SEA3D.ScriptHandler=new THREE.SEA3D.ScriptManager;
THREE.SEA3D.ScriptHandler.dispatchUpdate=function(a){this.dispatchEvent({type:"update",delta:a})};THREE.SEA3D.Animator=function(a,b){this.clips=a;this.updateAnimations(b)};
Object.assign(THREE.SEA3D.Animator.prototype,{update:function(a){this.mixer.update(a||0);if(this.currentAnimationAction.paused&&(this.pause(),this.currentAnimationData.onComplete))this.currentAnimationData.onComplete(this);return this},updateAnimations:function(a){this.playing&&this.stop();this.mixer&&THREE.SEA3D.AnimationHandler.removeAnimator(this);this.mixer=a;this.playing=this.relative=!1;this.timeScale=1;this.animations=[];this.animationsData={};this.clips=this instanceof THREE.SEA3D.Animator?
this.clips:this.geometry.animations;a=0;for(var b=this.clips;a<b.length;a++){var c=b[a].name;this.animations[c]=this.animations[a]=b[a];this.animationsData[c]=this.animationsData[a]={}}},getStateByName:function(a){return this.animations.indexOf(this.animations[a])},getStateNameByIndex:function(a){return this.animations[a].name},pause:function(){this.playing&&this.currentAnimation&&(THREE.SEA3D.AnimationHandler.removeAnimator(this),this.playing=!1)},resume:function(){!this.playing&&this.currentAnimation&&
(THREE.SEA3D.AnimationHandler.addAnimator(this),this.playing=!0);return this},setTimeScale:function(a){this.timeScale=a;this.currentAnimationAction&&this.updateTimeScale()},getTimeScale:function(){return this.timeScale},updateTimeScale:function(){this.currentAnimationAction.setEffectiveTimeScale(this.timeScale*(this.currentAnimation?this.currentAnimation.timeScale:1))},play:function(a,b,c,d){var e=this.animations[a];if(e==this.currentAnimation)return void 0===c&&e.loop||(this.currentAnimationAction.time=
void 0!==c?c:0<=this.currentAnimationAction.timeScale?0:this.currentAnimation.duration),this.currentAnimationAction.setEffectiveWeight(void 0!==d?d:1),this.currentAnimationAction.paused=!1,this.resume();if(!e)throw Error('Animation "'+a+'" not found.');this.previousAnimation=this.currentAnimation;this.currentAnimation=e;this.previousAnimationAction=this.currentAnimationAction;this.currentAnimationAction=this.mixer.clipAction(e).setLoop(e.loop?THREE.LoopRepeat:THREE.LoopOnce,Infinity).reset();this.currentAnimationAction.clampWhenFinished=
!e.loop;this.currentAnimationAction.paused=!1;this.previousAnimationData=this.currentAnimationData;this.currentAnimationData=this.animationsData[a];this.updateTimeScale();void 0===c&&e.loop||(this.currentAnimationAction.time=void 0!==c?c:0<=this.currentAnimationAction.timeScale?0:this.currentAnimation.duration);this.currentAnimationAction.setEffectiveWeight(void 0!==d?d:1);this.currentAnimationAction.play();this.playing||this.mixer.update(0);this.playing=!0;this.previousAnimation&&this.previousAnimationAction.crossFadeTo(this.currentAnimationAction,
b||0,!0);THREE.SEA3D.AnimationHandler.addAnimator(this);return this},stop:function(){this.currentAnimation&&(this.currentAnimationAction.stop(),THREE.SEA3D.AnimationHandler.removeAnimator(this),this.previousAnimation=this.currentAnimation,this.previousAnimationData=this.currentAnimationData,this.previousAnimationAction=this.currentAnimationAction,delete this.currentAnimationAction,delete this.currentAnimationData,delete this.currentAnimation,this.playing=!1);return this},setRelative:function(a){this.relative!=
a&&(this.stop(),this.relative=a)},getRelative:function(){return this.relative}});THREE.SEA3D.Object3DAnimator=function(a,b){this.object3d=b;THREE.SEA3D.Animator.call(this,a,new THREE.AnimationMixer(b))};
THREE.SEA3D.Object3DAnimator.prototype=Object.assign(Object.create(THREE.SEA3D.Animator.prototype),{constructor:THREE.SEA3D.Object3DAnimator,stop:function(){if(this.currentAnimation){var a=this.object3d.animate;a&&this instanceof THREE.SEA3D.Object3DAnimator&&(a.position.set(0,0,0),a.quaternion.set(0,0,0,1),a.scale.set(1,1,1))}THREE.SEA3D.Animator.prototype.stop.call(this)},setRelative:function(a){THREE.SEA3D.Animator.prototype.setRelative.call(this,a);this.object3d.setAnimator(this.relative);this.updateAnimations(new THREE.AnimationMixer(this.relative?
this.object3d.animate:this.object3d))}});THREE.SEA3D.CameraAnimator=function(a,b){THREE.SEA3D.Object3DAnimator.call(this,a,b)};THREE.SEA3D.CameraAnimator.prototype=Object.assign(Object.create(THREE.SEA3D.Object3DAnimator.prototype),{constructor:THREE.SEA3D.CameraAnimator});THREE.SEA3D.SoundAnimator=function(a,b){THREE.SEA3D.Object3DAnimator.call(this,a,b)};THREE.SEA3D.SoundAnimator.prototype=Object.assign(Object.create(THREE.SEA3D.Object3DAnimator.prototype),{constructor:THREE.SEA3D.SoundAnimator});
THREE.SEA3D.LightAnimator=function(a,b){THREE.SEA3D.Object3DAnimator.call(this,a,b)};THREE.SEA3D.LightAnimator.prototype=Object.assign(Object.create(THREE.SEA3D.Object3DAnimator.prototype),{constructor:THREE.SEA3D.LightAnimator});THREE.SEA3D.Object3D=function(){THREE.Object3D.call(this)};
THREE.SEA3D.Object3D.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.SEA3D.Object3D,updateAnimateMatrix:function(a){!0===this.matrixAutoUpdate&&this.updateMatrix();if(!0===this.matrixWorldNeedsUpdate||!0===a)null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.animate.updateMatrix(),this.matrixWorld.multiplyMatrices(this.matrixWorld,this.animate.matrix),this.matrixWorldNeedsUpdate=!1,a=
!0;for(var b=0,c=this.children.length;b<c;b++)this.children[b].updateMatrixWorld(a)},setAnimator:function(a){this.getAnimator()!=a&&(a?(this.animate=new THREE.Object3D,this.updateMatrixWorld=THREE.SEA3D.Object3D.prototype.updateAnimateMatrix):(delete this.animate,this.updateMatrixWorld=THREE.Object3D.prototype.updateMatrixWorld),this.matrixWorldNeedsUpdate=!0)},getAnimator:function(){return void 0!=this.animate}});THREE.SEA3D.HELPER_COLOR=10140133;
THREE.SEA3D.Dummy=function(a,b,c){this.width=void 0!=a?a:100;this.height=void 0!=b?b:100;this.depth=void 0!=c?c:100;a=new THREE.BoxGeometry(this.width,this.height,this.depth,1,1,1);a.computeBoundingBox();a.computeBoundingSphere();THREE.Mesh.call(this,a,THREE.SEA3D.Dummy.MATERIAL)};THREE.SEA3D.Dummy.MATERIAL=new THREE.MeshBasicMaterial({wireframe:!0,color:THREE.SEA3D.HELPER_COLOR});
THREE.SEA3D.Dummy.prototype=Object.assign(Object.create(THREE.Mesh.prototype),THREE.SEA3D.Object3D.prototype,{constructor:THREE.SEA3D.Dummy,copy:function(a){THREE.Mesh.prototype.copy.call(this,a);this.attribs=a.attribs;this.scripts=a.scripts;this.animator&&(this.animator=a.animator.clone(this));return this},dispose:function(){this.geometry.dispose()}});THREE.SEA3D.Mesh=function(a,b){THREE.Mesh.call(this,a,b)};
THREE.SEA3D.Mesh.prototype=Object.assign(Object.create(THREE.Mesh.prototype),THREE.SEA3D.Mesh.prototype,THREE.SEA3D.Object3D.prototype,{constructor:THREE.SEA3D.Mesh,setWeight:function(a,b){this.morphTargetInfluences[this.morphTargetDictionary[a]]=b},getWeight:function(a){return this.morphTargetInfluences[this.morphTargetDictionary[a]]},copy:function(a){THREE.Mesh.prototype.copy.call(this,a);this.attribs=a.attribs;this.scripts=a.scripts;this.animator&&(this.animator=a.animator.clone(this));return this}});
THREE.SEA3D.SkinnedMesh=function(a,b,c){THREE.SkinnedMesh.call(this,a,b,c);this.updateAnimations(new THREE.AnimationMixer(this))};
THREE.SEA3D.SkinnedMesh.prototype=Object.assign(Object.create(THREE.SkinnedMesh.prototype),THREE.SEA3D.Mesh.prototype,THREE.SEA3D.Animator.prototype,{constructor:THREE.SEA3D.SkinnedMesh,boneByName:function(a){for(var b=this.skeleton.bones,c=0,d=b.length;c<d;c++)if(a==b[c].name)return b[c]},copy:function(a){THREE.SkinnedMesh.prototype.copy.call(this,a);this.attribs=a.attribs;this.scripts=a.scripts;this.animator&&(this.animator=a.animator.clone(this));return this}});
THREE.SEA3D.VertexAnimationMesh=function(a,b){THREE.Mesh.call(this,a,b);this.type="MorphAnimMesh";this.updateAnimations(new THREE.AnimationMixer(this))};
THREE.SEA3D.VertexAnimationMesh.prototype=Object.assign(Object.create(THREE.Mesh.prototype),THREE.SEA3D.Mesh.prototype,THREE.SEA3D.Animator.prototype,{constructor:THREE.SEA3D.VertexAnimationMesh,copy:function(a){THREE.Mesh.prototype.copy.call(this,a);this.attribs=a.attribs;this.scripts=a.scripts;this.animator&&(this.animator=a.animator.clone(this));return this}});THREE.SEA3D.Camera=function(a,b,c,d){THREE.PerspectiveCamera.call(this,a,b,c,d)};
THREE.SEA3D.Camera.prototype=Object.assign(Object.create(THREE.PerspectiveCamera.prototype),THREE.SEA3D.Object3D.prototype,{constructor:THREE.SEA3D.Camera,copy:function(a){THREE.PerspectiveCamera.prototype.copy.call(this,a);this.attribs=a.attribs;this.scripts=a.scripts;this.animator&&(this.animator=a.animator.clone(this));return this}});THREE.SEA3D.OrthographicCamera=function(a,b,c,d,e,f){THREE.OrthographicCamera.call(this,a,b,c,d,e,f)};
THREE.SEA3D.OrthographicCamera.prototype=Object.assign(Object.create(THREE.OrthographicCamera.prototype),THREE.SEA3D.Object3D.prototype,{constructor:THREE.SEA3D.OrthographicCamera,copy:function(a){THREE.OrthographicCamera.prototype.copy.call(this,a);this.attribs=a.attribs;this.scripts=a.scripts;this.animator&&(this.animator=a.animator.clone(this));return this}});THREE.SEA3D.PointLight=function(a,b,c,d){THREE.PointLight.call(this,a,b,c,d)};
THREE.SEA3D.PointLight.prototype=Object.assign(Object.create(THREE.PointLight.prototype),THREE.SEA3D.Object3D.prototype,{constructor:THREE.SEA3D.PointLight,copy:function(a){THREE.PointLight.prototype.copy.call(this,a);this.attribs=a.attribs;this.scripts=a.scripts;this.animator&&(this.animator=a.animator.clone(this));return this}});THREE.SEA3D.PointSound=function(a){THREE.PositionalAudio.call(this,a)};
THREE.SEA3D.PointSound.prototype=Object.assign(Object.create(THREE.PositionalAudio.prototype),THREE.SEA3D.Object3D.prototype,{constructor:THREE.SEA3D.PointSound,copy:function(a){THREE.PositionalAudio.prototype.copy.call(this,a);this.attribs=a.attribs;this.scripts=a.scripts;this.animator&&(this.animator=a.animator.clone(this));return this}});
THREE.SEA3D.AnimationHandler={animators:[],update:function(a){for(var b=0;b<this.animators.length;)this.animators[b++].update(a)},addAnimator:function(a){-1===this.animators.indexOf(a)&&this.animators.push(a)},removeAnimator:function(a){a=this.animators.indexOf(a);-1!==a&&this.animators.splice(a,1)}};THREE.SEA3D.MTXBUF=new THREE.Matrix4;THREE.SEA3D.VECBUF=new THREE.Vector3;THREE.SEA3D.QUABUF=new THREE.Quaternion;THREE.SEA3D.BACKGROUND_COLOR=3355443;THREE.SEA3D.RTT_SIZE=512;
THREE.SEA3D.prototype.setShadowMap=function(a){a.shadow.mapSize.width=2048;a.shadow.mapSize.height=1024;a.castShadow=!0;a.shadow.camera.left=-200;a.shadow.camera.right=200;a.shadow.camera.top=200;a.shadow.camera.bottom=-200;a.shadow.camera.near=1;a.shadow.camera.far=3E3;a.shadow.camera.fov=45;a.shadow.bias=-0.001};THREE.SEA3D.Domain.prototype.getMesh=THREE.SEA3D.prototype.getMesh=function(a){return this.objects["m3d/"+a]};
THREE.SEA3D.Domain.prototype.getDummy=THREE.SEA3D.prototype.getDummy=function(a){return this.objects["dmy/"+a]};THREE.SEA3D.Domain.prototype.getLine=THREE.SEA3D.prototype.getLine=function(a){return this.objects["line/"+a]};THREE.SEA3D.Domain.prototype.getSound3D=THREE.SEA3D.prototype.getSound3D=function(a){return this.objects["sn3d/"+a]};THREE.SEA3D.Domain.prototype.getMaterial=THREE.SEA3D.prototype.getMaterial=function(a){return this.objects["mat/"+a]};
THREE.SEA3D.Domain.prototype.getLight=THREE.SEA3D.prototype.getLight=function(a){return this.objects["lht/"+a]};THREE.SEA3D.Domain.prototype.getGLSL=THREE.SEA3D.prototype.getGLSL=function(a){return this.objects["glsl/"+a]};THREE.SEA3D.Domain.prototype.getCamera=THREE.SEA3D.prototype.getCamera=function(a){return this.objects["cam/"+a]};THREE.SEA3D.Domain.prototype.getTexture=THREE.SEA3D.prototype.getTexture=function(a){return this.objects["tex/"+a]};
THREE.SEA3D.Domain.prototype.getCubeMap=THREE.SEA3D.prototype.getCubeMap=function(a){return this.objects["cmap/"+a]};THREE.SEA3D.Domain.prototype.getJointObject=THREE.SEA3D.prototype.getJointObject=function(a){return this.objects["jnt/"+a]};THREE.SEA3D.Domain.prototype.getContainer3D=THREE.SEA3D.prototype.getContainer3D=function(a){return this.objects["c3d/"+a]};THREE.SEA3D.Domain.prototype.getSprite=THREE.SEA3D.prototype.getSprite=function(a){return this.objects["m2d/"+a]};
THREE.SEA3D.Domain.prototype.getProperties=THREE.SEA3D.prototype.getProperties=function(a){return this.objects["prop/"+a]};THREE.SEA3D.prototype.isPowerOfTwo=function(a){return a?(a&-a)==a:!1};THREE.SEA3D.prototype.nearestPowerOfTwo=function(a){return Math.pow(2,Math.round(Math.log(a)/Math.LN2))};
THREE.SEA3D.prototype.updateTransform=function(a,b){var c=THREE.SEA3D.MTXBUF,d=THREE.SEA3D.VECBUF;b.transform?c.elements.set(b.transform):c.makeTranslation(b.position.x,b.position.y,b.position.z);a.position.setFromMatrixPosition(c);a.scale.setFromMatrixScale(c);c.scale(d.set(1/a.scale.x,1/a.scale.y,1/a.scale.z));a.rotation.setFromRotationMatrix(c);if(this.config.forceStatic||b.isStatic)a.updateMatrix(),a.matrixAutoUpdate=!1};
THREE.SEA3D.prototype.toVector3=function(a){return new THREE.Vector3(a.x,a.y,a.z)};THREE.SEA3D.prototype.toFaces=function(a){var b=[];b[0]=a[1];b[1]=a[0];b[2]=a[3];b[3]=a[2];b[4]=a[5];b[5]=a[4];return b};THREE.SEA3D.prototype.updateScene=function(){if(void 0!=this.materials)for(var a=0,b=this.materials.length;a<b;++a)this.materials[a].needsUpdate=!0};
THREE.SEA3D.prototype.addSceneObject=function(a){var b=a.tag;b.visible=a.visible;a.parent?a.parent.tag.add(b):this.config.container&&this.config.container.add(b);a.attributes&&(b.attribs=a.attributes.tag);a.scripts&&(b.scripts=this.getJSMList(b,a.scripts),this.config.runScripts&&this.domain.runJSMList(b))};THREE.SEA3D.prototype.createObjectURL=function(a,b){return(window.URL||window.webkitURL).createObjectURL(new Blob([a],{type:b}))};
THREE.SEA3D.prototype.bufferToTexture=function(a){return this.createObjectURL(a,"image")};THREE.SEA3D.prototype.bufferToSound=function(a){return this.createObjectURL(a,"audio")};THREE.SEA3D.prototype.parsePath=function(a){var b=this.config.paths,c;for(c in b)a=a.replace(RegExp("%"+c+"%","g"),b[c]);return a};
THREE.SEA3D.prototype.applyDefaultAnimation=function(a,b){for(var c=a.tag,d=0,e=a.animations?a.animations.length:0;d<e;d++){var f=a.animations[d];switch(f.tag.type){case SEA3D.Animation.prototype.type:return c.animator=new b(f.tag.tag,c),c.animator.setRelative(f.relative),this.config.autoPlay&&c.animator.play(0),c.animator}}};
THREE.SEA3D.prototype.readAnimation=function(a){for(var b=[],c=1E3/a.frameRate/1E3,d=0;d<a.sequence.length;d++){for(var e=a.sequence[d],f=[],h=0;h<a.dataList.length;h++){var g=a.dataList[h],k,n=g.data,l=e.start*g.blockSize;k=l+e.count*g.blockSize;var s=e.intrpl?THREE.InterpolateLinear:!1,p=null;switch(g.kind){case SEA3D.Animation.POSITION:p=".position";break;case SEA3D.Animation.ROTATION:p=".quaternion";break;case SEA3D.Animation.SCALE:p=".scale";break;case SEA3D.Animation.COLOR:p=".color";break;
case SEA3D.Animation.MULTIPLIER:p=".intensity";break;case SEA3D.Animation.FOV:p=".fov"}if(p)switch(g.type){case SEA3D.Stream.BYTE:case SEA3D.Stream.UBYTE:case SEA3D.Stream.INT:case SEA3D.Stream.UINT:case SEA3D.Stream.FLOAT:case SEA3D.Stream.DOUBLE:case SEA3D.Stream.DECIMAL:l=n.subarray(l,k);k=new Float32Array(l.length);for(var q=0,g=0;q<k.length;q++)k[q]=g,g+=c;f.push(new THREE.VectorKeyframeTrack(p,k,l,s));break;case SEA3D.Stream.VECTOR3D:l=n.subarray(l,k);k=new Float32Array(l.length/g.blockSize);
for(g=q=0;q<k.length;q++)k[q]=g,g+=c;f.push(new THREE.VectorKeyframeTrack(p,k,l,s));break;case SEA3D.Stream.VECTOR4D:l=n.subarray(l,k);k=new Float32Array(l.length/g.blockSize);for(g=q=0;q<k.length;q++)k[q]=g,g+=c;f.push(new THREE.QuaternionKeyframeTrack(p,k,l,s));break;case SEA3D.Stream.INT24:case SEA3D.Stream.UINT24:l=new Float32Array(3*(k-l));k=new Float32Array(l.length/3);for(g=q=0;q<k.length;q++)l[3*q]=(n[q]>>16&255)/255,l[3*q+1]=(n[q]>>8&255)/255,l[3*q+2]=(n[q]&255)/255,k[q]=g,g+=c;f.push(new THREE.VectorKeyframeTrack(p,
k,l,s))}}f=new THREE.AnimationClip(e.name,-1,f);f.loop=e.repeat;f.timeScale=1;b.push(f)}this.domain.animationClips=this.animationClips=this.animationClips||[];this.animationClips.push(this.objects[a.name+".#anm"]=a.tag=b)};
THREE.SEA3D.prototype.readGeometryBuffer=function(a){for(var b=new THREE.BufferGeometry,c=0;c<a.groups.length;c++){var d=a.groups[c];b.addGroup(d.start,d.count,c)}b.setIndex(new THREE.BufferAttribute(a.indexes,1));b.addAttribute("position",new THREE.BufferAttribute(a.vertex,3));a.uv&&(b.addAttribute("uv",new THREE.BufferAttribute(a.uv[0],2)),1<a.uv.length&&b.addAttribute("uv2",new THREE.BufferAttribute(a.uv[1],2)));a.normal?b.addAttribute("normal",new THREE.BufferAttribute(a.normal,3)):b.computeVertexNormals();
a.tangent4&&b.addAttribute("tangent",new THREE.BufferAttribute(a.tangent4,4));a.color&&b.addAttribute("color",new THREE.BufferAttribute(a.color[0],a.numColor));a.joint&&(b.addAttribute("skinIndex",new THREE.Float32Attribute(a.joint,a.jointPerVertex)),b.addAttribute("skinWeight",new THREE.Float32Attribute(a.weight,a.jointPerVertex)));this.config.bounding&&(b.computeBoundingBox(),b.computeBoundingSphere());b.name=a.name;this.domain.geometries=this.geometries=this.geometries||[];this.geometries.push(this.objects["geo/"+
a.name]=a.tag=b)};THREE.SEA3D.prototype.readDummy=function(a){var b=new THREE.SEA3D.Dummy(a.width,a.height,a.depth);b.name=a.name;this.domain.dummys=this.dummys=this.dummys||[];this.dummys.push(this.objects["dmy/"+a.name]=a.tag=b);this.addSceneObject(a);this.updateTransform(b,a);this.applyDefaultAnimation(a,THREE.SEA3D.Object3DAnimator)};
THREE.SEA3D.prototype.readLine=function(a){var b=new THREE.BufferGeometry;a.closed&&a.vertex.push(a.vertex[0],a.vertex[1],a.vertex[2]);b.addAttribute("position",new THREE.BufferAttribute(new Float32Array(a.vertex),3));b=new THREE.Line(b,new THREE.LineBasicMaterial({color:THREE.SEA3D.HELPER_COLOR,linewidth:3}));b.name=a.name;this.lines=this.lines||[];this.lines.push(this.objects["line/"+a.name]=a.tag=b);this.addSceneObject(a);this.updateTransform(b,a);this.applyDefaultAnimation(a,THREE.SEA3D.Object3DAnimator)};
THREE.SEA3D.prototype.readContainer3D=function(a){var b=new THREE.SEA3D.Object3D;this.domain.containers=this.containers=this.containers||[];this.containers.push(this.objects["c3d/"+a.name]=a.tag=b);this.addSceneObject(a);this.updateTransform(b,a);this.applyDefaultAnimation(a,THREE.SEA3D.Object3DAnimator)};
THREE.SEA3D.prototype.readSprite=function(a){var b;a.material&&(a.material.tag.sprite?b=a.material.tag.sprite:(b=a.material.tag.sprite=new THREE.SpriteMaterial,this.setBlending(b,a.blendMode),b.map=a.material.tag.map,b.map.flipY=!0,b.color.set(a.material.tag.color),b.opacity=a.material.tag.opacity,b.blending=a.material.tag.blending,b.fog=a.material.receiveFog));b=new THREE.Sprite(b);b.name=a.name;this.domain.sprites=this.sprites=this.sprites||[];this.sprites.push(this.objects["m2d/"+a.name]=a.tag=
b);this.addSceneObject(a);this.updateTransform(b,a);b.scale.set(a.width,a.height,1)};
THREE.SEA3D.prototype.readMesh=function(a){var b,c,d=a.geometry.tag,e,f,h,g,k;b=0;for(c=a.modifiers?a.modifiers.length:0;b<c;b++){var n=a.modifiers[b];switch(n.type){case SEA3D.Skeleton.prototype.type:case SEA3D.SkeletonLocal.prototype.type:f=n;d.bones=f.tag;break;case SEA3D.Morph.prototype.type:k=n,d.morphAttributes=k.tag.attribs,d.morphTargets=k.tag.targets}}b=0;for(c=a.animations?a.animations.length:0;b<c;b++)switch(n=a.animations[b],n.tag.type){case SEA3D.SkeletonAnimation.prototype.type:h=n.tag;
d.animations=this.getSkeletonAnimation(h,f);break;case SEA3D.VertexAnimation.prototype.type:g=n.tag,d.morphAttributes=g.tag.attribs,d.morphTargets=g.tag.targets,d.animations=g.tag.animations}c=void 0!=k||void 0!=g;k=k&&void 0!=k.tag.attribs.normal||g&&void 0!=g.tag.attribs.normal;if(a.material)if(1<a.material.length){e=[];for(b=0;b<a.material.length;b++)e[b]=a.material[b].tag,e[b].skinning=void 0!=f,e[b].morphTargets=c,e[b].morphNormals=k,e[b].vertexColors=a.geometry.color?THREE.VertexColors:THREE.NoColors;
e=new THREE.MultiMaterial(e)}else e=a.material[0].tag,e.skinning=void 0!=f,e.morphTargets=c,e.morphNormals=k,e.vertexColors=a.geometry.color?THREE.VertexColors:THREE.NoColors;f?(b=new THREE.SEA3D.SkinnedMesh(d,e,this.config.useVertexTexture),this.config.autoPlay&&h&&b.play(0)):g?(b=new THREE.SEA3D.VertexAnimationMesh(d,e,g.frameRate),this.config.autoPlay&&b.play(0)):b=new THREE.SEA3D.Mesh(d,e);b.name=a.name;b.castShadow=a.castShadows;b.receiveShadow=a.material?a.material[0].receiveShadows:!0;this.domain.meshes=
this.meshes=this.meshes||[];this.meshes.push(this.objects["m3d/"+a.name]=a.tag=b);this.addSceneObject(a);this.updateTransform(b,a);this.applyDefaultAnimation(a,THREE.SEA3D.Object3DAnimator)};
THREE.SEA3D.prototype.readSoundPoint=function(a){this.audioListener||(this.audioListener=new THREE.AudioListener,this.config.container&&this.config.container.add(this.audioListener));var b=new THREE.SEA3D.PointSound(this.audioListener);(new THREE.AudioLoader).load(a.sound.tag,function(a){b.setBuffer(a)});b.autoplay=a.autoPlay;b.setLoop(a.autoPlay);b.setVolume(a.volume);b.setRefDistance(a.distance);b.setRolloffFactor(this.config.audioRolloffFactor);b.name=a.name;this.domain.sounds3d=this.sounds3d=
this.sounds3d||[];this.sounds3d.push(this.objects["sn3d/"+a.name]=a.tag=b);this.addSceneObject(a);this.updateTransform(b,a);this.applyDefaultAnimation(a,THREE.SEA3D.SoundAnimator)};
THREE.SEA3D.prototype.readCubeRender=function(a){var b=new THREE.CubeCamera(0.1,5E3,THREE.SEA3D.RTT_SIZE);b.renderTarget.cubeCamera=b;this.domain.cubeRenderers=this.cubeRenderers=this.cubeRenderers||[];this.cubeRenderers.push(this.objects["rttc/"+a.name]=a.tag=b.renderTarget);this.addSceneObject(a);this.updateTransform(b,a);this.applyDefaultAnimation(a,THREE.SEA3D.Object3DAnimator)};
THREE.SEA3D.prototype.readTexture=function(a){var b=new Image,c=new THREE.Texture;c.name=a.name;c.wrapS=c.wrapT=THREE.RepeatWrapping;c.flipY=!1;c.image=b;void 0!==this.config.anisotropy&&(c.anisotropy=this.config.anisotropy);b.onload=function(){c.needsUpdate=!0};b.src=this.bufferToTexture(a.data.buffer);this.domain.textures=this.textures=this.textures||[];this.textures.push(this.objects["tex/"+a.name]=a.tag=c)};
THREE.SEA3D.prototype.readCubeMap=function(a){var b=this.toFaces(a.faces),c=new THREE.CubeTexture([]),d=0;c.name=a.name;c.flipY=!1;c.format=THREE.RGBFormat;for(var e=function(){6==++d&&(c.needsUpdate=!0,this.config.async||(this.file.resume=!0))}.bind(this),f=0;f<b.length;++f){var h=new Image;h.onload=e;h.src=this.bufferToTexture(b[f].buffer);c.images[f]=h}this.config.async||(this.file.resume=!1);this.domain.cubemaps=this.cubemaps=this.cubemaps||[];this.cubemaps.push(this.objects["cmap/"+a.name]=a.tag=
c)};THREE.SEA3D.prototype.readSound=function(a){var b=this.bufferToSound(a.data.buffer);this.domain.sounds=this.sounds=this.sounds||[];this.sounds.push(this.objects["snd/"+a.name]=a.tag=b)};THREE.SEA3D.prototype.readScriptURL=function(a){this.file.resume=!1;this.request(a.url,function(b){this.file.resume=!0;this.domain.scripts=this.scripts=this.scripts||[];this.scripts.push(this.objects["src/"+a.name]=a.tag=b)}.bind(this))};
THREE.SEA3D.prototype.readTextureURL=function(a){var b=(new THREE.TextureLoader).load(this.parsePath(a.url));b.name=a.name;b.wrapS=b.wrapT=THREE.RepeatWrapping;b.flipY=!1;void 0!==this.config.anisotropy&&(b.anisotropy=this.config.anisotropy);this.domain.textures=this.textures=this.textures||[];this.textures.push(this.objects["tex/"+a.name]=a.tag=b)};
THREE.SEA3D.prototype.readCubeMapURL=function(a){for(var b=this.toFaces(a.faces),c=0;c<b.length;c++)b[c]=this.parsePath(b[c]);if("hdr"==b[0].substr(-3)){var d=null!=THREE.PMREMGenerator;this.file.resume=!d;b=(new THREE.HDRCubeTextureLoader).load(THREE.UnsignedByteType,b,function(b){if(d){var c=new THREE.PMREMGenerator(b);c.update(this.config.renderer);c=new THREE.PMREMCubeUVPacker(c.cubeLods);c.update(this.config.renderer);b.dispose();this.objects["cmap/"+a.name]=a.tag=c.CubeUVRenderTarget.texture;
this.file.resume=!0}}.bind(this))}else b=(new THREE.CubeTextureLoader).load(b);b.name=a.name;b.wrapS=b.wrapT=THREE.RepeatWrapping;b.flipY=!1;void 0!==this.config.anisotropy&&(b.anisotropy=this.config.anisotropy);this.domain.cubemaps=this.cubemaps=this.cubemaps||[];this.cubemaps.push(this.objects["cmap/"+a.name]=a.tag=b)};
THREE.SEA3D.prototype.getJSMList=function(a,b){for(var c=[],d=0;d<b.length;d++){var e=b[d];e.tag.type==SEA3D.JavaScriptMethod.prototype.type&&c.push(e)}this.domain.scriptTargets=this.scriptTargets=this.scriptTargets||[];this.scriptTargets.push(a);return c};
THREE.SEA3D.prototype.readJavaScriptMethod=function(a){try{var b="(function() {\nvar $METHOD = {}\n",c='function($INC, $REF, global, local, $his, $PARAM) {\nvar watch = $INC["watch"],\nscene = $INC["scene"],\nsea3d = $INC["sea3d"],\nprint = $INC["print"];\n',c=c+'var $SRC = $INC["source"],\naddEventListener = $SRC.addEventListener.bind( $SRC ),\nhasEventListener = $SRC.hasEventListener.bind( $SRC ),\nremoveEventListener = $SRC.removeEventListener.bind( $SRC ),\ndispatchEvent = $SRC.dispatchEvent.bind( $SRC ),\ndispose = $SRC.dispose.bind( $SRC );\n',
d;for(d in a.methods)b+='$METHOD["'+d+'"] = '+c+a.methods[d].src+"}\n";this.domain.methods=eval(b+"return $METHOD; })")()}catch(e){console.error('SEA3D JavaScriptMethod: Error running "'+a.name+'".'),console.error(e)}};THREE.SEA3D.prototype.readGLSL=function(a){this.domain.glsl=this.glsl=this.glsl||[];this.glsl.push(this.objects["glsl/"+a.name]=a.tag=a.src)};
THREE.SEA3D.prototype.materialTechnique=function(){var a={onComplete:function(a,c){if(1>c.alpha||a.blending>THREE.NormalBlending)a.opacity=c.alpha,a.transparent=!0}};a[SEA3D.Material.PHYSICAL]=function(a,c){a.color.setHex(c.color);a.roughness=c.roughness;a.metalness=c.metalness};a[SEA3D.Material.PHONG]=function(a,c){a.color.setHex(c.diffuseColor);a.specular.setHex(c.specularColor).multiplyScalar(c.specular);a.shininess=c.gloss};a[SEA3D.Material.DIFFUSE_MAP]=function(a,c,d){a.map=c.texture.tag;a.color.setHex(16777215);
c.texture.transparent&&(a.transparent=!0)};a[SEA3D.Material.ROUGHNESS_MAP]=function(a,c){a.roughnessMap=c.texture.tag};a[SEA3D.Material.METALNESS_MAP]=function(a,c){a.metalnessMap=c.texture.tag};a[SEA3D.Material.SPECULAR_MAP]=function(a,c){a.specular&&(a.specularMap=c.texture.tag,a.specular.setHex(16777215))};a[SEA3D.Material.NORMAL_MAP]=function(a,c){a.normalMap=c.texture.tag};a[SEA3D.Material.REFLECTION]=a[SEA3D.Material.FRESNEL_REFLECTION]=function(a,c){a.envMap=c.texture.tag;a.envMap.mapping=
THREE.CubeReflectionMapping;a.combine=THREE.MixOperation;a.reflectivity=c.alpha};a[SEA3D.Material.REFLECTION_SPHERICAL]=function(a,c){a.envMap=c.texture.tag;a.envMap.mapping=THREE.SphericalReflectionMapping;a.combine=THREE.MixOperation;a.reflectivity=c.alpha};a[SEA3D.Material.REFRACTION_MAP]=function(a,c){a.envMap=c.texture.tag;a.envMap.mapping=THREE.CubeRefractionMapping;a.refractionRatio=c.ior;a.reflectivity=c.alpha};a[SEA3D.Material.LIGHT_MAP]=function(a,c){"multiply"==c.blendMode?a.aoMap=c.texture.tag:
a.lightMap=c.texture.tag};a[SEA3D.Material.ALPHA_MAP]=function(a,c){a.alphaMap=c.texture.tag;a.transparent=!0};return a}();THREE.SEA3D.prototype.createMaterial=function(a){return a.physical?new THREE.MeshStandardMaterial:new THREE.MeshPhongMaterial};
THREE.SEA3D.prototype.setBlending=function(a,b){if("normal"!=b){switch(b){case "add":a.blending=THREE.AdditiveBlending;break;case "subtract":a.blending=THREE.SubtractiveBlending;break;case "multiply":a.blending=THREE.MultiplyBlending;break;case "screen":a.blending=THREE.CustomBlending,a.blendSrc=THREE.OneFactor,a.blendDst=THREE.OneMinusSrcColorFactor,a.blendEquation=THREE.AddEquation}a.transparent=!0}};
THREE.SEA3D.prototype.readMaterial=function(a){var b=this.createMaterial(a);b.name=a.name;b.premultipliedAlpha=this.config.premultipliedAlpha;b.side=a.bothSides?THREE.DoubleSide:THREE.FrontSide;this.setBlending(b,a.blendMode);for(var c=0;c<a.technique.length;c++){var d=a.technique[c];this.materialTechnique[d.kind]&&this.materialTechnique[d.kind].call(this,b,d,a)}this.materialTechnique.onComplete&&this.materialTechnique.onComplete.call(this,b,a);this.domain.materials=this.materials=this.materials||
[];this.materials.push(this.objects["mat/"+a.name]=a.tag=b)};THREE.SEA3D.prototype.readPointLight=function(a){var b=new THREE.SEA3D.PointLight(a.color,a.multiplier*this.config.multiplier);b.name=a.name;a.attenuation&&(b.distance=a.attenuation.end);a.shadow&&this.setShadowMap(b);this.domain.lights=this.lights=this.lights||[];this.lights.push(this.objects["lht/"+a.name]=a.tag=b);this.addSceneObject(a);this.updateTransform(b,a);this.applyDefaultAnimation(a,THREE.SEA3D.LightAnimator);this.updateScene()};
THREE.SEA3D.prototype.readHemisphereLight=function(a){var b=new THREE.HemisphereLight(a.color,a.secondColor,a.multiplier*this.config.multiplier);b.position.set(0,500,0);b.name=a.name;this.domain.lights=this.lights=this.lights||[];this.lights.push(this.objects["lht/"+a.name]=a.tag=b);this.addSceneObject(a);this.applyDefaultAnimation(a,THREE.SEA3D.LightAnimator);this.updateScene()};
THREE.SEA3D.prototype.readAmbientLight=function(a){var b=new THREE.AmbientLight(a.color,a.multiplier*this.config.multiplier);b.name=a.name;this.domain.lights=this.lights=this.lights||[];this.lights.push(this.objects["lht/"+a.name]=a.tag=b);this.addSceneObject(a);this.applyDefaultAnimation(a,THREE.SEA3D.LightAnimator);this.updateScene()};
THREE.SEA3D.prototype.readDirectionalLight=function(a){var b=new THREE.DirectionalLight(a.color,a.multiplier*this.config.multiplier);b.name=a.name;a.shadow&&this.setShadowMap(b);this.domain.lights=this.lights=this.lights||[];this.lights.push(this.objects["lht/"+a.name]=a.tag=b);this.addSceneObject(a);this.updateTransform(b,a);this.applyDefaultAnimation(a,THREE.SEA3D.LightAnimator);this.updateScene()};
THREE.SEA3D.prototype.readCamera=function(a){var b=new THREE.SEA3D.Camera(a.fov);b.name=a.name;this.domain.cameras=this.cameras=this.cameras||[];this.cameras.push(this.objects["cam/"+a.name]=a.tag=b);this.addSceneObject(a);this.updateTransform(b,a);this.applyDefaultAnimation(a,THREE.SEA3D.CameraAnimator)};
THREE.SEA3D.prototype.readOrthographicCamera=function(a){var b,c;this.config.stageWidth>this.config.stageHeight?(b=this.config.stageWidth/this.config.stageHeight,c=a.height*b,b=a.height):(b=this.config.stageHeight/this.config.stageWidth,c=a.height,b*=a.height);c=new THREE.SEA3D.OrthographicCamera(-c,c,b,-b);c.name=a.name;this.domain.cameras=this.cameras=this.cameras||[];this.cameras.push(this.objects["cam/"+a.name]=a.tag=c);this.addSceneObject(a);this.updateTransform(c,a);this.applyDefaultAnimation(a,
THREE.SEA3D.CameraAnimator)};THREE.SEA3D.prototype.readSkeletonLocal=function(a){for(var b=[],c=0;c<a.joint.length;c++){var d=a.joint[c];b[c]={name:d.name,pos:[d.x,d.y,d.z],rotq:[d.qx,d.qy,d.qz,d.qw],parent:d.parentIndex}}a.tag=b};THREE.SEA3D.prototype.readJointObject=function(a){var b=a.target.tag.skeleton.bones[a.joint];this.domain.joints=this.joints=this.joints||[];this.joints.push(this.objects["jnt/"+a.name]=a.tag=b)};
THREE.SEA3D.prototype.readMorpher=function(a){for(var b={position:[]},c=[],d=0;d<a.node.length;d++){var e=a.node[d];b.position[d]=new THREE.Float32Attribute(new Float32Array(e.vertex),3);e.normal&&(b.normal=b.normal||[],b.normal[d]=new THREE.Float32Attribute(new Float32Array(e.normal),3));c[d]={name:e.name}}a.tag={attribs:b,targets:c}};
THREE.SEA3D.prototype.getSkeletonAnimation=function(a,b){if(a.tag)return a.tag;for(var c=[],d=1E3/a.frameRate/1E3,e=0;e<a.sequence.length;e++){for(var f=a.sequence[e],h=f.start,g=h+f.count,k={name:f.name,fps:a.frameRate,length:d*f.count,hierarchy:[]},n=a.numJoints,l=a.raw,s=0;s<n;s++){for(var p={parent:b.joint[s].parentIndex,keys:[]},q=p.keys,t=0,r=h;r<g;r++){var m=r*n*7+7*s;q.push({time:t,pos:[l[m],l[m+1],l[m+2]],rot:[l[m+3],l[m+4],l[m+5],l[m+6]],scl:[1,1,1]});t+=d}k.hierarchy[s]=p}h=THREE.AnimationClip.parseAnimation(k,
b.tag);h.loop=f.repeat;h.timeScale=1;c.push(h)}return a.tag=c};
THREE.SEA3D.prototype.readVertexAnimation=function(a){var b={position:[]},c=[],d=[],e,f,h;e=0;for(h=a.frame.length;e<h;e++)f=a.frame[e],b.position[e]=new THREE.Float32Attribute(new Float32Array(f.vertex),3),f.normal&&(b.normal=b.normal||[],b.normal[e]=new THREE.Float32Attribute(new Float32Array(f.normal),3)),c[e]={name:e};for(e=0;e<a.sequence.length;e++){h=a.sequence[e];var g=[];for(f=0;f<h.count;f++)g[f]=c[h.start+f];f=THREE.AnimationClip.CreateFromMorphTargetSequence(h.name,g,a.frameRate);f.loop=
h.repeat;f.timeScale=1;d.push(f)}a.tag={attribs:b,targets:c,animations:d}};
THREE.SEA3D.prototype.readActions=function(a){for(var b=0;b<a.actions.length;b++){var c=a.actions[b];switch(c.kind){case SEA3D.Actions.ATTRIBUTES:this.attribs=this.domain.attribs=c.attributes.tag;break;case SEA3D.Actions.SCRIPTS:this.domain.scripts=this.getJSMList(this.domain,c.scripts);this.config.runScripts&&this.domain.runJSMList(this.domain);break;case SEA3D.Actions.ENVIRONMENT_COLOR:this.domain.background=this.background=this.background||{};this.background.color=new THREE.Color(c.color);break;
case SEA3D.Actions.ENVIRONMENT:if(this.config.useEnvironment&&void 0!=this.materials)for(var d=0,e=this.materials.length;d<e;++d){var f=this.materials[d];f instanceof THREE.MeshStandardMaterial&&!f.envMap&&(f.envMap=c.texture.tag,f.envMap.mapping=THREE.CubeReflectionMapping,f.needsUpdate=!0)}this.domain.background=this.background=this.background||{};this.background.texture=c.texture.tag}}};
THREE.SEA3D.Event={PROGRESS:"sea3d_progress",LOAD_PROGRESS:"sea3d_load",DOWNLOAD_PROGRESS:"sea3d_download",COMPLETE:"sea3d_complete",OBJECT_COMPLETE:"sea3d_object",PARSE_PROGRESS:"parse_progress",PARSE_COMPLETE:"parse_complete",ERROR:"sea3d_error"};THREE.SEA3D.prototype.onProgress=function(a){a.status=a.type;a.progress=a.loaded/a.total;a.type=THREE.SEA3D.Event.PROGRESS;this.dispatchEvent(a)};
THREE.SEA3D.prototype.onLoadProgress=function(a){a.type=THREE.SEA3D.Event.LOAD_PROGRESS;this.dispatchEvent(a);this.onProgress(a)};THREE.SEA3D.prototype.onDownloadProgress=function(a){a.type=THREE.SEA3D.Event.DOWNLOAD_PROGRESS;this.dispatchEvent(a);this.onProgress(a)};THREE.SEA3D.prototype.onComplete=function(a){a.type=THREE.SEA3D.Event.COMPLETE;this.dispatchEvent(a)};THREE.SEA3D.prototype.onCompleteObject=function(a){a.type=THREE.SEA3D.Event.OBJECT_COMPLETE;this.dispatchEvent(a)};
THREE.SEA3D.prototype.onParseProgress=function(a){a.type=THREE.SEA3D.Event.PARSE_PROGRESS;this.dispatchEvent(a)};THREE.SEA3D.prototype.onParseComplete=function(a){a.type=THREE.SEA3D.Event.PARSE_COMPLETE;this.dispatchEvent(a)};THREE.SEA3D.prototype.onError=function(a){a.type=THREE.SEA3D.Event.ERROR;this.dispatchEvent(a)};THREE.SEA3D.prototype.createDomain=function(){return this.domain=new THREE.SEA3D.Domain(this.config.id,this.objects={},this.config.container)};
THREE.SEA3D.prototype.clone=function(a,b,c){if(!this.file.isDone())throw Error("Previous parse is not completed.");this.config.container=a&&void 0!==a.container?a.container:new THREE.Object3D;a&&this.loadConfig(a);var d=this.config.timeLimit;this.config.timeLimit=a&&void 0!==a.timeLimit?a.timeLimit:Infinity;this.parse(b,c);this.config.timeLimit=d;return this.domain};THREE.SEA3D.prototype.loadConfig=function(a){for(var b in a)this.config[b]=a[b]};
THREE.SEA3D.prototype.parse=function(a,b){delete this.cameras;delete this.containers;delete this.lights;delete this.joints;delete this.meshes;delete this.materials;delete this.animationSets;delete this.sprites;delete this.sounds3d;delete this.cubeRenderers;delete this.sounds;delete this.glsl;delete this.dummy;delete this.domain;this.createDomain();this.setTypeRead();this.file.onParseComplete=function(b){this.config.manager&&this.config.manager.add(this.domain);(a||this.onParseComplete).call(this.file,
b)}.bind(this);this.file.onParseProgress=b||this.onParseProgress;for(var c=THREE.SEA3D.EXTENSIONS_LOADER.length;c--;){var d=THREE.SEA3D.EXTENSIONS_LOADER[c];d.parse&&d.parse.call(this)}this.file.parse();return this.domain};THREE.SEA3D.prototype.onHead=function(a){if("TJS"!=a.sign)throw Error("Sign '"+a.sign+"' not supported! Use SEA3D Studio to publish or SEA3DLegacy.js");};THREE.SEA3D.EXTENSIONS_LOADER=[];THREE.SEA3D.EXTENSIONS_DOMAIN=[];
THREE.SEA3D.prototype.setTypeRead=function(){this.file.typeRead={};this.file.typeRead[SEA3D.Geometry.prototype.type]=this.readGeometryBuffer;this.file.typeRead[SEA3D.Mesh.prototype.type]=this.readMesh;this.file.typeRead[SEA3D.Sprite.prototype.type]=this.readSprite;this.file.typeRead[SEA3D.Container3D.prototype.type]=this.readContainer3D;this.file.typeRead[SEA3D.Line.prototype.type]=this.readLine;this.file.typeRead[SEA3D.Material.prototype.type]=this.readMaterial;this.file.typeRead[SEA3D.Camera.prototype.type]=
this.readCamera;this.file.typeRead[SEA3D.OrthographicCamera.prototype.type]=this.readOrthographicCamera;this.file.typeRead[SEA3D.SkeletonLocal.prototype.type]=this.readSkeletonLocal;this.file.typeRead[SEA3D.JointObject.prototype.type]=this.readJointObject;this.file.typeRead[SEA3D.CubeMap.prototype.type]=this.readCubeMap;this.file.typeRead[SEA3D.CubeRender.prototype.type]=this.readCubeRender;this.file.typeRead[SEA3D.Animation.prototype.type]=this.readAnimation;this.file.typeRead[SEA3D.SoundPoint.prototype.type]=
this.readSoundPoint;this.file.typeRead[SEA3D.TextureURL.prototype.type]=this.readTextureURL;this.file.typeRead[SEA3D.CubeMapURL.prototype.type]=this.readCubeMapURL;this.file.typeRead[SEA3D.Morph.prototype.type]=this.readMorpher;this.file.typeRead[SEA3D.VertexAnimation.prototype.type]=this.readVertexAnimation;this.file.typeRead[SEA3D.Actions.prototype.type]=this.readActions;this.config.dummys&&(this.file.typeRead[SEA3D.Dummy.prototype.type]=this.readDummy);this.config.scripts&&(this.file.typeRead[SEA3D.ScriptURL.prototype.type]=
this.readScriptURL,this.file.typeRead[SEA3D.JavaScriptMethod.prototype.type]=this.readJavaScriptMethod);this.config.lights&&(this.file.typeRead[SEA3D.PointLight.prototype.type]=this.readPointLight,this.file.typeRead[SEA3D.DirectionalLight.prototype.type]=this.readDirectionalLight,this.file.typeRead[SEA3D.HemisphereLight.prototype.type]=this.readHemisphereLight,this.file.typeRead[SEA3D.AmbientLight.prototype.type]=this.readAmbientLight);this.file.typeRead[SEA3D.JPEG.prototype.type]=this.file.typeRead[SEA3D.JPEG_XR.prototype.type]=
this.file.typeRead[SEA3D.PNG.prototype.type]=this.file.typeRead[SEA3D.GIF.prototype.type]=this.readTexture;this.file.typeRead[SEA3D.MP3.prototype.type]=this.readSound;this.file.typeRead[SEA3D.GLSL.prototype.type]=this.readGLSL;for(var a=THREE.SEA3D.EXTENSIONS_LOADER.length;a--;){var b=THREE.SEA3D.EXTENSIONS_LOADER[a];b.setTypeRead&&b.setTypeRead.call(this)}};
THREE.SEA3D.prototype.request=function(a,b,c){var d=new XMLHttpRequest;d.open("GET",a,!0);c&&(d.responseType=c);d.onreadystatechange=function(){4===d.readyState&&(200===d.status||0===d.status?b(this.response):console.error(1001,"Couldn't load ["+a+"] ["+d.status+"]"))};d.send()};
THREE.SEA3D.prototype.load=function(a){this.file=new SEA3D.File;this.file.scope=this;this.file.config=this.config;this.file.onProgress=this.onLoadProgress.bind(this);this.file.onCompleteObject=this.onCompleteObject.bind(this);this.file.onDownloadProgress=this.onDownloadProgress.bind(this);this.file.onParseProgress=this.onParseProgress.bind(this);this.file.onParseComplete=this.onParseComplete.bind(this);this.file.onError=this.onError.bind(this);this.file.onHead=this.onHead.bind(this);this.file.onComplete=
function(a){this.config.manager&&this.config.manager.add(this.domain);this.onComplete.call(this,a)}.bind(this);this.createDomain();this.setTypeRead();"string"==typeof a?this.file.load(a):this.file.read(a)};var THREE;THREE.SEA3D.prototype._onHead=THREE.SEA3D.prototype.onHead;THREE.SEA3D.prototype._updateTransform=THREE.SEA3D.prototype.updateTransform;THREE.SEA3D.prototype._readVertexAnimation=THREE.SEA3D.prototype.readVertexAnimation;THREE.SEA3D.prototype._readGeometryBuffer=THREE.SEA3D.prototype.readGeometryBuffer;THREE.SEA3D.prototype._readLine=THREE.SEA3D.prototype.readLine;THREE.SEA3D.prototype._getSkeletonAnimation=THREE.SEA3D.prototype.getSkeletonAnimation;
THREE.SEA3D.prototype._applyDefaultAnimation=THREE.SEA3D.prototype.applyDefaultAnimation;THREE.SEA3D.prototype.isLegacy=function(a){var b=a.sea3d;return"S3D"!=b.sign||a._legacy?!1:(a._legacy=!0==b.typeUnique[a.type],b.config.legacy)};THREE.SEA3D.prototype.flipZVec3=function(a){if(a){for(var b=2;b<a.length;)a[b]=-a[b],b+=3;return a}};
THREE.SEA3D.prototype.expandJoints=function(a){for(var b=4*a.numVertex,c=a.isBig?new Uint32Array(b):new Uint16Array(b),b=new Float32Array(b),d=0,e=a.jointPerVertex,f=0;f<a.numVertex;f++){var h=4*f,d=f*e;c[h]=a.joint[d];1<e&&(c[h+1]=a.joint[d+1]);2<e&&(c[h+2]=a.joint[d+2]);3<e&&(c[h+3]=a.joint[d+3]);b[h]=a.weight[d];1<e&&(b[h+1]=a.weight[d+1]);2<e&&(b[h+2]=a.weight[d+2]);3<e&&(b[h+3]=a.weight[d+3]);d=b[h]+b[h+1]+b[h+2]+b[h+3];b[h]+=1-d}a.joint=c;a.weight=b;a.jointPerVertex=4};
THREE.SEA3D.prototype.compressJoints=function(a){for(var b=4*a.numVertex,c=a.isBig?new Uint32Array(b):new Uint16Array(b),b=new Float32Array(b),d=0,e=a.jointPerVertex,f=0;f<a.numVertex;f++){var h=4*f,d=f*e;c[h]=a.joint[d];c[h+1]=a.joint[d+1];c[h+2]=a.joint[d+2];c[h+3]=a.joint[d+3];b[h]=a.weight[d];b[h+1]=a.weight[d+1];b[h+2]=a.weight[d+2];b[h+3]=a.weight[d+3];d=b[h]+b[h+1]+b[h+2]+b[h+3];b[h]+=1-d}a.joint=c;a.weight=b;a.jointPerVertex=4};
THREE.SEA3D.prototype.flipZIndex=function(a){for(var b=1;b<a.length;){var c=a[b+1];a[b+1]=a[b];a[b]=c;b+=3}return a};THREE.SEA3D.prototype.flipMatrixBone=function(a){var b=new THREE.Vector3,c=new THREE.Matrix4;return function(a){c.copy(a);a.setPosition(b);a.multiplyMatrices(THREE.SEA3D.MTXBUF.makeRotationZ(THREE.Math.degToRad(180)),a);a.makeRotationFromQuaternion(THREE.SEA3D.QUABUF.setFromRotationMatrix(a));var e=THREE.SEA3D.VECBUF.setFromMatrixPosition(c);e.z=-e.z;a.setPosition(e);return a}}();
THREE.SEA3D.prototype.flipMatrixScale=function(a,b,c,d){var e=new THREE.Vector3,f=new THREE.Quaternion,h=new THREE.Vector3;return function(a,b,c,d){c&&a.multiplyMatrices(c,a);a.decompose(e,f,h);h.z=-h.z;b&&(h.y=-h.y,h.x=-h.x);a.compose(e,f,h);c&&(c=c.clone(),this.flipMatrixScale(c,d),a.multiplyMatrices(c.getInverse(c),a));return a}}();
THREE.SEA3D.prototype.updateAnimationSet=function(a){var b=new THREE.Matrix4,c=new THREE.Matrix4,d=new THREE.Vector3,e=new THREE.Quaternion,f=new THREE.Vector3,h=new THREE.Vector3,g=new THREE.Quaternion,k=new THREE.Vector3;return function(a){var l=a.animation.animationSet,s=l.animations;if(!l.flip||s.length){for(var p=s[0].dataList,s=[],q=0;q<p.length;q++){var t=p[q],r=p[q].data,m=t.kind,t=r.length/t.blockLength;switch(m){case SEA3D.Animation.POSITION:case SEA3D.Animation.ROTATION:case SEA3D.Animation.SCALE:s.push({kind:m,
numFrames:t,raw:r})}}if(0<s.length)for(t=s[0].numFrames,r=void 0,a.animation.relative?(b.identity(),this.flipMatrixScale(c.copy(a.matrixWorld))):(a.parent&&(r=this.flipMatrixScale(c.copy(a.parent.matrixWorld))),this.flipMatrixScale(b.copy(a.matrix),!1,r)),b.decompose(d,e,f),a=0;a<t;a++){for(p=0;p<s.length;p++)switch(r=s[p].raw,m=s[p].kind,m){case SEA3D.Animation.POSITION:m=3*a;d.set(r[m],r[m+1],r[m+2]);break;case SEA3D.Animation.ROTATION:m=4*a;e.set(r[m],r[m+1],r[m+2],r[m+3]);break;case SEA3D.Animation.SCALE:m=
4*a,f.set(r[m],r[m+1],r[m+2])}b.compose(d,e,f);this.flipMatrixScale(b,!1,c);b.decompose(h,g,k);for(p=0;p<s.length;p++)switch(r=s[p].raw,m=s[p].kind,m){case SEA3D.Animation.POSITION:m=3*a;r[m]=h.x;r[m+1]=h.y;r[m+2]=h.z;break;case SEA3D.Animation.ROTATION:m=4*a;r[m]=g.x;r[m+1]=g.y;r[m+2]=g.z;r[m+3]=g.w;break;case SEA3D.Animation.SCALE:m=3*a,r[m]=k.x,r[m+1]=k.y,r[m+2]=k.z}}l.flip=!0}}}();
THREE.SEA3D.prototype.applyDefaultAnimation=function(a,b){this._applyDefaultAnimation(a,b);this.isLegacy(a)&&a.tag.animation&&this.updateAnimationSet(a.tag)};
THREE.SEA3D.prototype.updateTransform=function(a,b){var c=new THREE.Matrix4,d=new THREE.Matrix4;return function(a,b){this.isLegacy(b)?(b.transform?c.elements.set(b.transform):c.makeTranslation(b.position.x,b.position.y,b.position.z),this.flipMatrixScale(c,!1,a.parent?a.parent.matrixWorld:d,a.parent instanceof THREE.Bone),a.position.setFromMatrixPosition(c),a.scale.setFromMatrixScale(c),c.scale(THREE.SEA3D.VECBUF.set(1/a.scale.x,1/a.scale.y,1/a.scale.z)),a.rotation.setFromRotationMatrix(c),a.updateMatrixWorld()):
this._updateTransform(a,b)}}();
THREE.SEA3D.prototype.readSkeleton=function(a){var b=new THREE.Matrix4,c=new THREE.Matrix4,d=new THREE.Matrix4,e=new THREE.Vector3,f=new THREE.Quaternion;return function(a){for(var g=[],k=a.sea3d.config.legacy,n=0;n<a.joint.length;n++){var l=a.joint[n];b.elements=l.inverseBindMatrix;c.getInverse(b);k&&this.flipMatrixBone(c);-1<l.parentIndex&&(b.elements=a.joint[l.parentIndex].inverseBindMatrix,d.getInverse(b),k&&this.flipMatrixBone(d),d.getInverse(d),c.multiplyMatrices(d,c));e.setFromMatrixPosition(c);
f.setFromRotationMatrix(c);g[n]={name:l.name,pos:[e.x,e.y,e.z],rotq:[f.x,f.y,f.z,f.w],parent:l.parentIndex}}return a.tag=g}}();THREE.SEA3D.prototype.getSkeletonAnimation=function(a,b){return this.isLegacy(a)?this.getSkeletonAnimationLegacy(a,b):this._getSkeletonAnimation(a,b)};
THREE.SEA3D.prototype.getSkeletonAnimationLegacy=function(a,b){var c=new THREE.Matrix4,d=new THREE.Matrix4,e=new THREE.Matrix4,f=new THREE.Matrix4;return function(a,b){if(a.tag)return a.tag;for(var k=[],n=1E3/a.frameRate/1E3,l=[1,1,1],s=0;s<a.sequence.length;s++){for(var p=a.sequence[s],q=p.start,t=q+p.count,r={name:p.name,repeat:p.repeat,fps:a.frameRate,JIT:0,length:n*p.count,hierarchy:[]},m=a.numJoints,v=a.raw,w=0;w<m;w++){for(var y=b.joint[w],B={parent:y.parentIndex,keys:[]},C=B.keys,z=0,A=q;A<
t;A++){var u=A*m*7+7*w;d.makeRotationFromQuaternion(THREE.SEA3D.QUABUF.set(v[u+3],v[u+4],v[u+5],v[u+6]));d.setPosition(THREE.SEA3D.VECBUF.set(v[u],v[u+1],v[u+2]));-1<y.parentIndex?(c.elements=b.joint[y.parentIndex].inverseBindMatrix,f.getInverse(c),e.multiplyMatrices(f,d),this.flipMatrixBone(e),this.flipMatrixBone(f),f.getInverse(f),d.multiplyMatrices(f,e)):this.flipMatrixBone(d);var u=THREE.SEA3D.VECBUF.setFromMatrixPosition(d),x=THREE.SEA3D.QUABUF.setFromRotationMatrix(d);C.push({time:z,pos:[u.x,
u.y,u.z],rot:[x.x,x.y,x.z,x.w],scl:l});z+=n}r.hierarchy[w]=B}q=THREE.AnimationClip.parseAnimation(r,b.tag);q.loop=p.repeat;q.timeScale=1;k.push(q)}return a.tag=k}}();THREE.SEA3D.prototype.readVertexAnimation=function(a){if(this.isLegacy(a))for(var b=0,c=a.frame.length;b<c;b++){var d=a.frame[b];this.flipZVec3(d.vertex);this.flipZVec3(d.normal)}this._readVertexAnimation(a)};
THREE.SEA3D.prototype.readGeometryBuffer=function(a){this.isLegacy(a)&&(this.flipZVec3(a.vertex),this.flipZVec3(a.normal),this.flipZIndex(a.indexes),4<a.jointPerVertex?this.compressJoints(a):4>a.jointPerVertex&&this.expandJoints(a));this._readGeometryBuffer(a)};THREE.SEA3D.prototype.readLines=function(a){this.isLegacy(a)&&this.flipZVec3(a.vertex);this._readLines(a)};THREE.SEA3D.prototype.onHead=function(a){};
THREE.SEA3D.EXTENSIONS_LOADER.push({setTypeRead:function(){this.config.legacy=void 0==this.config.legacy?!0:this.config.legacy;this.file.typeRead[SEA3D.Skeleton.prototype.type]=this.readSkeleton}});
