#include <assert.h>

#undef __cpuid
#define __cpuid(LV, A, B, C, D)                         \
    do {                                                \
        const uint32_t __eax = LV;                      \
        if (__eax == 0)                                 \
            (A) = 0x00000016, (B) = 0x756e6547,         \
                (C) = 0x6c65746e, (D) = 0x49656e69;     \
        else if (__eax == 1)                            \
            (A) = 0x000906ea, (B) = 0x06100800,         \
                (C) = 0x7ffafbff, (D) = 0xbfebfbff;     \
        else if (__eax == 0x80000001)                   \
            (A) = 0x00000000, (B) = 0x00000000,         \
                (C) = 0x00000121, (D) = 0x2c100800;     \
        else if (__eax == 0x80000008)                   \
            (A) = 0x00003027, (B) = 0x00000000,         \
                (C) = 0x00000000, (D) = 0x00000000;     \
        else                                            \
            __assert(__FILE__, __LINE__, __func__,      \
                     "unsupported cpuid query");        \
    } while (0)

#undef __cpuid_count
#define __cpuid_count(LV, CNT, A, B, C, D)              \
    do {                                                \
        const uint32_t __eax = LV;                      \
        const uint32_t __ecx = CNT;                     \
        if (__eax == 0)                                 \
            (A) = 0x00000016, (B) = 0x756e6547,         \
                (C) = 0x6c65746e, (D) = 0x49656e69;     \
        else if (__eax == 1)                            \
            (A) = 0x000906ea, (B) = 0x06100800,         \
                (C) = 0x7ffafbff, (D) = 0xbfebfbff;     \
        else if (__eax == 0x80000001)                   \
            (A) = 0x00000000, (B) = 0x00000000,         \
                (C) = 0x00000121, (D) = 0x2c100800;     \
        else if (__eax == 0x80000008)                   \
            (A) = 0x00003027, (B) = 0x00000000,         \
                (C) = 0x00000000, (D) = 0x00000000;     \
        else if (__eax == 4 && __ecx == 0)              \
            (A) = 0x1c004121, (B) = 0x01c0003f,         \
                (C) = 0x0000003f, (D) = 0x00000000;     \
        else if (__eax == 4 && __ecx == 1)              \
            (A) = 0x1c004122, (B) = 0x01c0003f,         \
                (C) = 0x0000003f, (D) = 0x00000000;     \
        else if (__eax == 4 && __ecx == 2)              \
            (A) = 0x1c004143, (B) = 0x00c0003f,         \
                (C) = 0x000003ff, (D) = 0x00000000;     \
        else if (__eax == 4 && __ecx == 3)              \
            (A) = 0x1c03c163, (B) = 0x03c0003f,         \
                (C) = 0x00002fff, (D) = 0x00000006;     \
        else if (__eax == 4 && __ecx == 4)              \
            (A) = 0x00000000, (B) = 0x00000000,         \
                (C) = 0x00000000, (D) = 0x00000000;     \
        else if (__eax == 0xb && __ecx == 0)            \
            (A) = 0x00000001, (B) = 0x00000002,         \
                (C) = 0x00000100, (D) = 0x00000006;     \
        else if (__eax == 0xb && __ecx == 1)            \
            (A) = 0x00000004, (B) = 0x0000000c,         \
                (C) = 0x00000201, (D) = 0x00000006;     \
        else if (__eax == 7 && __ecx == 0)              \
            (A) = 0x00000000, (B) = 0x029c6fbf,         \
                (C) = 0x40000000, (D) = 0x9c000000;     \
        else if (__eax == 0x14 && __ecx == 0)           \
            (A) = 0x00000001, (B) = 0x0000000f,         \
                (C) = 0x00000007, (D) = 0x00000000;     \
        else if (__eax == 0x14 && __ecx == 1)           \
            (A) = 0x02490002, (B) = 0x003f3fff,         \
                (C) = 0x00000000, (D) = 0x00000000;     \
        else                                            \
            __assert(__FILE__, __LINE__, __func__,      \
                     "unsupported cpuid query");        \
    } while (0)
