#include <stdio.h>
#include "enclave_u.h"

uintptr_t ocall_fopen(const char *filename, const char *mode) {
    return (uintptr_t)fopen(filename, mode);
}

size_t ocall_fread(void *buf, size_t size, size_t count, uintptr_t f) {
    return fread(buf, size, count, (FILE *)f);
}

size_t ocall_fwrite(const void *buf, size_t size, size_t count, uintptr_t f) {
    return fwrite(buf, size, count, (FILE *)f);
}

int ocall_fseek(uintptr_t file, long int offset, int origin) {
    return fseek((FILE *)file, offset, origin);
}

long int ocall_ftell(uintptr_t file) {
    return ftell((FILE *)file);
}

size_t ocall_fsize(uintptr_t f) {
    FILE *file = (FILE *)f;
    size_t size = 0;
    long int saved = ftell(file);
    fseek(file, 0, SEEK_END);

    long int end = ftell(file);
    fseek(file, saved, SEEK_SET);

    if (end > 0) {
        size = (size_t)end;
    }

    return size;
}

int ocall_fclose(uintptr_t f) {
    return fclose((FILE *)f);
}

void ocall_print_string(const char *str) {
    printf("%s", str);
}
