/* Copyright (c) 2018 Baidu, Inc. All Rights Reserved.
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at
       http://www.apache.org/licenses/LICENSE-2.0
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
#ifndef ANAKIN_SABER_FUNCS_RCNN_DET_OUTPUT_WITH_ATTR_H
#define ANAKIN_SABER_FUNCS_RCNN_DET_OUTPUT_WITH_ATTR_H
#include "saber/saber_funcs_param.h"
#include "saber/funcs/base.h"
#include "saber/funcs/impl/impl_rcnn_det_output_with_attr.h"
#ifdef NVIDIA_GPU
#include "saber/funcs/impl/cuda/saber_rcnn_det_output_with_attr.h"
#endif

namespace anakin {
namespace saber {

template <typename TargetType,
          DataType OpDtype
          >
class RCNNDetOutputWithAttr : public BaseFunc <
    TargetType, OpDtype,
    ImplBase, ProposalParam
    > {
public:
    typedef TargetType targetType_t;
    typedef Tensor<TargetType> OpTensor;
    typedef ProposalParam<TargetType> Param_t;
    typedef const std::vector<OpTensor*> Input_v;
    typedef std::vector<OpTensor*> Output_v;

    RCNNDetOutputWithAttr() = default;

    virtual SaberStatus compute_output_shape(Input_v& input, Output_v& output,
            Param_t& param) override {
        if (output.size() > 0) {
            Shape output_shape = (input[0]->valid_shape());
            return output[0]->set_shape(output_shape);
        } else {
            return SaberSuccess; // This allow no outputs.
        }
    }
    virtual SaberStatus init_impl(ImplEnum implenum) override {
        switch (implenum) {
        case VENDER_IMPL:
            this->_impl.push_back(new VenderRCNNDetOutputWithAttr<TargetType, OpDtype>);
            return SaberSuccess;

        case SABER_IMPL:
            this->_impl.push_back(new SaberRCNNDetOutputWithAttr<TargetType, OpDtype>);
            return SaberSuccess;

        default:
            return SaberUnImplError;
        }
    }

private:
    virtual void pick_best_static() override {
        if (true) { // some condition?
            this->_best_impl = this->_impl[0];
        }
    }
    virtual void pick_best_specify(ImplEnum implenum) override {
        this->_best_impl = this->_impl[0];
    }
};

}
}
#endif //ANAKIN_SABER_FUNCS_CONV_H