/* Copyright (c) 2018 Baidu, Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

#ifndef ANAKIN_SABER_FUNCS_IMPL_ARM_UTILS_H
#define ANAKIN_SABER_FUNCS_IMPL_ARM_UTILS_H

namespace anakin{

namespace saber{

#ifdef __aarch64__

template <typename Dtype>
inline void prefetch(const Dtype *din) {
    asm volatile(
    "PRFM PLDL1KEEP, [%[din]] \n"
    :
    : [din] "r"(din)
    : "memory");
}

#else
template <typename Dtype>
inline void prefetch(const Dtype *din) {
    asm volatile(
       "pld [%[din]] \n"
       :
       : [din] "r"(din)
       : "memory");
}
#endif //__aarch64__

} //namespace saber

} //namespace anakin

#endif // ANAKIN_SABER_FUNCS_IMPL_ARM_UTILS_H
