| Op Name | Input | Output | 参数 | 功能 | 支持的精度 | 支持的设备 |
| --- | --- | --- | --- | --- | --- | --- |
| [activation](../../framework/operators/activation.cpp) | 1 tensor | 1 tensor | **type(std::string)**:选择TanH、Sigmoid、Stanh、ClippedRelu、Relu、PRelU中的一种. <br>  **clip_relu_num(int)**:type="ClippedRelu"时的上限值. <br>  **alpha(int)**:type="Relu"时alpha的值. <br> **channel_shared(bool)**:type="PReLU"时通道是否共享。 | 激活函数 | FP32 | NVGPU, X86, ARM, BITMAIN, MLU, AMDGPU|
| [affine_channel](../../framework/operators/affine_channel.cpp) | 1 tensor | 1 tensor  | **weights(void*)**:传入的weights. <br> **bias(void*)**: 传入bias. <br> **affine_channel(int)**：表示axis，默认是1。 | dout[i] = din[i] * weights[c]  + biias[c] | FP32 | NVGPU, X86|
| [aligned_mat_mul](../../framework/operators/aligned_mat_mul.cpp)  | 2 tensor: tensor-0是 A，tensor-1是 B   | 1 tensor | **transpose_x(bool)**:行方向是否转置. <br> **transpose_y(bool)**:列方向是否转置. <br> **scale(float)**:矩阵乘系数alpha。 |C = alpha*A*B | FP32 | NVGPU, X86|
| [anchor_generator](../../framework/operators/anchor_generator.cpp) | 1 tensor |2 tensor: tensor-0是输入的anchor, tensor-1是anchor的扩展布局 |**anchor_sizes(std::vector<float>)**:生成anchor的anchor大小，以绝对像素的形式表示. <br> **aspect_ratios(std::vector<float>)**:生成anchor的高宽比. <br> **variance(std::vector<float>)**:变量，在框回归delta中使，默认：[0.1,0.1,0.2,0.2]. <br> **stride(std::vector<float>)**:anchor在宽度和高度方向上的步长. <br> **offset(float)**: 先验框的中心位移，默认：0.5. <br> **mode(std::string)**:先验框操作符名称，默认：default. | 为Faster RCNN算法生成anchor，输入的每一位产生N个anchor，N=size(anchor_sizes)*size(aspect_ratios)。生成anchor的顺序首先是aspect_ratios循环，然后是anchor_sizes循环 | FP32 | NVGPU, X86, MLU|
| [arg_max](../../framework/operators/arg_max.cpp) | 1 tensor | 1 tensor |  **out_max_val(bool)**:是否输出Max的下标. <br> **top_k(int)**: 显示前top_k的数目. <br> **axis_term(bool)**:表示是否按轴进行求Max.| 求前top_k个的最大数据  | FP32 | NVGPU, X86, ARM, MLU, AMDGPU|
| [arithmetic](../../framework/operators/arithmetic.cpp) | 2 tensor: tensor-0是第一个输入数据，tensor-1是第二个输入数据 | 1 tensor | **op_type(int)**: 计算类型.  |   最简单的数学计算，目前支持+、- 和 X 运算  | FP32 | NVGPU, X86|
| [attension_lstm](../../framework/operators/attension_lstm.cpp) | 1 tensor | 1 tensor | **attention_fc_w_0(tensor)**: fc_0的weights. <br>  **attention_fc_b_0(tensor)**: fc_0的bias. <br> **attention_fc_w_1(tensor)**: fc_1的weights. <br> **attention_fc_b_1(tensor)**: fc_1的bias. <br> **lstm_w(tensor)**: lstm的weights. <br> **lstm_b(tensor)**: lstm的bias. | 实现两个fc+lstm的功能  | FP32 | NVGPU, X86 |
| [axpy](../../framework/operators/axpy.cpp) | 3 tensor: tensor-0是输入的scale, tensor-1是输入数据din, tensor-2是输入的bias | 1 tensor |  |  dout = din * scale + bias | FP32 | NVGPU, X86, ARM, BITMAIN, MLU, AMDGPU|
| [batch_norm](../../framework/operators/batch_norm.cpp) | 1 tensor |1 tensor | **scale(float)**:系数. <br> **eps(float)**:加在分母上为了数值稳定的值, 默认值为1e-5. <br> **mean(std:vector<float>)**: 均值. <br> **var(std:vector<float>)**: 方差. | 批正则化--归一化 | FP32 | NVGPU, X86|
| [box_clip](../../framework/operators/box_clip.cpp) | 2 tensor: tensor-0: 是输入框din, tensor-1是输入框的图像信息im_info | 1 tensor | | 将box框剪切为 im_info 给出的大小 |FP32 | NVGPU, X86|
| [box_coder](../../framework/operators/box_coder.cpp) | 2 tensor 或 3 tensor: tensor-0是先验框信息，tensor-1是priorbox信息，tensor-2是variance信息 | 1 tensor | **axis(int)**: 在PriorBox中为axis指定的轴broadcast以进行框解码. <br> **box_normalized(bool)**:是否将先验框作为正则框，默认为true. <br> **var_tensor(tensor)**:存放variance的list.  | 编码/解码带有先验框信息的目标边界框 |FP32 | NVGPU, X86, MLU|
| [cast](../../framework/operators/cast.cpp) | 1 tensor | 1 tensor | **in_type(int)**:输入数据类型. <br> **out_type(int)**:输出数据类型   | 类型转换  | FP32 | NVGPU, X86, ARM, MLU, AMDGPU|
| [concat](../../framework/operators/concat.cpp) | n tensor：多输入，输入tensor个数大于2 |1 tensor | **axis(int)**:concat操作的轴.  |  按照axis轴将输入的数据连接在一起 | FP32 | NVGPU, X86, ARM, BITMAIN, MLU, AMDGPU|
| [convolution.cpp](../../framework/operators/convolution.cpp) | 1 tensor | 1 tensor | **group(int)**: 卷积的组数. <br> **bias_term(bool)**:是否有bias. <br> **padding(std::vector<int>)**:填充大小. <br> **strides(std::vector<int>)**:步长大小. <br> **dilation_rate(std::vector<int>)**:膨胀大小. <br> **kernel_size(std::vector<int>)**:滤波器大小. <br> **filter_num(int)**:滤波器数，与输出通道相同. <br> **axis(int)**:表示轴 | 卷积计算 |FP32 | NVGPU, X86, ARM, BITMAIN, MLU, AMDGPU|
| [coord2patch]((../../framework/operators/coord2patch.cpp))                                           |        |       |                                                                                                                                                                                                                                                                       |      |
| [cos_sim](../../framework/operators/cos_sim_.cpp)                                                    |        |        |                                                                                                                                                                                                                                                                       |      |
| [crf_decoding](../../framework/operators/crf_decoding.cpp)                                           | 1 tensor       | 1 tensor        | weight_1(PBlock<Ttype>)  特征权重                                                                                                                                                                                                                                                                      | FP32、INT8     | NVGPU,<br>X86,<br>AMGGPU,<br>ARM
| [crop](../../framework/operators/crop.cpp)                                                           | 1 tensor       | 1 tensor      | **axis(int)**:处理的轴。<br>**cropping(int)**:保留系数。| crop保留大小                                                                                                                                                                                                 | FP32、INT8 | NVGPU,<br>X86,<br>MLU,<br>ARM 
| [ctc_align](../../framework/operators/ctc_align.cpp)                                                 |        |        |                                                                                                                                                                                                                                                                       |      |
| [deconvolution](../../framework/operators/deconvolution/cpp)                                         | 1 tensor      | 1 tensor       | **filter_num(int)**:过滤器个数.<br>**kernel_size(std::vector<int>)**:核的大小.<br>**strides(std::vector<int>)**:步长.<br>**padding(std::vector<int>))**:padding大小.<br>**group(int)**:分组个数.<br>**axis(int)**:处理维度.<br>**bias_term(bool)**:是否有bias.<br>**weight_1(tensor)**:权重<br>**weight_2(tensor)**:bias权重.| 反卷积操作 | FP32、INT8 | NVGPU,<br>X86,<br>AMGGPU,<br>ARM,<br>BITMAIN |
| [deformconvolution](../../framework/operators/deformconvolution.cpp)                                 | 1 tensor       | 1 tensor      | **filter_num(int)**:过滤器个数.<br>**kernel_size(std::vector<int>)**:核的大小.<br>**strides(std::vector<int>)**:步长.<br>**padding(std::vector<int>))**:padding大小.<br>**group(int)**:分组个数.<br>**dilation_rate(std::vector<int>)**:膨胀系数.<br>**axis(int)**:处理维度.<br>**bias_term(bool)**:是否有bias.<br>**weight_1(tensor)**:权重<br>**weight_2(tensor)**:bias权重.| 可变形卷积操作  | FP32、INT8  | NVGPU,<br>X86,<br>AMGGPU,<br>ARM,<br>BITMAIN                                                                                                                                                                                                                                                                  |
| [dense](../../framework/operators/dense.cpp)                                                         | 1 tensor       | 1 tensor       | **out_dim(int)**:输出维度大小.<br>**axis(int)**:处理维度.<br>**bias_term(bool)**:是否存在bias.<br>**weight_1(tensor)**:权重<br>**weight_2(tensor)**:bias权重.| 全连接                                                                                                                                                                                                                                                                     | FP32、INT8     | NVGPU,<br>X86,<br>AMGGPU,<br>ARM,<br>BITMAIN |
| [depwise_seq_convolution](../../framework/operators/depwise_seq_convolution.cpp)                     |        |        |                                                                                                                                                                                                                                                                       |      |
| [detection_output](../../framework/operators/detection_output.cpp)                                   | 1 tensor       | **shatre_location(bool)**:不同类别间是否共享框的位置.<br>**variance_encode_in_target(bool)**::variance是否被解码.<br>**class_num(int)**:类别个数.<br>**background_id(int)**:背景色的id.<br>**keep_top_k(int)**:保留框的个数.<br>**code_type(std::string)**:选择CORNER、CENTER_SIZE、CORNER_SIZE中的一种.<br>**conf_thresh(float)**: 检测置信阈值.<br>**nms_top_k(int)**: nms保留框的个数.<br>**nms_thresh(float)**: nms阈值.<br>**nms_eta(float)**: 动态阈值.      |  ssd网络最后一层，输出目标检测框、label和score。                                                                                                                                                                                                                                                                     | FP32     | NVGPU,<br>X86,<br>ARM,<br>MLU,<br>BITMAIN
| [dfm_ps_roi_align](../../framework/operators/dfm_ps_roi_align.cpp)                                   |        |        |                                                                                                                                                                                                                                                                       |      |
| [dot](../../framework/operators/dot.cpp)                                                             |        |        |                                                                                                                                                                                                                                                                       |      |
| [dropout](../../framework/operators/dropout.cpp)                                                     |        |        |                                                                                                                                                                                                                                                                       |      |
| [eltwise](../../framework/operators/eltwise.cpp)                                                     | 2 tensor       | **type(std::sting)**:选择Add、Max、Prob、Multiply、Div、Mul中的一种. <br> **coeff(std::vector<float>)**: 扩展系数，输入在基本的操作上增加系数的操作. <br> **axis(int)**: 操作的轴.       | 元素进行加、取最大值、点乘、除、乘等运算。                                                                                                                                                                                                                                                                      | FP32     | NVGPU,<br>X86,<br>ARM,<br>MLU,<br>AMDGPU
| [elu](../../framework/operators/elu.cpp)                                                             |        |        |                                                                                                                                                                                                                                                                       |      |
| [embedding](../../framework/operators/embedding.cpp)| 1 tensor | 1 tensor |**word_num(int):** 输入词的数量 <br> **emb_dim(int):** 嵌入向量维度 <br> **padding_idx(int):** 一旦padding_idx存大，则input中的padding_idx用0填充输出向量 <br>|该层用于查找由输入提供的id在查找表中的嵌入矩阵，查找的结果是input里每个ID对应的嵌入矩阵|fp32|NVGPU X86 ARM MLU|
| [flatten](../../framework/operators/flatten.cpp)| 1 tensor | 1 tensor |**start_axis(int):** 开始的维度<br> **end_axis(int):** 结束的维度<br> | 将输入张量指定维度压成一维|FP32,INT8|NVGPU X86 ARM MLU|
| [gather](../../framework/operators/gather.cpp)| 2 tensor(2tensor互相share)|1 tensor | -- | 将其中一个tensor作为输出|FP32,INT8|NVGPU X86 ARM MLU|
| [generate_proposals](../../framework/operators/generate_proposals.cpp)| 2 tensor | 1 tensor | **pre_nms_top_n(int):** 前处理nms的top_k <br> **post_nms_top_n(int):** 后处理nms的top_k <br> **nms_thresh(float):** nms的阈值 <br> **min_size(float):** 框的最小尺寸 <br> **eta(float):** 其他参数 <br>| 根据anchor和对应score进行生成roi | FP32 | NVGPU X86 MLU|
| [group_norm](../../framework/operators/group_norm.cpp)| 1 tensor | 1 tensor | **p(int):** normalize 指数 <br> **group(int):** 分组数 <br> **has_bias(bool):** 是否有bias <br> **has_scale(bool):** 是否有scale <br> **bias(tensor):** 偏置项 <br> **scale(tensor):** 缩放项 <br> **eps(float):** 正则项 <br>| 对输入进行分组normalize|FP32|NVGPU X86 ARM MLU|
| [gru](../../framework/operators/gru.cpp)                                                             |        |        |                                                                                                                                                                                                                                                                       |      |
| [im2sequence](../../framework/operators/im2sequence.cpp)| 1 tensor | 1 tensor | **padding(vector<int>):** pad数量 <br>    **stride(vector<int>):** 扫描步长 <br> **window_size(vector<int>):** 扫描窗口大小 <br> **dilation(vector<int>):** 膨胀系数 <br>| 将输入图片类似im2col进行转换|FP32| NVGPU X86 ARM MLU|
| [input](../../framework/operators/input.cpp)| -- | 1 tensor | **input_shape(Shape):** 输入的默认shape <br>| 接收模型输入 | FP32 | NVGPU X86 ARM MLU BIT|
| [interp](../../framework/operators/interp.cpp)| 1 tensor | 1 tensor | **shrink_factor(int):** 缩小倍数 <br> **zoom_factor(int):** 放大倍数 <br> | 对图像利用缩小和放大倍数进行缩放 | FP32 | NVGPU X86 ARM MLU BIT|
| [layer_norm](../../framework/operators/layer_norm.cpp)| 1 tensor | 1 tensor | **begin_norm_axis(int):** 从begin_norm_axis起进行normalize <br>  **eps(float):** 正则项 <br> **weight_1(tensor):** 偏置项 <br> **weight_2(tensor):** 缩放项 <br> | 对输入从指定维度开始进行normalize | FP32 | NVGPU X86 ARM MLU|
| [lrn](../../framework/operators/lrn.cpp)| 1 tensor | 1 tensor | **local_size(int):** 需要归一化的范围大小 <br> **alpha(float):** 缩放参数 <br> **beta(float):** 指数 <br> **norm_region(string):** 归一化区域类型 <br> **k(float):** 位移 <br>| 对局部输入区域正则化，执行一种侧向抑制 | FP32 | NVGPU X86 ARM MLU|
| [lstm](../../framework/operators/lstm.cpp)                                                           |        |        |                                                                                                                                                                                                                                                                       |      |
| [mat\_mul](../../framework/operators/mat_mul.cpp)                                                     | 2 tensor | 1 tensor | **transpose\_x(bool)**:是否转置X矩阵 **transpose\_y(bool)**:是否转置Y矩阵 **scale(float)**:缩放因子 |矩阵相乘|FP32|NV、X86、ARM、MLU
| [maxout](../../framework/operators/maxout.cpp)                                                       | 1 tensor | 1 tensor |**groups(int)**:输入tensor的channel的组数                                                                                                                                                                                                                                                      | 激活函数 |FP32|NV、X86、ARM、AMD
| [mean](../../framework/operators/mean.cpp)                                                           | 1 tensor | 1 tensor | **/**                                                                                                                                                                                                                                                                      | 取均值 |FP32|NV、X86、ARM、AMD
| [multi\_roi\_align](../../framework/operators/multi_roi_align.cpp) | 1 in\_roi 和 n in\_data | 1 tensor | **pooled\_height(int)**:池化输出高度  **pooled\_width(int)**:池化输出宽度  **sampling\_ratio(int)**:采样点数目，如果小于0则自适应宽和高 **finest\_scale(float)**:最佳缩放因子 **spatial\_scale(tensor\*)**:多个输入对应的缩放因子                                                                                                                                                                                                                                                                       | 多输入的区域特征对齐 |FP32|NV、X86
| [negative](../../framework/operators/negative.cpp)                                                   | 1 tensor | 1 tensor | **/**                                                                                                                                                                                                                                                            | 取负 |FP32、INT8(NV、ARM)|NV、X86、ARM、AMD
| [normalize](../../framework/operators/normalize.cpp)                                                 | 1 tensor | 1 tensor | **p(int)**:p=1,L1 normalize; p=2,L2 normalize **across\_spatial(bool)**:是否归一化 **has\_scale(bool)**:是否有缩放 **has\_bias(bool)**:是否有偏移 **channel\_shared(bool)**:是否共享一个缩放因子 **scale(tensor\*)**:缩放因子  **bias(tensor\*)**:偏移  **eps(float)**:1e-6f,防止溢出参数  **group(int)**:组数                                                                                                                                                                                                                                                                        | 归一化 | FP32 | NV、X86、ARM、AMD、BM、MLU
| [one\_hot](../../framework/operators/one_hot.cpp)                                                     | 1 tensor | 1 tensor | **depth(int)**:编码深度                                                                                                                                                                                                                                                                       | 独热编码 | FP32 | NV、X86、ARM
| [output](../../framework/operators/output.cpp)                                                       | 1 tensor | 1 tensor | **/**                                                                                                                                                                                                                                                                      | 输出 | FP32 | NV、X86、ARM、AMD、BM、MLU
| [pad](../../framework/operators/pad.cpp)                                                             | 1 tensor | 1 tensor | **pad_c(vector\<int\>)**:2个整数分别代表前后填充长度  **pad\_h(vector\<int\>)**:2个整数分别代表上下填充高度  **pad\_w(vector\<int\>)**:2个整数分别代表左右填充宽度                                                                                                                                                                                                                                                                    | 填充 | FP32 | NV、X86、ARM、AMD、MLU
| [pad2d](../../framework/operators/pad2d.cpp)                                                         | 1 tensor | 1 tensor | **\_mode(PadMode)**:三种模式:PAD\_CONSTANT(默认)、PAD\_EDGE、PAD\_REFLECT **\_pad\_h(vector\<int\>)**:2个整数分别代表上下填充高度  **\_pad\_w(vector\<int\>)**:2个整数分别代表左右填充宽度 **\_pad\_value(float)**:填充区域的值                                                                                                                                                                                                                                                                    | 二维填充 | FP32 | NV、X86、ARM、AMD
| [permute](../../framework/operators/permute.cpp)                                                     | 1 tensor | 1 tensor | **order(vector\<int\>)**: 维度序列                                                                                                                                                                                                                                                                     | 维度换位，将tensor的维度重新排列 | FP32 | NV、X86、ARM、AMD、BM、MLU
| [pixel\_shuffle](../../framework/operators/pixel_shuffle.cpp)                                         | 1 tensor | 1 tensor | **rh(int)**:高度增大因子 **rw(int)**:宽度增大因子  **channel\_first(bool)**:true则输出NCHW，false则输出NHWC                                                                                                                                                                                                                                                                     | 像素重组，将一个形为[N,C,H,W]的tensor重新排列成形为[N,C/rh/rw,H\*rh, W\*rw]的tensor | FP32 | NV、X86、ARM
| [pooling](../../framework/operators/pooling.cpp)                                                     | 1 tensor | 1 tensor | **window\_h(int)**:窗口高度 **window\_w(int)**:窗口宽度 **pad\_h(int)**:高度填充 **pad\_w(int)**:宽度填充 **stride\_h(int)**:高度步长 **stride\_w(int)**:宽度步长  **global\_pooling(bool)**:是否全局池化，若true则输出宽高为1 **cmp\_out\_shape\_floor\_as\_conv(bool)**:  **pooling\_type(PoolingType)**:池化类型，包括MAX,AVG,SUM                                                                                                                                                                                                                                                                  | 池化 | FP32、INT8(NV、X86、ARM) | NV、X86、ARM、AMD、BM、MLU
| [power](../../framework/operators/power.cpp) | 1 tensor | 1 tensor | **shift(float)** 偏移量 <br> **scale(float)** 放大系数 <br> **power(float)** 指数   | output = ( shift + scale * x ) ^ power | FP32 | NVGPU, X86, ARM |
| [priorbox](../../framework/operators/priorbox.cpp) | 1 tensor | 1 tensor | **min_size(vector\<float\>)** 最小尺寸 <br> **max_size(vector\<float\>)** 最大尺寸 <br> **aspect_ratio(vector\<float\>)** 纵横比 <br> **is_flip(bool)** 是否忽略ratio <br> **is_clip(bool)** 是否使用clip <br> **variance(vector\<float\>)** 解码 <br> **img_h(int)** 输入图片高 <br> **img_w(int)** 输入图片宽 <br> **step_h(float)** height步长 <br> **step_w(float)** width步长 <br> **offset(float)** 位移 <br> **order(vector\<string\>)** prioribox的方式，参数内容候选如下(MIN MAX COM) | SSD算法生成先验框 | FP32 | NVGPU X86 ARM MLU BITMAIN |
| [reduce](../../framework/operators/reduce.cpp) | 1 tensor | 1 tensor | **reduce_type(std::string)** reduce的方法, 参数候选(Reduce_min, Reduce_max, Reduce_sum, Reduce_avg, Reduce_prod) <br> **keep_dim(bool)** Reduce后dim是否跟input保持一致。 <br> **reduce_all(bool)** 是否进行整个tensor的Reduce <br> **reduce_dim(vector<int>)** 进行Reduce的维度 <br> **coeff(float)** 扩展用 | 对tensor进行reduce操作，支持min，max，sum，avg，prod操作 | FP32 | NVGPU, X86, ARM |
| [relu](../../framework/operators/relu.cpp) | 1 tensor| 1 tensor | **alpha(float)** 负数部分的系数，标准relu为0 | output = input > 0 ? input : input * alpha | FP32 | NVGPU, X86, ARM, MLU, BITMAIN, AMDGPU |
| [reshape](../../framework/operators/reshape.cpp) | 1 tensor | 1 tensor | **dims(vector\<int\>)** 维度信息 | 对tensor的shape按照dims重新设置 | FP32 | NVGPU, X86, ARM, MLU, BITMAIN, AMDGPU |
| [resize](../../framework/operators/resize.cpp)  | 1 tensor | 1 tensor | **method(string) default(RESIZE_CUSTOM)** resize方法,参数候选(BILINEAR_ALIGN, BILINEAR_NO_ALIGN, RESIZE_CUSTOM, NEAREST_ALIGN) <br> **width_scale(float) default(0.f)** 输入高度乘数因子 <br> **height_scale(float) default(0.f)** 输入宽度乘数因子 <br> **out_width(int) default(-1)** 输出指定宽度 <br> **out_height(int) default(-1)** 输出指定高度 | 按照指定方法完成resize功能，可以指定scale自己计算，也可以指定output的height和width，两种参数指定方法选其中一种 | FP32 | NVGPU, X86, ARM, MLU, AMDGPU |
| [reverse_input](../../framework/operators/reverse_input.cpp) | 1 tensor | 1 tensor | 无 | 根据seq_offset的batch，对输入tensor的每个batch都进行reverse操作 | FP32 | NVGPU, X86, AMDGPU |
| [roi_aligh](../../framework/operators/roi_aligh.cpp) | 1 tensor | 1 tensor | 无 | 根据seq_offset的batch，对各个batch内的序列进行倒序操作 | FP32 | NVGPU, X86, AMDGPU |
| [roi_pool](../../framework/operators/roi_pool.cpp)| in_data和in_rois 2tensor | 1 tensor |**spatial_scale（float)** 缩放因子<br>**pooled_w(int)** 池化输出宽度 <br>**pooled_h(int)** 池化输出高度 | Faster-RCNN的roi_pool, 对非均匀的输入执行最大池化以获得固定输出 | FP32 | NVGPU, X86, ARM, MLU, AMDGPU |
| [scale](../../framework/operators/scale.cpp)  | tensor <br> num:1 | tensor <br> num:1 | axis: 指定维度<br>num_axes: <br>bias_term: 偏置项<br> weights: 权值|  out =   scale * x + bias |  FP32|CPU<br> NV<br> AMD<br> ARM<br> MLU(寒武纪)<br> BM(比特大陆)<br>|
| [sequence_concat](../../framework/operators/sequence_concat.cpp) |tensor<br> num:1| tensor<br> num: 2 | param_sequence_concat(default): 该op默认参数，无实际参数|concat向量序列| FP32 | X86<br> NV<br> AMD<br>|
| [sequence_conv](../../framework/operators/sequence_conv.cpp) | tensor<br> num: 1| tensor<br> num: 1| context_length:  <br> context_start: <br> context_stride: <br> padding_trainable: <br> bias_term: 偏置<br> filter_tensor: filter|对每个序列做卷积操作|FP32<br> INT8<br>| X86<br> NV<br> ARM<br> MLU<br> AMD<br>| 
| [sequence_depadding](../../framework/operators/sequence_depadding.cpp) |tensor<br> num: 2 | tensor<br> num: 1| param_sequence_depadding(default):该op默认参数，无实际参数| 删除输入中的padding值| FP32 | X86<br> NV<br> ARM<br> AMD<br>|
| [sequence_padding](../../framework/operators/sequence_padding.cpp) |tensor<br> num: 1 | tensor<br> num: 1| param_sequence_padding(default):该op默认参数，无实际参数|对输入进行填充0| FP32 | X86<br> NV<br> ARM<br> AMD<br>|
| [sequence_pool](../../framework/operators/sequence_pool.cpp)|tensor<br> num: 1 | tensor<br> num: 1| pool_tyle: <br> null: 未定义<br> AVERAGE: avg pool<br> SUM: <br> sum pool<br> SQRT: sqrt pool<br> LAST: 取最后一行<br> FIRST: 取第一行<br> |对指定类型pool| FP32 | X86<br> NV<br> ARM<br> AMD<br> MLU|
| [sequence_pool_concat](../../framework/operators/sequence_pool_concat.cpp)|tensor<br> num: 1 | tensor<br> num: 1| pool_tyle: <br> null: 未定义<br> AVERAGE: avg pool<br> SUM: <br> sum pool<br> SQRT: sqrt pool<br> LAST: 取最后一行<br> FIRST: 取第一行<br> |对输入做指定类型pool,然后concat| FP32 | X86<br> NV<br> ARM<br>|
| [shuffle_channel](../../framework/operators/shuffle_channel.cpp) |tensor<br> num: 1 | tensor<br> num: 1|无实际参数|该算子将输入的通道混洗重排| FP32 | X86<br> NV<br> ARM<br>|
| [slice](../../framework/operators/slice.cpp)|tensor<br> num: 1 | tensor<br> num: 1|slice_dim: <br> slice_point: <br> axis: <br>|沿多个轴生成输入张量的切片| FP32 | X86<br> NV<br> ARM<br> MLU<br> BM<br>|
| [softmax](../../framework/operators/softmax.cpp)|tensor<br> num: 1 | tensor<br> num: 1| 无实际参数|out = exp(x)/sigma(exp(x))| FP32 | X86<br> NV<br> ARM<br> MLU<br> BM<br> AMD<br>|
| [split](../../framework/operators/split.cpp)                                                         | 1 tensor | split_num tensor | **split_num(int)**:切分的份数。                                                                                                                                                                           | 切分得到split_num份的output，每份与input shape相同，且共享数据 | FP32、INT8(ARM)  | NV、X86、ARM、AMD、MLU、BM |
| [topk_avg_pooling](../../framework/operators/topk_avg_pooling.cpp)                                   | 3 tensor | 1 tensor | **top_ks(vector<int>)**:top_k列表。<br> **feat_map_num(int)**:feature map数。<br> **is_pooling_by_row(bool)**:为true时按行池化，false按列。<br>                                                                                                                   | topK平均池化 |  FP32            | NV、X86、ARM |
| [topk_pooling](../../framework/operators/topk_pooling.cpp)                                           | 2 tensor | 1 tensor | **top_k(int)**:获取前top_k个数用于池化。<br> **feat_map_num(int)**:feature map数。<br>                                                                                                                                                                            | topK池化   |  FP32            | NV、X86、ARM、AMD |
| [yolo_box](../../framework/operators/yolo_box.cpp)                                                   | 2 tensor | 2 tensor | **anchors(vector<int>)**:anchor宽和高。<br> **class_num(int)**:预测的分类数。<br> **conf_thresh(float)**:检测盒的置信度阈值。<br> **downsample_ratio(int)**:降采样率。                                                                              | 从YOLOv3网络的输出中生成YOLO检测盒 | FP32             | NV、X86、ARM  |