// Copyright 2014 Citra Emulator Project
// Licensed under GPLv2 or any later version
// Refer to the license.txt file included.

#include "common/archives.h"
#include "core/hle/service/apt/apt_a.h"

namespace Service::APT {

APT_A::APT_A(std::shared_ptr<Module> apt)
    : Module::APTInterface(std::move(apt), "APT:A", MaxAPTSessions) {
    static const FunctionInfo functions[] = {
        // clang-format off
        {0x0001, &APT_A::GetLockHandle, "GetLockHandle"},
        {0x0002, &APT_A::Initialize, "Initialize"},
        {0x0003, &APT_A::Enable, "Enable"},
        {0x0004, &APT_A::Finalize, "Finalize"},
        {0x0005, &APT_A::GetAppletManInfo, "GetAppletManInfo"},
        {0x0006, &APT_A::GetAppletInfo, "GetAppletInfo"},
        {0x0007, nullptr, "GetLastSignaledAppletId"},
        {0x0008, &APT_A::CountRegisteredApplet, "CountRegisteredApplet"},
        {0x0009, &APT_A::IsRegistered, "IsRegistered"},
        {0x000A, &APT_A::GetAttribute, "GetAttribute"},
        {0x000B, &APT_A::InquireNotification, "InquireNotification"},
        {0x000C, &APT_A::SendParameter, "SendParameter"},
        {0x000D, &APT_A::ReceiveParameter, "ReceiveParameter"},
        {0x000E, &APT_A::GlanceParameter, "GlanceParameter"},
        {0x000F, &APT_A::CancelParameter, "CancelParameter"},
        {0x0010, nullptr, "DebugFunc"},
        {0x0011, nullptr, "MapProgramIdForDebug"},
        {0x0012, nullptr, "SetHomeMenuAppletIdForDebug"},
        {0x0013, nullptr, "GetPreparationState"},
        {0x0014, nullptr, "SetPreparationState"},
        {0x0015, &APT_A::PrepareToStartApplication, "PrepareToStartApplication"},
        {0x0016, &APT_A::PreloadLibraryApplet, "PreloadLibraryApplet"},
        {0x0017, &APT_A::FinishPreloadingLibraryApplet, "FinishPreloadingLibraryApplet"},
        {0x0018, &APT_A::PrepareToStartLibraryApplet, "PrepareToStartLibraryApplet"},
        {0x0019, &APT_A::PrepareToStartSystemApplet, "PrepareToStartSystemApplet"},
        {0x001A, &APT_A::PrepareToStartNewestHomeMenu, "PrepareToStartNewestHomeMenu"},
        {0x001B, &APT_A::StartApplication, "StartApplication"},
        {0x001C, &APT_A::WakeupApplication, "WakeupApplication"},
        {0x001D, &APT_A::CancelApplication, "CancelApplication"},
        {0x001E, &APT_A::StartLibraryApplet, "StartLibraryApplet"},
        {0x001F, &APT_A::StartSystemApplet, "StartSystemApplet"},
        {0x0020, nullptr, "StartNewestHomeMenu"},
        {0x0021, &APT_A::OrderToCloseApplication, "OrderToCloseApplication"},
        {0x0022, &APT_A::PrepareToCloseApplication, "PrepareToCloseApplication"},
        {0x0023, nullptr, "PrepareToJumpToApplication"},
        {0x0024, nullptr, "JumpToApplication"},
        {0x0025, &APT_A::PrepareToCloseLibraryApplet, "PrepareToCloseLibraryApplet"},
        {0x0026, &APT_A::PrepareToCloseSystemApplet, "PrepareToCloseSystemApplet"},
        {0x0027, &APT_A::CloseApplication, "CloseApplication"},
        {0x0028, &APT_A::CloseLibraryApplet, "CloseLibraryApplet"},
        {0x0029, &APT_A::CloseSystemApplet, "CloseSystemApplet"},
        {0x002A, &APT_A::OrderToCloseSystemApplet, "OrderToCloseSystemApplet"},
        {0x002B, &APT_A::PrepareToJumpToHomeMenu, "PrepareToJumpToHomeMenu"},
        {0x002C, &APT_A::JumpToHomeMenu, "JumpToHomeMenu"},
        {0x002D, &APT_A::PrepareToLeaveHomeMenu, "PrepareToLeaveHomeMenu"},
        {0x002E, &APT_A::LeaveHomeMenu, "LeaveHomeMenu"},
        {0x002F, nullptr, "PrepareToLeaveResidentApplet"},
        {0x0030, nullptr, "LeaveResidentApplet"},
        {0x0031, &APT_A::PrepareToDoApplicationJump, "PrepareToDoApplicationJump"},
        {0x0032, &APT_A::DoApplicationJump, "DoApplicationJump"},
        {0x0033, &APT_A::GetProgramIdOnApplicationJump, "GetProgramIdOnApplicationJump"},
        {0x0034, &APT_A::SendDeliverArg, "SendDeliverArg"},
        {0x0035, &APT_A::ReceiveDeliverArg, "ReceiveDeliverArg"},
        {0x0036, &APT_A::LoadSysMenuArg, "LoadSysMenuArg"},
        {0x0037, &APT_A::StoreSysMenuArg, "StoreSysMenuArg"},
        {0x0038, nullptr, "PreloadResidentApplet"},
        {0x0039, nullptr, "PrepareToStartResidentApplet"},
        {0x003A, nullptr, "StartResidentApplet"},
        {0x003B, &APT_A::CancelLibraryApplet, "CancelLibraryApplet"},
        {0x003C, &APT_A::SendDspSleep, "SendDspSleep"},
        {0x003D, &APT_A::SendDspWakeUp, "SendDspWakeUp"},
        {0x003E, &APT_A::ReplySleepQuery, "ReplySleepQuery"},
        {0x003F, &APT_A::ReplySleepNotificationComplete, "ReplySleepNotificationComplete"},
        {0x0040, &APT_A::SendCaptureBufferInfo, "SendCaptureBufferInfo"},
        {0x0041, &APT_A::ReceiveCaptureBufferInfo, "ReceiveCaptureBufferInfo"},
        {0x0042, nullptr, "SleepSystem"},
        {0x0043, &APT_A::NotifyToWait, "NotifyToWait"},
        {0x0044, &APT_A::GetSharedFont, "GetSharedFont"},
        {0x0045, &APT_A::GetWirelessRebootInfo, "GetWirelessRebootInfo"},
        {0x0046, &APT_A::Wrap, "Wrap"},
        {0x0047, &APT_A::Unwrap, "Unwrap"},
        {0x0048, &APT_A::GetProgramInfo, "GetProgramInfo"},
        {0x0049, &APT_A::Reboot, "Reboot"},
        {0x004A, &APT_A::GetCaptureInfo, "GetCaptureInfo"},
        {0x004B, &APT_A::AppletUtility, "AppletUtility"},
        {0x004C, nullptr, "SetFatalErrDispMode"},
        {0x004D, nullptr, "GetAppletProgramInfo"},
        {0x004E, &APT_A::HardwareResetAsync, "HardwareResetAsync"},
        {0x004F, &APT_A::SetAppCpuTimeLimit, "SetAppCpuTimeLimit"},
        {0x0050, &APT_A::GetAppCpuTimeLimit, "GetAppCpuTimeLimit"},
        {0x0051, &APT_A::GetStartupArgument, "GetStartupArgument"},
        {0x0052, nullptr, "Wrap1"},
        {0x0053, nullptr, "Unwrap1"},
        {0x0054, &APT_A::Unknown54, "Unknown54"},
        {0x0055, &APT_A::SetScreenCapturePostPermission, "SetScreenCapturePostPermission"},
        {0x0056, &APT_A::GetScreenCapturePostPermission, "GetScreenCapturePostPermission"},
        {0x0057, &APT_A::WakeupApplication2, "WakeupApplication2"},
        {0x0058, &APT_A::GetProgramId, "GetProgramId"},
        {0x0101, &APT_A::GetTargetPlatform, "GetTargetPlatform"},
        {0x0102, &APT_A::CheckNew3DS, "CheckNew3DS"},
        {0x0103, &APT_A::GetApplicationRunningMode, "GetApplicationRunningMode"},
        {0x0104, &APT_A::IsStandardMemoryLayout, "IsStandardMemoryLayout"},
        {0x0105, &APT_A::IsTitleAllowed, "IsTitleAllowed"},
        // clang-format on
    };
    RegisterHandlers(functions);
}

} // namespace Service::APT

SERIALIZE_EXPORT_IMPL(Service::APT::APT_A)
