<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: wap.php 139 2024-10-19 09:23:13Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

$wap_tpl_name = $settings[wap_tpl_name] ? trim($settings[wap_tpl_name]) : 'default';
$wap_tpl_dir = "plugins/wap/$wap_tpl_name";
$wap_base_dir = "plugins/wap";

if(!display_plugin('wap','open_wap_plugin',$settings['open_wap'],0)){
	$title = '提示信息';
	include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
	$sysmsg[] = '手机版网盘未开启';
	wap_redirect('',$sysmsg);
	include PD_PLUGINS_DIR."wap/includes/m_footer.inc.php";
	exit;
}

if(!$pd_uid && in_array($action,array('myfile','upload','mydisk','myfav','mybuyed'))){
	header('Location: '.urr("wap","action=login"));
	exit;
}
switch ($action){
	case 'view_ann':
		$aid = (int)gpc('aid','G',0);
		if(!$aid){
			$title = '提示信息';
			include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
			echo '<div class="tb_box_msg" style="padding:50px;">ID Error</div>';
			include PD_PLUGINS_DIR."wap/includes/m_footer.inc.php";
			exit;
		}
		$rs = $db->fetch_one_array("select * from {$tpf}announces where annid='$aid' and is_hidden=0");
		if(!$rs){
			$title = '提示信息';
			include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
			echo '<div class="tb_box_msg" style="padding:50px;">公告不存在</div>';
			include PD_PLUGINS_DIR."wap/includes/m_footer.inc.php";
			exit;
		}
		$title = $rs[subject].' 网盘公告';
		$sub_nav = ' &raquo; 公告内容';
		include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
		require_once template_echo('m_view_ann','',"wap/$wap_tpl_name");
		break;
	case 'view':
		$file_id = (int)gpc('file_id','G',0);
		if(!$file_id){
			$title = '提示信息';
			include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
			echo '<div class="tb_box_msg" style="padding:50px;">文件不存在,ID Error</div>';
			include PD_PLUGINS_DIR."wap/includes/m_footer.inc.php";
			exit;
		}
		$file = $db->fetch_one_array("select * from {$tpf}files where file_id='$file_id' and is_del=0");
		if(!$file){
			$title = '提示信息';
			include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
			echo '<div class="tb_box_msg" style="padding:50px;">文件不存在</div>';
			include PD_PLUGINS_DIR."wap/includes/m_footer.inc.php";
			exit;
		}else{
			$sql_add = " and (cate_id>0 or use_code=1 or share_end_time>$timestamp)";
			if(($pd_uid && $pd_uid==$file[userid]) || $file[cate_id] || $file[share_end_time]>$timestamp){
				$num5 = true;
			}else{
				$num5 = false;
			}
			if($num5){
				$file = $db->fetch_one_array("select * from {$tpf}files where file_id='$file_id'");
				if($file){
					$file[a_downfile] = create_down_url($file);
					$file[file_time] = $file[file_time] ? date('Y-m-d',$file[file_time]) : '-';
					$file[file_last_view] = $file[file_last_view] ? date('Y-m-d',$file[file_last_view]) : '-';
					$file[file_size] = get_size($file[file_size]);
					$tmp_ext = $file[file_extension] ? '.'.$file[file_extension] : '';
					$file[file_name_all] = $file[file_name].$tmp_ext;
				}
				$db->query_unbuffered("update {$tpf}files set file_last_view='$timestamp',file_views=file_views+1 where file_id='$file_id'");
				$userid = @$db->result_first("select userid from {$tpf}files where file_id='$file_id' and in_recycle=0 and is_del=0");
				add_credit_log($file_id,1,'view',$userid,$pd_uid);
				require_once template_echo('files',$user_tpl_dir);
			}else{
				$title = '提示信息';
				include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
				echo '<div class="tb_box_msg" style="padding:50px;">您权限不足，无法访问此文件</div>';
				include PD_PLUGINS_DIR."wap/includes/m_footer.inc.php";
				exit;
			}
		}
		$title = $file[file_name_all].' 文件下载';
		$sub_nav = ' &raquo; 文件下载';
		include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
		require_once template_echo('m_view','',"wap/$wap_tpl_name");
		break;
	case 'login':
		$title = '登录网盘';
		include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
		require_once template_echo('m_account','',"wap/$wap_tpl_name");
		break;
	case 'register':
		if(!$settings['allow_register']){
			$sysmsg[] = $settings[close_register_reason];
			wap_redirect(urr("wap",""),$sysmsg);
			exit;
		}

		if($settings[reg_interval]){
			$num = @$db->result_first("select count(*) from {$tpf}users where reg_ip='$onlineip' and $timestamp-reg_time<{$settings[reg_interval]} limit 1");
			if($num){
				$error = true;
				$sysmsg[] = __('register_too_busy');
			}
			wap_redirect(urr("wap",""),$sysmsg);
			exit;
		}
		$title = '新用户注册';
		include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
		require_once template_echo('m_account','',"wap/$wap_tpl_name");
		break;
	case 'logout':
		$title = '退出网盘';
		include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
		pd_setcookie(PHPDISK_COOKIE,'',-3600);
		$sysmsg[] = __('logout_success');
		wap_redirect(urr("wap",""),$sysmsg);
		break;
	case 'upload':
		$folder_id = (int)gpc('folder_id','GP','');
		$folder_id = $folder_id ? $folder_id : -1;
		$title = '上传文件';
		include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
		$sign = md5($pd_uid.$settings[encrypt_key].date('Ymd'));
		if($settings['open_multi_server']){
			$rs = $db->fetch_one_array("select server_host,server_store_path,server_key from {$tpf}servers where server_id>1 order by is_default desc limit 1");
			if($rs){
				$remote_upload_url = $rs['server_host']."index.php?action=m_h5upload&uid=$pd_uid&folder_id=$folder_id&sign=$sign";
			}
			unset($rs);
		}else{
			$remote_upload_url = urr("mydisk","item=m_h5upload&uid=$pd_uid&folder_id=$folder_id&sign=$sign");
		}
		require_once template_echo('m_upload','',"wap/$wap_tpl_name");
		break;

	case 'announce':
	case 'extract_file':
		$tit_arr = array(
		'extract_file'=>'提取文件',
		'announce'=>'网盘公告',
		);
		$title = $tit_arr[$action];
		include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
		require_once template_echo('m_phpdisk','',"wap/$wap_tpl_name");
		break;
	case 'mydisk':
		$myinfo = get_mydisk_info($pd_uid);

		$nav_arr = get_my_nav();

		$group_set = $group_settings[$pd_gid];
		$group_set['max_folders'] = $group_set['max_folders'] ? $group_set['max_folders']: __('no_limit');
		$group_set['max_files'] = $group_set['max_files'] ? $group_set['max_files'] : __('no_limit');

		$upload_max = get_byte_value(ini_get('upload_max_filesize'));
		$post_max = get_byte_value(ini_get('post_max_size'));
		$settings_max = $settings['max_file_size'] ? get_byte_value($settings['max_file_size']) : 0;
		$max_php_file_size = min($upload_max, $post_max);
		$max_file_size_byte = ($settings_max && $settings_max <= $max_php_file_size) ? $settings_max : $max_php_file_size;

		if($group_set['max_filesize']){
			$group_set_max_file_size = get_byte_value($group_set['max_filesize']);
			$max_file_size_byte = ($group_set_max_file_size >=$max_file_size_byte) ? $max_file_size_byte : $group_set_max_file_size;
		}
		$group_set['max_filesize'] = get_size($max_file_size_byte,'B',0);

		$rs = $db->fetch_one_array("select user_file_types,user_store_space from {$tpf}users where userid='$pd_uid' limit 1");
		if($rs['user_file_types']){
			$group_set['user_file_types'] = $rs['user_file_types'];
		}else{
			$group_set['user_file_types'] = $group_set['group_file_types'] ? $group_set['group_file_types'] : __('no_limit');

		}
		if($rs['user_store_space']){
			$group_set['max_storage'] = $rs['user_store_space'];
		}else{
			$group_set['max_storage'] = $group_set['max_storage'] ? $group_set['max_storage'] : __('no_limit');
		}
		unset($rs);
		$rs = $db->fetch_one_array("select user_store_space from {$tpf}users where userid='$pd_uid'");
		if($rs['user_store_space'] ==0){
			$max_storage = $group_settings[$pd_gid]['max_storage']==0 ? __('no_limit') : $group_settings[$pd_gid]['max_storage'];
		}else{
			$max_storage = $rs['user_store_space'];
		}
		unset($rs);

		$stats['total_folders'] = (int)@$db->result_first("select count(*) from {$tpf}folders where userid='$pd_uid'");

		$stats['total_share_folders'] = @$db->result_first("select count(*) from {$tpf}folders where userid='$pd_uid' and in_share=1");

		$stats['total_files'] = (int)@$db->result_first("select count(*) from {$tpf}files where userid='$pd_uid' and in_recycle=0 and is_del=0");

		$stats['file_size_total'] = get_size(@$db->result_first("select sum(file_size) from {$tpf}files where userid='$pd_uid' and in_recycle=0 and is_del=0"));

		$disk_fill = $max_storage ? @round($rs['file_size_total']/get_byte_value($max_storage),1)*120 : 0;
		$disk_percent = $max_storage ? @round($rs['file_size_total']/get_byte_value($max_storage),3)*100 : 0;

		$rs = $db->fetch_one_array("select reg_time,reg_ip,email,last_login_time,last_login_ip from {$tpf}users where userid='$pd_uid'");
		if($rs){
			$stats['reg_time'] = date("Y-m-d H:i:s",$rs['reg_time']);
			$stats['last_login_time'] = $rs['last_login_time'] ? date("Y-m-d H:i:s",$rs['last_login_time']) : '-';
			$stats['reg_ip'] = $rs['reg_ip'];
			$stats['last_login_ip'] = $rs['last_login_ip'];
			$stats['email'] = $rs['email'];
		}
		unset($rs);

		$title = '我的信息';
		include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
		require_once template_echo('m_mydisk','',"wap/$wap_tpl_name");
		break;
	case 'myfile':
		$folder_id = (int)gpc('folder_id','GP','');
		$title = '我的文件';
		$sub_nav = wap_nav($folder_id,$pd_uid);
		$sub_nav = $sub_nav ? '&raquo;<a href="'.urr("wap","action=myfile").'">根目录</a>&raquo;'.$sub_nav : '';
		include PD_PLUGINS_DIR."wap/includes/m_header.inc.php";
		require_once template_echo('m_phpdisk','',"wap/$wap_tpl_name");
		break;
		break;
	default:
		if($pd_uid){
			header("Location: ".urr("wap","action=mydisk"));
		}else{
			header("Location: ".urr("wap","action=login"));
		}
		exit;
}

include PD_PLUGINS_DIR."wap/includes/m_footer.inc.php";

function wap_nav($folder_id,$uid,$only_txt=0){
	global $db,$tpf;
	$rs = $db->fetch_one_array("select parent_id,folder_name,folder_id from {$tpf}folders where folder_id='$folder_id' and userid='$uid'");
	$str = '';
	if($rs['parent_id']!=0){
		$str .= wap_nav($rs['parent_id'],$uid,$only_txt);
	}
	if($only_txt){
		$str .= $rs['folder_name'] ? $rs['folder_name'].'>' : '';
	}else{
		$str .= $rs['folder_name'] ? '<a href="'.urr("wap","action=myfile&folder_id={$rs['folder_id']}").'"><img src="images/folder_open.gif" align="absmiddle">'.$rs['folder_name'].'</a>&raquo; ' : '';
	}
	unset($rs);
	return $str;
}

?>


