<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: rc_upload.php 139 2024-10-19 09:23:13Z along $
#
#	Copyright (C) 2008-2018 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

$uid = (int)gpc('uid','GP','');
$uid = $uid ? (int)$uid : $pd_uid;
$folder_id = (int)gpc('folder_id','GP','');
$action = gpc('action','GP','');
$sign = trim(gpc('sign','GP',''));

$upload_log_dir = PHPDISK_ROOT.'system/upLog/';
make_dir($upload_log_dir);

$upload_log_fn = $upload_log_dir.'upload.error.php';
$hacker_log_fn = $upload_log_dir.'hacker.error.php';


$is_locked = @$db->result_first("select is_locked from {$tpf}users where userid='$uid'");
if($is_locked){
	write_file($upload_log_fn,'<?php exit; ?> User locked'.LF,'ab');
	exit;
}
@set_time_limit(0);

$server_oid = get_server_oid();

switch($action){
	case 'doupload':	
		
		$file = $_FILES['file'];

		$file['name'] = filter_name($file['name']);
		$file_extension = strtolower($db->escape(get_extension($file['name'])));
		$esp = strlen($file_extension)+1;
		if($file_extension){
			$file_name = $db->escape(substr($file['name'],0,strlen($file['name'])-$esp));
		}else{
			$file_name = $db->escape($file['name']);
		}
		$file_ext = get_real_ext($file_extension);
		
		$tmpDir = PHPDISK_ROOT.'system/upload_tmp/';
		make_dir($tmpDir);
		
		$file_real_path = PHPDISK_ROOT.$settings['file_path'].'/';
		$file_store_path = date('Y/m/d/');
		$uploadDir = $file_real_path.$file_store_path;
		make_dir($uploadDir);
	
		$temp_file_name = md5($uid.$_REQUEST['name'].$_REQUEST['type'].$_REQUEST['size'].$_REQUEST['lastModifiedDate']);

		//$dest_file = $file_real_path.$file_store_path.$file_real_name.$file_ext;
	
		///////////////////////////////
		
		$cleanupTargetDir = true; // Remove old files
		$maxFileAge = $settings[tmpfile_expire_time] ? (int)$settings[tmpfile_expire_time] : 5 * 3600; // Temp file age in seconds		
		$tmpFilePath = $tmpDir.$temp_file_name; // temp file
		//$uploadFilePath = $uploadDir .
		// Chunking might be enabled
		$chunk = isset($_REQUEST["chunk"]) ? intval($_REQUEST["chunk"]) : 0;
		$chunks = isset($_REQUEST["chunks"]) ? intval($_REQUEST["chunks"]) : 1;
		
		if(!chk_extension_ok_h5($file_extension)){
			write_file($upload_log_fn,'<?php exit; ?> File extension not allow!'.LF,'ab');
			exit;
		}
		
		// Remove old temp files
		if ($cleanupTargetDir) {
			if (!is_dir($tmpDir) || !$dir = opendir($tmpDir)) {
				write_file($upload_log_fn,'<?php exit; ?> Failed to open temp directory.!'.LF,'ab');
				exit;
			}
		
			while (($file = readdir($dir)) !== false) {
				$tmpFilePathPath = $tmpDir . DIRECTORY_SEPARATOR . $file;
		
				// If temp file is current file proceed to the next
				if ($tmpFilePathPath == "{$tmpFilePath}_{$chunk}.phpdisk" || $tmpFilePathPath == "{$tmpFilePath}_{$chunk}.phpdisktmp") {
					continue;
				}
		
				// Remove temp file if it is older than the max age and is not the current file
				if (preg_match('/\.(phpdisk|phpdisktmp)$/', $file) && (@filemtime($tmpFilePathPath) < time() - $maxFileAge)) {
					@unlink($tmpFilePathPath);
				}
			}
			closedir($dir);
		}
		
		
		// Open temp file
		if (!$out = @fopen("{$tmpFilePath}_{$chunk}.phpdisktmp", "wb")) {
			write_file($upload_log_fn,'<?php exit; ?> Failed to open output stream.!'.LF,'ab');
			exit;			
		}
		
		if (!empty($_FILES)) {
			if ($_FILES["file"]["error"] || !is_uploaded_file($_FILES["file"]["tmp_name"])) {
				write_file($upload_log_fn,'<?php exit; ?> Failed to move uploaded file.!'.LF,'ab');
				exit;
			}
		
			// Read binary input stream and append it to temp file
			if (!$in = @fopen($_FILES["file"]["tmp_name"], "rb")) {
				write_file($upload_log_fn,'<?php exit; ?> Failed to open input stream.!'.LF,'ab');
				exit;
			}
		} else {
			if (!$in = @fopen("php://input", "rb")) {
				write_file($upload_log_fn,'<?php exit; ?> Failed to open input stream.!'.LF,'ab');
				exit;
			}
		}
		
		while ($buff = fread($in, 4096)) {
			fwrite($out, $buff);
		}
		
		@fclose($out);
		@fclose($in);
		
		rename("{$tmpFilePath}_{$chunk}.phpdisktmp", "{$tmpFilePath}_{$chunk}.phpdisk");
		
		$index = 0;
		$done = true;
		$upload_success = false;
		for( $index = 0; $index < $chunks; $index++ ) {
			if ( !file_exists("{$tmpFilePath}_{$index}.phpdisk") ) {
				$done = false;
				break;
			}
		}
		if ( $done ) {
			// rename store file
			$file_real_name = md5(uniqid(mt_rand(),true).microtime());  // reload
			$dest_file = $file_real_path.$file_store_path.$file_real_name.$file_ext;
			////////
			if (!$out = @fopen($dest_file, "wb")) {
				write_file($upload_log_fn,'<?php exit; ?> Failed to open output stream.!'.LF,'ab');
				exit;
			}
		
			if ( flock($out, LOCK_EX) ) {
				for( $index = 0; $index < $chunks; $index++ ) {
					if (!$in = @fopen("{$tmpFilePath}_{$index}.phpdisk", "rb")) {
						break;
					}
		
					while ($buff = fread($in, 4096)) {
						fwrite($out, $buff);
					}
		
					@fclose($in);
					
					$upload_success = true;
					
					@unlink("{$tmpFilePath}_{$index}.phpdisk");
				}
		
				flock($out, LOCK_UN);
			}
			@fclose($out);
		}
		
		/// upload file success
		if($upload_success){
			$report_status = 0;
			$report_arr = explode(',',$settings['report_word']);
			if(count($report_arr)){
				foreach($report_arr as $value){
					if (strpos($file['name'],$value) !== false){
						$report_status = 2;
					}
				}
			}
			$file_key = random(8);
	
			$file_mime = strtolower($db->escape($_REQUEST['type']));
			$file_size = $db->escape($_REQUEST['size']);
			$img_arr = getimagesize($dest_file);
			if($img_arr[2] && @in_array($file_extension,array('jpg','jpeg','png','gif','bmp'))){
				$is_image = 1;
				if($file_size<1024*1024*2){
					make_thumb($dest_file, $file_real_path.$file_store_path.$file_real_name.'_thumb.'.$file_extension,150,120);
				}
			}else{
				$is_image = 0;
			}

	
			$db->ping();
			$ins = array(
					'file_name' => $file_name,
					'file_key' => $file_key,
					'file_extension' => $file_extension,
					'is_image' => $is_image,
					'file_mime' => $file_mime,
					'file_description' => $file_description ? $file_description : '',
					'file_store_path' => $file_store_path,
					'file_real_name' => $file_real_name,
					'file_md5' => $file_md5 ? $file_md5 : '',
					'file_size' => $file_size,
					'file_time' => $timestamp,
					'server_oid' => (int)$server_oid,
					'is_checked' => 1,
					'report_status' => $report_status,
					'userid' => $uid,
					'ip' => $onlineip,
					'folder_id' => $folder_id ? $folder_id : -1,
			);
			$db->query_unbuffered("insert into {$tpf}files set ".$db->sql_array($ins).";");
			//$file_id = $db->insert_id();
			$folder_id && $db->query_unbuffered("update {$tpf}folders set folder_size=folder_size+{$file_size} where userid='$uid' and folder_id='$folder_id'");
		}

		break;
	
	default:
		write_file($upload_log_fn,'<?php exit;?> no action'.date('Y-m-d H:i:s').LF,'ab');
}

?>

