<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: wap_ajax.php 197 2016-08-12 08:11:33Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

include "../../includes/commons.inc.php";

if(!$pd_uid && in_array($action,array('myfile','upload','mydisk'))){
	header('Location: '.urr("wap","action=login"));
	exit;
}
$perpage = $settings['wap_perpage'] ? (int)$settings['wap_perpage'] : 20;
switch($action){
	case 'dologin':
		$username = trim(gpc('u','P',''));
		$password = trim(gpc('p','P',''));
		$verycode = trim(gpc('c','P',''));

		if(checklength($username,2,60)){
			$error = true;
			$sysmsg[] = __('invalid_username');
		}
		if(checklength($password,6,20)){
			$error = true;
			$sysmsg[] = __('invalid_password');
		}else{
			$md5_pwd = phpdisk_md5($password);
		}
		if($settings['login_verycode'] && $settings['open_verycode']){
			if (!$verycode || strtolower($verycode) != strtolower($_SESSION['_verycode'])) {
				unset($_SESSION['_verycode']);
				$error = true;
				$sysmsg[] = __('invalid_verycode');
			}
		}
		if(!$settings['allow_access'] && $gid !=1){
			$error = true;
			$sysmsg[] = __('admin_not_valid');
		}
		if(display_plugin('api','open_uc_plugin',$settings['connect_uc'],0)){
			if($settings['connect_uc_type']=='phpwind'){
				$user_login = uc_user_login($username,$md5_pwd,0);
				$ucsynlogin = $user_login['synlogin'];
			}else{
				list($uid, $username, $password, $email) = uc_user_login($username, $password);
				if($uid > 0){
					$ucsynlogin = uc_user_synlogin($uid);
					if(trim($username)){
						$rs = $db->fetch_one_array("select username from {$tpf}users where username='$username' limit 1");
						if(!$rs){
							$gid = 4;
							$ins = array(
							'username' => $username,
							'password' => $md5_pwd,
							'email' => $email,
							'gid' => $gid,
							'reg_time' => $timestamp,
							'reg_ip' => $onlineip,
							);
							$db->query("insert into {$tpf}users set ".$db->sql_array($ins).";");
							$userid = $db->insert_id();
						}
						unset($rs);
					}
					if(!@$db->result_first("select count(*) from {$tpf}users where username='$username' and password='$md5_pwd' limit 1")){
						$db->query_unbuffered("update {$tpf}users set password='$md5_pwd',email='$email' where username='$username' limit 1");
					}
				}elseif($uid ==-1){
					$email = @$db->result_first("select email from {$tpf}users where username='$username_pd' limit 1");
					if($email){
						$uid = uc_user_register($username_pd , $password_pd , $email);
						if($uid<=0){
							$error = true;
							$sysmsg[] = 'UC:'.__('invalid_username');
						}
					}else{
						$error = true;
						$sysmsg[] = 'UC:'.__('user_already_delete');
					}
				}elseif($uid ==-2){
					$error = true;
					$sysmsg[] = __('password_is_error');
				}
			}
		}
		$rs = $db->fetch_one_array("select userid,gid,username,password,email,is_locked from {$tpf}users where username='$username' limit 1");
		if(!$rs){
			$error = true;
			$sysmsg[] = __('user_not_exists');
		}else{
			if($md5_pwd != $rs['password']){
				$error = true;
				$sysmsg[] = __('user_password_false');
			}elseif($rs['is_locked']){
				$error = true;
				$sysmsg[] = __('user_is_locked');
			}else{
				$userid = (int)$rs['userid'];
				$gid = (int)$rs['gid'];
				$username = trim($rs['username']);
				$password = trim($rs['password']);
				$email = trim($rs['email']);
			}
		}
		if(!$settings['allow_access'] && $gid !=1){
			$error = true;
			$sysmsg[] = __('admin_not_valid');
		}
		if(!$error){
			$db->query_unbuffered("update {$tpf}users set last_login_ip='$onlineip',last_login_time='$timestamp' where userid='$userid'");
			pd_setcookie(PHPDISK_COOKIE,pd_encode("$userid\t$gid\t$username\t$password\t$email"));

			$sysmsg[] = __('login_success');
			echo 'true|'.arr2str($sysmsg,1);
		}else{
			echo arr2str($sysmsg,1);
		}
		break;
	case 'chk_username':
		$r_username = trim(gpc('r_username','P',''));
		if(checklength($r_username,2,60)){
			echo __('username_length_error');
		}elseif(is_bad_chars($r_username)){
			echo __('username_has_bad_chars');
		}else{
			$num = @$db->result_first("select count(*) from {$tpf}users where username='$r_username'");
			if($num){
				echo __('username_already_exists');
			}else{
				echo 'true|恭喜，用户名可注册';
			}
		}
		break;
	case 'chk_email':
		$r_email = trim(gpc('r_email','P',''));

		if(!checkemail($r_email)){
			echo __('invalid_email');
		}else{
			$num = @$db->result_first("select count(*) from {$tpf}users where email='$r_email'");
			if($num){
				echo __('email_already_exists');
			}else{
				echo 'true|恭喜，E-mail能注册';
			}
		}
		break;
	case 'doregister':
		$username = trim(gpc('u','P',''));
		$password = trim(gpc('p','P',''));
		$confirm_password = trim(gpc('p2','P',''));
		$email = trim(gpc('e','P',''));
		$verycode = trim(gpc('c','P',''));

		if(!$settings['allow_register']){
			$error = true;
			$sysmsg[] = $settings['close_register_reason'];
		}
		if($settings[reg_interval]){
			$num = @$db->result_first("select count(*) from {$tpf}users where reg_ip='$onlineip' and $timestamp-reg_time<{$settings[reg_interval]} limit 1");
			if($num){
				$error = true;
				$sysmsg[] = __('register_too_busy');
			}
		}
		if($pd_uid){
			$error = true;
			$sysmsg[] = __('user_already_register');
		}
		if(checklength($username,2,60)){
			$error = true;
			$sysmsg[] = __('username_length_error');
		}elseif(is_bad_chars($username)){
			$error = true;
			$sysmsg[] = __('username_has_bad_chars');
		}else{
			$rs = $db->fetch_one_array("select username from {$tpf}users where username='$username' limit 1");
			if($rs){
				if(strcasecmp($username,$rs['username']) ==0){
					$error = true;
					$sysmsg[] = __('username_already_exists');
				}
			}
			unset($rs);
		}
		if(display_plugin('api','open_uc_plugin',$settings['connect_uc'],0)){
			if($settings['connect_uc_type']=='phpwind'){
				$checkuser = uc_check_username($username);
				if($checkuser<>1){
					$error = true;
					$sysmsg[] = 'UC:'.__('invalid_username');
				}
			}else{
				$ucresult = uc_user_checkname($username);
				if($ucresult <0) {
					$error = true;
					$sysmsg[] = 'UC:'.__('username_already_exists');
				}
			}
		}
		if(checklength($password,6,20)){
			$error = true;
			$sysmsg[] = __('invalid_password');
		}else{
			if($password == $confirm_password){
				$md5_pwd = phpdisk_md5($password);
			}else{
				$error = true;
				$sysmsg[] = __('confirm_password_invalid');
			}
		}
		if($settings['register_verycode'] && $settings['open_verycode']){
			if (!$verycode || strtolower($verycode) != strtolower($_SESSION['_verycode'])) {
				unset($_SESSION['_verycode']);
				$error = true;
				$sysmsg[] = __('invalid_verycode');
			}
		}
		if($settings['reg_use_email']){
			if(!checkemail($email)){
				$error = true;
				$sysmsg[] = __('invalid_email');
			}else{
				$rs = $db->fetch_one_array("select email from {$tpf}users where email='$email' limit 1");
				if($rs){
					if(strcasecmp($email,$rs['email']) ==0){
						$error = true;
						$sysmsg[] = __('email_already_exists');
					}
					unset($rs);
				}
			}
			if(display_plugin('api','open_uc_plugin',$settings['connect_uc'],0)){
				if($settings['connect_uc_type']=='phpwind'){
					$ucresult = uc_check_email($email);
					if($ucresult <>1){
						$error = true;
						$sysmsg[] = 'UC:'.__('email_already_exists');
					}
				}else{
					$ucresult = uc_user_checkemail($email);
					if($ucresult <0){
						$error = true;
						$sysmsg[] = 'UC:'.__('email_already_exists');
					}
				}
			}

			if(!$error && display_plugin('api','open_uc_plugin',$settings['connect_uc'],0)){
				if($settings['connect_uc_type']=='phpwind'){
					uc_user_register($username,$md5_pwd,$email);
				}else{
					$uid = uc_user_register($username , $password , $email);
					if($uid <= 0){
						$error = true;
						$sysmsg[] = 'UC: '.__('reg_user_error');
					}
				}
			}
		}
		$gid = $settings[default_reg_gid] ? (int)$settings[default_reg_gid] : (int)$db->result_first("select gid from {$tpf}groups order by gid desc limit 1");
		if(!$error){
			$credit = $settings['credit_open'] ? (int)$settings['credit_reg'] : 0;
			$ins = array(
			'username' => $username,
			'password' => $md5_pwd,
			'email' => $email,
			'gid' => $gid,
			'depart_id' => (int)$depart_id,
			'is_activated' => $settings['check_new_user'] ? 0 : 1,
			'credit' => $credit,
			'reg_time' => $timestamp,
			'reg_ip' => $onlineip,
			);
			$db->query("insert into {$tpf}users set ".$db->sql_array($ins).";");
			$userid = $db->insert_id();

			$num = $db->result_first("select count(*) from {$tpf}users ");
			$stat['users_count'] = (int)$num;
			stats_cache($stat);

			pd_setcookie(PHPDISK_COOKIE,pd_encode("$userid\t$gid\t$username\t$md5_pwd\t$email"));
			if(display_plugin('phpdisk_sso','open_phpdisk_sso_plugin',$settings['open_sso'],0)){
				echo sso_register($username,$password,$email,$gid);
			}
			if(display_plugin('api','open_uc_plugin',$settings['connect_uc'],0)){
				if($settings['connect_uc_type']=='phpwind'){
					$user_login = uc_user_login($username,$md5_pwd,0);
					$ucsynlogin = $user_login['synlogin'];
				}
				echo $ucsynlogin;
			}
			$sysmsg[] = __('register_success');
			echo 'true|'.arr2str($sysmsg,1);
		}else{
			echo arr2str($sysmsg,1);
		}
		break;
	case 'dosearch':
		$word = trim(gpc('word','P',''));
		$pg = (int)gpc('pg','P','');
		$pg = $pg ? $pg : 1;

		if(!$word){
			echo 'true|<div align="center">请输入关键词</div>';
			exit;
		}else{
			$sql_keyword = $word ? " (file_name like '%$word%' or file_extension like '%$word%') and " : '';
		}

		$files_array = array();

		$sql_do = " {$tpf}files where $sql_keyword is_checked=1 and is_del=0 and in_recycle=0 ";

		$start_num = ($pg-1) * $perpage;

		$q = $db->query("select * from {$sql_do} order by file_time desc limit $start_num,$perpage");
		$files_array = array();
		while($rs = $db->fetch_array($q)){
			$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
			$rs[file_name] = str_ireplace($word,'<span class="txtred">'.$word.'</span>',$rs['file_name'].$tmp_ext);
			$rs[a_view] = urr("wap","action=view&file_id=$rs[file_id]");
			$rs['file_size'] = get_size($rs['file_size']);
			$rs['file_time'] = date("Y-m-d",$rs['file_time']);
			$files_array[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$str = '';
		if(count($files_array)){
			$str .= $pg==1 ? '<div class="item_1 f12"><span style="float:right;">大小</span>文件名</div>'.LF : '';
			foreach($files_array as $k => $v){
				$color = ($k%2 ==0) ? 'color1' :'color6';
				$str .= '<div class="item f16 '.$color.'"><span style="float:right;" class="sz">'.$v['file_size'].'</span><a href="'.$v['a_view'].'">'.file_icon($v['file_extension'],'filetype_32').$v['file_name'].'</a></div>'.LF;
			}
			unset($files_array);
			$str .= '<div align="center" class="f16" style="margin:8px 0;" id="pgv_'.($pg+1).'"><a href="javascript:;" onclick="dosearch('.($pg+1).',false,\''.$word.'\')">点击查看下一页...</a></div>'.LF;
			echo 'true|'.$str;
		}else{
			if($pg>1){
				echo 'true|<div align="center" id="rs" class="pd5">已没有更多结果</div><script>setTimeout(function(){$(\'#rs\').hide(500)},1250)</script>';
			}else{
				echo 'true|<div align="center" class="pd5">暂无文件记录</div>';
			}
		}
		break;
	case 'myfile':
		$folder_id = (int)gpc('folder_id','GP','');
		$pg = (int)gpc('pg','P','');
		$pg = $pg ? $pg : 1;
		$folder_id = $folder_id ? $folder_id : -1;
		if($pg==1){
			$q = $db->query("select fd.*,u.username from {$tpf}folders fd,{$tpf}users u where fd.parent_id='$folder_id' and fd.userid='$pd_uid' and fd.userid=u.userid and in_recycle=0 order by folder_order asc,folder_id asc");
			$folders_array = array();
			while ($rs = $db->fetch_array($q)) {
				$rs[a_folder_view] = urr("wap","action=myfile&folder_id={$rs[folder_id]}");
				$rs[folder_size] = get_size($rs[folder_size]);
				$rs[in_time] = date('Y-m-d H:i:s',$rs[in_time]);
				$folders_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
		}

		$start_num = ($pg-1) * $perpage;
		$files_array = array();

		$sql_do = " {$tpf}files where userid='$pd_uid' and is_del=0 and in_recycle=0 and folder_id='$folder_id'";
		$sql = "select * from {$sql_do} order by file_time desc limit $start_num,$perpage";

		$q = $db->query($sql);
		$files_array = array();
		while($rs = $db->fetch_array($q)){
			$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
			$rs[file_name] = $rs['file_name'].$tmp_ext;
			$rs[a_view] = urr("wap","action=view&file_id=$rs[file_id]");
			$rs['file_size'] = get_size($rs['file_size']);
			$rs['file_time'] = date("Y-m-d",$rs['file_time']);
			$rs[sz] = $rs['file_size'];
			$files_array[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$str = '';
		if(count($folders_array) || count($files_array)){
			$str .= $pg==1 ? '<div class="item_1 f12"><span style="float:right;">大小</span>文件(夹)名</div>'.LF : '';
		if(count($folders_array)){
			foreach($folders_array as $k => $v){
				$color = ($k%2 ==0) ? 'color1' :'color6';
				$str .= '<div class="item f16 '.$color.'"><span style="float:right;" class="sz">'.$v[folder_size].'</span><a href="'.$v['a_folder_view'].'"><img src="images/folder.png" align="absmiddle" border="0" />'.$v['folder_name'].'</a></div>'.LF;
			}
		}
		if(count($files_array)){
				foreach($files_array as $k => $v){
					$color = ($k%2 ==0) ? 'color1' :'color6';
					$str .= '<div class="item f16 '.$color.'"><span style="float:right;" class="sz">'.$v[sz].'</span><a href="'.$v['a_view'].'">'.file_icon($v['file_extension'],'filetype_32').$v['file_name'].'</a></div>'.LF;
				}
			}
			unset($files_array);
			$str .= '<div align="center" class="f16" style="margin:8px 0;" id="pgv_'.($pg+1).'"><a href="javascript:;" onclick="'.$action.'('.($pg+1).',false,'.$folder_id.')">点击查看下一页...</a></div>'.LF;
			echo 'true|'.$str;
		}else{
			if($pg>1){
				echo 'true|<div align="center" id="rs" class="pd5">已没有更多结果</div><script>setTimeout(function(){$(\'#rs\').hide(500)},1250)</script>';
			}else{
				echo 'true|<div align="center" class="pd5">暂无文件记录</div>';
			}
		}
		break;

	case 'announce':
		$pg = (int)gpc('pg','P','');
		$pg = $pg ? $pg : 1;

		$start_num = ($pg-1) * $perpage;
		$sql_do = "{$tpf}announces where is_hidden=0 $sql_ext";
		$q = $db->query("select * from {$sql_do} order by show_order asc,annid desc limit $start_num,$perpage");
		$ann_list = array();
		while($rs = $db->fetch_array($q)){
			$rs[a_ann_href] = urr("wap","action=view_ann&aid={$rs[annid]}");
			$rs[in_time] = date('Y-m-d',$rs[in_time]);
			$ann_list[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$str = '';
		if(count($ann_list)){
			$str .= $pg==1 ? '<div class="item_1 f12"><span style="float:right;">日期</span>标题</div>'.LF : '';
			foreach($ann_list as $k => $v){
				$color = ($k%2 ==0) ? 'color1' :'color6';
				$str .= '<div class="item f16 '.$color.'" style="height:25px;line-height:25px;"><span style="float:right;margin-top:0;" class="sz">'.$v[in_time].'</span><a href="'.$v['a_ann_href'].'">'.$v['subject'].'</a></div>'.LF;
			}
			unset($files_array);
			$str .= '<div align="center" class="f16" style="margin:8px 0;" id="pgv_'.($pg+1).'"><a href="javascript:;" onclick="'.$action.'('.($pg+1).',false)">点击查看下一页...</a></div>'.LF;
			echo 'true|'.$str;
		}else{
			if($pg>1){
				echo 'true|<div align="center" id="rs" class="pd5">已没有更多结果</div><script>setTimeout(function(){$(\'#rs\').hide(500)},1250)</script>';
			}else{
				echo 'true|<div align="center" class="pd5">暂无公告记录</div>';
			}
		}
		break;


}

?>