<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: mydisk.php 143 2024-10-19 14:15:17Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

phpdisk_core::user_login();

$mydisk_style = gpc('mydisk_style','C','');
//echo $mydisk_style;exit;

define('IN_MYDISK' ,true);
if(!$myinfo[is_activated]){
	$title = '系统提示';
	include PHPDISK_ROOT."./includes/header.inc.php";
	redirect('./','您的帐号未激活，请联系管理员激活后才能使用！',5000);
	include PHPDISK_ROOT."./includes/footer.inc.php";
	exit;
}
if(!$settings['allow_access'] && $pd_gid<>1){
	$title = '系统提示';
	include PHPDISK_ROOT."./includes/header.inc.php";
	redirect('./',$settings[close_access_reason],5000);
	include PHPDISK_ROOT."./includes/footer.inc.php";
	exit;
}
// fix firefox
if($item =='upload'){
	$uid = (int)gpc('uid','GP',0);
	$pd_is_activated = @$db->result_first("select is_activated from {$tpf}users where userid='$uid'");
}
$menu = trim(gpc('menu','G',''));
$menu = $menu ? $menu : 'file';
$item = $item ? $item : 'files';

if($pd_depart_id){
	$my_depart_name = @$db->result_first("select depart_name from {$tpf}departs where depart_id='$pd_depart_id'");
}
if($pd_uid){
	$new_msg_count = (int)@$db->result_first("select count(*) as total from {$tpf}messages where touserid='$pd_uid' and is_new=1");
}

if($menu =='file'){

	// root my folders
	$arr = my_folder_root();
	$tmp = $arr[file_count] ? __('all_file')."{$arr[file_count]} , ".__('folder_size').get_size($arr[folder_size]) : '';
	$folder_list = "tr.add(0,-1,'".__('mydisk_cp_manage')."','".urr("mydisk","item=files&menu=file&action=index")."','{$tmp}');".LF;
	// my other folders
	$arr = my_folder_menu();
	foreach($arr as $v){
		$folder_list .= "tr.add({$v['folder_id']},{$v['parent_id']},'{$v['folder_name']}','".urr("mydisk","item=files&menu=file&action=index&folder_id={$v['folder_id']}")."','{$v[count]}');".LF;
	}

}
if($menu == 'buddy' && $action=='corp_depart'){
	$depart_list = "tr2.add(0,-1,'企业部门导航','".urr("mydisk","item=buddy&menu=$menu&action=corp_depart")."','{$tmp}');".LF;
	$arr = corp_depart();
	foreach($arr as $v){
		$depart_list .= "tr2.add({$v['depart_id']},{$v['pid']},'{$v['depart_name']}','".urr("mydisk","item=buddy&menu=$menu&action=corp_depart&depart_id=$v[depart_id]")."','{$v[count]}');".LF;
	}
}

if($item =='folders' && $action !='index'){
	$inner_box = true;
}
if($item == 'upload' || $item=='h5upload' || $item=='m_h5upload'){
	$inner_box = true;
}
if($item == 'files' && in_array($action,array('file_modify','file_delete','download','make_link_code','to_folder','to_public','to_recycle','out_share','multi_down','ftp_upload'))){
	$inner_box = true;
}
if($item == 'share' && in_array($action,array('share_file','share_folder','unshare_file','unshare_folder','public_file','cancle_public_file'))){
	$inner_box = true;
}

if($item =='recycle' && in_array($action,array('show_files','folder_delete_complete','file_delete_complete','folder_restore','file_restore','to_folder','delete_complete_recycle'))){
	$inner_box = true;
}
if($item =='public' && in_array($action, array('file_modify','file_delete'))){
	$inner_box = true;
}
if($item =='message' && in_array($action,array('view'))){
	$inner_box = true;
}
if($item =='buddy' && in_array($action,array('addbuddy','delbuddy','s_addbuddy','viewinfo'))){
	$inner_box = true;
}

if($inner_box){
	require_once template_echo('my_header',$user_tpl_dir);
	require_once PHPDISK_ROOT."modules/".$item.".inc.php";
	require_once template_echo('my_footer',$user_tpl_dir);
}else{
	
	require_once template_echo('my_header',$user_tpl_dir);

	$items = array('files','folders','upload','h5upload','profile','main','recycle','share','public','message','buddy','m_h5upload');
	if(in_array($item,$items)){
		$action_module = PHPDISK_ROOT.'modules/'.$item.'.inc.php';
	}else{
		echo "Error operation, system halt!";
		exit;
	}
	
	$site_stat = $settings['site_stat'] ? '&nbsp;'.stripslashes(base64_decode($settings['site_stat'])) : '';
	//$debug_info = $settings['debug_info'] ? '' : 'none';

	$pageinfo = page_end_time();
	
	require_once template_echo("mydisk",$user_tpl_dir);
	require_once template_echo('my_footer',$user_tpl_dir);
	
}

include PHPDISK_ROOT."./includes/footer.inc.php";

