<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: upload.inc.php 135 2024-10-16 00:52:12Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_MYDISK')) {
	exit('[PHPDisk] Access Denied');
}

@set_time_limit(0);
$group_set = $group_settings[$pd_gid];


$my_all_file = @$db->result_first("select sum(file_size) from {$tpf}files where userid='$pd_uid' and is_del=0");
$rs = $db->fetch_one_array("select user_store_space from {$tpf}users where userid='$pd_uid'");
$tmp_max_storage = $rs['user_store_space'] ? $rs['user_store_space'] : $group_set['max_storage'];
if($tmp_max_storage && $my_all_file >= get_byte_value($tmp_max_storage)){
	tb_redirect('',__('user_storage_exceeded'),0);
	exit;
}

$file_id = (int)gpc('file_id','GP',0);
$folder_id = (int)gpc('folder_id','G',0);
$uid = (int)gpc('uid','G',0);
$action = $action ? $action : 'doupload';


if(!get_group_power($pd_gid,'can_upload',1)){
	tb_redirect('','您的帐号没有上传权限','f',0);
	exit;
}

$total = @$db->result_first("select count(*) from {$tpf}files where userid='$pd_uid'");
if($group_set['max_files'] && $total >= $group_set['max_files']){
	tb_redirect('','您的帐号可上传文件数量超过最大值','f',0);
	exit;
}

$folder_id = (int)gpc('folder_id','GP','');
$rs = $db->fetch_one_array("select user_file_types from {$tpf}users where userid='$pd_uid'");

$up_extensions = $up_mimeTypes = '';
$h5_upload_ext_txt = "支持的文件: 所有";
if($rs['user_file_types']){
	$arr = explode(',',trim($rs['user_file_types']));
	for($i=0;$i<count($arr);$i++){
		$up_mimeTypes .= ".{$arr[$i]},";
	}
	$up_mimeTypes = $up_mimeTypes ? substr($up_mimeTypes, 0,-1): '';
	$h5_upload_ext_txt = "支持的文件: ".$rs['user_file_types'];
	$up_extensions = $rs['user_file_types'];
}elseif($group_set['group_file_types']){
	$arr = explode(',',trim($group_set['group_file_types']));
	for($i=0;$i<count($arr);$i++){
		$up_mimeTypes .= ".{$arr[$i]},";
	}
	$h5_upload_ext_txt = "支持的文件: ".$group_set['group_file_types'];
	$up_extensions = $group_set['group_file_types'];
}elseif($settings[h5_upload_ext]){
	$arr = explode(',',trim($settings[h5_upload_ext]));
	for($i=0;$i<count($arr);$i++){
		$up_mimeTypes .= ".{$arr[$i]},";
	}
	$h5_upload_ext_txt = "支持的文件: ".$settings['h5_upload_ext'];
	$up_extensions = $settings[h5_upload_ext];
}

$up_mimeTypes = $up_mimeTypes ? substr($up_mimeTypes, 0,-1): '';

if($group_set['h5_max_filesize']){
	$up_fileSingleSizeLimit = get_byte_value($group_set['h5_max_filesize']);
}elseif($settings['h5_max_filesize']){
	$up_fileSingleSizeLimit = get_byte_value($settings['h5_max_filesize']);
}else{
	$up_fileSingleSizeLimit = get_byte_value('8g'); //default 
}
if($up_fileSingleSizeLimit){
	$up_fileSingleSizeLimit_txt = "单个文件大小: ".get_size($up_fileSingleSizeLimit,'B');
}else{
	$up_fileSingleSizeLimit_txt = "单个文件大小: 不限";
}

$sign = md5($pd_gid.$pd_uid.$settings[encrypt_key].date('Ymd'));
if($settings['open_multi_server']){
	$rs = $db->fetch_one_array("select server_host,server_store_path,server_key from {$tpf}servers where server_id>1 order by is_default desc limit 1");
	if($rs){
		$remote_upload_url = $rs['server_host']."index.php?action=h5upload&uid=$pd_uid&folder_id=$folder_id&gid=$pd_gid&sign=$sign";
	}
	unset($rs);
}
require_once template_echo('upload', $user_tpl_dir);



?>