<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: public.inc.php 138 2024-10-19 09:08:06Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_MYDISK')) {
	exit('[PHPDisk] Access Denied');
}
$nav_tit = array(
'buddy_folders'=>'好友',
'corp_folders'=>'公司',
'depart_folders'=>'部门',
'other_depart_folders'=>'其他部门',
'buddy_files'=>'好友',
'corp_files'=>'公司',
'depart_files'=>'部门',
'other_depart_files'=>'其他部门',
);

switch($action){

	case 'corp_folders':
	case 'depart_folders':
	case 'other_depart_folders':
	case 'buddy_folders':
		$folder_id = (int)gpc('folder_id','G',0);

		if(!$folder_id){
			if($action=='corp_folders'){
				$q = $db->query("select fd.*,username from {$tpf}folders fd,{$tpf}shares s,{$tpf}users u where fd.folder_id=s.share_fid and is_file=0 and u.userid=fd.userid and s.depart_id=-1 group by share_fid order by fd.folder_id asc");
			}elseif($action=='depart_folders'||$action=='other_depart_folders'){
				$q = $db->query("select fd.*,username from {$tpf}folders fd,{$tpf}shares s,{$tpf}users u where fd.folder_id=s.share_fid and is_file=0 and u.userid=fd.userid and s.depart_id='$pd_depart_id' group by share_fid order by fd.folder_id asc");
			}else{
				$q = $db->query("select fd.*,username from {$tpf}folders fd,{$tpf}shares s,{$tpf}users u where fd.folder_id=s.share_fid and s.touserid='$pd_uid' and is_file=0 and u.userid=fd.userid group by share_fid order by fd.folder_id asc");
			}
			$folders = array();
			while ($rs = $db->fetch_array($q)) {
				$rs[folder_size] = get_size($rs[folder_size]);
				$rs[in_time] = date('Y-m-d H:i:s',$rs[in_time]);
				$rs[a_folder] = urr("mydisk","item=$item&menu=$menu&action=$action&folder_id={$rs[folder_id]}");
				$folders[] = $rs;
			}
			$db->free($q);
			unset($rs);

		}else{
			$userid = @$db->result_first("select userid from {$tpf}shares where share_fid='$folder_id' and is_file=0 limit 1");
			$fd_sql = $folder_id ? " and folder_id='$folder_id'" : '';
			$q = $db->query("select fl.*,username from {$tpf}files fl,{$tpf}users u where fl.userid=u.userid $fd_sql and fl.userid='$userid' and in_recycle=0 and is_del=0 order by file_id desc ");
			$files = array();
			while ($rs = $db->fetch_array($q)) {
				$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
				$rs['file_thumb'] = get_file_thumb($rs);
				$rs['file_name'] = $rs['file_name'].$tmp_ext;
				$rs['file_size'] = get_size($rs['file_size']);
				$rs['file_description'] = cutstr($rs['file_description'],80);
				$rs['file_time'] = date("Y-m-d H:i:s",$rs['file_time']);
				$rs['a_downfile'] = create_down_url($rs);
				$rs['a_viewfile'] = urr("mydisk","item=files&action=download&file_id={$rs['file_id']}");
				$files[] = $rs;
			}
			$db->free($q);
			unset($rs);
		}
		
		require_once template_echo($item,$user_tpl_dir);
		break;

	case 'corp_files':
	case 'depart_files':
	case 'other_depart_files':
	case 'buddy_files':

		$folder_id = (int)gpc('folder_id','G',0);

		$fd_sql = $folder_id ? " and folder_id='$folder_id'" : '';

		$perpage = 20;
		if($action=='corp_files'){
			$sql_do = " {$tpf}files f,{$tpf}shares s,{$tpf}users u where f.file_id=s.share_fid and f.userid=u.userid and is_file=1 $fd_sql and s.depart_id=-1  and in_recycle=0 and is_del=0 group by share_fid";
		}elseif($action=='depart_files'||$action=='other_depart_files'){
			$sql_do = " {$tpf}files f,{$tpf}shares s,{$tpf}users u where f.file_id=s.share_fid and f.userid=u.userid and is_file=1 $fd_sql and s.depart_id='$pd_depart_id' and in_recycle=0 and is_del=0 group by share_fid";
		}else{
			$sql_do = " {$tpf}files f,{$tpf}shares s,{$tpf}users u where f.file_id=s.share_fid and f.userid=u.userid and is_file=1 $fd_sql and s.touserid='$pd_uid' and in_recycle=0 and is_del=0 group by share_fid";
		}
		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;

		$q = $db->query("select f.*,username from $sql_do order by file_id desc limit $start_num,$perpage");
		$files = array();
		while ($rs = $db->fetch_array($q)) {
			$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
			$rs['file_thumb'] = get_file_thumb($rs);
			$rs['file_name'] = $rs['file_name'].$tmp_ext;
			$rs['file_size'] = get_size($rs['file_size']);
			$rs['file_description'] = cutstr($rs['file_description'],80);
			$rs['file_time'] = date("Y-m-d H:i:s",$rs['file_time']);
			$rs['a_viewfile'] = urr("mydisk","item=files&action=download&file_id={$rs['file_id']}");
			$files[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$page_nav = multi($total_num, $perpage, $pg, urr("mydisk","item=$item&menu=$menu&action=$action"));

		require_once template_echo($item,$user_tpl_dir);
		break;

}
?>