<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: profile.inc.php 135 2024-10-16 00:52:12Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_MYDISK')) {
	exit('[PHPDisk] Access Denied');
}

$myinfo = get_mydisk_info($pd_uid);

$nav_arr = get_my_nav();

switch($action){
	case 'password':

		if($task == 'password'){
			form_auth(gpc('formhash','P',''),formhash());

			$old_pwd = trim(gpc('old_pwd','P',''));
			$new_pwd = trim(gpc('new_pwd','P',''));
			$cfm_pwd = trim(gpc('cfm_pwd','P',''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			$rs = $db->fetch_one_array("select userid from {$tpf}users where password='".phpdisk_md5($old_pwd)."' and userid='$pd_uid'");
			if(!$rs){
				$error = true;
				$sysmsg[] = __('invalid_password');
			}
			unset($rs);
			if(checklength($new_pwd,6,20)){
				$error = true;
				$sysmsg[] = __('password_max_min');
			}elseif($new_pwd != $cfm_pwd){
				$error = true;
				$sysmsg[] = __('confirm_password_invalid');
			}else{
				$md5_pwd = phpdisk_md5($new_pwd);
			}
			if(display_plugin('api','open_uc_plugin',$settings['connect_uc'],0)){
				if($settings['connect_uc_type']=='phpwind'){
					uc_user_edit($pd_uid, $pd_username, $pd_username, $new_pwd, $pd_email);
				}else{
					$ucresult = uc_user_edit($pd_username, $old_pwd, $new_pwd);
					if($ucresult < 0) {
						$error = true;
						$sysmsg[] = 'UC:'.__('invalid_password');
					}
				}
			}
			if(!$error){
				$sql = "update {$tpf}users set password='$md5_pwd' where userid='$pd_uid'";
				$db->query_unbuffered($sql);
				pd_setcookie(PHPDISK_COOKIE,'',-3600);
				$sysmsg[] = __('password_modify_success');
				redirect(urr("account","action=login"),$sysmsg,2000,'top');
			}else{
				redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}

		}else{
			require_once template_echo('profile',$user_tpl_dir);
		}

		break;

	case 'stats':		
		view_file_logs(0);
		break;

	case 'mycontact':
		if($task=='mycontact'){
			form_auth(gpc('formhash','P',''),formhash());
			$name = trim(gpc('name','P',''));
			$gender = (int)gpc('gender','P',0);
			$phone = trim(gpc('phone','P',''));
			$im = trim(gpc('im','P',''));
			$address = trim(gpc('address','P',''));
			$mood = trim(gpc('mood','P',''));
			
			if(!$name){
				$error = true;
				$sysmsg[] = '请填写真实姓名';
			}
			if(!$error){
				$ins = array(
				'name'=>$name,
				'gender'=>$gender,
				'phone'=>$phone,
				'im'=>$im,
				'address'=>$address,
				'mood'=>$mood,
				);
				$db->query_unbuffered("update {$tpf}users set ".$db->sql_array($ins)." where userid='$pd_uid'");
				$sysmsg[] = '联系信息修改成功';
				redirect(urr("mydisk","item=profile&menu=profile&action=mycontact"),$sysmsg);
			}else{
				redirect('back',$sysmsg);
			}
		}else{
			$pa = get_profile($pd_uid);
			require_once template_echo('profile',$user_tpl_dir);
		}
		break;

	default:
		$group_set = $group_settings[$pd_gid];
		$group_set['max_folders'] = $group_set['max_folders'] ? $group_set['max_folders']: __('no_limit');
		$group_set['max_files'] = $group_set['max_files'] ? $group_set['max_files'] : __('no_limit');

		$upload_max = get_byte_value(ini_get('upload_max_filesize'));
		$post_max = get_byte_value(ini_get('post_max_size'));
		$settings_max = $settings['max_file_size'] ? get_byte_value($settings['max_file_size']) : 0;
		$max_php_file_size = min($upload_max, $post_max);
		$max_file_size_byte = ($settings_max && $settings_max <= $max_php_file_size) ? $settings_max : $max_php_file_size;

		if($group_set['max_filesize']){
			$group_set_max_file_size = get_byte_value($group_set['max_filesize']);
			$max_file_size_byte = ($group_set_max_file_size >=$max_file_size_byte) ? $max_file_size_byte : $group_set_max_file_size;
		}
		$group_set['max_filesize'] = get_size($max_file_size_byte,'B',0);

		$rs = $db->fetch_one_array("select user_file_types,user_store_space from {$tpf}users where userid='$pd_uid' limit 1");
		if($rs['user_file_types']){
			$group_set['user_file_types'] = $rs['user_file_types'];
		}else{
			$group_set['user_file_types'] = $group_set['group_file_types'] ? $group_set['group_file_types'] : __('no_limit');

		}
		if($rs['user_store_space']){
			$group_set['max_storage'] = $rs['user_store_space'];
		}else{
			$group_set['max_storage'] = $group_set['max_storage'] ? $group_set['max_storage'] : __('no_limit');
		}
		unset($rs);
		$rs = $db->fetch_one_array("select user_store_space from {$tpf}users where userid='$pd_uid'");
		if($rs['user_store_space'] ==0){
			$max_storage = $group_settings[$pd_gid]['max_storage']==0 ? __('no_limit') : $group_settings[$pd_gid]['max_storage'];
		}else{
			$max_storage = $rs['user_store_space'];
		}
		unset($rs);

		$stats['total_folders'] = (int)@$db->result_first("select count(*) from {$tpf}folders where userid='$pd_uid'");

		$stats['total_share_folders'] = @$db->result_first("select count(*) from {$tpf}folders where userid='$pd_uid' and in_share=1");

		$stats['total_files'] = (int)@$db->result_first("select count(*) from {$tpf}files where userid='$pd_uid' and in_recycle=0 and is_del=0");

		$stats['file_size_total'] = get_size(@$db->result_first("select sum(file_size) from {$tpf}files where userid='$pd_uid' and in_recycle=0 and is_del=0"));

		$disk_fill = $max_storage ? @round($rs['file_size_total']/get_byte_value($max_storage),1)*120 : 0;
		$disk_percent = $max_storage ? @round($rs['file_size_total']/get_byte_value($max_storage),3)*100 : 0;

		$rs = $db->fetch_one_array("select reg_time,reg_ip,email,last_login_time,last_login_ip from {$tpf}users where userid='$pd_uid'");
		if($rs){
			$stats['reg_time'] = date("Y-m-d H:i:s",$rs['reg_time']);
			$stats['last_login_time'] = $rs['last_login_time'] ? date("Y-m-d H:i:s",$rs['last_login_time']) : '-';
			$stats['reg_ip'] = $rs['reg_ip'];
			$stats['last_login_ip'] = $rs['last_login_ip'];
			$stats['email'] = $rs['email'];
		}
		unset($rs);

		require_once template_echo('profile',$user_tpl_dir);

}

?>