<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: folders.inc.php 135 2024-10-16 00:52:12Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_MYDISK')) {
	exit('[PHPDisk] Access Denied');
}

switch($action){

	case 'folder_modify':
		if(!get_group_power($pd_gid,'can_edit_myfolder',1)){
			tb_redirect('','您的帐号没有修改文件夹权限','f',0);
			exit;
		}
		$folder_id = (int)gpc('folder_id','GP',0);
		
		if($task == 'folder_modify'){
			form_auth(gpc('formhash','P',''),formhash());

			$folder_name = trim(gpc('folder_name','P',''));
			$parent_id = (int)gpc('parent_id','P','');
			$folder_description = trim(gpc('folder_description','P',''));
			$ref = trim(gpc('ref','P',''));
			if(checklength($folder_name,1,100)){
				$error = true;
				$sysmsg[] = __('folder_min_max');
			}elseif(is_bad_chars($folder_name)){
				$error = true;
				$sysmsg[] = __('folder_name_bad_chars');
			}
			$num = @$db->result_first("select folder_id from {$tpf}folders where userid='$pd_uid' and folder_name='$folder_name' and folder_id<>'$folder_id'");
			if($num){
				$error = true;
				$sysmsg[] = __('folder_exists');
			}

			if(!$error){
				$ins = array(
				'parent_id' => $parent_id,
				'folder_name' => $folder_name,
				'folder_description' => $folder_description,
				);
				$db->query_unbuffered("update {$tpf}folders set ".$db->sql_array($ins)." where folder_id='{$folder_id}' and userid='$pd_uid';");
				tb_redirect($ref,__('folder_modify_success'));
			}else{
				tb_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
			}
		}else{
			$folder = $db->fetch_one_array("select folder_name,folder_description,parent_id from {$tpf}folders where folder_id='$folder_id' and userid='$pd_uid'");
			$ref = $_SERVER['HTTP_REFERER'];
			require_once template_echo('folders',$user_tpl_dir);
		}
		break;

	case 'folder_create':
		if(!get_group_power($pd_gid,'can_create_myfolder',1)){
			tb_redirect('','您的帐号没有创建文件夹权限','f',0);
			exit;
		}
		auth_check_folder();
		$group_set = $group_settings[$pd_gid];

		$folder_id = (int)gpc('folder_id','G',0);

		if($task == 'folder_create'){
			create_new_folder();
		}else{

			$ref = $_SERVER['HTTP_REFERER'];
			require_once template_echo('folders',$user_tpl_dir);
		}
		break;

	case 'folder_delete':
		if(!get_group_power($pd_gid,'can_del_myfolder',1)){
			tb_redirect('','您的帐号没有删除文件夹权限','f',0);
			exit;
		}
		$folder_id = (int)gpc('folder_id','GP',0);
		if($task =='folder_delete'){
			form_auth(gpc('formhash','P',''),formhash());

			$ref = trim(gpc('ref','P',''));

			$rs = $db->fetch_one_array("select count(*) as total from {$tpf}folders where parent_id='$folder_id' and userid='$pd_uid'");
			if($rs['total']){
				$error = true;
				$sysmsg[] = __('has_sub_folder');
			}
			unset($rs);
			if(!$error){
				$db->query_unbuffered("update {$tpf}files set in_recycle=1 where folder_id='$folder_id' and userid='$pd_uid'");
				$db->query_unbuffered("update {$tpf}folders set in_recycle=1 where folder_id='$folder_id' and userid='$pd_uid'");
				tb_redirect($ref,__('folder_delete_success'));

			}else{
				tb_redirect('back',$sysmsg);
			}
		}else{
			$rs = $db->fetch_one_array("select folder_name from {$tpf}folders where folder_id='$folder_id' and userid='$pd_uid'");
			$folder_name = $rs['folder_name'];
			$ref = $_SERVER['HTTP_REFERER'];
			require_once template_echo('folders',$user_tpl_dir);
		}
		break;

}
?>
