<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: global.cache.php 139 2024-10-19 09:23:13Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/
!defined('IN_PHPDISK') && exit('[PHPDisk] Access Denied');

function get_curr_tpl($tpl_type){
	global $db,$tpf;
	$tpl_name = @$db->result_first("select tpl_name from {$tpf}templates where tpl_type='$tpl_type' and actived=1");
	return array($tpl_name);
}
function get_lang_name(){
	global $db,$tpf;
	$lang_name = @$db->result_first("select lang_name from {$tpf}langs where actived=1");
	return array($lang_name);
}
function get_navigation_link($pos){
	global $db,$tpf;
	$pos = in_array($pos,array('top','bottom')) ? $pos : 'top';
	$q = $db->query("select * from {$tpf}navigations where position='$pos' order by show_order asc, navid desc");
	$arr = array();
	while($rs = $db->fetch_array($q)){
		$arr[] = $rs;
	}
	$db->free($q);
	unset($rs);
	return $arr;
}
function get_ads($adv_position){
	global $tpf,$db;
	$scope = substr(substr(strrchr($_SERVER['PHP_SELF'],'/'),1),0,-4);
	$echo_data = false;
	$q = $db->query("select * from {$tpf}advertisements where adv_position='$adv_position' and is_hidden=0 order by show_order asc,advid desc");
	$adv_arr = array();
	while($rs = $db->fetch_array($q)){
		$adv_type = $rs['adv_type'];
		$param = unserialize($rs['params']);
		$code = $rs['code'];
		$starttime = $rs['starttime'];
		$endtime = $rs['endtime'];

		if(strpos($param['adv_scope'],',')){
			$a2 = explode(',',$param['adv_scope']);
			if(in_array('all',$a2)){
				$echo_data = true;
			}elseif(in_array($scope,$a2)){
				$echo_data = true;
			}
		}else{
			if(!$param['adv_scope'] || $param['adv_scope'] =='all'){
				$echo_data = true;
			}elseif($param['adv_scope'] ==$scope){
				$echo_data = true;
			}
		}
		if($echo_data){
			if($starttime && TS<$starttime){
				$rs['adv_str'] = '';
			}elseif($endtime && TS>$endtime){
				$rs['adv_str'] = '';
			}else{
				switch($adv_type){
					case 'adv_text':
						$size = $param['adv_txt_size'] ? 'font-size:'.$param['adv_txt_size'].';' : 'font-size:12px;';
						$color = $param['adv_txt_color'] ? 'color:'.$param['adv_txt_color'].';' : '';

						$rs['adv_str'] = '<div style="padding:8px 0;"><a href="'.$param['adv_txt_url'].'" target="_blank" style="'.$size.$color.'">'.$param['adv_txt_title'].'</a></div>';
						break;
					case 'adv_code':
						$rs['adv_str'] = $code;
						break;
					case 'adv_flash':
						$rs['adv_str'] = '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="'.$param['adv_flash_width'].'" height="'.$param['adv_flash_height'].'">
						  <param name="movie" value="'.$param['adv_flash_src'].'" />
						  <param name="quality" value="high" />
						  <param name="allowScriptAccess" value="always" />
						  <param name="wmode" value="transparent">
							 <embed src="'.$param['adv_flash_src'].'"
							  quality="high"
							  type="application/x-shockwave-flash"
							  WMODE="transparent"
							  width="'.$param['adv_flash_width'].'"
							  height="'.$param['adv_flash_height'].'"
							  pluginspage="http://www.macromedia.com/go/getflashplayer"
							  allowScriptAccess="always" />
						</object>';
						break;
					default:
						$rs['adv_str'] = '<a href="'.$param['adv_img_url'].'" target="_blank">';
						$rs['adv_str'] .= '<img src="'.$param['adv_img_src'].'" ';
						$rs['adv_str'] .= $param['adv_img_width'] ? ' width="'.$param['adv_img_width'].'" ' : '';
						$rs['adv_str'] .= $param['adv_img_height'] ? ' height="'.$param['adv_img_height'].'" ' : '';
						$rs['adv_str'] .= ' align="absmiddle" border="0" alt="'.$param['adv_img_alt'].'" />';
						$rs['adv_str'] .= '</a>';
				}
			}
		}
		$adv_arr[] = $rs;
	}
	$db->free($q);
	unset($rs);

	return $adv_arr;
}
// direct show in tpl
function show_adv_data($pos){
	$adv_content = get_ads($pos);

	$rtn = '';
	switch($pos){
		case 'adv_bottom':
			if(count($adv_content)){
				foreach($adv_content as $v){
					$rtn .= '<div align="center">'.$v['adv_str'].'</div>';
				}
				unset($adv_content);
			}
			break;

		default:
			if(count($adv_content)){
				foreach($adv_content as $v){
					$rtn .= $v['adv_str'];
				}
				unset($adv_content);
			}
	}
	echo $rtn;
}

function my_folder_root(){
	global $db,$tpf;
	$file_count = (int)@$db->result_first("select count(*) from {$tpf}files where folder_id=0 and in_recycle=0 and userid='$pd_uid'");
	$folder_size = @$db->result_first("select sum(file_size) from {$tpf}files where folder_id=0 and in_recycle=0 and userid='$pd_uid'");
	return array('file_count'=>$file_count,'folder_size'=>$folder_size);
}
function my_folder_menu(){
	global $db,$tpf,$pd_uid;

	$q = $db->query("select folder_id,parent_id,folder_name,folder_node from {$tpf}folders where userid='$pd_uid' and in_recycle=0 order by folder_order asc,in_time asc");
	$arr = array();
	while($rs = $db->fetch_array($q)){
		//$num = (int)@$db->result_first("select count(*) from {$tpf}files where folder_id='{$rs['folder_id']}' and userid='$pd_uid'");
		//$rs[folder_size] = @$db->result_first("select sum(file_size) from {$tpf}files where folder_id='{$rs[folder_id]}' and userid='$pd_uid'");
		//$rs[count] = $num ? __('all_file')."$num , ".__('folder_size').get_size($rs['folder_size']) : '';
		$rs['parent_id'] = $rs['parent_id']==-1 ? 0 : (int)$rs['parent_id'];

		$arr[] = $rs;
	}
	$db->free($q);
	unset($rs);
	return $arr;
}
function corp_depart(){
	global $db,$tpf,$pd_uid;
	
	$q = $db->query("select * from {$tpf}departs order by show_order asc");
	$arr = array();
	while($rs = $db->fetch_array($q)){	
		$arr[] = $rs;
	}
	$db->free($q);
	unset($rs);
	return $arr;
}

function get_mydisk_info($pd_uid){
	global $db,$tpf,$settings;
	$rs = $db->fetch_one_array("select wealth,credit from {$tpf}users where userid='$pd_uid' limit 1");
	if($rs){
		$myinfo['credit'] = (int)$rs['credit'];
		$myinfo['wealth'] = (int)$rs['wealth'];
	}
	unset($rs);
	return $myinfo;
}

function main_stats(){
	global $db,$tpf,$timestamp;
	$stats['user_folders_count'] = (int)@$db->result_first("select count(*) from {$tpf}folders");

	$stats['users_count'] = (int)@$db->result_first("select count(*) from {$tpf}users ");

	$stats['users_locked_count'] = (int)@$db->result_first("select count(*) from {$tpf}users where is_locked=1");

	$stats['all_files_count'] = (int)@$db->result_first("select count(*) from {$tpf}files");

	$storage_count_tmp = (float)@$db->result_first("select sum(file_size) from {$tpf}files");

	$stats['user_storage_count'] = get_size($storage_count_tmp);
	$stats['users_open_count'] = $stats['users_count']-$stats['users_locked_count'];
	$stats['stat_time'] = $timestamp;

	stats_cache($stats);
}
function get_share_folder_path($folder_id,$uid){
	global $db,$tpf;
	$nav_path = @$db->result_first("select folder_name from {$tpf}folders where folder_id='$folder_id' and userid='$uid'");
	return $nav_path ? '<img src="images/folder.gif" align="absmiddle" border="0" />'.$nav_path : '';
}
function get_departs($all=1){
	global $db,$tpf,$pd_depart_id;
	if($all){
		$q = $db->query("select * from {$tpf}departs order by depart_id");
	}else{
		$q = $db->query("select * from {$tpf}departs where depart_id<>'$pd_depart_id' order by depart_id");
	}
	$arr = array();
	while ($rs = $db->fetch_array($q)) {
		$arr[] = $rs;
	}
	$db->free($q);
	unset($rs);
	return $arr;
}
function get_folder_list2($pid=0,$lv=0,$selID=0){
	global $db,$tpf,$pd_uid;
	$q = $db->query("select * from {$tpf}folders where userid='$pd_uid' order by folder_order asc,folder_id desc");
	while ($rs = $db->fetch_array($q)) {
		$data[] = $rs;
	}
	$db->free($q);
	unset($rs);
	if(count($data)){
		$html = '';
		foreach($data as $v){
			if($v['parent_id'] == $pid){
				$html .= '<div id="sfd_'.$v[folder_id].'" title="'.$v[folder_name].'">';
				$html .= str_repeat('&nbsp;',$lv*2).'<a href="javascript:;" onclick="add_disk('.$v[folder_id].',0)">';
				$html .= '<img id="simg_'.$v[folder_id].'" src="images/folder.gif" align="absmiddle" border="0" />';
				$html .= $v[folder_name].'</a></div>'.LF;
				$lv++;
				$html .= get_folder_list2($v['folder_id'],$lv,$folder_id);
				$lv--;
			}
		}
		return $html.'<script>$("#sfd_'.$selID.'").addClass("sel_a");$("#simg_'.$selID.'").attr("src","images/folder_open.gif")</script>';
	}else{
		return '';
	}
}
function get_web_link($url,$no_content=1){
	if(function_exists('curl_init')){
		$options = array(
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_HEADER         => false,
		CURLOPT_ENCODING       => "",
		CURLOPT_USERAGENT      => "spider",
		CURLOPT_AUTOREFERER    => true,
		CURLOPT_CONNECTTIMEOUT => 120,
		CURLOPT_TIMEOUT        => 2,
		CURLOPT_MAXREDIRS      => 10,
		CURLOPT_NOBODY => $no_content,
		);
		$ch = curl_init($url);
		curl_setopt_array($ch, $options);
		$content = curl_exec($ch);
		$err = curl_errno($ch);
		$errmsg = curl_error($ch);
		$header = curl_getinfo($ch);
		curl_close($ch);

		$header['errno'] = $err;
		$header['errmsg'] = $errmsg;
		$header['content'] = $content;

		return $header;
	}else{
		exit('PHP CURL module is not supported!');
	}
}
function show_in_page($arrs) {
	global $curr_script;
	$arr = explode(',',$arrs);
	if(in_array($curr_script,$arr)){
		return true;
	}else{
		return false;
	}
}