<?php 
##
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: global.func.php 139 2024-10-19 09:23:13Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
##

if(!defined('IN_PHPDISK')) {
	exit('[PHPDisk] Access Denied');
}

function template_echo($tpl,$tpl_dir,$app='',$is_admin_tpl=0){
	if($app){
		$tpl_cache_dir = PHPDISK_ROOT."system/plugins/$app/";
		$tpl_src_dir = PHPDISK_ROOT."plugins/$app/";
	}else{
		$tpl_cache_dir = $tpl_cache_dir_tmp = PHPDISK_ROOT.'system/'.$tpl_dir;
		$tpl_src_dir = PHPDISK_ROOT.$tpl_dir;
		$tpl_default_dir = PHPDISK_ROOT.'templates/default/';
		$admin_tpl_dir = PHPDISK_ROOT.'templates/admin/';
	}
	if(strpos($tpl,'/')!==false){
		$tpl_cache_dir_tmp = $tpl_cache_dir_tmp.substr($tpl,0,strlen($tpl)-strlen(strrchr($tpl,'/'))).'/';
	}
	make_dir($tpl_cache_dir_tmp);
	make_dir($tpl_cache_dir);

	$tpl_cache_file = $tpl_cache_dir.$tpl.'.tpl.php';
	$tpl_src_file = $tpl_src_dir.$tpl.'.tpl.php';
	if(!$app){
		if($is_admin_tpl && !file_exists($tpl_src_file)){
			$tpl_src_file = $admin_tpl_dir.$tpl.'.tpl.php';
		}elseif(!file_exists($tpl_src_file)){
			$tpl_src_file = $tpl_default_dir.$tpl.'.tpl.php';
		}
	}
	if(@filemtime($tpl_cache_file) < @filemtime($tpl_src_file)){
		write_file($tpl_cache_file,template_parse($tpl_src_file));
		return $tpl_cache_file;
	}
	if(file_exists($tpl_cache_file)){
		return $tpl_cache_file;
	}else{
		$str = strrchr($tpl_cache_file,'/');
		$str = substr($str,1,strlen($str));
		die("PHPDisk Template: <b>$tpl_dir$tpl_cache_file</b> not Exists!");
	}

}

function template_parse($tpl){
	global $user_tpl_dir;
	if(!file_exists($tpl)){
		exit('Template ['.$tpl.'] not exists!');
	}
	$str = read_file($tpl);
	$str = preg_replace("/\<\!\-\-\#include (.+?)\#\-\-\>/si","<?php require_once template_echo('\\1','$user_tpl_dir'); ?>", $str);
	$str = preg_replace("/\<\!\-\-\#(.+?)\#\-\-\>/si","<?php \\1 ?>", $str);
	$str = preg_replace("/\{([A-Z_]+)\}/","<?=\\1?>",$str);
	$str = preg_replace("/\{(\\\$[a-z0-9_\'\"\[\]]+)\}/si", "<?=\\1?>", $str);
	$str = preg_replace("/\{\<\?\=(\\\$[a-z0-9_\'\"\[\]]+)\?\>\}/si","{\\1}",$str);
	$str = preg_replace("/\{\#(.+?)\#\}/si","<?=\\1?>", $str);
	$str = preg_replace("/\{sql\[(.+)\]\[(.+)\]\}/si","<? foreach(get_sql(\"\\1\") as \\2){ ?>",$str);
	$str = str_replace("{/sql}","<? } ?>",$str);
	$str = str_replace('@@','{$tpf}',$str); // fix sql tag!

	$prefix = "<?php ".LF;
	$prefix .= "// This is PHPDISK auto-generated file. Do NOT modify me.".LF.LF;
	$prefix .= "// Cache Time:".date('Y-m-d H:i:s').LF.LF;
	$prefix .= "!defined('IN_PHPDISK') && exit('[PHPDisk] Access Denied');".LF.LF;
	$prefix .= "?>".LF;

	return $prefix.$str;
}

function form_auth($p_formhash,$formhash){
	if($p_formhash != $formhash){
		exit(__('system_error'));
	}
}
function convert_str($in,$out,$str){
	global $db;
	if(function_exists("iconv")){
		$str = iconv($in,$out,$str);
	}elseif(function_exists("mb_convert_encoding")){
		$str = mb_convert_encoding($str,$out,$in);
	}
	return $db->escape($str);
}

function is_utf8(){
	global $charset;
	return (strtolower($charset) == 'utf-8') ? true : false;
}
function is_windows(){
	return (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') ? 1 : 0;
}

function wipe_replace($str) {
	return str_replace(array( "\n", "\r", '..'), array('', '', ''), $str);
}

function word_style($i,$type ='font'){
	switch($i){
		case 500:
			$f_px = "25px";
			$c_col = '#ff6600';
			break;
		case 300:
			$f_px = "20px";
			$c_col = '#ff5500';
			break;
		case 100:
			$f_px = "18px";
			$c_col = '#003366';
			break;
		case 50:
			$f_px = "14px";
			$c_col = '#003366';
			break;
		default:
			$f_px = "12px";
			$c_col = '#666666';
	}
	return ($type =='font') ? $f_px : $c_col;
}
function page_end_time(){
	global $ps_time,$db,$C;
	return 'Processed in '.get_runtime('start','end').' second(s), '.$db->querycount.' queries, Gzip '.$C['gz']['status'];
}

function replace_inject_str($str){
	$bad_chars = array("\\","'",'"','/','*',',','<','>',"\r","\t","\n",'$','(',')','%','?',';','^','#',':','&');
	return str_replace($bad_chars,'',$str);
}
function redirect_top_page(){
	global $_SERVER;
	$tmp = strrchr($_SERVER['HTTP_REFERER'],'/');
	$arr = explode('.',$tmp);
	$php_ref = substr($arr[0],1);
	if($php_ref =='admincp' || $php_ref =='mydisk'){
		return true;
	}else{
		return false;
	}
}
function checklength($str,$min,$max){
	if(!$str || strlen($str) > $max || strlen($str) < $min){
		return true;
	}
}
function ifselected($int1,$int2,$type = 'int'){
	if($type == 'int'){
		if(intval($int1) == intval($int2)){
			return ' selected';
		}
	}elseif($type == 'str'){
		if(strval($int1) == strval($int2)){
			return ' selected';
		}
	}
}
function ifchecked($int1,$int2,$type = 'int'){
	if($type == 'int'){
		if(intval($int1) == intval($int2)){
			return ' checked';
		}
	}elseif($type == 'str'){
		if(strval($int1) == strval($int2)){
			return ' checked';
		}
	}
}
function multi_selected($id,$str){
	if(strpos($str,',')){
		$a2 = explode(',',$str);
		$rtn = in_array($id,$a2) ? ' selected' : '';
	}else{
		$rtn = $id==$str ? ' selected' : '';
	}
	return $rtn;
}

function replace_js($str){
	return preg_replace("'<script[^>]*?>(.*?)</script>'si","[script]\\1[/script]",$str);
}
function custom_time($format, $time){
	global $timestamp;
	$s = $timestamp - $time;
	if($s < 0){
		return __('custom_time_0');
	}
	if($s < 60){
		return $s.__('custom_time_1');
	}
	$m = $s / 60;
	if($m < 60){
		return floor($m).__('custom_time_2');
	}
	$h = $m / 60;
	if($h < 24){
		return floor($h).__('custom_time_3');
	}
	$d = $h / 24;
	if($d < 2){
		return __('custom_time_4').date("H:i", $time);
	}
	if($d <3){
		return __('custom_time_5').date("H:i", $time);
	}
	if($d <= 30){
		return floor($d).__('custom_time_6');
	}
	return date($format, $time);
}
function get_byte_value($v){
	$v = trim($v);
	$l = strtolower($v[strlen($v) - 1]);
	switch($l){
		case 't':
			$v *= 1024;
		case 'g':
			$v *= 1024;

		case 'm':
			$v *= 1024;

		case 'k':
			$v *= 1024;
	}
	return $v;
}

function wap_redirect($url,$str,$timeout = 2000,$target = ''){
	global $user_tpl_dir;

	if($timeout ==0){
		header("Location:$url");
		exit;
	}else{
		$msg = '';
		if(is_array($str)){
			for($i=0;$i<count($str);$i++){
				$msg .= "<li>".$str[$i]."</li>".LF;
			}
		}else{
			$msg = $str;
		}
		$go_url = $url=='back' ? 'javascript:history.back();' : $url;
		$rtn = '<div class="loading_box" align="center">'.$msg.'<br><a href="'.$go_url.'">[返回]</a></div>'.LF;
		if($go_url){
			$rtn .= "<script>".LF;
			$rtn .= "<!--".LF;
			$rtn .= "function redirect() {".LF;
			if($target =='top'){
				$rtn .= "	self.parent.location.href = '$go_url';".LF;
			}else{
				$rtn .= "	document.location.href = '$go_url';".LF;
			}
			$rtn .= "}".LF;
			$rtn .= "setTimeout('redirect();', $timeout);".LF;
			$rtn .= "-->".LF;
			$rtn .= "</script>".LF;
		}
		echo $rtn;
	}
}
function adm_redirect($url,$str,$timeout = 2000,$target = ''){
	global $admin_tpl_dir,$curr_script;

	if($timeout ==0){
		header("Location:$url");
		exit;
	}else{
		$msg = '';
		if(is_array($str)){
			for($i=0;$i<count($str);$i++){
				$msg .= "<li>".$str[$i]."</li>".LF;
			}
		}else{
			$msg = $str;
		}
		$go_url = $url=='back' ? $url = 'javascript:history.back();' : $url;
		require_once template_echo('msg_info',$admin_tpl_dir);
		$rtn = "<script>".LF;
		$rtn .= "<!--".LF;
		$rtn .= "function redirect() {".LF;
		if($target =='top'){
			$rtn .= "	top.document.location.href = '$go_url';".LF;
		}else{
			$rtn .= "	document.location.href = '$go_url';".LF;
		}
		$rtn .= "}".LF;
		$rtn .= "setTimeout('redirect();', $timeout);".LF;
		$rtn .= "-->".LF;
		$rtn .= "</script>".LF;
		echo $rtn;
	}
}
function redirect($url,$str,$timeout = 2000,$target = ''){
	global $user_tpl_dir,$curr_script;

	if($timeout ==0){
		header("Location:$url");
		exit;
	}else{
		$msg = '';
		if(is_array($str)){
			for($i=0;$i<count($str);$i++){
				$msg .= "<p>".$str[$i]."</p>".LF;
			}
		}else{
			$msg = $str;
		}
		$go_url = $url=='back' ? $url = 'javascript:history.back();' : $url;
		require_once template_echo('information',$user_tpl_dir);
		$rtn = "<script>".LF;
		$rtn .= "<!--".LF;
		$rtn .= "function redirect() {".LF;
		if($url =='reload'){
			$rtn .= " top.document.location.reload();";
		}
		if($target =='top'){
			if($url =='reload'){
				$rtn .= " top.document.location.reload();";
			}else{
				$rtn .= "	top.document.location.href = '$go_url';".LF;
			}
		}else{
			if($url =='reload'){
				$rtn .= " top.document.location.reload();";
			}else{
				$rtn .= "	document.location.href = '$go_url';".LF;
			}
		}
		$rtn .= "}".LF;
		$rtn .= "setTimeout('redirect();', $timeout);".LF;
		$rtn .= "-->".LF;
		$rtn .= "</script>".LF;
		echo $rtn;
	}
}
function tb_redirect($url,$str,$status='ok',$timeout=2000){
	if(is_array($str)){
		for($i=0;$i<count($str);$i++){
			$msg .= "<dt>".$str[$i]."</dt>".LF;
		}
	}else{
		$msg = $str;
	}
	$go_url = $url=='back' ? 'javascript:history.back();' : $url;
	$rtn = '';
	if($status=='f'){
		$rtn .= '<div class="alert alert-danger" style="padding:8px;">';
		$rtn .= '<div style="text-align:center"><i class="fa fa-exclamation-triangle fa-4x"></i></div>';
	}else{
		$rtn .= '<div class="alert alert-info" style="padding:8px;">';
		$rtn .= '<div style="text-align:center"><i class="fa fa-check-circle fa-4x"></i></div>';
	}
	$rtn .= '<dl style="text-align:center;margin-top:5px;">'.$msg.'</dl></div>'.LF;
	$rtn .= "<script>".LF;
	$rtn .= "<!--".LF;
	$rtn .= '$(document).ready(function(){$(".row").css({"display":"block"})});'.LF;
	$rtn .= "function redirect() {".LF;
	//$rtn .= $url=='back' ? 'javascript:history.back();'.LF : $url;
	if($url =='reload'){
		$rtn .= " top.document.location.reload();";
	}else{
		$rtn .= "	top.document.location = '$go_url';".LF;
	}
	$rtn .= "}".LF;
	if($timeout){
		$rtn .= "setTimeout('redirect();', $timeout);".LF;
	}
	$rtn .= "-->".LF;
	$rtn .= "</script>".LF;
	echo $rtn;
}
function is_bad_chars($str){
	$bad_chars = array("\\",' ',"'",'"','/','*',',','<','>',"\r","\t","\n",'$','(',')','%','+','?',';','^','#',':','　','`','=','|','-');
	foreach($bad_chars as $value){
		if (strpos($str,$value) !== false){
			return true;
		}
	}
}

function get_extension($name){
	return strtolower(trim(strrchr($name, '.'), '.'));
}
function formhash(){
	global $pd_uid,$pd_pwd;
	return substr(md5(substr(time(), 0, -7).$pd_uid.$pd_pwd), 8, 8);
}
function encode_pwd($str){
	global $settings;
	$len = trim($str) ? strlen($str) : 6;
	if($settings['online_demo']){
		$rtn = str_repeat('*',$len);
	}else{
		if($len <=4){
			$rtn = str_repeat('*',$len);
		}elseif($len <=10){
			$rtn = str_repeat('*',$len-4);
			$rtn .= substr($str,-4);
		}else{
			$rtn = str_repeat('*',$len-6);
			$rtn .= substr($str,-6);
		}
	}
	return $rtn;
}
function random($length){
	$seed = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	$str = "";
	while(strlen($str) < $length){
		$str .= substr($seed,(mt_rand() % strlen($seed)),1);
	}
	return $str;
}

function addslashes_array(&$array) {
	if(is_array($array)){
		foreach($array as $k => $v) {
			$array[$k] = addslashes_array($v);
		}
	}elseif(is_string($array)){
		$array = addslashes($array);
	}
	return $array;
}

function get_size($s,$u='B',$p=1){
	$us = array('B'=>'K','K'=>'M','M'=>'G','G'=>'T');
	return (($u!=='B')&&(!isset($us[$u]))||($s<1024))?(number_format($s,$p)." $u"):(get_size($s/1024,$us[$u],$p));
}

function checkemail($email) {
	if((strlen($email) > 6) && preg_match("/^[\w\-\.]+@[\w\-\.]+(\.\w+)+$/", $email)){
		return true;
	}else{
		return false;
	}
}

function defend_xss($val){
	return is_array($val) ? $val : htmlspecialchars($val);
}

function gpc($name,$w = 'GPC',$default = '',$d_xss=1){
	global $curr_script;
	if($curr_script==ADMINCP){
		$d_xss = 0;
	}
	$i = 0;
	for($i = 0; $i < strlen($w); $i++) {
		if($w[$i] == 'G' && isset($_GET[$name])) return $d_xss ? defend_xss($_GET[$name]) : $_GET[$name];
		if($w[$i] == 'P' && isset($_POST[$name])) return $d_xss ? defend_xss($_POST[$name]) : $_POST[$name];
		if($w[$i] == 'C' && isset($_COOKIE[$name])) return $d_xss ? defend_xss($_COOKIE[$name]) : $_COOKIE[$name];
	}
	return $default;
}
function get_ip(){
	if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
		$onlineip = getenv('HTTP_CLIENT_IP');
	} elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
		$onlineip = getenv('HTTP_X_FORWARDED_FOR');
	} elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
		$onlineip = getenv('REMOTE_ADDR');
	} elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
		$onlineip = $_SERVER['REMOTE_ADDR'];
	}
	$onlineip = addslashes($onlineip);
	@preg_match("/[\d\.]{7,15}/", $onlineip, $onlineipmatches);
	$onlineip = $onlineipmatches[0] ? $onlineipmatches[0] : 'unknown';
	unset($onlineipmatches);
	return $onlineip;
}

function pd_setcookie($var, $value, $expires = 0,$cookiepath = '/', $cookiedomain = '') {
	global $timestamp;
	setcookie($var, $value,$expires ? ($timestamp + $expires) : 0,$cookiepath,$cookiedomain, $_SERVER['SERVER_PORT'] == 443 ? 1 : 0);
}

function pd_encode($string, $operation = 'ENCODE',$key = ''){
	global $settings;
	$ckey_length = 4;
	$key = md5($key ? $key : ($settings['encrypt_key'] ? $settings['encrypt_key'] : 'PHPDisk=Rc9o'));

	$keya = md5(substr($key, 0, 16));
	$keyb = md5(substr($key, 16, 16));
	$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

	$cryptkey = $keya.md5($keya.$keyc);
	$key_length = strlen($cryptkey);

	$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d',0).substr(md5($string.$keyb), 0, 16).$string;
	$string_length = strlen($string);
	$result = '';
	$arr = range(0, 255);
	$rndkey = array();
	for($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($cryptkey[$i % $key_length]);
	}
	for($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $arr[$i] + $rndkey[$i]) % 256;
		$tmp = $arr[$i];
		$arr[$i] = $arr[$j];
		$arr[$j] = $tmp;
	}
	for($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $arr[$a]) % 256;
		$tmp = $arr[$a];
		$arr[$a] = $arr[$j];
		$arr[$j] = $tmp;

		$result .= chr(ord($string[$i]) ^ ($arr[($arr[$a] + $arr[$j]) % 256]));
	}
	if($operation == 'DECODE') {
		if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
			return substr($result, 26);
		} else {
			return '';
		}
	} else {

		return $keyc.str_replace('=', '', base64_encode($result));
	}
}
function encrypt_key($txt, $key) {
	$md5_key = md5($key);
	$ctr = 0;
	$tmp = '';
	for($i = 0; $i < strlen($txt); $i++) {
		$ctr = $ctr == strlen($md5_key) ? 0 : $ctr;
		$tmp .= $txt[$i] ^ $md5_key[$ctr++];
	}
	return $tmp;
}

function cutstr($string, $length, $dot = '...',$charset='utf-8') {
	if(strlen($string) <= $length) {
		return $string;
	}
	$string = str_replace(array('&amp;', '&quot;', '&lt;', '&gt;'), array('&', '"', '<', '>'), $string);
	$strcut = '';
	if(strtolower($charset) == 'utf-8') {

		$n = $tn = $noc = 0;
		while($n < strlen($string)) {

			$t = ord($string[$n]);
			if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
				$tn = 1; $n++; $noc++;
			} elseif(194 <= $t && $t <= 223) {
				$tn = 2; $n += 2; $noc += 2;
			} elseif(224 <= $t && $t < 239) {
				$tn = 3; $n += 3; $noc += 2;
			} elseif(240 <= $t && $t <= 247) {
				$tn = 4; $n += 4; $noc += 2;
			} elseif(248 <= $t && $t <= 251) {
				$tn = 5; $n += 5; $noc += 2;
			} elseif($t == 252 || $t == 253) {
				$tn = 6; $n += 6; $noc += 2;
			} else {
				$n++;
			}

			if($noc >= $length) {
				break;
			}

		}
		if($noc > $length) {
			$n -= $tn;
		}

		$strcut = substr($string, 0, $n);

	} else {
		for($i = 0; $i < $length - strlen($dot) - 1; $i++) {
			$strcut .= ord($string[$i]) > 127 ? $string[$i].$string[++$i] : $string[$i];
		}
	}

	$strcut = str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $strcut);

	return $strcut.$dot;
}

function multi($total, $perpage, $curpage, $mpurl) {
	global $curr_script;
	$multipage = '';
	$mpurl .= strpos($mpurl, '?') ? '&amp;' : '?';
	if($total > $perpage) {
		$pg = 10;
		$offset = 5;
		$pgs = @ceil($total / $perpage);
		if($pg > $pgs) {
			$from = 1;
			$to = $pgs;
		} else {
			$from = $curpage - $offset;
			$to = $curpage + $pg - $offset - 1;
			if($from < 1) {
				$to = $curpage + 1 - $from;
				$from = 1;
				if(($to - $from) < $pg && ($to - $from) < $pgs) {
					$to = $pg;
				}
			} elseif($to > $pgs) {
				$from = $curpage - $pgs + $to;
				$to = $pgs;
				if(($to - $from) < $pg && ($to - $from) < $pgs) {
					$from = $pgs - $pg + 1;
				}
			}
		}

		//if($curr_script==ADMINCP){
			$multipage = ($curpage - $offset > 1 && $pgs > $pg ? '<li class="paginate_button page-item "><a href="'.$mpurl.'pg=1" class="page-link">&laquo;</a></li>' : '').($curpage > 1 ? '<li class="paginate_button page-item "><a href="'.$mpurl.'pg='.($curpage - 1).'" class="page-link">&#8249;</a></li>' : '');
			for($i = $from; $i <= $to; $i++) {
				$multipage .= $i == $curpage ? '<li class="paginate_button page-item active"><span class="page-link ">'.$i.'</span></li>' : '<li class="paginate_button page-item "><a href="'.$mpurl.'pg='.$i.'" class="page-link">'.$i.'</a></li>';
			}
			$multipage .= ($curpage < $pgs ? '<li class="paginate_button page-item "><a href="'.$mpurl.'pg='.($curpage + 1).'" class="page-link">&#8250;</a></li>' : '').($to < $pgs ? '<li class="paginate_button page-item "><a href="'.$mpurl.'pg='.$pgs.'" class="page-link">&raquo;</a></li>' : '');
			$multipage = $multipage ? '<ul class="pagination "><li class="paginate_button page-item page-link">Total:&nbsp;<b>'.$total.'</b>&nbsp;</li>'.$multipage.'</ul>' : '';
		/*}else{
			$multipage = ($curpage - $offset > 1 && $pgs > $pg ? '<a href="'.$mpurl.'pg=1" class="p_redirect">&laquo;</a>' : '').($curpage > 1 ? '<a href="'.$mpurl.'pg='.($curpage - 1).'" class="p_redirect">&#8249;</a>' : '');
			for($i = $from; $i <= $to; $i++) {
				$multipage .= $i == $curpage ? '<span class="p_curpage">'.$i.'</span>' : '<a href="'.$mpurl.'pg='.$i.'" class="p_num">'.$i.'</a>';
			}
			$multipage .= ($curpage < $pgs ? '<a href="'.$mpurl.'pg='.($curpage + 1).'" class="p_redirect">&#8250;</a>' : '').($to < $pgs ? '<a href="'.$mpurl.'pg='.$pgs.'" class="p_redirect">&raquo;</a>' : '');
			$multipage = $multipage ? '<div class="p_bar"><span class="p_info">Total:&nbsp;<b>'.$total.'</b>&nbsp;</span>'.$multipage.'</div>' : '';
		}*/
	}
	return $multipage;
}
function is_today($time){
	return (date('Ymd') == date('Ymd',$time)) ? 1 : 0;
}
function get_ids_arr($arr,$msg,$str_in_db=0){
	global $db;
	$error = 0;
	if(!count($arr)){
		$error = 1;
		$strs = $msg;
	}else{
		for($i=0;$i<count($arr);$i++){
			if(is_numeric($arr[$i])){
				$strs .= $str_in_db ? (int)$arr[$i]."," : "'".(int)$arr[$i]."',";
			}
		}
		$strs = substr($strs,0,-1);
	}
	return array($error,$strs);
}
function get_last_upload_server($pd_uid,$group_set){
	$arr_ids = strpos($group_set,',') ? explode(',',$group_set) : $group_set;
	if(is_array($arr_ids)){
		$server_oid = (int)$arr_ids[mt_rand(0,count($arr_ids))];
		$server_oid = $server_oid ? $server_oid : (int)$arr_ids[0];
	}else{
		$server_oid = $arr_ids;
	}
	return $server_oid;
}

function get_file_thumb($rs){
	global $db,$tpf,$settings;
	if(display_plugin('multi_server','open_multi_server_plugin',$settings['open_multi_server'],0) && $rs['server_oid'] >1){
		$rs2 = $db->fetch_one_array("select * from {$tpf}servers where server_oid='{$rs['server_oid']}' limit 1");
		if($rs2){
			if($rs['is_image']){
				$file_thumb = $rs2['server_host'].$rs2['server_store_path'].'/'.$rs['file_store_path'].'/'.$rs['file_real_name'].'_thumb.'.$rs['file_extension'];
			}
		}
		unset($rs2);
	}else{
		if($rs['is_image']){
			if($rs['store_old']){
				$file_thumb = $settings['file_path'].'/'.$rs['file_store_path'].'/'.$rs['file_real_name'].'_thumb';
			}else{
				$file_thumb = $settings['file_path'].'/'.$rs['file_store_path'].'/'.$rs['file_real_name'].'_thumb.'.$rs['file_extension'];
			}
		}
	}
	return $file_thumb;
}
function short_date($str){
	return date($str);
}
function create_store_dir($y='',$m='',$d=''){
	global $settings;
	$store_dir = PHPDISK_ROOT.$settings['file_path'].'/'.date('Y/m/d/');
	make_dir($store_dir);
	return true;
}
function get_real_ext($file_extension){
	global $settings;
	$file_extension = trim($file_extension);
	if($file_extension){
		$exts = explode(',',$settings['filter_extension']);
		if(in_array($file_extension,$exts)){
			$file_ext = '.'.$file_extension.'.txt';
		}else{
			$file_ext = '.'.$file_extension;
		}
	}else{
		$file_ext = '.txt';
	}
	return $file_ext;
}
function get_file_name($file_name,$file_ext){
	$tmp_ext = $file_ext ? '.'.$file_ext: '';
	return $file_name.$tmp_ext;
}

function flashget_encode($t_url,$uid){
	$prefix = "Flashget://";
	$FlashgetURL = $prefix.base64_encode("[FLASHGET]".$t_url."[FLASHGET]")."&".$uid;
	return $FlashgetURL;
}

function thunder_encode($url){
	$thunderPrefix = "AA";
	$thunderPosix = "ZZ";
	$thunderTitle = "thunder://";
	$thunderUrl = $thunderTitle.base64_encode($thunderPrefix.$url.$thunderPosix);
	return $thunderUrl;
}
function file_icon($ext,$fd = 'filetype',$align='absmiddle'){
	$icon = PHPDISK_ROOT."images/{$fd}/".$ext.".gif";
	if(file_exists($icon)){
		$img = "<img src='images/{$fd}/{$ext}.gif' align='{$align}' border='0' />";
	}else{
		$img = "<img src='images/{$fd}/file.gif' align='{$align}' border='0' />";
	}
	return $img;
}
function mime_type( $ext ){
	$mime = array(
	'avi'  => 'video/x-msvideo',
	'bmp'  => 'image/bmp',
	'css'  => 'text/css',
	'js'   => 'application/x-javascript js',
	'doc'  => 'application/msword',
	'gif'  => 'image/gif',
	'htm'  => 'text/html',
	'html' => 'text/html',
	'jpg'  => 'image/jpeg',
	'jpeg' => 'image/jpeg',
	'mov'  => 'video/quicktime',
	'mpeg' => 'video/mpeg',
	'mp3'  => 'audio/mpeg mpga mp2 mp3',
	'pdf'  => 'application/pdf',
	'php'  => 'text/html',
	'png'  => 'image/png',
	'qt'   => 'video/quicktime',
	'rar'  => 'application/x-rar',
	'swf'  => 'application/x-shockwave-flash swf',
	'txt'  => 'text/plain',
	'wmv'  => 'video/x-ms-wmv',
	'xml'  => 'text/xml',
	'xsl'  => 'text/xml',
	'xls'  => 'application/msexcel x-excel',
	'zip'  => 'application/zip x-zip',
	'torrent' => 'application/x-bittorrent',

	);
	return isset($mime[$ext]) ? $mime[$ext] : 'application/octet-stream';
}

function get_my_nav($nav_arr=array()){
	global $db,$tpf,$pd_uid,$pd_gid,$group_settings;
	$rs = $db->fetch_one_array("select user_store_space from {$tpf}users where userid='$pd_uid'");
	if($rs['user_store_space'] ==0){
		$arr['max_storage'] = $group_settings[$pd_gid]['max_storage']==0 ? __('no_limit') : $group_settings[$pd_gid]['max_storage'];
	}else{
		$arr['max_storage'] = $rs['user_store_space'];
	}
	unset($rs);

	$file_size_total = $db->result_first("select sum(file_size) from {$tpf}files where userid='$pd_uid' and in_recycle=0 and is_del=0");
	$arr['now_space'] = get_size($file_size_total);
	$file_size_total = ($file_size_total > get_byte_value($arr['max_storage'])) ? get_byte_value($arr['max_storage']) : $file_size_total;
	$arr['disk_fill'] = $arr['max_storage'] ? @round($file_size_total/get_byte_value($arr['max_storage']),1)*120 : 0;
	$arr['disk_percent'] = $arr['max_storage'] ? @round($file_size_total/get_byte_value($arr['max_storage']),3)*100 : 0;
	$arr['disk_remain'] = 100-$arr['disk_percent'];
	$arr['disk_space'] = $arr['max_storage'] ? get_size(get_byte_value($arr['max_storage'])-$file_size_total) : __('no_limit');
	if(is_array($nav_arr)){
		$arr = array_merge($arr,$nav_arr);
	}
	return $arr;
}
function send_email($to,$subject,$body){
	global $settings;
	//Create a new PHPMailer instance
	$mail = new PHPMailer;
	//Tell PHPMailer to use SMTP
	$mail->isSMTP();
	//Enable SMTP debugging
	// 0 = off (for production use)
	// 1 = client messages
	// 2 = client and server messages
	$mail->SMTPDebug = 0;
	//Ask for HTML-friendly debug output
	$mail->Debugoutput = 'html';
	//Set the hostname of the mail server
	$mail->Host = trim($settings['email_smtp']);
	//Set the SMTP port number - likely to be 25, 465 or 587
	$mail->Port = (int)$settings['email_port'];
	if($settings['email_ssl']){
		$mail->SMTPSecure = $settings['email_ssl'];
	}
	//Whether to use SMTP authentication
	$mail->SMTPAuth = true;
	//Username to use for SMTP authentication
	$mail->Username = $settings['email_address'];
	//Password to use for SMTP authentication
	$mail->Password = $settings['email_pwd'];//
	//Set who the message is to be sent from
	$mail->setFrom($settings['email_address']);
	//Set an alternative reply-to address
	//$mail->addReplyTo($settings['email_address']);
	//Set who the message is to be sent to
	$mail->addAddress($to);
	//Set the subject line
	$mail->Subject = $subject;
	//Read an HTML message body from an external file, convert referenced images to embedded,
	//convert HTML into a basic plain-text alternative body
	$mail->msgHTML($body);
	//Replace the plain text body with one created manually
	//$mail->AltBody = $body;
	//Attach an image file
	//$mail->addAttachment('images/phpmailer_mini.png');

	//send the message, check for errors
	if (!$mail->send()) {
		return "Mailer Error: " . $mail->ErrorInfo;
	} else {
		return 'success';
	}
}

function get_sql($sql){
	global $db,$tpf;
	$q = $db->query($sql);
	$arr = array();
	while ($rs = $db->fetch_array($q)) {
		$arr[] = $rs;
	}
	$db->free($q);
	unset($rs);
	return $arr;
}

function urr($str,$vars){
	global $settings;
	if($settings['open_rewrite']){
		switch($str){
			case 'public':
				parse_str($vars);
				if($cate_id){
					return "public-{$cate_id}.html";
				}else{
					return "public.html";
				}
				break;
			case 'viewfile':
				parse_str($vars);
				return "file-{$file_id}.html";
				break;
			default:
				return $vars ? $str.'.php?'.$vars : $str.'.php';
		}

	}else{
		return $vars ? $str.'.php?'.$vars : $str.'.php';
	}
}
function get_pay_status($str){
	if($str =='success'){
		$rtn = '<span class="txtgreen">'.__('success').'</span>';
	}elseif($str =='fail'){
		$rtn = '<span class="txtred">'.__('fail').'</span>';
	}elseif($str =='pendding'){
		$rtn = '<span class="txtblue">'.__('pendding').'</span>';
	}else{
		$rtn = 'Unknown';
	}
	return $rtn;
}
function make_dir($path){
	if(!is_dir($path)){
		$str = dirname($path);
		if($str){
			make_dir($str.'/');
			@mkdir($path,0777);
			chmod($path,0777);
			write_file($path.'index.htm','PHPDisk');
		}
	}
}
function read_file($f) {
	if (file_exists($f)) {
		if (PHP_VERSION >= "4.3.0") return file_get_contents($f);
		$fp = fopen($f,"rb");
		$fsize = filesize($f);
		$c = fread($fp, $fsize);
		fclose($fp);
		return $c;
	} else{
		exit("<b>$f</b> does not exist!");
	}
}
function write_file($f,$str,$mode = 'wb') {
	$fp = fopen($f,$mode);
	if (!$fp) {
		exit("Can not open file <b>$f</b> .code:1");
	}
	if(is_writable($f)){
		if(!fwrite($fp,$str)){
			exit("Can not write file <b>$f</b> .code:2");
		}
	}else{
		exit("Can not write file <b>$f</b> .code:3");
	}
	fclose($fp);
}
function upload_file($source, $target) {
	if (function_exists('move_uploaded_file') && @move_uploaded_file($source, $target)) {
		@chmod($target, 0666);
		return $target;
	} elseif (@copy($source, $target)) {
		@chmod($target, 0666);
		return $target;
	} elseif (@is_readable($source)) {
		if ($fp = @fopen($source,'rb')) {
			@flock($fp,2);
			$filedata = @fread($fp,@filesize($source));
			@fclose($fp);
		}
		if ($fp = @fopen($target, 'wb')) {
			@flock($fp, 2);
			@fwrite($fp, $filedata);
			@fclose($fp);
			@chmod ($target, 0666);
			return $target;
		} else {
			return false;
		}
	}
}
function aheader($url){
	header("Location: ".$url);
	exit;
}

function ip_encode($ip){
	global $pd_gid;
	if($pd_gid==1){
		return $ip;
	}else{
		$arr = explode('.',$ip);
		for($i=0;$i<count($arr)-1;$i++){
			return $arr[0].'.'.$arr[1].'.*.*';
		}
	}
}
function get_profile($uid,$col='*'){
	global $db,$tpf,$pd_uid;
	$uid = $uid ? (int)$uid : $pd_uid;
	if($col=='*'){
		return $db->fetch_one_array("select * from {$tpf}users where userid='$uid' limit 1");
	}else{
		return @$db->result_first("select $col from {$tpf}users where userid='$uid' limit 1");
	}
}
function get_table_credit_log(){
	global $db,$tpf,$db_charset;
	$q = $db->query("show tables;");
	if($q){
		$tbl_list = array();
		while($rs = $db->fetch_array($q)){
			$tbl_list[] = $rs;
		}
		$db->free($q);
		unset($rs);
	}
	//print_r($tbl_list);
	for($i=0;$i<count($tbl_list)-1;$i++){
		foreach($tbl_list[$i] as $v){
			$arr[] = $v;
		}
	}
	$now_table = "{$tpf}credit_log".date('Ym');
	if(!in_array($now_table,$arr)){
		$sql = "CREATE TABLE IF NOT EXISTS `$now_table` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `credit` float unsigned NOT NULL DEFAULT '0',
  `action` varchar(20) NOT NULL,
  `in_time` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(15) NOT NULL,
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `touserid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `intime` (`in_time`),
  KEY `userid` (`userid`),
  KEY `touserid` (`touserid`),
  KEY `action` (`action`),
  KEY `file_id` (`file_id`)
) ENGINE=MyISAM  DEFAULT CHARSET={$db_charset};";

		$db->query_unbuffered($sql);
	}
	return $now_table;
}
function add_credit_log($file_id,$credit,$action,$userid,$touserid){
	global $db,$tpf,$timestamp,$onlineip,$settings;
	if($settings[open_file_logs]){
		switch ($action){
			case 'download':
				/*$id = @$db->result_first("select id from ".get_table_credit_log()." where file_id='$file_id' and userid='$userid' and action='$action' order by id desc limit  1");
				if($id){
				$db->query_unbuffered("update ".get_table_credit_log()." set credit=credit+$credit,in_time='$timestamp',ip='$onlineip' where id='$id'");
				}else{*/
				$ins = array(
				'file_id'=>$file_id,
				'credit'=>$credit,
				'action'=>$action,
				'in_time'=>$timestamp,
				'ip'=>$onlineip,
				'userid'=>$userid,
				'touserid'=>$touserid,
				);
				$db->query_unbuffered("insert into ".get_table_credit_log()." set ".$db->sql_array($ins)."");
				//}
				break;
			case 'view':
				/*$id = @$db->result_first("select id from ".get_table_credit_log()." where file_id='$file_id' and userid='$userid' and action='$action' order by id desc limit  1");
				if($id){
				$db->query_unbuffered("update ".get_table_credit_log()." set credit=credit+$credit,in_time='$timestamp',ip='$onlineip' where id='$id'");
				}else{*/
				$ins = array(
				'file_id'=>$file_id,
				'credit'=>$credit,
				'action'=>$action,
				'in_time'=>$timestamp,
				'ip'=>$onlineip,
				'userid'=>$userid,
				'touserid'=>$touserid,
				);
				$db->query_unbuffered("insert into ".get_table_credit_log()." set ".$db->sql_array($ins)."");
				//}
				break;
		}
	}
}
function get_folder_path($folder_id,$uid,$in_upload=0){
	global $db,$tpf;
	if($folder_id){
		$rs = $db->fetch_one_array("select folder_id,parent_id,folder_name from {$tpf}folders where folder_id='$folder_id' and userid='$uid'");
		$str = '';
		if($rs['parent_id']!=-1){
			$str .= get_folder_path($rs['parent_id'],$uid,$in_upload);
		}
		if($in_upload){
			$str .= $rs['folder_name'] ? '<img src="images/folder_open.gif" border="0" align="absmiddle" /><a href="javascript:;" onclick="top.document.location=\''.urr("mydisk","item=files&action=index&folder_id={$rs[folder_id]}").'\';">'.$rs['folder_name'].'</a>&nbsp;&raquo;&nbsp;' : '';
		}else{
			$str .= $rs['folder_name'] ? '<img src="images/folder_open.gif" border="0" align="absmiddle" /><a href="'.urr("mydisk","item=files&action=index&folder_id={$rs[folder_id]}").'">'.$rs['folder_name'].'</a>&nbsp;&raquo;&nbsp;' : '';
		}

		unset($rs);
	}
	return $str ? $str : '&nbsp;';
}
function get_group_power($gid,$key,$inner=0){
	global $group_settings;
	if($inner){
		$arr = unserialize($group_settings[$gid]['power_list']);
		return $arr[$key];
	}else{
		return $group_settings[$gid][$key];
	}
}
function create_down_url($file){
	global $db,$tpf,$settings;
	$pp = $file['file_store_path'].$file['file_real_name'].get_real_ext($file['file_extension']);
	$fs = get_byte_value($file['file_size']);
	$hash = strtoupper(md5($file['file_id'].'_'.$file['file_size'].'_'.$file['file_store_path'].$file['file_real_name']));
	$tmp_ext = $file['file_extension'] ? '.'.$file['file_extension'] : "";
	$p_filename = filter_name($file['file_name'].$tmp_ext);
	$host = $settings[phpdisk_url];
	if($file[server_oid]>1){
		$rs = $db->fetch_one_array("select server_host,server_key from {$tpf}servers where server_oid={$file[server_oid]}");
		if($rs){
			$host = $rs['server_host'];
		}
		unset($rs);
	}
	return $host.urr("dl",pd_encode("file_name=$p_filename&file_id={$file['file_id']}&fs=$fs&pp=$pp&hash=$hash"));
}
function filter_name($str){
	return str_ireplace(array(' ','&amp;','・'),'_',$str);
}
function list_table_users_credit($prefix=1){
	global $db,$tpf,$db_charset;
	$q = $db->query("show tables like '{$tpf}credit_log%';");
	if($q){
		$tbl_list = array();
		while($rs = $db->fetch_array($q)){
			$tbl_list[] = $rs;
		}
		$db->free($q);
		unset($rs);
	}
	//print_r($tbl_list);
	if($prefix){
		for($i=0;$i<count($tbl_list);$i++){
			foreach($tbl_list[$i] as $v){
				$arr[] = $v;
			}
		}
	}else{
		for($i=0;$i<count($tbl_list);$i++){
			foreach($tbl_list[$i] as $v){
				$arr[] = str_replace("{$tpf}credit_log",'',$v);
			}
		}
	}
	return array_reverse($arr);
}
function dir_writeable($dir) {
	if(!is_dir($dir)) {
		@mkdir($dir, 0777);
	}
	if(is_dir($dir)) {
		if($fp = @fopen("$dir/phpdisk.test", 'w')) {
			@fclose($fp);
			@unlink("$dir/phpdisk.test");
			$writeable = 1;
		} else {
			$writeable = 0;
		}
	}
	return $writeable;
}
function check_template($tpl_name){
	$dir = PHPDISK_ROOT."templates/{$tpl_name}/";
	if(file_exists($dir.'template_info.php') && $tpl_name !='.' && $tpl_name !='..'){
		$rtn = 1;
	}else{
		$rtn = 0;
	}
	return $rtn;
}
function get_lang_info($lang_name){
	global $db,$tpf;
	$file = PHPDISK_ROOT."languages/$lang_name/lang_info.php";
	if(file_exists($file)){
		$_data = read_file($file);
		preg_match("/Language Name:(.*)/i",$_data,$lang_title);
		preg_match("/Language URL:(.*)/i",$_data,$lang_url);
		preg_match("/Description:(.*)/i",$_data,$lang_desc);
		preg_match("/Author:(.*)/i",$_data,$lang_author);
		preg_match("/Author Site:(.*)/i",$_data,$lang_site);
		preg_match("/Version:(.*)/i",$_data,$lang_version);
		preg_match("/PHPDISK Core:(.*)/i",$_data,$phpdisk_core);
	}
	$actived = (int)@$db->result_first("select actived from {$tpf}langs where lang_name='$lang_name' limit 1");
	$arr = array(
	'lang_title' => trim($lang_title[1]),
	'lang_url' => trim($lang_url[1]),
	'lang_desc' => htmlspecialchars(trim($lang_desc[1])),
	'lang_author' => trim($lang_author[1]),
	'lang_site' => trim($lang_site[1]),
	'lang_version' => trim($lang_version[1]),
	'lang_dir' => trim($lang_name),
	'phpdisk_core' => trim($phpdisk_core[1]),
	'actived' => $actived,
	);
	return $arr;
}
function check_lang($lang_name){
	$dir = PHPDISK_ROOT."languages/{$lang_name}/";
	if(file_exists($dir.'./lang_info.php') && $lang_name !='.' && $lang_name !='..'){
		$rtn = 1;
	}else{
		$rtn = 0;
	}
	return $rtn;
}
function addziparray($dir2){
	global $dir,$zipfilearray;
	@$dirs=opendir($dir."/".$dir2);
	while (@$file=readdir($dirs)) {
		if(!is_dir("$dir/$dir2/$file")) {
			$zipfilearray[]="$dir2/$file";
		}
		elseif($file!="."&&$file!="..") {
			addziparray("$dir2/$file");
		}
	}
	@closedir($dirs);
}
function get_ids($str){
	$str2 = '';
	if($str){
		$arr = explode(',',$str);
		for($i=0;$i<count($arr);$i++){
			if(is_numeric($arr[$i])){
				$str2 .= (int)$arr[$i].',';
			}
		}
		return $str2 ? substr($str2,0,-1) : '';
	}else{
		return $str2;
	}
}
function get_cate_option($pid=0,$selID=0,$lv=0){
	global $db,$tpf;
	$q = $db->query("select * from {$tpf}categories order by show_order asc");
	while ($rs = $db->fetch_array($q)) {
		$data[] = $rs;
	}
	$db->free($q);
	unset($rs);
	if(count($data)){
		$html = '';
		foreach($data as $v){
			if($v['pid'] == $pid){
				$html .= '<option value="'.$v[cate_id].'"';
				$html .= $selID ? ifselected($selID,$v[cate_id]) : '';
				$html .= '>'.str_repeat('&nbsp;',$lv*4).$v[cate_name].'</option>'.LF;
				$lv++;
				$html .= get_cate_option($v['cate_id'],$selID,$lv);
				$lv--;
			}
		}
		return $html;
	}else{
		return '';
	}
}
function get_depart_option($pid=0,$selID=0,$lv=0){
	global $db,$tpf;
	$q = $db->query("select * from {$tpf}departs where pid=0 order by show_order asc");
	while ($rs = $db->fetch_array($q)) {
		$data[] = $rs;
	}
	$db->free($q);
	unset($rs);
	if(count($data)){
		$html = '';
		foreach($data as $v){
			if($v['pid'] == $pid){
				$html .= '<option value="'.$v[depart_id].'"';
				$html .= $selID ? ifselected($selID,$v[depart_id]) : '';
				$html .= '>'.str_repeat('&nbsp;',$lv*4).$v[depart_name].'</option>'.LF;
				$lv++;
				$html .= get_depart_option($v['depart_id'],$selID,$lv);
				$lv--;
			}
		}
		return $html;
	}else{
		return '';
	}
}
function get_folder_option($pid=-1,$selID=0,$lv=0,$folder_id=0){
	global $db,$tpf,$pd_uid;
	$q = $db->query("select * from {$tpf}folders where userid='$pd_uid' and folder_id<>'$folder_id' and in_recycle=0 order by folder_order asc,folder_id asc");
	while ($rs = $db->fetch_array($q)) {
		$data[] = $rs;
	}
	$db->free($q);
	unset($rs);
	if(count($data)){
		$html = '';
		foreach($data as $v){
			if($v['parent_id'] == $pid){
				$html .= '<option value="'.$v[folder_id].'"';
				$html .= $selID ? ifselected($selID,$v[folder_id]) : '';
				$html .= '>'.str_repeat('&nbsp;',$lv*2).$v[folder_name].'</option>'.LF;
				$lv++;
				$html .= get_folder_option($v['folder_id'],$selID,$lv,$folder_id);
				$lv--;
			}
		}
		return $html;
	}else{
		return '';
	}
}

function get_server_oid(){
	global $db,$tpf,$settings;
	if($settings[open_multi_server]){
		return (int)@$db->result_first("select server_oid from {$tpf}servers where server_id>1 order by is_default desc limit 1");
	}else{
		return 0;
	}
}

function get_h5_max_filesize($uid){
	global $settings,$group_settings;
	$uinfo = get_profile($uid);
	$gid = $uinfo['gid'];
	$group_set = $group_settings[$gid];
	$max_size = $group_set[h5_max_filesize] ? get_byte_value($group_set[h5_max_filesize]) : ($settings[h5_max_filesize] ? get_byte_value($settings[h5_max_filesize]) : 4294967296);
	return $max_size;
}

function arr2str($arr,$one=0){
	if(is_array($arr)){
		if($one){
			$rtn = '<li>'.$arr[0].'</li>';
		}else{
			for ($i=0;$i<count($arr);$i++){
				$rtn .= '<li>'.$arr[$i].'</li>';
			}
		}
	}else{
		$rtn = $arr;
	}
	return $rtn;
}
function clear_html($str,$len=50){
	return str_replace("\r\n",' ',cutstr(preg_replace("/<.+?>/i","",$str),$len));
}
function phpdisk_md5($str){
	return md5(md5($str).'1Phpdisk$_Salt9');
}
function phpdisk_encrypt($data, $expire = 0) {
	global $settings;
	$key  = $settings[phpdisk_urr_key] ? md5($settings[phpdisk_urr_key]) : md5('imphpdisk2099Ax');
	$data = base64_encode($data);
	$x    = 0;
	$len  = strlen($data);
	$l    = strlen($key);
	$char = '';
	for ($i = 0; $i < $len; $i++) {
		if ($x == $l) $x = 0;
		$char .= substr($key, $x, 1);
		$x++;
	}
	$str = sprintf('%010d', $expire ? $expire + time():0);
	for ($i = 0; $i < $len; $i++) {
		$str .= chr(ord(substr($data, $i, 1)) + (ord(substr($char, $i, 1)))%256);
	}
	return str_replace(array('+','/','='),array('-','_',''),base64_encode($str));
}

function phpdisk_decrypt($data){
	global $settings;
	$key  = $settings[phpdisk_urr_key] ? md5($settings[phpdisk_urr_key]) : md5('imphpdisk2099Ax');
	$data   = str_replace(array('-','_'),array('+','/'),$data);
	$mod4   = strlen($data) % 4;
	if ($mod4) {
		$data .= substr('====', $mod4);
	}
	$data   = base64_decode($data);
	$expire = substr($data,0,10);
	$data   = substr($data,10);
	if($expire > 0 && $expire < time()) {
		return '';
	}
	$x      = 0;
	$len    = strlen($data);
	$l      = strlen($key);
	$char   = $str = '';
	for ($i = 0; $i < $len; $i++) {
		if ($x == $l) $x = 0;
		$char .= substr($key, $x, 1);
		$x++;
	}
	for ($i = 0; $i < $len; $i++) {
		if (ord(substr($data, $i, 1))<ord(substr($char, $i, 1))) {
			$str .= chr((ord(substr($data, $i, 1)) + 256) - ord(substr($char, $i, 1)));
		}else{
			$str .= chr(ord(substr($data, $i, 1)) - ord(substr($char, $i, 1)));
		}
	}
	return base64_decode($str);
}
function chk_extension_ok_h5($ext){
	global $settings;
	$can_upload = false;
	$ext = strtolower($ext);
	if(strtolower($settings[h5_upload_ext])){
		$arr = explode(',',$settings[h5_upload_ext]);
		if(in_array($ext,$arr)){
			$can_upload = true;
		}
	}else{
		$can_upload = true;
	}
	return $can_upload;
}
function get_file_host($server_oid) {
	global $db,$tpf,$settings;
	$rs = @$db->fetch_one_array("select server_host,server_dl_host,server_store_path from {$tpf}servers where server_oid='$server_oid' limit 1");	
	if($rs && $server_oid>1){
		if($rs[server_dl_host]){
			$arr = explode(LF,$rs[server_dl_host]);
			return $arr[0].$rs[server_store_path].'/';
		}else{
			return $rs[server_host].$rs[server_store_path].'/';
		}
		unset($rs);
	}else{
		return $settings[phpdisk_url].$settings[file_path].'/';
	}
}
function can_preview($ext) {
	global $db,$tpf,$settings,$auth;
	$preview_ext = $auth[pd_3] ? $settings[preview_ext] : 'doc,docx,xls,xlsx,ppt,pptx';
	if($preview_ext && in_array($ext,explode(',', $preview_ext))){
		return true;		
	}else{
		return false;
	}
}
?>