<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: extract.php 139 2024-10-19 09:23:13Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

$in_front = true;

$title = __('extract_file').' - '.$settings['site_title'];
include PHPDISK_ROOT."./includes/header.inc.php";

switch($action){
	case 'file_extract':
		form_auth(gpc('formhash','P',''),formhash());

		$extract_code = trim(gpc('extract_code','P',''));

		if($extract_code){
			$rs = $db->fetch_one_array("select f.*,u.username from {$tpf}files f,{$tpf}users u where file_key='$extract_code' and u.userid=f.userid and is_del=0 and in_recycle=0");
			if($rs){
				if(!$rs[use_code]){
					$sysmsg[] = '提取码未启用或已关闭';
				}else{
					$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
					$rs['file_thumb'] = get_file_thumb($rs);
					$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
					$rs['file_name'] = cutstr($rs['file_name'].$tmp_ext,50);
					$rs['file_size'] = get_size($rs['file_size']);
					$rs['file_time'] = date("Y-m-d H:i",$rs['file_time']);
					$rs['a_viewfile'] = 'viewfile.php?file_id='.$rs['file_id'].'&code='.$rs['file_key'];
					$files_array[] = $rs;
				}
			}else{
				$sysmsg[] = __('extract_code_not_found');
			}
			unset($rs);
		}else{
			$sysmsg[] = __('extract_code_not_found');
		}

		require_once template_echo('pd_extract',$user_tpl_dir);

		break;

	default:
		require_once template_echo('pd_extract',$user_tpl_dir);
}
include PHPDISK_ROOT."./includes/footer.inc.php";

?>