<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: ajax.php 143 2024-10-19 14:15:17Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

include "includes/commons.inc.php";

switch($action){
	case 'get_name':
		$s_name = trim(gpc('s_name','GP',''));
		$q = $db->query("select userid,username from {$tpf}users where username like '{$s_name}%'");
		$str = '';
		while($rs = $db->fetch_array($q)){
			$str .= '<option value="'.$rs[userid].'">'.$rs[username].'</option>';
		}
		$db->free($q);
		unset($rs);
		echo $str ? 'true|'.$str : '找不到用户';
		break;
	case 'add_disk':
		$folder_id = (int)gpc('folder_id','GP',0);
		$pg = (int)gpc('pg','GP',0);

		$str = '<div class="add_box">';
		$str .= '<div class="l">';
		$str .= '<div id="sfd_0"><img src="images/ico_home.gif" align="absmiddle" border="0" /><a href="javascript:;" onclick="add_disk(0,0)">根目录</a></div>'.get_folder_list2(-1,0,$folder_id).'</div>';
		$str .= '<div class="r">';

		$pg = $pg ? $pg : 1;
		$perpage = 10;
		$sql_do = " {$tpf}files where userid='$pd_uid' and folder_id='$folder_id' and is_del=0";
		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;
		$q = $db->query("select file_id,file_name,file_extension,file_size,file_time from $sql_do order by file_id desc limit $start_num,$perpage");
		$files = array();
		while ($rs = $db->fetch_array($q)) {
			$files[] = $rs;
		}
		$db->free($q);
		unset($rs);
		if(count($files)){
			foreach($files as $k => $v){
				$tmp_ext = $v[file_extension] ? '.'.$v[file_extension] : '';
				$str .= '<li>';
				$str .= '<a href="javascript:;" onclick="javascript:add_file_addr(\''.str_replace("'","\'",file_icon($v[file_extension]).$v[file_name].$tmp_ext).'\',\''.$v[file_id].'\')" title="'.$v[file_name].$tmp_ext.'"><span style="float:right;" title="添加">[+]</span>'.file_icon($v[file_extension]).' '.$v[file_name].$tmp_ext.'</a>';
				$display = $k!=0 ? 'display:none;' : '';
				$str .= '<div style="'.$display.' clear:both;">大小：'.get_size($v[file_size]).'&nbsp;&nbsp;时间：'.date('Y-m-d',$v[file_time]).'</div></li>';
			}
		}else{
			$str .= '<li align="center">暂无文件记录</li>';
		}
		$str .= '</div><div class="clear"></div>';
		$str .= '<div align="right">'.multi_ajax($action,$folder_id,$total_num, $perpage, $pg).'</div>';
		$str .= '</div>';
		$str .= '<script>';
		$str .= '$(document).ready(function(){';
		$str .= '$(".add_box .r li").each(function(){';
		$str .= '	var li_obj = $(this).find("div");';
		$str .= '	$(this).mouseover(function(){';
		$str .= '		li_obj.css("display","");';
		$str .= '		li_obj.addClass("alt_bg txtgreen");';
		$str .= '	}).mouseout(function(){';
		$str .= '		li_obj.css("display","none");';
		$str .= '		li_obj.removeClass("alt_bg txtgreen");';
		$str .= '	});';
		$str .= '});';
		$str .= 	'$(".add_box .r li").mouseover(function(){';
		$str .= 	'$(this).addClass("alt_bg bd1");';
		$str .= '}).mouseout(function(){';
		$str .= 	'$(this).removeClass("alt_bg bd1");';
		$str .= '});';
		$str .= '});';
		$str .= '</script>';

		echo $str;
		break;
	case 'show_msg_file':
		$msgid = (int)gpc('msgid','P',0);
		if($msgid){
			$q = @$db->query("select * from {$tpf}files where file_id in (select file_id from {$tpf}msg_file where msgid='$msgid')");
			$file = array();
			while ($rs = $db->fetch_array($q)) {
				$file[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$str = '';
			if(count($file)){
				foreach($file as $v){
					$a_down = create_down_url($v);
					$tmp_ext = $v[file_extension] ? '.'.$v[file_extension] : '';
					$file_name = $v[file_name].$tmp_ext;
					$str .= '<li><a href="'.$a_down.'">'.file_icon($v[file_extension]).$file_name.'</a></li>';
				}
			}
			$str = $str ? $str : '没有';
			echo 'true|'.$str;
		}
		break;
	case 'digg':
		$file_id = (int)gpc('file_id','G',0);
		$dig_type = (int)gpc('dig_type','G',0);
		$digg_cookie = gpc("phpdisk_digg_{$file_id}",'C','');
		if(!$digg_cookie){
			$rs = $db->fetch_one_array("select good_count,bad_count,userid from {$tpf}files where file_id='$file_id' limit 1");
			if($rs){
				$good_count = (int)$rs['good_count']+1;
				$bad_count = (int)$rs['bad_count']+1;
				$userid = (int)$rs['userid'];
			}
			unset($rs);
			if($dig_type ==1){
				$db->query_unbuffered("update {$tpf}files set good_count=good_count+1 where file_id='$file_id'");
			}elseif($dig_type ==2){
				$db->query_unbuffered("update {$tpf}files set bad_count=bad_count+1 where file_id='$file_id'");
			}
			pd_setcookie("phpdisk_digg_{$file_id}", $file_id, $timestamp+3600);
			echo "var re=new Array();re[0]=".$file_id.";re[1]=".$dig_type.";re[2]=\"success\";re[3]=\"".__('vote_success')."\";";
		}else{
			echo "var re=new Array();re[0]=".$file_id.";re[1]=".$dig_type.";re[2]=\"fail\";re[3]=\"".__('cannot_same_vote')."\";";
		}
		break;
	case 'down_process':
		//$down_log = gpc('down_ip','C','');
		$file_id = (int)gpc('file_id','P',0);
		if($file_id){
			//pd_setcookie('down_ip',1,10);
			$userid = @$db->result_first("select userid from {$tpf}files where file_id='$file_id'");
			add_credit_log($file_id,1,'download',$userid,$pd_uid);
			$db->query_unbuffered("update {$tpf}files set file_downs=file_downs+1,file_last_view='$timestamp' where file_id='$file_id'");
		}
		echo 'true';
		break;
	case 'view_user':
		$uid = (int)gpc('uid','P','');
		$adm = (int)gpc('adm','P','');
		if($uid){
			$username = @$db->result_first("select username from {$tpf}users where userid='$uid'");
			if($adm){
				echo 'true|<a href="'.urr(ADMINCP,'item=users&menu=user&action=user_edit&uid='.$uid).'">'.$username.'</a>';
			}else{
				echo 'true|'.$username;
			}
		}else{
			echo 'Error id';
		}
		break;
	case 'view_share_my':
		$fid = (int)gpc('fid','P',0);
		if($fid){
			if($task=='folder'){
				$q = $db->query("select s.*,username from {$tpf}shares s,{$tpf}users u where share_fid='$fid' and s.userid='$pd_uid' and s.touserid=u.userid and is_file=0");
			}else{
				$q = $db->query("select s.*,username from {$tpf}shares s,{$tpf}users u where share_fid='$fid' and s.userid='$pd_uid' and s.touserid=u.userid and is_file=1");
			}
			$str = '<span class="txtgray">共享给：</span>';
			while ($rs = $db->fetch_array($q)) {
				$str .=	$rs[username].' , ';
			}
			$db->free($q);
			unset($rs);
			echo 'true|'.$str;
		}else{
			echo 'No data';
		}
		break;
	case 'view_share_user':
		$fid = (int)gpc('fid','P',0);
		if($fid){
			if($task=='folder'){
				$q = $db->query("select s.*,username from {$tpf}shares s,{$tpf}users u where share_fid='$fid' and s.touserid='$pd_uid' and s.userid=u.userid and is_file=0");
			}else{
				$q = $db->query("select s.*,username from {$tpf}shares s,{$tpf}users u where share_fid='$fid' and s.touserid='$pd_uid' and s.userid=u.userid and is_file=1");
			}
			$str = '<span class="txtgray">共享自：</span>';
			while ($rs = $db->fetch_array($q)) {
				$str .=	$rs[username].' , ';
			}
			$db->free($q);
			unset($rs);
			echo 'true|'.$str;
		}else{
			echo 'No data';
		}
		break;
	case 'add_cate':
		$sign = trim(gpc('sign','P',''));
		$cate_name = trim(gpc('cate_name','P',''));
		$uid = (int)gpc('uid','P','');
		$uid = $uid ? (int)$uid : $pd_uid;

		if($sign<>md5($uid.$settings[encrypt_key].date('Ymd'))){
			exit('Error Sign!');
		}
		if(checklength($cate_name,1,150)){
			$error = true;
			$rtn = __('add_folder_error');
		}
		$num = @$db->result_first("select count(*) from {$tpf}folders where userid='$uid' and folder_name='$cate_name'");
		if($num){
			$error = true;
			$rtn = __('folder_exists');
		}
		if(!$error){
			$ins = array(
			'parent_id' => -1,
			'folder_name' => $cate_name,
			'userid' => $uid,
			'in_time'=>$timestamp,
			);
			$db->query_unbuffered("insert into {$tpf}folders set ".$db->sql_array($ins)."");
			$id = $db->insert_id();
			echo 'true|'.$id;
		}else{
			echo $rtn;
		}
		break;
	case 'load_cate':
		$uid = (int)gpc('uid','P','');
		$uid = $uid ? (int)$uid : $pd_uid;
		$sign = trim(gpc('sign','P',''));
		$sel_id = (int)gpc('sel_id','P','');

		if($sign<>md5($uid.$settings[encrypt_key].date('Ymd'))){
			exit('Error Sign!');
		}
		$str = '<select id="up_folder_id" name="up_folder_id" onchange="set_folder_id()">'.LF;
		$str .= '<option value="0">'.__('root_folder').'</option>'.LF;
		$str .= get_folder_option(-1,$sel_id);
		$str .= '</select>';

		echo $str;
		break;
	case 'ajax_file':
		$folder_id = (int)gpc('folder_id','P',0);
		$folder_id = $folder_id==0 ? -1 : $folder_id;

		$perpage = 30;
		$pg=1;
		$sql_do = " {$tpf}files where folder_id='$folder_id' and userid='$pd_uid' and in_recycle=0 and is_del=0";
		$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
		$total_num = $rs['total_num'];
		$start_num = ($pg-1) * $perpage;

		$q = $db->query("select * from $sql_do order by file_id desc limit 30");
		$files_array = array();
		while($rs = $db->fetch_array($q)){
			$rs['a_downfile'] = create_down_url($rs);
			$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
			$rs['file_thumb'] = get_file_thumb($rs);

			$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
			$rs['file_name'] = cutstr($rs['file_name'].$tmp_ext,35);
			$rs['folder_icon'] = $rs['in_share'] ? 'share_folder' : 'folder';
			$rs['file_size'] = get_size($rs['file_size']);
			$rs['file_description'] = cutstr($rs['file_description'],80);
			$rs['file_time'] = date("Y-m-d",$rs['file_time']);
			$rs['a_viewfile'] = urr("mydisk","item=files&action=download&file_id={$rs['file_id']}");
			$rs['a_out_share'] = urr("mydisk","item=files&action=out_share&file_id={$rs['file_id']}");
			$rs['a_file_modify'] = urr("mydisk","item=files&action=file_modify&file_id={$rs['file_id']}");
			$rs['a_file_delete'] = urr("mydisk","item=files&action=file_delete&file_id={$rs['file_id']}");
			$rs['a_file_unshare'] = urr("mydisk","item=share&action=unshare_file&sel_type=all&file_id={$rs['file_id']}");
			$files_array[] = $rs;
		}
		$db->free($q);
		unset($rs);

		$str = '';
		if(count($files_array)){
			foreach($files_array as $k => $v){
				$color = ($k%2 ==0) ? 'color1' :'color4';

				$str .= '<tr class="'.$color.' tr_list">';
				$str .= '	<td><input type="checkbox" name="file_ids[]" id="file_ids" value="'.$v['file_id'].'" />&nbsp;<a href="'.$v['a_downfile'].'" title="'.__('download').'" target="_blank">'.file_icon($v['file_extension']).'</a>';
				if($v['is_image']){
					$str .= '		<a href="javascript:;" onclick="abox(\''.$v['a_viewfile'].'\',\'下载文件\',650,450);" id="p_'.$k.'">'.$v['file_name'].'</a>';
					$str .= '		<div id="c_'.$k.'" class="menu_thumb"><img src="'.$v['file_thumb'].'" /></div>';
					$str .= '<script type="text/javascript">on_menu(\'p_'.$k.'\',\'c_'.$k.'\',\'x\',\'\',\'\');</script>';
				}else{
					$str .= '		<a href="javascript:;" onclick="abox(\''.$v['a_viewfile'].'\',\'下载文件\',650,450);">'.$v['file_name'].'</a>';
				}
				$str .= '<span class="txtgray" title="文件ID">('.$v['file_id'].')</span>';
				$str .= '	<div class="ext_box" style="display:none;">';
				$str .= '	<span class="txtgray" title="描述">'.$v['file_description'].'</span></div>';
				$str .= '	</td>';
				$str .= '	<td align="center">'.$v['file_size'].'</td>';
				$str .= '	<td align="center"  class="txtgray">'.$v['file_time'].'</td>';
				$str .= '	<td align="right">';
				if($v['in_share']){
					$str .= '	<a href="javascript:;" onclick="abox(\''.$v['a_file_unshare'].'\',\''.__('file_unshare').'\',400,200);" title="'.__('file_unshare').'"><img src="images/cs_file.gif" border="0" align="absmiddle" /></a>';
				}
				if(get_group_power($pd_gid,'can_share_link',1)){
					$str .= '	<a href="javascript:;" onclick="abox(\''.$v['a_out_share'].'\',\'外部共享\',550,400);" title="外部共享"><img src="images/ico_link.gif" border="0" align="absmiddle" alt="外部共享" /></a>';
				}
				if($v['use_code']){
					$str .= '	<img src="images/ico_code.gif" data-clipboard-text="'.$v[file_key].'" style="cursor:pointer" class="cp_btn_c" border="0" align="absmiddle" alt="文件提取码" />';
				}
				$str .= '	<a href="javascript:;" onclick="abox(\''.$v['a_file_modify'].'\',\''.__('file_modify').'\',450,300);" title="'.__('modify').'"><img src="images/edit_icon.gif" border="0" align="absmiddle" /></a>';
				$str .= '	<a href="javascript:;" onclick="abox(\''.$v['a_file_delete'].'\',\''.__('file_delete').'\',400,200);" title="'.__('delete').'"><img src="images/recycle_icon.gif" border="0" align="absmiddle" /></a>';
				$str .= '	</td>';
				$str .= '</tr>';
			}
			$page_nav = multi($total_num, $perpage, $pg, urr("mydisk","item=files&menu=file&action=index&folder_id=$folder_id"));
			if($page_nav){
				$str .= '<tr>';
				$str .= '	<td colspan="6" style="padding:5px 0;">'.$page_nav.'</td>';
				$str .= '</tr>';
			}
			/*if(count($files_array)){
			$str .= '<tr>';
			$str .= '	<td colspan="6" style="padding:5px 0;"><input type="button" class="btn_gray" id="cb_select_all" value="'.__('select_all').'"/>&nbsp;';
			$str .= '	<input type="button" class="btn_gray" id="cb_select_cancel" value="'.__('select_cancel').'" />&nbsp;';
			$str .= '	<input type="button" class="btn_green" id="to_folder" value="'.__('my_folder').'" />&nbsp;';
			$str .= '	<input type="button" class="btn_green" id="is_link_code" value="'.__('is_link_code').'" />&nbsp;';
			$str .= '	<input type="button" class="btn_green" id="p_sfb" value="共享文件" />&nbsp;';
			$str .= '	<div id="c_sfb" class="menu_pop2" style="width:80px;">';
			$str .= '	<a id="to_share_corp" href="javascript:;">共享给公司</a>';
			$str .= '	<a id="to_share_depart" href="javascript:;">共享给部门</a>';
			$str .= '	<a id="to_share_buddy" href="javascript:;">共享给好友</a>';
			$str .= '	</div>';
			$str .= '	<script type="text/javascript">on_menu(\'p_sfb\',\'c_sfb\',\'-y\',\'\',\'\');</script>';
			$str .= '	<input type="button" class="btn_green" id="to_recycle" value="'.__('move_to_recycle').'" />&nbsp;';
			$str .= '	</td>';
			$str .= '</tr>';
			}
			*/
		}
		echo $str;
		break;
	case 'add_folder':
		$folder_name = trim(gpc('folder_name','P',''));
		if(checklength($folder_name,1,150)){
			$error = true;
			$rtn = '目录名字非法';
		}
		$num = @$db->result_first("select count(*) from {$tpf}folders where userid='$pd_uid' and folder_name='$folder_name'");
		if($num){
			$error = true;
			$rtn = '目录已存在';
		}
		if(!$error){
			$ins = array(
			'folder_name' => $folder_name,
			'userid' => $pd_uid,
			'in_time'=>$timestamp,
			);
			$db->query_unbuffered("insert into {$tpf}folders set ".$db->sql_array($ins)."");
			$id = $db->insert_id();
			echo 'true|'.$id;
		}else{
			echo $rtn;
		}
		break;
	case 'load_folders':
		$uid = (int)gpc('uid','P','');
		$sel_id = (int)gpc('sel_id','P','');
		$str = '<select id="folder_id" name="folder_id" onchange="set_folder_id()" class="form-control">'.LF;
		$str .= '<option value="0">'.__('pls_select_folder').'</option>'.LF;
		$str .= get_folder_option(-1,$sel_id);
		$str .= '</select>';

		echo $str;
		break;
		
	case 'chk_username':
		$r_username = trim(gpc('r_username','P',''));
		if(checklength($r_username,2,60)){
			echo __('username_length_error');
		}elseif(is_bad_chars($r_username)){
			echo __('username_has_bad_chars');
		}else{
			$num = @$db->result_first("select count(*) from {$tpf}users where username='$r_username'");
			if($num){
				echo __('username_already_exists');
			}else{
				echo 'true|'.__('username_can_reg');
			}
		}
		exit;
		break;
		
	case 'chk_email':
		$r_email = trim(gpc('r_email','P',''));

		if(!checkemail($r_email)){
			echo __('invalid_email');
		}else{
			$num = @$db->result_first("select count(*) from {$tpf}users where email='$r_email'");
			if($num){
				echo __('email_already_exists');
			}else{
				echo 'true|'.__('email_can_reg');
			}
		}
		exit;
		break;	
	case 'chg_theme':
		$theme = trim(gpc('theme','P',''));
		//echo json_encode($theme);
		pd_setcookie('mydisk_style',rawurldecode($theme),7*86400);
		break;

}

//include PHPDISK_ROOT."./includes/footer.inc.php";

function multi_ajax($action,$id,$total, $perpage, $curpage ) {
	$multipage = '';
	//$mpurl .= strpos($mpurl, '?') ? '&amp;' : '?';
	if($total > $perpage) {
		$pg = 10;
		$offset = 5;
		$pgs = @ceil($total / $perpage);
		if($pg > $pgs) {
			$from = 1;
			$to = $pgs;
		} else {
			$from = $curpage - $offset;
			$to = $curpage + $pg - $offset - 1;
			if($from < 1) {
				$to = $curpage + 1 - $from;
				$from = 1;
				if(($to - $from) < $pg && ($to - $from) < $pgs) {
					$to = $pg;
				}
			} elseif($to > $pgs) {
				$from = $curpage - $pgs + $to;
				$to = $pgs;
				if(($to - $from) < $pg && ($to - $from) < $pgs) {
					$from = $pgs - $pg + 1;
				}
			}
		}

		$multipage = ($curpage - $offset > 1 && $pgs > $pg ? '<a href="javascript:;" onclick="'.$action.'('.$id.',1);" class="p_redirect">&laquo;</a>' : '').($curpage > 1 ? '<a href="javascript:;" onclick="'.$action.'('.$id.','.($curpage - 1).');" class="p_redirect">&#8249;</a>' : '');
		for($i = $from; $i <= $to; $i++) {
			$multipage .= $i == $curpage ? '<span class="p_curpage">'.$i.'</span>' : '<a href="javascript:;" onclick="'.$action.'('.$id.','.$i.');" class="p_num">'.$i.'</a>';
		}
		$multipage .= ($curpage < $pgs ? '<a href="javascript:;" onclick="'.$action.'('.$id.','.($curpage + 1).');" class="p_redirect">&#8250;</a>' : '').($to < $pgs ? '<a href="javascript:;" onclick="'.$action.'('.$id.','.$pgs.');" class="p_redirect">&raquo;</a>' : '');
		$multipage = $multipage ? '<div class="p_bar"><span class="p_info">Total:&nbsp;<b>'.$total.'</b>&nbsp;</span>'.$multipage.'</div>' : '';
	}
	return $multipage;
}
?>