<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: files.inc.php 139 2024-10-19 09:23:13Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}

switch($action){
	case 'total_del':
		$file_id = (int)gpc('file_id','G',0);
		$safe = $task=='safe' ? 1 : 0;

		if($file_id){
			$num = @$db->result_first("select count(*) from {$tpf}files where file_id='$file_id'");
			if($num){
				$msg = '';
				$rs = $db->fetch_one_array("select * from {$tpf}files where file_id='$file_id'");
				if($rs){
					$tmp_ext = $rs[file_extension] ? '.'.$rs[file_extension] : '';
					$file_real_name = $rs[file_real_name];//convert_str('utf-8','gbk',$rs[file_real_name]);
					$pp = $settings[file_path].'/'.$rs[file_store_path].'/'.$file_real_name.$tmp_ext;
					$file_name = $rs[file_name].$tmp_ext;
					if($rs[server_oid]>1){
						$rs2 = $db->fetch_one_array("select * from {$tpf}servers where server_oid='{$rs[server_oid]}' limit 1");
						if($rs2){
							$msg = '';
							$up_del_url = $rs2[server_host].'phpdisk_del_process.php?'.pd_encode("pp=$pp&file_id={$rs[file_id]}&file_name={$file_name}&safe=$safe&server=up");
							$msg = '<script type="text/javascript" src="'.$up_del_url.'"></script>'.LF;
						}else{
							exit('Error param!');
						}
					}else{
						$up_del_url = $settings['phpdisk_url'].'phpdisk_del_process.php?'.pd_encode("pp=$pp&file_id={$rs[file_id]}&file_name={$file_name}&safe=$safe&server=up");
						$msg = '<script type="text/javascript" src="'.$up_del_url.'"></script>'.LF;
					}
				}
				unset($rs);
			}
		}else{
			$num = @$db->result_first("select count(*) from {$tpf}files where is_del=1");
			if($num){
				$msg = '';
				$q = $db->query("select * from {$tpf}files where is_del=1 limit 2");
				while ($rs = $db->fetch_array($q)) {
					$tmp_ext = $rs[file_extension] ? '.'.$rs[file_extension] : '';
					$file_real_name = $rs[file_real_name];//convert_str('utf-8','gbk',$rs[file_real_name]);
					$pp = $settings[file_path].'/'.$rs[file_store_path].'/'.$file_real_name.$tmp_ext;
					$file_name = $rs[file_name].$tmp_ext;
					if($rs[server_oid]>1){
						$rs2 = $db->fetch_one_array("select * from {$tpf}servers where server_oid='{$rs[server_oid]}' limit 1");
						if($rs2){
							$msg = '';
							$up_del_url = $rs2[server_host].'phpdisk_del_process.php?'.pd_encode("pp=$pp&file_id={$rs[file_id]}&file_name={$file_name}&safe=$safe&server=up");
							$msg .= '<script type="text/javascript" src="'.$up_del_url.'"></script>'.LF;
						}else{
							exit('Error param!');
						}
					}else{
						$up_del_url = $settings['phpdisk_url'].'phpdisk_del_process.php?'.pd_encode("pp=$pp&file_id={$rs[file_id]}&file_name={$file_name}&safe=$safe&server=up");
						$msg = '<script type="text/javascript" src="'.$up_del_url.'"></script>'.LF;
					}
				}
				$db->free($q);
				unset($rs);

				echo '<script type="text/javascript">'.LF;
				echo 'setTimeout(function(){'.LF;
				echo 'document.location.reload();'.LF;
				echo '},1500);'.LF;
				echo '</script>'.LF;
			}else{
				$msg = __('safe_del_file_success');
			}
		}
		require_once template_echo($item,$admin_tpl_dir,'',1);
		break;
	case 'index':

		$view = trim(gpc('view','GP',''));
		$uid = (int)gpc('uid','GP',0);

		if(in_array($task,array('check_public','file_to_locked','file_to_unlocked','delete_file_complete','restore_del_file','move_all','move_depart'))){
			form_auth(gpc('formhash','P',''),formhash());
			$file_ids = gpc('file_ids','P',array(''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			$ids_arr = get_ids_arr($file_ids,__('please_select_check_files'));
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if($task =='move_all'){
				$tousername = trim(gpc('tousername','P',''));
				if($tousername){
					$userid = @$db->result_first("select userid from {$tpf}users where username='$tousername'");
					if(!$userid){
						$error = true;
						$sysmsg[] = '目标用户名不存在，先返回修改';
					}
				}else{
					$error = true;
					$sysmsg[] = '目标用户名不存在，先返回修改';
				}
			}elseif($task =='move_depart'){
				$tousername2 = trim(gpc('tousername2','P',''));
				if($tousername2){
					$userid = @$db->result_first("select userid from {$tpf}users where username='$tousername2'");
					if(!$userid){
						$error = true;
						$sysmsg[] = '目标用户名不存在，先返回修改';
					}
				}else{
					$error = true;
					$sysmsg[] = '目标用户名不存在，先返回修改';
				}
			}
			if(!$error){
				if($task =='check_public'){
					$db->query_unbuffered("update {$tpf}files set is_checked=1 where file_id in ($file_str)");
					$sysmsg[] = __('check_public_success');
					adm_redirect(urr(ADMINCP,"item=files&menu=$menu&action=index&view=checked_file"),$sysmsg);
				}elseif($task =='file_to_locked'){
					$db->query_unbuffered("update {$tpf}files set is_locked=1 where file_id in ($file_str)");
					$sysmsg[] = __('file_to_locked_success');
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}elseif($task == 'file_to_unlocked'){
					$db->query_unbuffered("update {$tpf}files set is_locked=0 where file_id in ($file_str)");
					$sysmsg[] = __('file_to_unlocked_success');
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}elseif($task =='delete_file_complete'){
					$db->query_unbuffered("update {$tpf}files set is_del=1 where file_id in ($file_str)");
					$sysmsg[] = __('file_delete_success');
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}elseif($task =='restore_del_file'){
					$db->query_unbuffered("update {$tpf}files set is_del=0,folder_id=-1 where file_id in ($file_str)");
					$sysmsg[] = __('restore_del_file_success');
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}elseif($task =='move_all'){
					$db->query_unbuffered("update {$tpf}files set userid='$userid' where file_id in ($file_str)");
					$db->query_unbuffered("update {$tpf}shares set userid='$userid' where share_fid in ($file_str)");
					$sysmsg[] = '转移全部文件给用户 操作成功';
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}elseif($task =='move_depart'){					
					$db->query_unbuffered("update {$tpf}files set userid='$userid' where file_id in ($file_str)");
					$db->query_unbuffered("update {$tpf}shares set userid='$userid' where share_fid in ($file_str) and touserid=0");
					$sysmsg[] = '转移公司、部门文件给用户 操作成功';
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}
			}else{
				adm_redirect('back',$sysmsg);
			}
		}else{
			$sql_ext = '';
			$uid_sql = $uid ? "f.userid='$uid' and " : '';
			switch($view){
				case 'mydisk_recycle':
					$sql_ext = " where $uid_sql in_recycle=1 and is_del=0";
					break;
				case 'user_del':
					$sql_ext = " where $uid_sql f.is_del=1";
					break;
				case 'user':
					$sql_ext = " where $uid_sql f.userid='$uid' and is_del=0";
					break;
				default:
					$sql_ext = " where $uid_sql in_recycle=0 and is_del=0";
			}
			$rs = $db->fetch_one_array("select count(*) as total_num from {$tpf}files f {$sql_ext}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select f.*,u.username from {$tpf}files f,{$tpf}users u {$sql_ext} and f.userid=u.userid order by file_id desc limit $start_num,$perpage");
			$files_array = array();
			while($rs = $db->fetch_array($q)){
				$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
				$rs['file_thumb'] = get_file_thumb($rs);
				$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
				$rs['file_name'] = cutstr($rs['file_name'].$tmp_ext,35);
				$rs['a_user_view'] = urr(ADMINCP,"item=files&menu=$menu&action=$action&view=$view&uid=".$rs['userid']);
				$rs['file_size'] = get_size($rs['file_size']);
				$rs['file_time'] = date("Y-m-d H:i:s",$rs['file_time']);
				$rs['a_downfile'] = create_down_url($rs);
				$rs['a_viewfile'] = urr("viewfile","file_id={$rs['file_id']}");
				$rs['a_recycle_delete'] = urr(ADMINCP,"item=files&menu=$menu&action=recycle_delete&file_id={$rs['file_id']}");
				$rs['status_txt'] = $rs['is_locked'] ? "<span class=\"txtred\">".__('locked_status')."</span>" : "<span class=\"txtblue\">".__('common_status')."</span>";
				$rs['file_abs_path'] = $rs['file_store_path'].$rs['file_real_name'].get_real_ext($rs['file_extension']);
				$files_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr(ADMINCP,"item=$item&action=$action&view=$view&uid=$uid"));

			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'search':
		$view = trim(gpc('view','GP',''));
		$uid = (int)gpc('uid','GP',0);

		if(in_array($task,array('check_public','file_to_locked','file_to_unlocked','delete_file_complete','restore_del_file','move_all','move_depart'))){
			form_auth(gpc('formhash','P',''),formhash());
			$file_ids = gpc('file_ids','P',array(''));

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			$ids_arr = get_ids_arr($file_ids,__('please_select_check_files'));
			if($ids_arr[0]){
				$error = true;
				$sysmsg[] = $ids_arr[1];
			}else{
				$file_str = $ids_arr[1];
			}
			if($task =='move_all'){
				$tousername = trim(gpc('tousername','P',''));
				if($tousername){
					$userid = @$db->result_first("select userid from {$tpf}users where username='$tousername'");
					if(!$userid){
						$error = true;
						$sysmsg[] = '目标用户名不存在，先返回修改';
					}
				}else{
					$error = true;
					$sysmsg[] = '目标用户名不存在，先返回修改';
				}
			}elseif($task =='move_depart'){
				$tousername2 = trim(gpc('tousername2','P',''));
				if($tousername2){
					$userid = @$db->result_first("select userid from {$tpf}users where username='$tousername2'");
					if(!$userid){
						$error = true;
						$sysmsg[] = '目标用户名不存在，先返回修改';
					}
				}else{
					$error = true;
					$sysmsg[] = '目标用户名不存在，先返回修改';
				}
			}
			if(!$error){
				if($task =='check_public'){
					$db->query_unbuffered("update {$tpf}files set is_checked=1 where file_id in ($file_str)");
					$sysmsg[] = __('check_public_success');
					adm_redirect(urr(ADMINCP,"item=files&menu=$menu&action=index&view=checked_file"),$sysmsg);
				}elseif($task =='file_to_locked'){
					$db->query_unbuffered("update {$tpf}files set is_locked=1 where file_id in ($file_str)");
					$sysmsg[] = __('file_to_locked_success');
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}elseif($task == 'file_to_unlocked'){
					$db->query_unbuffered("update {$tpf}files set is_locked=0 where file_id in ($file_str)");
					$sysmsg[] = __('file_to_unlocked_success');
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}elseif($task =='delete_file_complete'){
					$db->query_unbuffered("update {$tpf}files set is_del=1 where file_id in ($file_str)");
					$sysmsg[] = __('file_delete_success');
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}elseif($task =='restore_del_file'){
					$db->query_unbuffered("update {$tpf}files set is_del=0,folder_id=-1 where file_id in ($file_str)");
					$sysmsg[] = __('restore_del_file_success');
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}elseif($task =='move_all'){
					$db->query_unbuffered("update {$tpf}files set userid='$userid' where file_id in ($file_str)");
					$db->query_unbuffered("update {$tpf}shares set userid='$userid' where share_fid in ($file_str)");
					$sysmsg[] = '转移全部文件给用户 操作成功';
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}elseif($task =='move_depart'){					
					$db->query_unbuffered("update {$tpf}files set userid='$userid' where file_id in ($file_str)");
					$db->query_unbuffered("update {$tpf}shares set userid='$userid' where share_fid in ($file_str) and touserid=0");
					$sysmsg[] = '转移公司、部门文件给用户 操作成功';
					adm_redirect($_SERVER['HTTP_REFERER'],$sysmsg);
				}
			}else{
				adm_redirect('back',$sysmsg);
			}
		}else{
			$word = trim(gpc('word','G',''));
			$word_str = str_replace('　',' ',replace_inject_str($word));
			$arr = explode(' ',$word_str);
			$str = '';
			if(count($arr)>1){
				for($i=0;$i<count($arr);$i++){
					if(trim($arr[$i]) <> ''){
						$str .= " (file_name like '%{$arr[$i]}%' or file_extension like '%{$arr[$i]}%') and";
					}
				}
				$str = substr($str,0,-3);
				$sql_keyword = " (".$str.")";

			}else{
				$sql_keyword = " (file_name like '%{$word_str}%' or file_extension like '%{$word_str}%')";
			}
			$is_del = $view=='user_del' ? 1 : 0;
			$sql_do = " {$tpf}files fl,{$tpf}users u where fl.userid=u.userid and is_del=$is_del and {$sql_keyword}";

			$rs = $db->fetch_one_array("select count(*) as total_num from {$sql_do}");
			$total_num = $rs['total_num'];
			$start_num = ($pg-1) * $perpage;

			$q = $db->query("select fl.*,u.username from {$sql_do} order by file_id desc limit $start_num,$perpage");
			$files_array = array();
			while($rs = $db->fetch_array($q)){
				$tmp_ext = $rs['file_extension'] ? '.'.$rs['file_extension'] : "";
				$rs['file_name_all'] = $rs['file_name'].$tmp_ext;
				$rs['file_name'] = str_replace($word,'<span class="txtred">'.$word.'</span>',cutstr($rs['file_name'].$tmp_ext,35));
				$rs['a_user_view'] = urr(ADMINCP,"item=files&menu=$menu&action=index&view=$view&uid=".$rs['userid']);
				$rs['file_size'] = get_size($rs['file_size']);
				$rs['file_time'] = custom_time("Y-m-d",$rs['file_time']);
				$rs['a_downfile'] = create_down_url($rs);
				$rs['a_viewfile'] = urr("viewfile","file_id={$rs['file_id']}");
				$rs['a_recycle_delete'] = urr(ADMINCP,"item=files&menu=$menu&action=recycle_delete&file_id={$rs['file_id']}");
				$rs['status_txt'] = $rs['is_locked'] ? "<span class=\"txtred\">".__('locked_status')."</span>" : "<span class=\"txtblue\">".__('common_status')."</span>";
				$rs['file_abs_path'] = $rs['file_store_path'].$rs['file_real_name'].get_real_ext($rs['file_extension']);
				$files_array[] = $rs;
			}
			$db->free($q);
			unset($rs);
			$page_nav = multi($total_num, $perpage, $pg, urr(ADMINCP,"item=$item&action=search&word=".rawurlencode($word).""));

			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'recycle_delete':
		if($settings['online_demo']){
			$error = true;
			$sysmsg[] = __('online_demo_deny');
		}
		if(!$error){
			$file_id = (int)gpc('file_id','G',0);
			$db->query_unbuffered("update {$tpf}files set is_del=1 where file_id='$file_id'");
			$sysmsg[] = __('file_delete_success');
			adm_redirect(urr(ADMINCP,"item=files&menu=$menu&action=index&view=public_recycle"),$sysmsg);
		}else{
			adm_redirect('back',$sysmsg);
		}
		break;
	case 'stats':
		if($task=='update_setting'){
			form_auth(gpc('formhash','P',''),formhash());
			$setting = array(
			'open_file_logs' => 0,
			);
			$settings = gpc('setting','P',$setting);

			if(!$error){

				settings_cache($settings);

				$sysmsg[] = '配置更新成功';
				adm_redirect(urr(ADMINCP,"item=$item&menu=$menu&action=$action"),$sysmsg);

			}else{
				adm_redirect('back',$sysmsg);
			}
		}else{
			view_file_logs(1);
		}
		break;
}

?>