<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: email.inc.php 139 2024-10-19 09:23:13Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}

switch($action){
	case 'setting':

		if($task =='update'){
			form_auth(gpc('formhash','P',''),formhash());

			$email_pwd_src = trim($settings['email_pwd']);
			$setting = array(
			'open_email' => 0,
			'email_address' => '',
			'email_user' => '',
			'email_pwd' => '',
			'email_smtp' => '',
			'email_port' => '',
			'email_ssl' => '',
			);
			$online_demo = $settings['online_demo'];
			$settings = gpc('setting','P',$setting);

			if($online_demo){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(!checkemail($settings['email_address'])){
				$error = true;
				$sysmsg[] = __('email_address_error');
			}
			if(checklength($settings['email_user'],2,30)){
				$error = true;
				$sysmsg[] = __('email_user_error');
			}
			if(strpos($settings['email_pwd'],'*') ===false){
				if(checklength($settings['email_pwd'],2,20)){
					$error = true;
					$sysmsg[] = __('email_pwd_error');
				}
			}else{
				$settings['email_pwd'] = $email_pwd_src;
			}
			if(checklength($settings['email_smtp'],6,50)){
				$error = true;
				$sysmsg[] = __('email_smtp_error');
			}
			if(!$settings['email_port']){
				$error = true;
				$sysmsg[] = __('email_port_error');
			}else{
				$settings['email_port'] = (int)$settings['email_port'];
			}
			if(!$error){

				settings_cache($settings);

				$sysmsg[] = __('email_update_success');
				adm_redirect(urr(ADMINCP,"item=email&menu=$menu&action=$action"),$sysmsg);

			}else{
				adm_redirect('back',$sysmsg);
			}
		}else{
			$setting = $settings;
			$setting['email_pwd'] = encode_pwd($setting['email_pwd']);
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'mail_test':
		if($task =='mail_test'){
			form_auth(gpc('formhash','P',''),formhash());

			$receive_address = trim(gpc('receive_address','P',''));
			$mail_subject = trim(gpc('mail_subject','P',''));
			$mail_content = trim(gpc('mail_content','P',''));

			if(!checkemail($receive_address)){
				$error = true;
				$sysmsg[] = __('email_address_error');
			}
			if(checklength($mail_subject,2,80)){
				$error = true;
				$sysmsg[] = __('email_subject_error');
			}
			if(checklength($mail_content,2,250)){
				$error = true;
				$sysmsg[] = __('email_content_error');
			}
			if(!$error){
				$to = $receive_address;
				$subject = $mail_subject;
				$body = $mail_content;

				$mailer_str = send_email($to,$subject,$body);
				if($mailer_str=='success'){
					$sysmsg[] = __('send_email_success');
				}else{
					$sysmsg[] = $mailer_str;
				}
				adm_redirect(urr(ADMINCP,"item=email&menu=$menu&action=$action"),$sysmsg,5000);

			}else{
				adm_redirect('back',$sysmsg);
			}

		}else{
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	default:
		adm_redirect(urr(ADMINCP,"item=email&menu=$menu&action=setting"),'',0);
}
?>