<?php 
/**
#	Project: PHPDISK File Storage Solution
#	This is NOT a freeware, use is subject to license terms.
#
#	Chinese Website: http://www.phpdisk.com
#
#	International Website: http://www.phpdisk.net
#
#	Author: Along ( admin@phpdisk.com )
#
#	$Id: depart.inc.php 139 2024-10-19 09:23:13Z along $
#
#	Copyright (C) 2008-2083 PHPDisk Team. All Rights Reserved.
#
*/

if(!defined('IN_PHPDISK') || !defined('IN_ADMINCP')) {
	exit('[PHPDisk] Access Denied');
}

switch($action){
	case 'depart_create':

		if($task =='depart_create'){
			form_auth(gpc('formhash','P',''),formhash());

			$depart_name = trim(gpc('depart_name','P',''));
			$pid = (int)gpc('pid','P','');

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(checklength($depart_name,1,100)){
				$error = true;
				$sysmsg[] = '部门名字长度非法';
			}
			$rs = $db->fetch_one_array("select count(*) as total from {$tpf}departs where depart_name='$depart_name'");
			if($rs['total'] >0){
				$error = true;
				$sysmsg[] = '部门名字已存在，请重新修改';
			}
			unset($rs);
			if(!$error){
				$ins = array(
				'depart_name' => $depart_name,
				'pid' => $pid,
				);
				$db->query("insert into {$tpf}departs set ".$db->sql_array($ins).";");
				$sysmsg[] = '部门添加成功';
				adm_redirect(urr(ADMINCP,"item=depart&menu=user&action=index"),$sysmsg);

			}else{
				adm_redirect('back',$sysmsg);
			}
		}else{
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'depart_modify':
		$depart_id = (int)gpc('depart_id','GP',0);
		if($task =='depart_modify'){
			form_auth(gpc('formhash','P',''),formhash());

			$depart_name = trim(gpc('depart_name','P',''));
			$pid = (int)gpc('pid','P','');

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(checklength($depart_name,1,100)){
				$error = true;
				$sysmsg[] = '部门名字长度非法';
			}
			$rs = $db->fetch_one_array("select count(*) as total from {$tpf}departs where depart_name='$depart_name' and depart_id<>'$depart_id'");
			if($rs['total'] >0){
				$error = true;
				$sysmsg[] = '部门名字已存在，请重新修改';
			}
			unset($rs);
			$num = @$db->query("select count(*) from {$tpf}departs where depart_id='$pid'");
			if($num){
				$error = true;
				$sysmsg[] = '自己不能设置自己为顶节点，请返回修改';
			}			

			if(!$error){
				$db->query("update {$tpf}departs set depart_name='$depart_name',pid='$pid' where depart_id='$depart_id'");
				$sysmsg[] = '部门名字修改成功';
				adm_redirect(urr(ADMINCP,"item=depart&menu=user&action=index"),$sysmsg);
			}else{
				adm_redirect('back',$sysmsg);
			}

		}else{
			$rs = $db->fetch_one_array("select * from {$tpf}departs where depart_id='$depart_id'");
			if($rs){
				$depart_name = $rs['depart_name'];
				$pid = $rs[pid];
			}
			unset($rs);
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	case 'depart_delete':
		$depart_id = (int)gpc('depart_id','G',0);
		if($settings['online_demo']){
			$error = true;
			$sysmsg[] = __('online_demo_deny');
		}
		if($depart_id){
			$db->query("update {$tpf}users set depart_id=0 where depart_id='$depart_id'");
			$db->query("update {$tpf}departs set pid=0 where pid='$depart_id'");
			$db->query("delete from {$tpf}departs where depart_id='$depart_id' limit 1");
			$sysmsg[] = '部门删除成功';
			adm_redirect(urr(ADMINCP,"item=depart&menu=user&action=index"),$sysmsg);
		}else{
			$sysmsg[] = '部门参数不正确';
			adm_redirect('back',$sysmsg);
		}
		break;

	case 'index':
		if($task =='update'){
			form_auth(gpc('formhash','P',''),formhash());

			$show_order = gpc('show_order','P',array());
			$depart_ids = gpc('depart_ids','P',array());

			if($settings['online_demo']){
				$error = true;
				$sysmsg[] = __('online_demo_deny');
			}
			if(!$error){
				for($i =0;$i<count($depart_ids);$i++){
					$db->query_unbuffered("update {$tpf}departs set show_order='".(int)$show_order[$i]."' where depart_id='".(int)$depart_ids[$i]."'");
				}
				$sysmsg[] = '部门组管理更新成功';
				adm_redirect(urr(ADMINCP,"item=$item&menu=$menu&action=$action"),$sysmsg);
			}else{
				adm_redirect('back',$sysmsg);
			}
		}else{
			$depart_tree = get_depart_tree();
			require_once template_echo($item,$admin_tpl_dir,'',1);
		}
		break;

	default:
		adm_redirect(urr(ADMINCP,"item=depart&menu=user&action=index"),'',0);
}
function get_depart_tree($pid=0,$lv=0){
	global $db,$tpf;
	$q = $db->query("select * from {$tpf}departs order by show_order asc");
	while ($rs = $db->fetch_array($q)) {
		$data[] = $rs;
	}
	$db->free($q);
	unset($rs);
	if(count($data)){
		$html = '<tr>'.LF;
		foreach($data as $v){
			if($v['pid'] == $pid){
				$a_modify = urr(ADMINCP,"item=depart&menu=user&action=depart_modify&depart_id={$v['depart_id']}");
				$a_view = urr(ADMINCP,"item=users&menu=user&action=index&depart_id={$v['depart_id']}");
				$a_del = urr(ADMINCP,"item=depart&menu=user&action=depart_delete&depart_id={$v['depart_id']}");
				$user_count = (int)@$db->result_first("select count(*) from {$tpf}users where depart_id='".$v['depart_id']."'");

				$html .= "<td>".LF;
				$html .= '<input type="text" name="show_order[]" value="'.$v['show_order'].'" style="width:20px; text-align:center" maxlength="2" />'.LF;
				$html .= '<input type="hidden" name="depart_ids[]" value="'.$v['depart_id'].'" />'.LF;
				$html .= str_repeat('&nbsp;',$lv*2).'<a href="'.$a_view.'">'.$v[depart_name].'</a></td>'.LF;
				$html .= '	<td align="center">';
				$html .= '<a href="'.$a_view.'">'.$user_count.'</a>';
				$html .= '	</td>'.LF;
				$html .= '	<td align="right">';
				$html .= '	<a href="'.$a_modify.'">'.__('modify').'</a>&nbsp;';
				$html .= '	<a href="javascript:;" onclick="aconfirm(\'确认删除此部门组吗？此部门组下面的用户将会成变成无部门状态。\',\''.$a_del.'\');">'.__('delete').'</a></td>'.LF;
				$lv++;
				$html .= get_depart_tree($v['depart_id'],$lv);
				$lv--;
			}
		}
		$html .= '</tr>'.LF;
		return $html;
	}else{
		return '';
	}
}


?>