module lang::jimple::tests::TestTransformations

import lang::jimple::core::Syntax;
import lang::jimple::decompiler::jimplify::Transformations;
import lang::jimple::decompiler::jimplify::RemoveModifiers;



ClassOrInterfaceDeclaration fooBarBeforeTransformations = classDecl([Public(),Synchronized()],TObject("samples.pointsto.simple.FooBar"),TObject("java.lang.Object"),[],[],[method([Public()],TVoid(),"\<init\>",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",-1)),label("L1333452388",context=stmtContext(2,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",-1)),invokeStmt(specialInvoke("r0",methodSignature("java.lang.Object",TVoid(),"\<init\>",[]),[]),context=stmtContext(3,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8)),returnEmptyStmt(context=stmtContext(4,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8)),label("L474893139",context=stmtContext(5,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8))],[])),method([Public()],TVoid(),"foo",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"q"),localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"t"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"p"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"r"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r2"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r3")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: V foo()\>",-1)),label("L64156033",context=stmtContext(2,"\<samples.pointsto.simple.FooBar: V foo()\>",-1)),assign(localVariable("$r1"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(3,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),invokeStmt(specialInvoke("$r1",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(4,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),assign(localVariable("p"),immediate(local("$r1")),context=stmtContext(5,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),label("L584906067",context=stmtContext(6,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),assign(localVariable("q"),immediate(local("p")),context=stmtContext(7,"\<samples.pointsto.simple.FooBar: V foo()\>",12)),label("L999582550",context=stmtContext(8,"\<samples.pointsto.simple.FooBar: V foo()\>",12)),assign(localVariable("$r2"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(9,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),invokeStmt(specialInvoke("$r2",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(10,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),assign(localVariable("r"),immediate(local("$r2")),context=stmtContext(11,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),label("L1091256100",context=stmtContext(12,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),assign(fieldRef("p",fieldSignature("samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next")),immediate(local("r")),context=stmtContext(13,"\<samples.pointsto.simple.FooBar: V foo()\>",14)),label("L1438748797",context=stmtContext(14,"\<samples.pointsto.simple.FooBar: V foo()\>",14)),assign(localVariable("$r3"),invokeExp(specialInvoke("r0",methodSignature("samples.pointsto.simple.FooBar",TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")]),[local("q")])),context=stmtContext(15,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),assign(localVariable("t"),immediate(local("$r3")),context=stmtContext(16,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),label("L275943931",context=stmtContext(17,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),returnEmptyStmt(context=stmtContext(18,"\<samples.pointsto.simple.FooBar: V foo()\>",16)),label("L145000056",context=stmtContext(19,"\<samples.pointsto.simple.FooBar: V foo()\>",16))],[])),method([Private()],TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"s"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),identity("s","@parameter0",TObject("samples.pointsto.simple.Node"),context=stmtContext(2,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),label("L1303183315",context=stmtContext(3,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),assign(localVariable("$r1"),localFieldRef("s","samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next"),context=stmtContext(4,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19)),returnStmt(local("$r1"),context=stmtContext(5,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19)),label("L1628907352",context=stmtContext(6,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19))],[]))]);


test bool testBasic(){
	ClassOrInterfaceDeclaration transformed = jimplify(fooBarBeforeTransformations, basic());
	
	ClassOrInterfaceDeclaration expected = classDecl([Public()],TObject("samples.pointsto.simple.FooBar"),TObject("java.lang.Object"),[],[],[method([Public()],TVoid(),"\<init\>",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"TObject(\"samples.pointsto.simple.FooBar\").\<init\>()",-1)),invokeStmt(specialInvoke("r0",methodSignature("java.lang.Object",TVoid(),"\<init\>",[]),[]),context=stmtContext(2,"TObject(\"samples.pointsto.simple.FooBar\").\<init\>()",8)),returnEmptyStmt(context=stmtContext(3,"TObject(\"samples.pointsto.simple.FooBar\").\<init\>()",8))],[])),method([Public()],TVoid(),"foo",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"q"),localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"t"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"p"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"r"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r2"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r3")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"TObject(\"samples.pointsto.simple.FooBar\").foo()",-1)),assign(localVariable("$r1"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(2,"TObject(\"samples.pointsto.simple.FooBar\").foo()",11)),invokeStmt(specialInvoke("$r1",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(3,"TObject(\"samples.pointsto.simple.FooBar\").foo()",11)),assign(localVariable("p"),immediate(local("$r1")),context=stmtContext(4,"TObject(\"samples.pointsto.simple.FooBar\").foo()",11)),assign(localVariable("q"),immediate(local("p")),context=stmtContext(5,"TObject(\"samples.pointsto.simple.FooBar\").foo()",12)),assign(localVariable("$r2"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(6,"TObject(\"samples.pointsto.simple.FooBar\").foo()",13)),invokeStmt(specialInvoke("$r2",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(7,"TObject(\"samples.pointsto.simple.FooBar\").foo()",13)),assign(localVariable("r"),immediate(local("$r2")),context=stmtContext(8,"TObject(\"samples.pointsto.simple.FooBar\").foo()",13)),assign(fieldRef("p",fieldSignature("samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next")),immediate(local("r")),context=stmtContext(9,"TObject(\"samples.pointsto.simple.FooBar\").foo()",14)),assign(localVariable("$r3"),invokeExp(specialInvoke("r0",methodSignature("samples.pointsto.simple.FooBar",TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")]),[local("q")])),context=stmtContext(10,"TObject(\"samples.pointsto.simple.FooBar\").foo()",15)),assign(localVariable("t"),immediate(local("$r3")),context=stmtContext(11,"TObject(\"samples.pointsto.simple.FooBar\").foo()",15)),returnEmptyStmt(context=stmtContext(12,"TObject(\"samples.pointsto.simple.FooBar\").foo()",16))],[])),method([Private()],TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"s"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"TObject(\"samples.pointsto.simple.FooBar\").bar(samples.pointsto.simple.Node)",-1)),identity("s","@parameter0",TObject("samples.pointsto.simple.Node"),context=stmtContext(2,"TObject(\"samples.pointsto.simple.FooBar\").bar(samples.pointsto.simple.Node)",-1)),assign(localVariable("$r1"),localFieldRef("s","samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next"),context=stmtContext(3,"TObject(\"samples.pointsto.simple.FooBar\").bar(samples.pointsto.simple.Node)",19)),returnStmt(local("$r1"),context=stmtContext(4,"TObject(\"samples.pointsto.simple.FooBar\").bar(samples.pointsto.simple.Node)",19))],[]))]);
	
	return transformed == expected;
}

test bool testOptimizations(){
	ClassOrInterfaceDeclaration transformed = jimplify(fooBarBeforeTransformations, optimizations());

	ClassOrInterfaceDeclaration expected = classDecl([Public(),Synchronized()],TObject("samples.pointsto.simple.FooBar"),TObject("java.lang.Object"),[],[],[method([Public()],TVoid(),"\<init\>",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",-1)),label("L1333452388",context=stmtContext(2,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",-1)),invokeStmt(specialInvoke("r0",methodSignature("java.lang.Object",TVoid(),"\<init\>",[]),[]),context=stmtContext(3,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8)),returnEmptyStmt(context=stmtContext(4,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8)),label("L474893139",context=stmtContext(5,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8))],[])),method([Public()],TVoid(),"foo",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"q"),localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"t"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"p"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"r"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r2"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r3")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: V foo()\>",-1)),label("L64156033",context=stmtContext(2,"\<samples.pointsto.simple.FooBar: V foo()\>",-1)),assign(localVariable("$r1"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(3,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),invokeStmt(specialInvoke("$r1",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(4,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),assign(localVariable("p"),immediate(local("$r1")),context=stmtContext(5,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),label("L584906067",context=stmtContext(6,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),assign(localVariable("q"),immediate(local("p")),context=stmtContext(7,"\<samples.pointsto.simple.FooBar: V foo()\>",12)),label("L999582550",context=stmtContext(8,"\<samples.pointsto.simple.FooBar: V foo()\>",12)),assign(localVariable("$r2"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(9,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),invokeStmt(specialInvoke("$r2",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(10,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),assign(localVariable("r"),immediate(local("$r2")),context=stmtContext(11,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),label("L1091256100",context=stmtContext(12,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),assign(fieldRef("p",fieldSignature("samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next")),immediate(local("r")),context=stmtContext(13,"\<samples.pointsto.simple.FooBar: V foo()\>",14)),label("L1438748797",context=stmtContext(14,"\<samples.pointsto.simple.FooBar: V foo()\>",14)),assign(localVariable("$r3"),invokeExp(specialInvoke("r0",methodSignature("samples.pointsto.simple.FooBar",TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")]),[local("q")])),context=stmtContext(15,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),assign(localVariable("t"),immediate(local("$r3")),context=stmtContext(16,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),label("L275943931",context=stmtContext(17,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),returnEmptyStmt(context=stmtContext(18,"\<samples.pointsto.simple.FooBar: V foo()\>",16)),label("L145000056",context=stmtContext(19,"\<samples.pointsto.simple.FooBar: V foo()\>",16))],[])),method([Private()],TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"s"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),identity("s","@parameter0",TObject("samples.pointsto.simple.Node"),context=stmtContext(2,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),label("L1303183315",context=stmtContext(3,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),assign(localVariable("$r1"),localFieldRef("s","samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next"),context=stmtContext(4,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19)),returnStmt(local("$r1"),context=stmtContext(5,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19)),label("L1628907352",context=stmtContext(6,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19))],[]))]);
	
	return transformed == expected;
}

test bool testGiven(){
	ClassOrInterfaceDeclaration transformed = jimplify(fooBarBeforeTransformations, given([processModifiers]));

	ClassOrInterfaceDeclaration expected = classDecl([Public()],TObject("samples.pointsto.simple.FooBar"),TObject("java.lang.Object"),[],[],[method([Public()],TVoid(),"\<init\>",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",-1)),label("L1333452388",context=stmtContext(2,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",-1)),invokeStmt(specialInvoke("r0",methodSignature("java.lang.Object",TVoid(),"\<init\>",[]),[]),context=stmtContext(3,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8)),returnEmptyStmt(context=stmtContext(4,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8)),label("L474893139",context=stmtContext(5,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8))],[])),method([Public()],TVoid(),"foo",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"q"),localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"t"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"p"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"r"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r2"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r3")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: V foo()\>",-1)),label("L64156033",context=stmtContext(2,"\<samples.pointsto.simple.FooBar: V foo()\>",-1)),assign(localVariable("$r1"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(3,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),invokeStmt(specialInvoke("$r1",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(4,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),assign(localVariable("p"),immediate(local("$r1")),context=stmtContext(5,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),label("L584906067",context=stmtContext(6,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),assign(localVariable("q"),immediate(local("p")),context=stmtContext(7,"\<samples.pointsto.simple.FooBar: V foo()\>",12)),label("L999582550",context=stmtContext(8,"\<samples.pointsto.simple.FooBar: V foo()\>",12)),assign(localVariable("$r2"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(9,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),invokeStmt(specialInvoke("$r2",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(10,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),assign(localVariable("r"),immediate(local("$r2")),context=stmtContext(11,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),label("L1091256100",context=stmtContext(12,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),assign(fieldRef("p",fieldSignature("samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next")),immediate(local("r")),context=stmtContext(13,"\<samples.pointsto.simple.FooBar: V foo()\>",14)),label("L1438748797",context=stmtContext(14,"\<samples.pointsto.simple.FooBar: V foo()\>",14)),assign(localVariable("$r3"),invokeExp(specialInvoke("r0",methodSignature("samples.pointsto.simple.FooBar",TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")]),[local("q")])),context=stmtContext(15,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),assign(localVariable("t"),immediate(local("$r3")),context=stmtContext(16,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),label("L275943931",context=stmtContext(17,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),returnEmptyStmt(context=stmtContext(18,"\<samples.pointsto.simple.FooBar: V foo()\>",16)),label("L145000056",context=stmtContext(19,"\<samples.pointsto.simple.FooBar: V foo()\>",16))],[])),method([Private()],TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"s"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),identity("s","@parameter0",TObject("samples.pointsto.simple.Node"),context=stmtContext(2,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),label("L1303183315",context=stmtContext(3,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),assign(localVariable("$r1"),localFieldRef("s","samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next"),context=stmtContext(4,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19)),returnStmt(local("$r1"),context=stmtContext(5,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19)),label("L1628907352",context=stmtContext(6,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19))],[]))]);
	
	return transformed == expected;
}

test bool testGivenByNames(){
	ClassOrInterfaceDeclaration transformed = jimplify(fooBarBeforeTransformations, givenByNames(["modifier"]));

	ClassOrInterfaceDeclaration expected = classDecl([Public()],TObject("samples.pointsto.simple.FooBar"),TObject("java.lang.Object"),[],[],[method([Public()],TVoid(),"\<init\>",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",-1)),label("L1333452388",context=stmtContext(2,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",-1)),invokeStmt(specialInvoke("r0",methodSignature("java.lang.Object",TVoid(),"\<init\>",[]),[]),context=stmtContext(3,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8)),returnEmptyStmt(context=stmtContext(4,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8)),label("L474893139",context=stmtContext(5,"\<samples.pointsto.simple.FooBar: V \<init\>()\>",8))],[])),method([Public()],TVoid(),"foo",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"q"),localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"t"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"p"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"r"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r2"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r3")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: V foo()\>",-1)),label("L64156033",context=stmtContext(2,"\<samples.pointsto.simple.FooBar: V foo()\>",-1)),assign(localVariable("$r1"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(3,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),invokeStmt(specialInvoke("$r1",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(4,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),assign(localVariable("p"),immediate(local("$r1")),context=stmtContext(5,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),label("L584906067",context=stmtContext(6,"\<samples.pointsto.simple.FooBar: V foo()\>",11)),assign(localVariable("q"),immediate(local("p")),context=stmtContext(7,"\<samples.pointsto.simple.FooBar: V foo()\>",12)),label("L999582550",context=stmtContext(8,"\<samples.pointsto.simple.FooBar: V foo()\>",12)),assign(localVariable("$r2"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(9,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),invokeStmt(specialInvoke("$r2",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(10,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),assign(localVariable("r"),immediate(local("$r2")),context=stmtContext(11,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),label("L1091256100",context=stmtContext(12,"\<samples.pointsto.simple.FooBar: V foo()\>",13)),assign(fieldRef("p",fieldSignature("samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next")),immediate(local("r")),context=stmtContext(13,"\<samples.pointsto.simple.FooBar: V foo()\>",14)),label("L1438748797",context=stmtContext(14,"\<samples.pointsto.simple.FooBar: V foo()\>",14)),assign(localVariable("$r3"),invokeExp(specialInvoke("r0",methodSignature("samples.pointsto.simple.FooBar",TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")]),[local("q")])),context=stmtContext(15,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),assign(localVariable("t"),immediate(local("$r3")),context=stmtContext(16,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),label("L275943931",context=stmtContext(17,"\<samples.pointsto.simple.FooBar: V foo()\>",15)),returnEmptyStmt(context=stmtContext(18,"\<samples.pointsto.simple.FooBar: V foo()\>",16)),label("L145000056",context=stmtContext(19,"\<samples.pointsto.simple.FooBar: V foo()\>",16))],[])),method([Private()],TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"s"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),identity("s","@parameter0",TObject("samples.pointsto.simple.Node"),context=stmtContext(2,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),label("L1303183315",context=stmtContext(3,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",-1)),assign(localVariable("$r1"),localFieldRef("s","samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next"),context=stmtContext(4,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19)),returnStmt(local("$r1"),context=stmtContext(5,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19)),label("L1628907352",context=stmtContext(6,"\<samples.pointsto.simple.FooBar: Lsamples/pointsto/simple/Node; bar(lang.jimple.internal.generated.Type$c_TObject@e5a3c9b9)\>",19))],[]))]);
	
	return transformed == expected;
}

test bool testFull(){
	ClassOrInterfaceDeclaration transformed = jimplify(fooBarBeforeTransformations, full());
	
	ClassOrInterfaceDeclaration expected = classDecl([Public()],TObject("samples.pointsto.simple.FooBar"),TObject("java.lang.Object"),[],[],[method([Public()],TVoid(),"\<init\>",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"TObject(\"samples.pointsto.simple.FooBar\").\<init\>()",-1)),invokeStmt(specialInvoke("r0",methodSignature("java.lang.Object",TVoid(),"\<init\>",[]),[]),context=stmtContext(2,"TObject(\"samples.pointsto.simple.FooBar\").\<init\>()",8)),returnEmptyStmt(context=stmtContext(3,"TObject(\"samples.pointsto.simple.FooBar\").\<init\>()",8))],[])),method([Public()],TVoid(),"foo",[],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"q"),localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"t"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"p"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"r"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r2"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r3")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"TObject(\"samples.pointsto.simple.FooBar\").foo()",-1)),assign(localVariable("$r1"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(2,"TObject(\"samples.pointsto.simple.FooBar\").foo()",11)),invokeStmt(specialInvoke("$r1",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(3,"TObject(\"samples.pointsto.simple.FooBar\").foo()",11)),assign(localVariable("p"),immediate(local("$r1")),context=stmtContext(4,"TObject(\"samples.pointsto.simple.FooBar\").foo()",11)),assign(localVariable("q"),immediate(local("p")),context=stmtContext(5,"TObject(\"samples.pointsto.simple.FooBar\").foo()",12)),assign(localVariable("$r2"),newInstance(TObject("samples.pointsto.simple.Node")),context=stmtContext(6,"TObject(\"samples.pointsto.simple.FooBar\").foo()",13)),invokeStmt(specialInvoke("$r2",methodSignature("samples.pointsto.simple.Node",TVoid(),"\<init\>",[]),[]),context=stmtContext(7,"TObject(\"samples.pointsto.simple.FooBar\").foo()",13)),assign(localVariable("r"),immediate(local("$r2")),context=stmtContext(8,"TObject(\"samples.pointsto.simple.FooBar\").foo()",13)),assign(fieldRef("p",fieldSignature("samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next")),immediate(local("r")),context=stmtContext(9,"TObject(\"samples.pointsto.simple.FooBar\").foo()",14)),assign(localVariable("$r3"),invokeExp(specialInvoke("r0",methodSignature("samples.pointsto.simple.FooBar",TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")]),[local("q")])),context=stmtContext(10,"TObject(\"samples.pointsto.simple.FooBar\").foo()",15)),assign(localVariable("t"),immediate(local("$r3")),context=stmtContext(11,"TObject(\"samples.pointsto.simple.FooBar\").foo()",15)),returnEmptyStmt(context=stmtContext(12,"TObject(\"samples.pointsto.simple.FooBar\").foo()",16))],[])),method([Private()],TObject("samples.pointsto.simple.Node"),"bar",[TObject("samples.pointsto.simple.Node")],[],methodBody([localVariableDeclaration(TObject("samples.pointsto.simple.FooBar"),"r0"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"s"),localVariableDeclaration(TObject("samples.pointsto.simple.Node"),"$r1")],[identity("r0","@this",TObject("samples.pointsto.simple.FooBar"),context=stmtContext(1,"TObject(\"samples.pointsto.simple.FooBar\").bar(samples.pointsto.simple.Node)",-1)),identity("s","@parameter0",TObject("samples.pointsto.simple.Node"),context=stmtContext(2,"TObject(\"samples.pointsto.simple.FooBar\").bar(samples.pointsto.simple.Node)",-1)),assign(localVariable("$r1"),localFieldRef("s","samples/pointsto/simple/Node",TObject("samples.pointsto.simple.Node"),"next"),context=stmtContext(3,"TObject(\"samples.pointsto.simple.FooBar\").bar(samples.pointsto.simple.Node)",19)),returnStmt(local("$r1"),context=stmtContext(4,"TObject(\"samples.pointsto.simple.FooBar\").bar(samples.pointsto.simple.Node)",19))],[]))]);
	
	return transformed == expected;
}