#include <string>
#include <thread>
#include <vector>

struct bark_params {
    // Number of threads used for audio generation.
    int32_t n_threads = std::min(4, (int32_t)std::thread::hardware_concurrency());

    // User prompt.
    std::string prompt = "This is an audio generated by bark.cpp";

    // Location of model weights.
    std::string model_path = "./ggml_weights";

    // Destination path for generated WAV file.
    std::string dest_wav_path = "output.wav";

    // Seed for reproducibility in token sampling.
    int32_t seed = 0;
};

/**
 * @brief Writes a WAV file from disk and stores the audio data in a vector of floats.
 *
 * @param in_path Path to the input WAV file.
 * @param audio_arr Vector to store the audio data.
 * @return true If the file was successfully read.
 * @return false If the file could not be read.
 */
void write_wav_on_disk(std::vector<float>& audio_arr, std::string dest_path);

/**
 * @brief Parses command line arguments and stores them in a bark_params struct.
 *
 * @param argc The number of command line arguments.
 * @param argv An array of C-strings containing the command line arguments.
 * @param params A reference to a bark_params struct where the parsed arguments will be stored.
 * @return int Returns 0 if the parsing was successful, otherwise returns a non-zero value.
 */
int bark_params_parse(int argc, char** argv, bark_params& params);

/**
 * Prints the usage information for the bark command-line tool.
 *
 * @param argv The command-line arguments passed to the program.
 * @param params The parameters used by the bark command-line tool.
 */
void bark_print_usage(char** argv, const bark_params& params);
