// Angular 2
import {
  enableDebugTools,
  disableDebugTools
} from '@angular/platform-browser';
import {
  ApplicationRef,
  enableProdMode
} from '@angular/core';

/*--------------   Configuration variables   -------------- */
let PROVIDERS = [
  { provide: 'DEFAULT_USERNAME', useValue: '_anonymous_' }, // TODO delete
  { provide: 'DEFAULT_PASSWORD', useValue: '' }, // TODO delete
  { provide: 'SWELLRT_DOMAIN', useValue: 'demo.swellrt.org' },
  { provide: 'JETPAD_URL', useValue: 'https://demo.jetpad.net' },
  { provide: 'RECOVER_PASSWORD_URL', useValue: 'https://demo.jetpad.net/recover/*$token*$user-id*' }
];

// Angular debug tools in the dev console
// https://github.com/angular/angular/blob/86405345b781a9dc2438c0fbe3e9409245647019/TOOLS_JS.md
let _decorateModuleRef = <T>(value: T): T => { return value; };

if ('production' === ENV) {
  enableProdMode();

  // Production
  _decorateModuleRef = (modRef: any) => {
    disableDebugTools();

    return modRef;
  };

  PROVIDERS = [
    ...PROVIDERS,
    // custom providers in production
  ];

} else {

  _decorateModuleRef = (modRef: any) => {
    const appRef = modRef.injector.get(ApplicationRef);
    const cmpRef = appRef.components[0];

    let _ng = (<any> window).ng;
    enableDebugTools(cmpRef);
    (<any> window).ng.probe = _ng.probe;
    (<any> window).ng.coreTokens = _ng.coreTokens;
    return modRef;
  };

  // Development
  PROVIDERS = [
    ...PROVIDERS,
    // custom providers in development
  ];

}

export const decorateModuleRef = _decorateModuleRef;

export const ENV_PROVIDERS = [
  ...PROVIDERS
];
