/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opoo.press.CompassConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompassConfigImpl
implements CompassConfig {
    private static final Logger log = LoggerFactory.getLogger(CompassConfigImpl.class);
    private final File compassProjectPath;
    private File configFile;
    private File sassDir;
    private File cssDir;

    public CompassConfigImpl(File compassProjectPath) {
        this.compassProjectPath = compassProjectPath;
        this.configFile = new File(compassProjectPath, "config.rb");
        if (!(this.configFile.exists() && this.configFile.isFile() && this.configFile.canRead())) {
            throw new IllegalArgumentException("Not a valid compass project config: " + compassProjectPath);
        }
        FileInputStream stream = null;
        Properties configContent = new Properties();
        try {
            stream = new FileInputStream(this.configFile);
            configContent.load(stream);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        this.sassDir = this.getSassDirectory(configContent);
        this.cssDir = this.getCssDirectory(configContent);
    }

    private String get(Properties configContent, String name) {
        String value = configContent.getProperty(name);
        if (value != null) {
            value = StringUtils.remove((String)value, (String)"\"");
            value = StringUtils.remove((String)value, (String)"'");
        }
        log.debug(name + ": " + value);
        return value;
    }

    private File getSassDirectory(Properties configContent) {
        File sass;
        String dir = this.get(configContent, "sass_dir");
        if (dir == null) {
            dir = "sass";
        }
        if (!(sass = new File(this.compassProjectPath, dir)).exists() || !sass.isDirectory()) {
            throw new IllegalArgumentException("No valid sass directory definded in config.rb");
        }
        return sass;
    }

    private File getCssDirectory(Properties configContent) {
        String dir = this.get(configContent, "css_dir");
        if (dir == null) {
            dir = "assets/stylesheets";
        }
        File css = new File(this.compassProjectPath, dir);
        return css;
    }

    @Override
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public File getSassDirectory() {
        return this.sassDir;
    }

    @Override
    public File getCssDirectory() {
        return this.cssDir;
    }
}

