/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.generator;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opoo.press.Generator;
import org.opoo.press.Page;
import org.opoo.press.Pager;
import org.opoo.press.Post;
import org.opoo.press.Renderer;
import org.opoo.press.Site;
import org.opoo.press.Tag;
import org.opoo.press.impl.AbstractConvertible;
import org.opoo.press.source.Source;
import org.opoo.util.URLUtils;

public class TagGenerator
implements Generator {
    @Override
    public int getOrder() {
        return 300;
    }

    @Override
    public void generate(Site site) {
        List<Tag> tags = site.getTags();
        String tagTitlePrefix = site.getConfig().get("tag_title_prefix", "");
        for (Tag tag : tags) {
            List<Post> posts = tag.getPosts();
            if (posts.isEmpty()) continue;
            Collections.sort(posts);
            Collections.reverse(posts);
            TagPage page = new TagPage(site);
            page.setTitle(tagTitlePrefix + tag.getName());
            page.setUrl(tag.getUrl());
            page.setPosts(posts);
            site.getPages().add(page);
        }
    }

    public static class TagPage
    extends AbstractConvertible
    implements Page {
        public static final String TEMPLATE = "category_index.ftl";
        private String url;
        private Renderer renderer;
        private Site site;
        private String content;
        private String title;
        private List<Post> posts;

        private TagPage(Site site) {
            this.site = site;
            this.renderer = site.getRenderer();
        }

        @Override
        public void render(Map<String, Object> rootMap) {
            rootMap = new HashMap<String, Object>(rootMap);
            this.mergeRootMap(rootMap);
            String output = this.getRenderer().render(TEMPLATE, rootMap);
            this.setContent(output);
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public Source getSource() {
            return null;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getPath() {
            return null;
        }

        @Override
        public String getLayout() {
            return "nil";
        }

        @Override
        public String getPermalink() {
            return null;
        }

        @Override
        public Date getDate() {
            return null;
        }

        @Override
        public Date getUpdated() {
            return null;
        }

        @Override
        public String getDateFormatted() {
            return null;
        }

        @Override
        public String getUpdatedFormatted() {
            return null;
        }

        @Override
        public Pager getPager() {
            return null;
        }

        @Override
        public void setPager(Pager pager) {
        }

        @Override
        public void setContent(String content) {
            this.content = content;
        }

        @Override
        public String getOutputFileExtension() {
            return ".html";
        }

        @Override
        protected Renderer getRenderer() {
            return this.renderer;
        }

        @Override
        protected void convert() {
        }

        @Override
        protected void mergeRootMap(Map<String, Object> rootMap) {
            rootMap.put("canonical", this.site.buildCanonical(this.getUrl()));
            rootMap.put("page", this);
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public List<Post> getPosts() {
            return this.posts;
        }

        public void setPosts(List<Post> posts) {
            this.posts = posts;
        }

        public boolean isFooter() {
            return false;
        }

        public boolean isSidebar() {
            return true;
        }

        @Override
        public Object get(String string) {
            return null;
        }

        @Override
        public File getOutputFile(File dest) {
            String url = this.getUrl() + "index.html";
            url = URLUtils.decodeURL(url);
            File target = new File(dest, url);
            return target;
        }

        public boolean isComments() {
            return false;
        }

        @Override
        public void set(String name, Object value) {
        }
    }
}

