/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.wagon.github;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.TypedResource;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.util.EncodingUtils;
import org.opoo.press.maven.wagon.github.GitHubException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHub {
    private static final Logger log = LoggerFactory.getLogger(GitHub.class);
    public static final String BRANCH_DEFAULT = "refs/heads/gh-pages";
    public static final String NO_JEKYLL_FILE = ".nojekyll";
    private String branch = "refs/heads/gh-pages";
    private String message;
    private String repositoryName;
    private String repositoryOwner;
    private String userName;
    private String password;
    private String oauth2Token;
    private String host;
    private String[] includes;
    private String[] excludes;
    private boolean force;
    private boolean noJekyll = true;
    private boolean merge;
    private boolean dryRun;
    private int numThreads = 1;

    public void setBranch(String branch) {
        if (!branch.startsWith("refs/heads/")) {
            branch = "refs/heads/" + branch;
        }
        this.branch = branch;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setRepositoryOwner(String repositoryOwner) {
        this.repositoryOwner = repositoryOwner;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setOauth2Token(String oauth2Token) {
        this.oauth2Token = oauth2Token;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setNoJekyll(boolean noJekyll) {
        this.noJekyll = noJekyll;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void deploy(File outputDirectory, String destinationDirectory) throws GitHubException {
        Commit created;
        RepositoryId repository = this.getRepository(this.repositoryOwner, this.repositoryName);
        if (this.dryRun) {
            log.info("Dry run mode, repository will not be modified");
        }
        String[] paths = this.getPaths(outputDirectory);
        String prefix = this.getPrefix(destinationDirectory);
        GitHubClient client = this.createClient(this.host, this.userName, this.password, this.oauth2Token);
        DataService service = new DataService(client);
        boolean createNoJekyll = this.noJekyll;
        if (createNoJekyll) {
            for (String path : paths) {
                if (!NO_JEKYLL_FILE.equals(path)) continue;
                createNoJekyll = false;
                break;
            }
        }
        ArrayList<TreeEntry> entries = new ArrayList<TreeEntry>(paths.length);
        if (this.numThreads <= 1) {
            this.createEntries(entries, prefix, paths, service, repository, outputDirectory);
        } else {
            this.createEntriesInThreads(entries, prefix, paths, service, repository, outputDirectory, this.numThreads);
        }
        if (createNoJekyll) {
            if (log.isDebugEnabled()) {
                log.debug("Creating empty '.nojekyll' blob at root of tree");
            }
            TreeEntry entry = this.createEntry("", NO_JEKYLL_FILE, service, repository, outputDirectory);
            entries.add(entry);
        }
        Reference ref = this.getReference(service, repository);
        if (this.dryRun) {
            log.debug("Dry run mode, skip deploy.");
            return;
        }
        Tree tree = this.createTree(service, repository, ref, entries);
        Commit commit = new Commit();
        commit.setMessage(this.message != null ? this.message : "GitHubWagon: Deploying OpooPress to GitHub Pages.");
        commit.setTree(tree);
        if (ref != null) {
            commit.setParents(Collections.singletonList(new Commit().setSha(ref.getObject().getSha())));
        }
        try {
            created = service.createCommit((IRepositoryIdProvider)repository, commit);
            log.info(MessageFormat.format("Creating commit with SHA-1: {0}", created.getSha()));
        }
        catch (IOException e) {
            throw new GitHubException("Error creating commit: " + e.getMessage(), e);
        }
        TypedResource object = new TypedResource();
        object.setType("commit").setSha(created.getSha());
        if (ref != null) {
            ref.setObject(object);
            try {
                log.info(String.format("Updating reference %s from %s to %s", this.branch, ((Commit)commit.getParents().get(0)).getSha(), created.getSha()));
                service.editReference((IRepositoryIdProvider)repository, ref, this.force);
            }
            catch (IOException e) {
                throw new GitHubException("Error editing reference: " + e.getMessage(), e);
            }
        }
        ref = new Reference().setObject(object).setRef(this.branch);
        try {
            log.info(MessageFormat.format("Creating reference {0} starting at commit {1}", this.branch, created.getSha()));
            service.createReference((IRepositoryIdProvider)repository, ref);
        }
        catch (IOException e) {
            throw new GitHubException("Error creating reference: " + e.getMessage(), e);
        }
    }

    private List<TreeEntry> createEntries(List<TreeEntry> entries, String prefix, String[] paths, DataService service, RepositoryId repository, File outputDirectory) throws GitHubException {
        for (String path : paths) {
            TreeEntry entry = this.createEntry(prefix, path, service, repository, outputDirectory);
            entries.add(entry);
        }
        return entries;
    }

    private List<TreeEntry> createEntriesInThreads(List<TreeEntry> entries, final String prefix, String[] paths, final DataService service, final RepositoryId repository, final File outputDirectory, int numThreads) throws GitHubException {
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        ExecutorCompletionService<TreeEntry> cs = new ExecutorCompletionService<TreeEntry>(threadPool);
        for (final String path : paths) {
            cs.submit(new Callable<TreeEntry>(){

                @Override
                public TreeEntry call() throws Exception {
                    return GitHub.this.createEntry(prefix, path, service, repository, outputDirectory);
                }
            });
        }
        try {
            for (int i = 0; i < paths.length; ++i) {
                entries.add((TreeEntry)cs.take().get());
            }
            log.info("All entries created: " + paths.length);
        }
        catch (InterruptedException e) {
            throw new GitHubException("", e);
        }
        catch (ExecutionException e) {
            throw new GitHubException("", e);
        }
        return entries;
    }

    private Tree createTree(DataService service, RepositoryId repository, Reference ref, List<TreeEntry> entries) throws GitHubException {
        try {
            int size = entries.size();
            log.info(String.format("Creating tree with %s blob entries", size));
            String baseTree = null;
            if (this.merge && ref != null) {
                Tree currentTree = service.getCommit((IRepositoryIdProvider)repository, ref.getObject().getSha()).getTree();
                if (currentTree != null) {
                    baseTree = currentTree.getSha();
                }
                log.info(MessageFormat.format("Merging with tree {0}", baseTree));
            }
            return service.createTree((IRepositoryIdProvider)repository, entries, baseTree);
        }
        catch (IOException e) {
            throw new GitHubException("Error creating tree: " + e.getMessage(), e);
        }
    }

    private Reference getReference(DataService service, RepositoryId repository) throws GitHubException {
        Reference ref = null;
        try {
            ref = service.getReference((IRepositoryIdProvider)repository, this.branch);
        }
        catch (RequestException e) {
            if (404 != e.getStatus()) {
                throw new GitHubException("Error getting reference: " + e.getMessage(), e);
            }
        }
        catch (IOException e) {
            throw new GitHubException("Error getting reference: " + e.getMessage(), e);
        }
        if (ref != null && !"commit".equals(ref.getObject().getType())) {
            throw new GitHubException(MessageFormat.format("Existing ref {0} points to a {1} ({2}) instead of a commmit", ref.getRef(), ref.getObject().getType(), ref.getObject().getSha()));
        }
        return ref;
    }

    private TreeEntry createEntry(String prefix, String path, DataService service, RepositoryId repository, File outputDirectory) throws GitHubException {
        TreeEntry entry = new TreeEntry();
        entry.setPath(prefix + path);
        entry.setType("blob");
        entry.setMode("100644");
        if (!this.dryRun) {
            entry.setSha(this.createBlob(service, repository, outputDirectory, path));
            log.info("" + path + " -> " + entry.getSha());
        }
        return entry;
    }

    private String getPrefix(String destinationDirectory) {
        String prefix = destinationDirectory;
        if (prefix == null) {
            prefix = "";
        }
        if ("./".equals(prefix)) {
            prefix = "";
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    private String createBlob(DataService service, RepositoryId repository, File outputDirectory, String path) throws GitHubException {
        try {
            Blob blob = new Blob().setEncoding("base64");
            if (NO_JEKYLL_FILE.equals(path)) {
                blob.setContent("");
            } else {
                File file = new File(outputDirectory, path);
                byte[] bytes = FileUtils.readFileToByteArray((File)file);
                String encoded = EncodingUtils.toBase64((byte[])bytes);
                blob.setContent(encoded);
            }
            if (log.isDebugEnabled()) {
                log.debug("Creating blob from " + path);
            }
            return service.createBlob((IRepositoryIdProvider)repository, blob);
        }
        catch (IOException e) {
            throw new GitHubException("Error creating blob from '" + path + "': " + e.getMessage(), e);
        }
    }

    private GitHubClient createClient(String host, String userName, String password, String oauth2Token) throws GitHubException {
        GitHubClient client;
        if (!StringUtils.isEmpty((String)host)) {
            if (log.isDebugEnabled()) {
                log.debug("Using custom host: " + host);
            }
            client = this.createClient(host);
        } else {
            client = new GitHubClient();
        }
        if (!StringUtils.isEmpty((String)userName) && !StringUtils.isEmpty((String)password)) {
            if (log.isDebugEnabled()) {
                log.debug("Using basic authentication with username: " + userName);
            }
            client.setCredentials(userName, password);
            return client;
        }
        if (!StringUtils.isEmpty((String)oauth2Token)) {
            if (log.isDebugEnabled()) {
                log.debug("Using OAuth2 access token authentication");
            }
            client.setOAuth2Token(oauth2Token);
            return client;
        }
        if (StringUtils.isEmpty((String)userName) && !StringUtils.isEmpty((String)password)) {
            if (log.isDebugEnabled()) {
                log.debug("Using OAuth2 access token authentication");
            }
            client.setOAuth2Token(password);
            return client;
        }
        if (!StringUtils.isEmpty((String)userName) && System.console() != null) {
            Console console = System.console();
            while (StringUtils.isEmpty((String)password)) {
                password = new String(console.readPassword("Input the password for '" + userName + "': ", new Object[0]));
            }
            client.setCredentials(userName, password);
            return client;
        }
        throw new GitHubException("No authentication credentials configured");
    }

    private GitHubClient createClient(String hostname) throws GitHubException {
        if (!hostname.contains("://")) {
            return new GitHubClient(hostname);
        }
        try {
            URL hostUrl = new URL(hostname);
            return new GitHubClient(hostUrl.getHost(), hostUrl.getPort(), hostUrl.getProtocol());
        }
        catch (MalformedURLException e) {
            throw new GitHubException("Could not parse host URL " + hostname, e);
        }
    }

    private RepositoryId getRepository(String owner, String name) throws GitHubException {
        RepositoryId repository = null;
        if (!StringUtils.isNotBlank((String)name) || !StringUtils.isNotBlank((String)owner)) {
            throw new GitHubException("No GitHub repository (owner and name) configured");
        }
        repository = RepositoryId.create((String)owner, (String)name);
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Using GitHub repository {0}", repository.generateId()));
        }
        return repository;
    }

    private String[] getPaths(File outputDirectory) {
        String baseDir = outputDirectory.getAbsolutePath();
        Object[] includePaths = GitHub.removeEmpties(this.includes);
        Object[] excludePaths = GitHub.removeEmpties(this.excludes);
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Scanning {0} and including {1} and exluding {2}", baseDir, Arrays.toString(includePaths), Arrays.toString(excludePaths)));
        }
        Object[] paths = GitHub.getMatchingPaths((String[])includePaths, (String[])excludePaths, baseDir);
        if ('\\' == File.separatorChar) {
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = paths[i].replace('\\', '/');
            }
        }
        if (paths.length != 1) {
            log.info(MessageFormat.format("Creating {0} blobs", paths.length));
        } else {
            log.info("Creating 1 blob");
        }
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Scanned files to include: {0}", Arrays.toString(paths)));
        }
        return paths;
    }

    public static String[] removeEmpties(String ... values) {
        if (values == null || values.length == 0) {
            return new String[0];
        }
        ArrayList<String> validValues = new ArrayList<String>();
        for (String value : values) {
            if (value == null || value.length() <= 0) continue;
            validValues.add(value);
        }
        return validValues.toArray(new String[validValues.size()]);
    }

    public static String[] getMatchingPaths(String[] includes, String[] excludes, String baseDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        if (includes != null && includes.length > 0) {
            scanner.setIncludes(includes);
        }
        if (excludes != null && excludes.length > 0) {
            scanner.setExcludes(excludes);
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

