/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.plugins.plugin;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.opoo.press.Site;
import org.opoo.press.SiteManager;
import org.opoo.press.importer.ImportException;
import org.opoo.press.maven.plugins.plugin.AbstractInstallMojo;

public class ImportMojo
extends AbstractInstallMojo {
    private String importerName;

    @Override
    protected void afterInstall(SiteManager siteManager, File siteDir) throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isBlank((String)this.importerName)) {
            throw new MojoFailureException("importer name is required, e.g. -Dimporter=wordpress");
        }
        HashMap<String, String> props = new HashMap<String, String>();
        Properties properties = System.getProperties();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            if (value == null) continue;
            props.put(name, value);
        }
        try {
            Site site = siteManager.createSite(siteDir);
            siteManager.doImport(site, this.importerName, props);
        }
        catch (ImportException e) {
            throw new MojoFailureException(e.getMessage());
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage());
        }
    }
}

