/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.plugins.plugin;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.opoo.press.Site;
import org.opoo.press.maven.plugins.plugin.AbstractDeployMojo;
import org.opoo.util.ChainingClassLoader;

public class DeployMojo
extends AbstractDeployMojo
implements Contextualizable {
    private boolean chmod;
    private String chmodMode;
    private String chmodOptions;
    private WagonManager wagonManager;
    private Settings settings;
    private PlexusContainer container;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deploy(Site site, File directory, Repository repository) throws MojoExecutionException {
        Wagon wagon = DeployMojo.getWagon(repository, this.wagonManager);
        try {
            DeployMojo.configureWagon(wagon, repository.getId(), this.settings, this.container, this.getLog());
        }
        catch (WagonConfigurationException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        String relativeDir = site.getRoot();
        if ("".equals(relativeDir)) {
            relativeDir = "./";
        } else if (relativeDir.startsWith("/")) {
            relativeDir = relativeDir.substring(1);
        }
        try {
            ProxyInfo proxyInfo = DeployMojo.getProxyInfo(repository, this.wagonManager);
            DeployMojo.push(directory, repository, this.wagonManager, wagon, proxyInfo, relativeDir, this.getLog());
            if (this.chmod) {
                DeployMojo.chmod(wagon, repository, this.chmodOptions, this.chmodMode);
            }
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }

    private static void configureScpWagonIfRequired(Wagon wagon, Log log) {
        log.debug((CharSequence)("configureScpWagonIfRequired: " + wagon.getClass().getName()));
        if (System.console() == null) {
            log.debug((CharSequence)"No System.console(), skip configure Wagon");
            return;
        }
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = DeployMojo.class.getClassLoader();
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        loaders.add(wagon.getClass().getClassLoader());
        ChainingClassLoader loader = new ChainingClassLoader(parent, loaders);
        Class scpWagonClass = null;
        try {
            scpWagonClass = ClassUtils.getClass((ClassLoader)loader, (String)"org.apache.maven.wagon.providers.ssh.jsch.ScpWagon");
        }
        catch (ClassNotFoundException e) {
            log.debug((CharSequence)"Class 'org.apache.maven.wagon.providers.ssh.jsch.ScpWagon' not found, skip configure Wagon.");
            return;
        }
        if (scpWagonClass.isInstance(wagon)) {
            try {
                Class userInfoClass = ClassUtils.getClass((ClassLoader)loader, (String)"org.opoo.press.maven.plugins.plugin.ssh.SystemConsoleInteractiveUserInfo");
                Object userInfo = userInfoClass.newInstance();
                MethodUtils.invokeMethod((Object)wagon, (String)"setInteractiveUserInfo", userInfo);
                log.debug((CharSequence)"ScpWagon using SystemConsoleInteractiveUserInfo(Java 6+).");
            }
            catch (ClassNotFoundException e) {
                log.debug((CharSequence)"Class 'org.opoo.press.maven.plugins.plugin.ssh.SystemConsoleInteractiveUserInfo' not found, skip configure Wagon.");
            }
            catch (InstantiationException e) {
                log.debug((CharSequence)"Instantiate class exception", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.debug((CharSequence)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.debug((CharSequence)e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.debug((CharSequence)e.getMessage(), (Throwable)e);
            }
        } else {
            log.debug((CharSequence)"Not a ScpWagon.");
        }
    }

    private static Wagon getWagon(Repository repository, WagonManager manager) throws MojoExecutionException {
        Wagon wagon;
        try {
            wagon = manager.getWagon(repository);
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Unsupported protocol: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        catch (WagonConfigurationException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        if (!wagon.supportsDirectoryCopy()) {
            throw new MojoExecutionException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying");
        }
        return wagon;
    }

    private static void push(File inputDirectory, Repository repository, WagonManager manager, Wagon wagon, ProxyInfo proxyInfo, String relativeDir, Log log) throws MojoExecutionException {
        AuthenticationInfo authenticationInfo = manager.getAuthenticationInfo(repository.getId());
        log.debug((CharSequence)("authenticationInfo with id '" + repository.getId() + "': " + (authenticationInfo == null ? "-" : authenticationInfo.getUserName())));
        try {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
            if (proxyInfo != null) {
                log.debug((CharSequence)"connect with proxyInfo");
                wagon.connect(repository, authenticationInfo, proxyInfo);
            } else if (proxyInfo == null && authenticationInfo != null) {
                log.debug((CharSequence)"connect with authenticationInfo and without proxyInfo");
                wagon.connect(repository, authenticationInfo);
            } else {
                log.debug((CharSequence)"connect without authenticationInfo and without proxyInfo");
                wagon.connect(repository);
            }
            log.info((CharSequence)("Pushing " + inputDirectory));
            log.info((CharSequence)("   >>> to " + repository.getUrl() + relativeDir));
            wagon.putDirectory(inputDirectory, relativeDir);
        }
        catch (ResourceDoesNotExistException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (AuthorizationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
    }

    private static void chmod(Wagon wagon, Repository repository, String chmodOptions, String chmodMode) throws MojoExecutionException {
        try {
            if (wagon instanceof CommandExecutor) {
                CommandExecutor exec = (CommandExecutor)wagon;
                exec.executeCommand("chmod " + chmodOptions + " " + chmodMode + " " + repository.getBasedir());
            }
        }
        catch (CommandExecutionException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
    }

    private static void configureWagon(Wagon wagon, String repositoryId, Settings settings, PlexusContainer container, Log log) throws WagonConfigurationException {
        log.debug((CharSequence)" configureWagon ");
        DeployMojo.configureLog(wagon, log);
        DeployMojo.configureScpWagonIfRequired(wagon, log);
        for (Object o : settings.getServers()) {
            Server server = (Server)o;
            String id = server.getId();
            log.debug((CharSequence)("configureWagon server " + id));
            if (id == null || !id.equals(repositoryId) || server.getConfiguration() == null) continue;
            XmlPlexusConfiguration plexusConf = new XmlPlexusConfiguration((Xpp3Dom)server.getConfiguration());
            ComponentConfigurator componentConfigurator = null;
            try {
                componentConfigurator = (ComponentConfigurator)container.lookup(ComponentConfigurator.ROLE);
                componentConfigurator.configureComponent((Object)wagon, (PlexusConfiguration)plexusConf, container.getContainerRealm());
            }
            catch (ComponentLookupException e) {
                throw new WagonConfigurationException(repositoryId, "Unable to lookup wagon configurator. Wagon configuration cannot be applied.", (Throwable)e);
            }
            catch (ComponentConfigurationException e) {
                throw new WagonConfigurationException(repositoryId, "Unable to apply wagon configuration.", (Throwable)e);
            }
            finally {
                if (componentConfigurator == null) continue;
                try {
                    container.release((Object)componentConfigurator);
                }
                catch (ComponentLifecycleException e) {
                    log.error((CharSequence)("Problem releasing configurator - ignoring: " + e.getMessage()));
                }
            }
        }
    }

    private static void configureLog(Wagon wagon, Log log) {
        try {
            Method method = wagon.getClass().getMethod("setLog", Log.class);
            method.invoke((Object)wagon, log);
            log.info((CharSequence)("Set log for wagon: " + wagon));
        }
        catch (Exception e) {
            log.debug((CharSequence)"Wagon does not supports setLog() method.");
        }
    }

    public static ProxyInfo getProxyInfo(Repository repository, WagonManager wagonManager) {
        ProxyInfo proxyInfo = wagonManager.getProxy(repository.getProtocol());
        if (proxyInfo == null) {
            return null;
        }
        String host = repository.getHost();
        String nonProxyHostsAsString = proxyInfo.getNonProxyHosts();
        for (String nonProxyHost : org.codehaus.plexus.util.StringUtils.split((String)nonProxyHostsAsString, (String)",;|")) {
            if (StringUtils.contains((String)nonProxyHost, (String)"*")) {
                int pos = nonProxyHost.indexOf(42);
                String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                if (org.codehaus.plexus.util.StringUtils.isNotEmpty((String)nonProxyHostPrefix) && host.startsWith(nonProxyHostPrefix) && org.codehaus.plexus.util.StringUtils.isEmpty((String)nonProxyHostSuffix)) {
                    return null;
                }
                if (org.codehaus.plexus.util.StringUtils.isEmpty((String)nonProxyHostPrefix) && org.codehaus.plexus.util.StringUtils.isNotEmpty((String)nonProxyHostSuffix) && host.endsWith(nonProxyHostSuffix)) {
                    return null;
                }
                if (!org.codehaus.plexus.util.StringUtils.isNotEmpty((String)nonProxyHostPrefix) || !host.startsWith(nonProxyHostPrefix) || !org.codehaus.plexus.util.StringUtils.isNotEmpty((String)nonProxyHostSuffix) || !host.endsWith(nonProxyHostSuffix)) continue;
                return null;
            }
            if (!host.equals(nonProxyHost)) continue;
            return null;
        }
        return proxyInfo;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

