/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.plugins.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.opoo.press.CompassConfig;
import org.opoo.press.SiteManager;
import org.opoo.press.maven.plugins.plugin.AbstractInstallMojo;
import org.opoo.press.support.Compass;
import org.opoo.press.util.StaleUtils;

public class AbstractSassCompileMojo
extends AbstractInstallMojo {
    protected boolean skipSassCompile = false;

    @Override
    protected final void afterInstall(SiteManager siteManager, File siteDir) throws MojoExecutionException, MojoFailureException {
        if (this.skipSassCompile) {
            this.getLog().info((CharSequence)"op.sass.compile.skip = true: Skipping sass compile");
        } else if (!new File(siteDir, "config.rb").exists()) {
            this.getLog().warn((CharSequence)"Compass/sass config file not exists, skipping sass compile");
            this.skipSassCompile = true;
        } else if (this.skipSassCompile(siteManager, siteDir)) {
            this.getLog().info((CharSequence)"Skipping sass compile, css file is up to date.");
        } else {
            new Compass(siteDir).compile();
        }
        this.afterSassCompile(siteManager, siteDir);
    }

    protected void afterSassCompile(SiteManager siteManager, File siteDir) throws MojoExecutionException, MojoFailureException {
    }

    private boolean skipSassCompile(SiteManager siteManager, File siteDir) {
        CompassConfig compassConfig = siteManager.createCompassConfig(siteDir);
        boolean compassStale = StaleUtils.isCompassStale((CompassConfig)compassConfig);
        return !compassStale;
    }
}

