/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.plugins.plugin;

import java.io.File;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.opoo.press.SiteManager;
import org.opoo.press.maven.plugins.plugin.AbstractPressMojo;

public abstract class AbstractInstallMojo
extends AbstractPressMojo {
    protected String locale = Locale.getDefault().toString();
    protected boolean createSamplePost = true;
    protected boolean skipInstall = false;

    @Override
    protected final void execute(SiteManager siteManager, File siteDir) throws MojoExecutionException, MojoFailureException {
        if (this.skipInstall) {
            this.getLog().info((CharSequence)"op.install.skip = true: Skipping install");
        } else if (this.skipInstall(siteManager, siteDir)) {
            this.getLog().info((CharSequence)"Skipping install, site already installed.");
        } else {
            Locale loc = Locale.getDefault();
            if (StringUtils.isNotEmpty((String)this.locale)) {
                loc = LocaleUtils.toLocale((String)this.locale);
            }
            this.getLog().info((CharSequence)"Installing site...");
            try {
                siteManager.install(siteDir, loc, this.createSamplePost);
            }
            catch (Exception e) {
                throw new MojoFailureException(e.getMessage());
            }
        }
        this.afterInstall(siteManager, siteDir);
    }

    private boolean skipInstall(SiteManager siteManager, File siteDir) {
        return siteDir.exists() && siteDir.isDirectory();
    }

    protected void afterInstall(SiteManager siteManager, File siteDir) throws MojoExecutionException, MojoFailureException {
    }
}

