/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.plugins.plugin;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.wagon.repository.Repository;
import org.opoo.press.Site;
import org.opoo.press.SiteConfig;
import org.opoo.press.SiteManager;
import org.opoo.press.maven.plugins.plugin.AbstractGenerateMojo;

public abstract class AbstractDeployMojo
extends AbstractGenerateMojo {
    private boolean skipDeploy;

    @Override
    protected boolean showDrafts() {
        return false;
    }

    @Override
    protected void afterGenerate(SiteManager siteManager, File siteDir, Site site) throws MojoExecutionException, MojoFailureException {
        if (this.skipDeploy) {
            this.getLog().info((CharSequence)"op.deploy.skip = true: Skipping deployment");
            return;
        }
        File destination = site.getDestination();
        this.getLog().info((CharSequence)("Destination [" + destination + "]"));
        this.getLog().info((CharSequence)("Site root [" + site.getRoot() + "]"));
        if (!destination.exists()) {
            throw new MojoExecutionException("The site does not exist, please run mvn op:generate first");
        }
        this.deploy(site, destination);
    }

    protected void deploy(Site site, File destination) throws MojoExecutionException, MojoFailureException {
        Repository repository = this.getRepository(site);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Deploying to '" + repository.getUrl() + "',\n    Using credentials from server id '" + repository.getId() + "'"));
        }
        this.deploy(site, destination, repository);
    }

    protected void deploy(Site site, File destination, Repository repository) throws MojoExecutionException, MojoFailureException {
        throw new UnsupportedOperationException("deploy(File, Repository)");
    }

    private Repository getRepository(Site site) throws MojoExecutionException, MojoFailureException {
        SiteConfig config = site.getConfig();
        Object server = config.get("deploy_server");
        if (server == null) {
            throw new MojoFailureException("Deploy server not found in config.yml");
        }
        String serverId = null;
        Map repo = null;
        if (server instanceof Map) {
            repo = (Map)server;
        } else if (server instanceof String) {
            serverId = (String)server;
            repo = (Map)config.get(serverId);
            if (repo == null) {
                throw new MojoFailureException("Deploy server not found: " + server);
            }
        } else {
            throw new MojoFailureException("Deploy server not found in config.yml");
        }
        String id = (String)repo.get("id");
        String url = (String)repo.get("url");
        if (id == null) {
            id = serverId;
        }
        if (id == null || url == null) {
            throw new MojoFailureException("Deploy server configuration must contains 'id' and 'url': " + server);
        }
        Properties props = new Properties();
        for (String key : repo.keySet()) {
            if ("id".equals(key) || "url".equals(key)) continue;
            props.setProperty(key, (String)repo.get(key));
        }
        Repository repository = new Repository(id, AbstractDeployMojo.appendSlash(url));
        if (!props.isEmpty()) {
            repository.setParameters(props);
        }
        return repository;
    }

    static String appendSlash(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return url + "/";
    }
}

