/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.source.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.opoo.press.source.Source;
import org.opoo.press.source.SourceEntry;

public class CachedSource
implements Source {
    private final Map<String, Object> frontMatter;
    private final File contentFile;
    private final SourceEntry sourceEntry;

    CachedSource(SourceEntry sourceEntry, Map<String, Object> frontMatter, String content) {
        this.frontMatter = frontMatter;
        this.sourceEntry = sourceEntry;
        FileOutputStream stream = null;
        try {
            this.contentFile = File.createTempFile("CachedSource", ".bin");
            stream = new FileOutputStream(this.contentFile);
            IOUtils.write((String)content, (OutputStream)stream, (String)"UTF-8");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)stream);
    }

    CachedSource(SourceEntry sourceEntry, Map<String, Object> frontMatter, List<String> contentLines) {
        this.frontMatter = frontMatter;
        this.sourceEntry = sourceEntry;
        FileOutputStream stream = null;
        try {
            this.contentFile = File.createTempFile("PageSourceContent", ".bin");
            stream = new FileOutputStream(this.contentFile);
            IOUtils.writeLines(contentLines, null, (OutputStream)stream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)stream);
    }

    @Override
    public SourceEntry getSourceEntry() {
        return this.sourceEntry;
    }

    @Override
    public Map<String, Object> getMeta() {
        return this.frontMatter;
    }

    @Override
    public String getContent() {
        String string;
        FileReader reader = null;
        try {
            reader = new FileReader(this.contentFile);
            string = IOUtils.toString((Reader)reader);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }
}

