/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.nimbus;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class State<T extends JComponent> {
    static final Map<String, StandardState> standardStates = new HashMap<String, StandardState>(7);
    static final State Enabled = new StandardState(1);
    static final State MouseOver = new StandardState(2);
    static final State Pressed = new StandardState(4);
    static final State Disabled = new StandardState(8);
    static final State Focused = new StandardState(256);
    static final State Selected = new StandardState(512);
    static final State Default = new StandardState(1024);
    private String name;

    protected State(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    boolean isInState(T t, int n) {
        return this.isInState(t);
    }

    protected abstract boolean isInState(T var1);

    String getName() {
        return this.name;
    }

    static boolean isStandardStateName(String string) {
        return standardStates.containsKey(string);
    }

    static StandardState getStandardState(String string) {
        return standardStates.get(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StandardState
    extends State<JComponent> {
        private int state;

        private StandardState(int n) {
            super(StandardState.toString(n));
            this.state = n;
            standardStates.put(this.getName(), this);
        }

        public int getState() {
            return this.state;
        }

        @Override
        boolean isInState(JComponent jComponent, int n) {
            return (n & this.state) == this.state;
        }

        @Override
        protected boolean isInState(JComponent jComponent) {
            throw new AssertionError((Object)"This method should never be called");
        }

        private static String toString(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            if ((n & 0x400) == 1024) {
                stringBuffer.append("Default");
            }
            if ((n & 8) == 8) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append("Disabled");
            }
            if ((n & 1) == 1) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append("Enabled");
            }
            if ((n & 0x100) == 256) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append("Focused");
            }
            if ((n & 2) == 2) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append("MouseOver");
            }
            if ((n & 4) == 4) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append("Pressed");
            }
            if ((n & 0x200) == 512) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("+");
                }
                stringBuffer.append("Selected");
            }
            return stringBuffer.toString();
        }
    }
}

