/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.wagon.git;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Random;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.opoo.press.maven.wagon.git.Git;

public class GitWagon
extends AbstractWagon {
    private boolean safeCheckout = "true".equals(System.getProperty("wagon.git.safe.checkout", "true"));
    private File checkoutDirectory;

    public GitWagon() {
        this.fireSessionDebug("wagon.git.safe.checkout: " + this.safeCheckout);
    }

    public File getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        this.fireGetStarted(resource, destination);
        try {
            File remote = new File(this.checkoutDirectory, resourceName);
            if (remote.exists()) {
                this.transfer(resource, new FileInputStream(remote), new FileOutputStream(destination), 5);
            }
        }
        catch (Exception e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException("Unable to get file", (Throwable)e);
        }
        this.fireGetCompleted(resource, destination);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("Not currently supported: getIfNewer");
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (source.isDirectory()) {
            throw new IllegalArgumentException("Source is a directory: " + source);
        }
        String resourceName = FilenameUtils.separatorsToUnix((String)destination);
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        this.firePutStarted(resource, source);
        try {
            File file = new File(this.checkoutDirectory, destination);
            file.getParentFile().mkdirs();
            this.transfer(resource, source, new FileOutputStream(file), true);
        }
        catch (Exception e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException("Unable to put file", (Throwable)e);
        }
        this.firePutCompleted(resource, source);
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        if (this.checkoutDirectory == null) {
            this.checkoutDirectory = this.createCheckoutDirectory();
        }
        if (this.checkoutDirectory.exists() && this.safeCheckout) {
            this.removeCheckoutDirectory();
        }
        this.checkoutDirectory.mkdirs();
    }

    protected void closeConnection() throws ConnectionException {
        if (this.safeCheckout) {
            this.removeCheckoutDirectory();
        }
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (!sourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("Source is not a directory: " + sourceDirectory);
        }
        String resourceName = FilenameUtils.separatorsToUnix((String)destinationDirectory);
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, sourceDirectory);
        this.firePutStarted(resource, sourceDirectory);
        Repository repo = this.getRepository();
        String url = repo.getUrl();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        String remote = url.substring(4);
        String branch = repo.getParameter("branch");
        String message = repo.getParameter("message");
        if (branch == null) {
            branch = "master";
        }
        try {
            Git git = new Git(this.checkoutDirectory, remote, branch);
            if (message != null) {
                git.setMessage(message);
            }
            if (this.safeCheckout) {
                git.cloneAll();
            } else {
                git.pullAll();
            }
            FileUtils.copyDirectoryStructure((File)sourceDirectory, (File)new File(this.checkoutDirectory, destinationDirectory));
            git.pushAll();
        }
        catch (Exception e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException("Unable to put file", (Throwable)e);
        }
        this.firePutCompleted(resource, sourceDirectory);
    }

    private void removeCheckoutDirectory() throws ConnectionException {
        if (this.checkoutDirectory == null) {
            return;
        }
        try {
            FileUtils.deleteDirectory((File)this.checkoutDirectory);
        }
        catch (IOException e) {
            throw new ConnectionException("Unable to cleanup checkout directory", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createCheckoutDirectory() {
        Random rand;
        if (!this.safeCheckout) {
            String url = this.getRepository().getUrl();
            try {
                return new File(System.getProperty("java.io.tmpdir"), "wagon-git-" + GitWagon.md5(url));
            }
            catch (Exception e) {
                this.fireSessionDebug("Create static checkout directory for '" + url + "' error, try create random directory again.");
                this.safeCheckout = true;
            }
        }
        File checkoutDirectory = null;
        DecimalFormat fmt = new DecimalFormat("#####");
        Random random = rand = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
        synchronized (random) {
            while ((checkoutDirectory = new File(System.getProperty("java.io.tmpdir"), "wagon-git" + fmt.format(Math.abs(rand.nextInt())) + ".checkout")).exists()) {
            }
        }
        return checkoutDirectory;
    }

    private static String md5(String input) throws NoSuchAlgorithmException {
        MessageDigest mDigest = MessageDigest.getInstance("MD5");
        byte[] result = mDigest.digest(input.getBytes());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            sb.append(Integer.toString((result[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

