/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.wagon.git;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.opoo.press.maven.wagon.git.GitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Git {
    private static final Logger log = LoggerFactory.getLogger(Git.class);
    private final File workingDirectory;
    private final String remote;
    private final String branch;
    private String message;
    private final CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer(){

        public void consumeLine(String line) {
            log.info("[git] " + line);
        }
    };
    private final CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer(){

        public void consumeLine(String line) {
            log.info("[git] " + line);
        }
    };

    public Git(File workingDirectory, String remote, String branch) throws GitException {
        this.remote = remote;
        this.branch = branch;
        this.workingDirectory = workingDirectory;
        if (!workingDirectory.exists()) {
            throw new GitException("Invalid directory");
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private boolean execute(String command, String ... args) throws GitException {
        int exitCode;
        Commandline cl = new Commandline();
        cl.setExecutable("git");
        cl.createArg().setValue(command);
        cl.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        for (int i = 0; i < args.length; ++i) {
            cl.createArg().setValue(args[i]);
        }
        if (log.isInfoEnabled()) {
            log.info("[" + cl.getWorkingDirectory().getAbsolutePath() + "] Executing: " + cl);
        }
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)this.stdout, (StreamConsumer)this.stderr);
        }
        catch (CommandLineException e) {
            throw new GitException("Error while executing command.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Run: " + cl + " / $? = " + exitCode);
        }
        return exitCode == 0;
    }

    private boolean isValidGitRepository() {
        return new File(this.workingDirectory, ".git").exists();
    }

    public void cloneAll() throws GitException {
        if (!this.execute("clone", this.remote, this.workingDirectory.getAbsolutePath())) {
            throw new GitException("git clone failed");
        }
        if ("master".equals(this.branch) ? !this.execute("checkout", new String[0]) : !this.execute("checkout", this.branch)) {
            throw new GitException("git checkout failed");
        }
        if (!this.execute("ls-files", new String[0])) {
            throw new GitException("git ls-files failed");
        }
    }

    public void pullAll() throws GitException {
        if (!this.isValidGitRepository()) {
            if (!this.execute("init", new String[0])) {
                throw new GitException("git init failed");
            }
            if (!this.execute("remote", "add", "origin", this.remote)) {
                log.warn("git remote add failed, try git remote set-url");
                if (!this.execute("remote", "set-url", "origin", this.remote)) {
                    throw new GitException("git remote failed");
                }
            }
            if (!this.execute("fetch", "--progress")) {
                throw new GitException("git fetch failed");
            }
        }
        if (!this.execute("show-ref", "refs/remotes/origin/" + this.branch)) {
            if (!this.execute("symbolic-ref", "HEAD", "refs/heads/" + this.branch)) {
                throw new GitException("Unable to create branch");
            }
            File index = new File(this.workingDirectory, ".git/index");
            if (index.exists() && !index.delete()) {
                throw new GitException("Unable to create branch");
            }
            if (!this.execute("clean", "-fdx")) {
                throw new GitException("Unable to create branch");
            }
        } else if (!this.execute("show-ref", "refs/heads/" + this.branch) ? !this.execute("checkout", "-b", this.branch, "origin/" + this.branch) : !this.execute("checkout", this.branch)) {
            throw new GitException("Unable to checkout branch");
        }
    }

    public void pushAll() throws GitException {
        if (!this.execute("add", ".")) {
            throw new GitException("Unable to add files");
        }
        if (this.message == null) {
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            this.message = "GitWagon: Deploying OpooPress to branch " + this.branch + " at " + timestamp;
        }
        if (!this.execute("commit", "--allow-empty", "-m", this.message)) {
            throw new GitException("Unable to commit files");
        }
        if (!this.execute("push", "--progress", "origin", this.branch)) {
            throw new GitException("Unable to push files");
        }
    }
}

