/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.opto;

import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.InheritedCacheCompiler;
import org.jruby.compiler.impl.InvokeDynamicCacheCompiler;
import org.jruby.compiler.impl.InvokeDynamicInvocationCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.runtime.opto.FailoverSwitchPointInvalidator;
import org.jruby.runtime.opto.GenerationAndSwitchPointInvalidator;
import org.jruby.runtime.opto.GenerationInvalidator;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.ObjectIdentityInvalidator;
import org.jruby.runtime.opto.SwitchPointInvalidator;
import org.jruby.util.cli.Options;

public class OptoFactory {
    public static boolean tryIndy = Options.COMPILE_INVOKEDYNAMIC.load();

    public static InvocationCompiler newInvocationCompiler(BaseBodyCompiler bodyCompiler, SkinnyMethodAdapter method2) {
        if (tryIndy) {
            try {
                return new InvokeDynamicInvocationCompiler(bodyCompiler, method2);
            }
            catch (Error e) {
                tryIndy = false;
                throw e;
            }
            catch (Throwable t) {
                tryIndy = false;
            }
        }
        return new StandardInvocationCompiler(bodyCompiler, method2);
    }

    public static CacheCompiler newCacheCompiler(StandardASMCompiler scriptCompiler) {
        if (tryIndy) {
            try {
                return new InvokeDynamicCacheCompiler(scriptCompiler);
            }
            catch (Error e) {
                tryIndy = false;
                throw e;
            }
            catch (Throwable t) {
                tryIndy = false;
            }
        }
        return new InheritedCacheCompiler(scriptCompiler);
    }

    public static Invalidator newConstantInvalidator() {
        if (tryIndy && Options.COMPILE_INVOKEDYNAMIC.load().booleanValue() && RubyInstanceConfig.INVOKEDYNAMIC_CONSTANTS) {
            try {
                return new SwitchPointInvalidator();
            }
            catch (Error e) {
                tryIndy = false;
                throw e;
            }
            catch (Throwable t) {
                tryIndy = false;
            }
        }
        return new ObjectIdentityInvalidator();
    }

    public static Invalidator newGlobalInvalidator(int maxFailures) {
        if (tryIndy && Options.COMPILE_INVOKEDYNAMIC.load().booleanValue() && RubyInstanceConfig.INVOKEDYNAMIC_CONSTANTS) {
            try {
                return new FailoverSwitchPointInvalidator(maxFailures);
            }
            catch (Error e) {
                tryIndy = false;
                throw e;
            }
            catch (Throwable t) {
                tryIndy = false;
            }
        }
        return new ObjectIdentityInvalidator();
    }

    public static Invalidator newMethodInvalidator(RubyModule module) {
        if (tryIndy && Options.COMPILE_INVOKEDYNAMIC.load().booleanValue() && RubyInstanceConfig.INVOKEDYNAMIC_INVOCATION_SWITCHPOINT) {
            try {
                return new GenerationAndSwitchPointInvalidator(module);
            }
            catch (Error e) {
                tryIndy = false;
                throw e;
            }
            catch (Throwable t) {
                tryIndy = false;
            }
        }
        return new GenerationInvalidator(module);
    }
}

