/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.encoding;

import java.io.Console;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jruby.Ruby;
import org.jruby.RubyConverter;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.exceptions.MainExitException;
import org.jruby.ext.nkf.RubyNKF;
import org.jruby.platform.Platform;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public final class EncodingService {
    private final CaseInsensitiveBytesHash<EncodingDB.Entry> encodings;
    private final CaseInsensitiveBytesHash<EncodingDB.Entry> aliases;
    private final IRubyObject[] encodingList;
    private RubyEncoding[] encodingIndex = new RubyEncoding[4];
    private final Ruby runtime;
    private final Encoding ascii8bit;
    private final Encoding javaDefault;
    private static final ByteList LOCALE_BL = ByteList.create((CharSequence)"locale");
    private static final ByteList EXTERNAL_BL = ByteList.create((CharSequence)"external");
    private static final ByteList INTERNAL_BL = ByteList.create((CharSequence)"internal");
    private static final ByteList FILESYSTEM_BL = ByteList.create((CharSequence)"filesystem");

    public EncodingService(Ruby runtime) {
        this.runtime = runtime;
        this.encodings = EncodingDB.getEncodings();
        this.aliases = EncodingDB.getAliases();
        this.ascii8bit = ((EncodingDB.Entry)this.encodings.get("ASCII-8BIT".getBytes())).getEncoding();
        Charset javaDefaultCharset = Charset.defaultCharset();
        ByteList javaDefaultBL = new ByteList(javaDefaultCharset.name().getBytes());
        EncodingDB.Entry javaDefaultEntry = this.findEncodingOrAliasEntry(javaDefaultBL);
        this.javaDefault = javaDefaultEntry == null ? this.ascii8bit : javaDefaultEntry.getEncoding();
        this.encodingList = new IRubyObject[this.encodings.size()];
        if (runtime.is1_9()) {
            Encoding loadedEncoding;
            RubyEncoding.createEncodingClass(runtime);
            RubyConverter.createConverterClass(runtime);
            this.defineEncodings();
            this.defineAliases();
            String encoding2 = runtime.getInstanceConfig().getExternalEncoding();
            if (encoding2 != null && !encoding2.equals("")) {
                loadedEncoding = this.loadEncoding(ByteList.create((CharSequence)encoding2));
                if (loadedEncoding == null) {
                    throw new MainExitException(1, "unknown encoding name - " + encoding2);
                }
                runtime.setDefaultExternalEncoding(loadedEncoding);
            } else {
                Encoding consoleEncoding = this.getConsoleEncoding();
                Encoding availableEncoding = consoleEncoding == null ? this.getLocaleEncoding() : consoleEncoding;
                runtime.setDefaultExternalEncoding(availableEncoding);
            }
            encoding2 = runtime.getInstanceConfig().getInternalEncoding();
            if (encoding2 != null && !encoding2.equals("")) {
                loadedEncoding = this.loadEncoding(ByteList.create((CharSequence)encoding2));
                if (loadedEncoding == null) {
                    throw new MainExitException(1, "unknown encoding name - " + encoding2);
                }
                runtime.setDefaultInternalEncoding(loadedEncoding);
            }
        }
    }

    private Encoding getConsoleEncoding() {
        if (!Platform.IS_WINDOWS) {
            return null;
        }
        Encoding consoleEncoding = null;
        try {
            Console console = System.console();
            if (console != null) {
                String CONSOLE_CHARSET = "cs";
                Field fcs = Console.class.getDeclaredField("cs");
                fcs.setAccessible(true);
                Charset cs = (Charset)fcs.get(console);
                consoleEncoding = this.loadEncoding(ByteList.create((CharSequence)cs.name()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return consoleEncoding;
    }

    public Encoding getUSAsciiEncoding() {
        return USASCIIEncoding.INSTANCE;
    }

    public Encoding getAscii8bitEncoding() {
        return this.ascii8bit;
    }

    public Encoding getFileSystemEncoding(Ruby runtime) {
        return SpecialEncoding.FILESYSTEM.toEncoding(runtime);
    }

    public CaseInsensitiveBytesHash<EncodingDB.Entry> getEncodings() {
        return this.encodings;
    }

    public CaseInsensitiveBytesHash<EncodingDB.Entry> getAliases() {
        return this.aliases;
    }

    public EncodingDB.Entry findEncodingEntry(ByteList bytes2) {
        return (EncodingDB.Entry)this.encodings.get(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public EncodingDB.Entry findAliasEntry(ByteList bytes2) {
        return (EncodingDB.Entry)this.aliases.get(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public EncodingDB.Entry findEncodingOrAliasEntry(ByteList bytes2) {
        EncodingDB.Entry e = this.findEncodingEntry(bytes2);
        return e != null ? e : this.findAliasEntry(bytes2);
    }

    public Encoding getLocaleEncoding() {
        EncodingDB.Entry entry = this.findEncodingOrAliasEntry(new ByteList(Charset.defaultCharset().name().getBytes()));
        return entry == null ? ASCIIEncoding.INSTANCE : entry.getEncoding();
    }

    public IRubyObject[] getEncodingList() {
        return this.encodingList;
    }

    public Encoding loadEncoding(ByteList name2) {
        EncodingDB.Entry entry = this.findEncodingOrAliasEntry(name2);
        if (entry == null) {
            return null;
        }
        Encoding enc = entry.getEncoding();
        int index2 = enc.getIndex();
        if (index2 >= this.encodingIndex.length) {
            RubyEncoding[] tmp = new RubyEncoding[index2 + 4];
            System.arraycopy(this.encodingIndex, 0, tmp, 0, this.encodingIndex.length);
            this.encodingIndex = tmp;
        }
        this.encodingIndex[index2] = (RubyEncoding)this.encodingList[entry.getIndex()];
        return enc;
    }

    public RubyEncoding getEncoding(Encoding enc) {
        RubyEncoding rubyEncoding;
        int index2 = enc.getIndex();
        if (index2 < this.encodingIndex.length && (rubyEncoding = this.encodingIndex[index2]) != null) {
            return rubyEncoding;
        }
        enc = this.loadEncoding(new ByteList(enc.getName(), false));
        return this.encodingIndex[enc.getIndex()];
    }

    private void defineEncodings() {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator hei = this.encodings.entryIterator();
        while (hei.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)hei.next();
            EncodingDB.Entry ee = (EncodingDB.Entry)e.value;
            RubyEncoding encoding2 = RubyEncoding.newEncoding(this.runtime, e.bytes, e.p, e.end, ee.isDummy());
            this.encodingList[ee.getIndex()] = encoding2;
            this.defineEncodingConstants(this.runtime, encoding2, e.bytes, e.p, e.end);
        }
    }

    private void defineAliases() {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator hei = this.aliases.entryIterator();
        while (hei.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)hei.next();
            EncodingDB.Entry ee = (EncodingDB.Entry)e.value;
            RubyEncoding encoding2 = (RubyEncoding)this.encodingList[ee.getIndex()];
            this.defineEncodingConstants(this.runtime, encoding2, e.bytes, e.p, e.end);
        }
    }

    private void defineEncodingConstants(Ruby runtime, RubyEncoding encoding2, byte[] name2, int p2, int end2) {
        ASCIIEncoding enc = ASCIIEncoding.INSTANCE;
        int s2 = p2;
        int code = name2[s2] & 0xFF;
        if (enc.isDigit(code)) {
            return;
        }
        boolean hasUpper = false;
        boolean hasLower = false;
        if (enc.isUpper(code)) {
            hasUpper = true;
            while (++s2 < end2 && (enc.isAlnum(name2[s2] & 0xFF) || name2[s2] == 95)) {
                if (!enc.isLower(name2[s2] & 0xFF)) continue;
                hasLower = true;
            }
        }
        boolean isValid = false;
        if (s2 >= end2) {
            isValid = true;
            this.defineEncodingConstant(runtime, encoding2, name2, p2, end2);
        }
        if (!isValid || hasLower) {
            if (!hasLower || !hasUpper) {
                do {
                    if (enc.isLower(code = name2[s2] & 0xFF)) {
                        hasLower = true;
                    }
                    if (!enc.isUpper(code)) continue;
                    hasUpper = true;
                } while (++s2 < end2 && (!hasLower || !hasUpper));
            }
            byte[] constName = new byte[end2 - p2];
            System.arraycopy(name2, p2, constName, 0, end2 - p2);
            s2 = 0;
            code = constName[s2] & 0xFF;
            if (!isValid) {
                if (enc.isLower(code)) {
                    constName[s2] = AsciiTables.ToUpperCaseTable[code];
                }
                while (s2 < constName.length) {
                    if (!enc.isAlnum(constName[s2] & 0xFF)) {
                        constName[s2] = 95;
                    }
                    ++s2;
                }
                if (hasUpper) {
                    this.defineEncodingConstant(runtime, encoding2, constName, 0, constName.length);
                }
            }
            if (hasLower) {
                for (s2 = 0; s2 < constName.length; ++s2) {
                    code = constName[s2] & 0xFF;
                    if (!enc.isLower(code)) continue;
                    constName[s2] = AsciiTables.ToUpperCaseTable[code];
                }
                this.defineEncodingConstant(runtime, encoding2, constName, 0, constName.length);
            }
        }
    }

    private void defineEncodingConstant(Ruby runtime, RubyEncoding encoding2, byte[] constName, int constP, int constEnd) {
        runtime.getEncoding().defineConstant(new String(constName, constP, constEnd), encoding2);
    }

    public IRubyObject getDefaultExternal() {
        IRubyObject defaultExternal = this.convertEncodingToRubyEncoding(this.runtime.getDefaultExternalEncoding());
        if (defaultExternal.isNil()) {
            ByteList encodingName = ByteList.create((CharSequence)"US-ASCII");
            Encoding encoding2 = this.runtime.getEncodingService().loadEncoding(encodingName);
            this.runtime.setDefaultExternalEncoding(encoding2);
            defaultExternal = this.convertEncodingToRubyEncoding(encoding2);
        }
        return defaultExternal;
    }

    public IRubyObject getDefaultInternal() {
        return this.convertEncodingToRubyEncoding(this.runtime.getDefaultInternalEncoding());
    }

    public IRubyObject convertEncodingToRubyEncoding(Encoding defaultEncoding) {
        return defaultEncoding != null ? this.getEncoding(defaultEncoding) : this.runtime.getNil();
    }

    public Encoding getJavaDefault() {
        return this.javaDefault;
    }

    public Encoding getEncodingFromObject(IRubyObject arg2) {
        if (arg2 == null) {
            return null;
        }
        Encoding encoding2 = null;
        if (arg2 instanceof RubyEncoding) {
            encoding2 = ((RubyEncoding)arg2).getEncoding();
        } else {
            if (arg2 instanceof RubyFixnum && RubyNKF.NKFCharsetMap.containsKey((int)arg2.convertToInteger().getLongValue())) {
                return this.getEncodingFromNKFId(arg2);
            }
            if (!arg2.isNil()) {
                encoding2 = arg2.convertToString().toEncoding(this.runtime);
            }
        }
        return encoding2;
    }

    private Encoding getEncodingFromNKFId(IRubyObject id2) {
        String name2 = RubyNKF.NKFCharsetMap.get((int)id2.convertToInteger().getLongValue());
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator hei = this.encodings.entryIterator();
        while (hei.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)hei.next();
            EncodingDB.Entry ee = (EncodingDB.Entry)e.value;
            String className = ee.getEncodingClass();
            if (!className.equals(name2)) continue;
            Encoding enc = ee.getEncoding();
            return enc;
        }
        return null;
    }

    public Encoding getEncodingFromString(String string2) {
        if (string2 == null) {
            return null;
        }
        ByteList name2 = new ByteList(ByteList.plain((CharSequence)string2));
        this.checkAsciiEncodingName(name2);
        SpecialEncoding special = SpecialEncoding.valueOf(name2);
        if (special != null) {
            return special.toEncoding(this.runtime);
        }
        return this.findEncodingWithError(name2);
    }

    public Encoding findEncoding(IRubyObject str) {
        ByteList name2 = str.convertToString().getByteList();
        this.checkAsciiEncodingName(name2);
        SpecialEncoding special = SpecialEncoding.valueOf(name2);
        if (special != null) {
            return special.toEncoding(this.runtime);
        }
        return this.findEncodingWithError(name2);
    }

    public EncodingDB.Entry findEntry(IRubyObject str) {
        ByteList name2 = str.convertToString().getByteList();
        this.checkAsciiEncodingName(name2);
        SpecialEncoding special = SpecialEncoding.valueOf(name2);
        if (special != null) {
            return this.findEntryFromEncoding(special.toEncoding(this.runtime));
        }
        return this.findEntryWithError(name2);
    }

    public IRubyObject rubyEncodingFromObject(IRubyObject str) {
        EncodingDB.Entry entry = this.findEntry(str);
        if (entry == null) {
            return this.runtime.getNil();
        }
        return this.getEncodingList()[entry.getIndex()];
    }

    public Charset charsetForEncoding(Encoding encoding2) {
        Charset charset = encoding2.getCharset();
        if (encoding2.toString().equals("ASCII-8BIT")) {
            return Charset.forName("ISO-8859-1");
        }
        try {
            return Charset.forName(encoding2.toString());
        }
        catch (UnsupportedCharsetException uce) {
            throw this.runtime.newEncodingCompatibilityError("no java.nio.charset.Charset found for encoding `" + encoding2.toString() + "'");
        }
    }

    private void checkAsciiEncodingName(ByteList name2) {
        if (!name2.getEncoding().isAsciiCompatible()) {
            throw this.runtime.newArgumentError("invalid name encoding (non ASCII)");
        }
    }

    public Encoding findEncodingWithError(ByteList name2) {
        return this.findEntryWithError(name2).getEncoding();
    }

    private EncodingDB.Entry findEntryWithError(ByteList name2) {
        EncodingDB.Entry e = this.findEncodingOrAliasEntry(name2);
        if (e == null) {
            throw this.runtime.newArgumentError("unknown encoding name - " + name2);
        }
        return e;
    }

    private EncodingDB.Entry findEntryFromEncoding(Encoding e) {
        if (e == null) {
            return null;
        }
        return this.findEncodingEntry(new ByteList(e.getName()));
    }

    private static enum SpecialEncoding {
        LOCALE,
        EXTERNAL,
        INTERNAL,
        FILESYSTEM;


        public static SpecialEncoding valueOf(ByteList name2) {
            if (name2.caseInsensitiveCmp(LOCALE_BL) == 0) {
                return LOCALE;
            }
            if (name2.caseInsensitiveCmp(EXTERNAL_BL) == 0) {
                return EXTERNAL;
            }
            if (name2.caseInsensitiveCmp(INTERNAL_BL) == 0) {
                return INTERNAL;
            }
            if (name2.caseInsensitiveCmp(FILESYSTEM_BL) == 0) {
                return FILESYSTEM;
            }
            return null;
        }

        public Encoding toEncoding(Ruby runtime) {
            EncodingService service = runtime.getEncodingService();
            switch (this) {
                case LOCALE: {
                    return service.getLocaleEncoding();
                }
                case EXTERNAL: {
                    return runtime.getDefaultExternalEncoding();
                }
                case INTERNAL: {
                    return runtime.getDefaultInternalEncoding();
                }
                case FILESYSTEM: {
                    return runtime.getDefaultExternalEncoding();
                }
            }
            throw new RuntimeException("invalid SpecialEncoding: " + (Object)((Object)this));
        }
    }
}

