/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.RubyMethod;
import org.jruby.RubyProc;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.Specializeable;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.MethAddr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public abstract class CallBase
extends Instr
implements Specializeable {
    protected Operand receiver;
    protected Operand[] arguments;
    protected Operand closure;
    protected MethAddr methAddr;
    protected CallSite callSite;
    private final CallType callType;
    private boolean flagsComputed;
    private boolean canBeEval;
    private boolean targetRequiresCallersBinding;
    public HashMap<DynamicMethod, Integer> profile;
    private boolean dontInline;
    private boolean containsSplat;

    protected CallBase(Operation op, CallType callType, MethAddr methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        super(op);
        this.receiver = receiver2;
        this.arguments = args2;
        this.closure = closure;
        this.methAddr = methAddr;
        this.callType = callType;
        this.callSite = CallBase.getCallSiteFor(callType, methAddr);
        this.containsSplat = CallBase.containsSplat(args2);
        this.flagsComputed = false;
        this.canBeEval = true;
        this.targetRequiresCallersBinding = true;
        this.dontInline = false;
    }

    @Override
    public Operand[] getOperands() {
        return CallBase.buildAllArgs(this.getMethodAddr(), this.receiver, this.arguments, this.closure);
    }

    public MethAddr getMethodAddr() {
        return this.methAddr;
    }

    public Operand getClosureArg(Operand ifUnspecified) {
        return this.closure == null ? ifUnspecified : this.closure;
    }

    public Operand getReceiver() {
        return this.receiver;
    }

    public Operand[] getCallArgs() {
        return this.arguments;
    }

    public CallSite getCallSite() {
        return this.callSite;
    }

    public CallType getCallType() {
        return this.callType;
    }

    public void blockInlining() {
        this.dontInline = true;
    }

    public boolean inliningBlocked() {
        return this.dontInline;
    }

    private static CallSite getCallSiteFor(CallType callType, MethAddr methAddr) {
        assert (callType != null) : "Calltype should never be null";
        String name2 = methAddr.getName();
        switch (callType) {
            case NORMAL: {
                return MethodIndex.getCallSite(name2);
            }
            case FUNCTIONAL: {
                return MethodIndex.getFunctionalCallSite(name2);
            }
            case VARIABLE: {
                return MethodIndex.getVariableCallSite(name2);
            }
            case SUPER: {
                return MethodIndex.getSuperCallSite();
            }
        }
        return null;
    }

    public boolean hasClosure() {
        return this.closure != null;
    }

    public boolean isAllConstants() {
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            if (this.arguments[i2] instanceof ImmutableLiteral) continue;
            return false;
        }
        return true;
    }

    public boolean isAllFixnums() {
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            if (this.arguments[i2] instanceof Fixnum) continue;
            return false;
        }
        return true;
    }

    @Override
    public CallBase specializeForInterpretation() {
        return this;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        if (this.receiver != null) {
            this.receiver = this.receiver.getSimplifiedOperand(valueMap, force);
        }
        this.methAddr = (MethAddr)this.methAddr.getSimplifiedOperand(valueMap, force);
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            this.arguments[i2] = this.arguments[i2].getSimplifiedOperand(valueMap, force);
        }
        this.containsSplat = CallBase.containsSplat(this.arguments);
        if (this.closure != null) {
            this.closure = this.closure.getSimplifiedOperand(valueMap, force);
        }
        this.flagsComputed = false;
        this.callSite = CallBase.getCallSiteFor(this.callType, this.methAddr);
    }

    public Operand[] cloneCallArgs(InlinerInfo ii) {
        int i2 = 0;
        Operand[] clonedArgs = new Operand[this.arguments.length];
        for (Operand a : this.arguments) {
            clonedArgs[i2++] = a.cloneForInlining(ii);
        }
        return clonedArgs;
    }

    public boolean isRubyInternalsCall() {
        return false;
    }

    public boolean isStaticCallTarget() {
        return false;
    }

    public boolean canModifyCode() {
        return true;
    }

    private boolean getEvalFlag() {
        Operand[] args2;
        String mname = this.getMethodAddr().getName();
        if (mname.equals("call") || mname.equals("eval") || mname.equals("module_eval") || mname.equals("class_eval") || mname.equals("instance_eval")) {
            return true;
        }
        if ((mname.equals("send") || mname.equals("__send__")) && (args2 = this.getCallArgs()).length >= 2) {
            Operand meth = args2[0];
            if (!(meth instanceof StringLiteral)) {
                return true;
            }
            String name2 = ((StringLiteral)meth).string;
            if (name2.equals("call") || name2.equals("eval") || mname.equals("module_eval") || mname.equals("class_eval") || mname.equals("instance_eval") || name2.equals("send") || name2.equals("__send__")) {
                return true;
            }
        }
        return false;
    }

    private boolean computeRequiresCallersBindingFlag() {
        Operand[] args2;
        if (this.canBeEval()) {
            return true;
        }
        if (this.closure != null) {
            return true;
        }
        String mname = this.getMethodAddr().getName();
        if (mname.equals("lambda")) {
            return true;
        }
        if (mname.equals("binding")) {
            return true;
        }
        if ((mname.equals("send") || mname.equals("__send__")) && (args2 = this.getCallArgs()).length >= 1) {
            Operand meth = args2[0];
            if (!(meth instanceof StringLiteral)) {
                return true;
            }
            String name2 = ((StringLiteral)meth).string;
            if (name2.equals("binding")) {
                return true;
            }
        }
        return false;
    }

    private void computeFlags() {
        this.flagsComputed = true;
        this.canBeEval = this.getEvalFlag();
        this.targetRequiresCallersBinding = this.canBeEval ? true : this.computeRequiresCallersBindingFlag();
    }

    public boolean canBeEval() {
        if (!this.flagsComputed) {
            this.computeFlags();
        }
        return this.canBeEval;
    }

    public boolean targetRequiresCallersBinding() {
        if (!this.flagsComputed) {
            this.computeFlags();
        }
        return this.targetRequiresCallersBinding;
    }

    public boolean canSetDollarVars() {
        return true;
    }

    @Override
    public String toString() {
        return "" + (Object)((Object)this.getOperation()) + "(" + (Object)((Object)this.callType) + ", " + this.getMethodAddr() + ", " + this.receiver + ", " + Arrays.toString(this.getCallArgs()) + (this.closure == null ? "" : ", &" + this.closure) + ")";
    }

    protected static boolean containsSplat(Operand[] arguments) {
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            if (!(arguments[i2] instanceof Splat)) continue;
            return true;
        }
        return false;
    }

    private static Operand[] buildAllArgs(Operand methAddr, Operand receiver2, Operand[] callArgs, Operand closure) {
        Operand[] allArgs = new Operand[callArgs.length + 2 + (closure != null ? 1 : 0)];
        assert (methAddr != null) : "METHADDR is null";
        assert (receiver2 != null) : "RECEIVER is null";
        allArgs[0] = methAddr;
        allArgs[1] = receiver2;
        for (int i2 = 0; i2 < callArgs.length; ++i2) {
            assert (callArgs[i2] != null) : "ARG " + i2 + " is null";
            allArgs[i2 + 2] = callArgs[i2];
        }
        if (closure != null) {
            allArgs[callArgs.length + 2] = closure;
        }
        return allArgs;
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope dynamicScope, IRubyObject self2, Object[] temp, Block block) {
        IRubyObject object = (IRubyObject)this.receiver.retrieve(context, self2, dynamicScope, temp);
        IRubyObject[] values2 = this.prepareArguments(context, self2, this.arguments, dynamicScope, temp);
        Block preparedBlock = this.prepareBlock(context, self2, dynamicScope, temp);
        return this.callSite.call(context, self2, object, values2, preparedBlock);
    }

    protected IRubyObject[] prepareArguments(ThreadContext context, IRubyObject self2, Operand[] arguments, DynamicScope dynamicScope, Object[] temp) {
        return this.containsSplat ? this.prepareArgumentsComplex(context, self2, arguments, dynamicScope, temp) : this.prepareArgumentsSimple(context, self2, arguments, dynamicScope, temp);
    }

    protected IRubyObject[] prepareArgumentsSimple(ThreadContext context, IRubyObject self2, Operand[] args2, DynamicScope currDynScope, Object[] temp) {
        IRubyObject[] newArgs = new IRubyObject[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newArgs[i2] = (IRubyObject)args2[i2].retrieve(context, self2, currDynScope, temp);
        }
        return newArgs;
    }

    protected IRubyObject[] prepareArgumentsComplex(ThreadContext context, IRubyObject self2, Operand[] args2, DynamicScope currDynScope, Object[] temp) {
        ArrayList<IRubyObject> argList = new ArrayList<IRubyObject>();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject rArg = (IRubyObject)args2[i2].retrieve(context, self2, currDynScope, temp);
            if (args2[i2] instanceof Splat) {
                argList.addAll(Arrays.asList(((RubyArray)rArg).toJavaArray()));
                continue;
            }
            argList.add(rArg);
        }
        return argList.toArray(new IRubyObject[argList.size()]);
    }

    protected Block prepareBlock(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, Object[] temp) {
        Block block;
        if (this.closure == null) {
            return Block.NULL_BLOCK;
        }
        Object value2 = this.closure.retrieve(context, self2, currDynScope, temp);
        if (value2 instanceof Block) {
            block = (Block)value2;
        } else if (value2 instanceof RubyProc) {
            block = ((RubyProc)value2).getBlock();
        } else if (value2 instanceof RubyMethod) {
            block = ((RubyProc)((RubyMethod)value2).to_proc(context, null)).getBlock();
        } else if (value2 instanceof IRubyObject && ((IRubyObject)value2).isNil()) {
            block = Block.NULL_BLOCK;
        } else if (value2 instanceof IRubyObject) {
            block = ((RubyProc)TypeConverter.convertToType((IRubyObject)value2, context.runtime.getProc(), "to_proc", true)).getBlock();
        } else {
            throw new RuntimeException("Unhandled case in CallInstr:prepareBlock.  Got block arg: " + value2);
        }
        block.type = Block.Type.NORMAL;
        return block;
    }
}

