/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jcodings.Encoding;
import org.jruby.ext.ripper.Position;
import org.jruby.util.ByteList;

public class LexerSource {
    private Position lastPosition;
    private final String sourceName;
    protected int line = 0;
    protected int lineOffset = 0;
    protected int offset = 0;
    private StringBuilder lineBuffer;
    private StringBuilder sourceLine;
    private static final int INITIAL_PUSHBACK_SIZE = 100;
    private final InputStream in;
    private char[] buf = new char[100];
    private int bufLength = -1;
    private int oneAgo = 10;
    private int twoAgo = 0;
    static final ByteList EOF_LABEL = new ByteList(new byte[]{123, 101, 111, 102, 125});

    protected LexerSource(String sourceName, InputStream in, int lineOffset) {
        this.in = in;
        this.sourceName = sourceName;
        this.lineOffset = lineOffset;
        this.lastPosition = new Position(sourceName, this.line, this.line, this.offset, this.offset);
        this.lineBuffer = new StringBuilder(160);
        this.sourceLine = new StringBuilder(160);
    }

    public String getFilename() {
        return this.sourceName;
    }

    public int getLine() {
        return this.line;
    }

    public int getVirtualLine() {
        return this.line + this.lineOffset;
    }

    public int getOffset() {
        return this.offset <= 0 ? 0 : this.offset;
    }

    public Position getPosition() {
        return new Position(this.getFilename(), this.lastPosition.getEndLine(), this.getLine(), this.lastPosition.getEndOffset(), this.getOffset());
    }

    public Position getPosition(Position startPosition, boolean inclusive) {
        this.lastPosition = startPosition == null ? new Position(this.getFilename(), this.lastPosition.getEndLine(), this.getLine(), this.lastPosition.getEndOffset(), this.getOffset()) : (inclusive ? new Position(this.getFilename(), startPosition.getStartLine(), this.getLine(), startPosition.getStartOffset(), this.getOffset()) : new Position(this.getFilename(), startPosition.getEndLine(), this.getLine(), startPosition.getEndOffset(), this.getOffset()));
        return this.lastPosition;
    }

    private void captureFeatureNewline() {
        StringBuilder temp = this.sourceLine;
        this.sourceLine = this.lineBuffer;
        temp.setLength(0);
        this.lineBuffer = temp;
    }

    protected void captureFeature(int c) {
        switch (c) {
            case 10: {
                this.lineBuffer.append((char)c);
            }
            case -1: {
                this.captureFeatureNewline();
                break;
            }
            default: {
                this.lineBuffer.append((char)c);
            }
        }
    }

    public String getCurrentLine() {
        int errorLocation = this.lineBuffer.length() - 1;
        try {
            this.readLineBytes();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.sourceLine.toString() + this.makePointer(errorLocation);
    }

    protected String makePointer(int length2) {
        StringBuilder buffer = new StringBuilder();
        for (int i2 = 0; i2 < length2; ++i2) {
            buffer.append(' ');
        }
        buffer.append('^');
        return buffer.toString();
    }

    public int readCodepoint(int first2, Encoding encoding2) throws IOException {
        int c;
        int count2;
        byte[] value2 = new byte[6];
        value2[0] = (byte)first2;
        for (count2 = 1; count2 < 6 && (c = this.read()) != -1; ++count2) {
            value2[count2] = (byte)c;
        }
        int length2 = encoding2.length(value2, 0, count2);
        if (length2 < 0) {
            return -2;
        }
        int codepoint = encoding2.mbcToCode(value2, 0, length2);
        for (int i2 = count2 - 1; i2 >= length2; --i2) {
            this.unread(value2[i2]);
        }
        return codepoint;
    }

    public int read() throws IOException {
        int c;
        if (this.bufLength >= 0) {
            c = this.buf[this.bufLength--];
        } else {
            c = this.wrappedRead();
            if (c == -1) {
                return -1;
            }
        }
        this.advance(c);
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    public void unread(int c) {
        if (c == -1) {
            return;
        }
        this.retreat();
        if (c == 10) {
            --this.line;
        }
        this.buf[++this.bufLength] = (char)c;
        this.growBuf();
    }

    public boolean peek(int to) throws IOException {
        int captureTwoAgo = this.twoAgo;
        int c = this.read();
        this.unread(c);
        this.twoAgo = captureTwoAgo;
        return c == to;
    }

    private void advance(int c) {
        this.twoAgo = this.oneAgo;
        this.oneAgo = c;
        ++this.offset;
    }

    private int carriageReturn(int c) throws IOException {
        c = this.in.read();
        if (c != 10) {
            this.unread((char)c);
        } else {
            ++this.offset;
        }
        return c;
    }

    private void growBuf() {
        if (this.bufLength + 1 == this.buf.length) {
            char[] newBuf = new char[this.buf.length + 100];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
    }

    private void retreat() {
        --this.offset;
        this.oneAgo = this.twoAgo;
        this.twoAgo = 0;
    }

    private int wrappedRead() throws IOException {
        int c = this.in.read();
        if (c == 13) {
            c = this.carriageReturn(c);
        }
        this.captureFeature(c);
        return c;
    }

    public ByteList readLineBytes() throws IOException {
        ByteList bytelist = new ByteList(80);
        int c = this.read();
        while (c != 10 && c != -1) {
            bytelist.append(c);
            c = this.read();
        }
        return bytelist;
    }

    public ByteList readLineBytesPlusNewline() throws IOException {
        ByteList bytelist = new ByteList(80);
        int c = this.read();
        while (c != 10 && c != -1) {
            bytelist.append(c);
            c = this.read();
        }
        if (c != -1) {
            bytelist.append(c);
        }
        return bytelist;
    }

    public int skipUntil(int marker) throws IOException {
        int c = this.read();
        while (c != marker && c != -1) {
            c = this.read();
        }
        return c;
    }

    public void unreadMany(CharSequence buffer) {
        int length2 = buffer.length();
        for (int i2 = length2 - 1; i2 >= 0; --i2) {
            this.unread(buffer.charAt(i2));
        }
    }

    public int matchMarker(ByteList match2, boolean indent, boolean checkNewline) throws IOException {
        int length2 = match2.length();
        ByteList buffer = new ByteList(length2 + 1);
        if (indent) {
            this.indentLoop(buffer);
        }
        if (!this.matches(match2, buffer, length2)) {
            return 0;
        }
        return this.finishMarker(checkNewline, buffer);
    }

    private void indentLoop(ByteList buffer) throws IOException {
        int c;
        while ((c = this.read()) != -1) {
            if (!Character.isWhitespace(c) || c == 10) {
                this.unread(c);
                break;
            }
            buffer.append(c);
        }
    }

    private boolean matches(ByteList match2, ByteList buffer, int length2) throws IOException {
        for (int i2 = 0; i2 < length2; ++i2) {
            int c = this.read();
            buffer.append(c);
            if (match2.charAt(i2) == c) continue;
            this.unreadMany((CharSequence)buffer);
            return false;
        }
        return true;
    }

    private int finishMarker(boolean checkNewline, ByteList buffer) throws IOException {
        if (!checkNewline) {
            return -1;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        if (c == 10) {
            return 10;
        }
        buffer.append(c);
        this.unreadMany((CharSequence)buffer);
        return 0;
    }

    public boolean wasBeginOfLine() {
        return this.twoAgo == 10;
    }

    public boolean lastWasBeginOfLine() {
        return this.oneAgo == 10;
    }

    public String toString() {
        try {
            int i2;
            ByteList buffer = new ByteList(20);
            ByteList unreadBuffer = new ByteList(20);
            if (this.twoAgo != -1 && this.twoAgo != 0) {
                buffer.append(this.twoAgo);
            }
            if (this.oneAgo != -1 && this.oneAgo != 0) {
                buffer.append(this.oneAgo);
            }
            buffer.append(60);
            int c = this.read();
            unreadBuffer.append(c);
            if (c == -1) {
                this.unread(unreadBuffer.charAt(0));
                buffer.append(EOF_LABEL);
                buffer.append(62);
                return buffer.toString();
            }
            buffer.append(c).append(62);
            for (i2 = 1; i2 < 20; ++i2) {
                c = this.read();
                unreadBuffer.append(c);
                if (c == -1) {
                    buffer.append(EOF_LABEL);
                    --i2;
                    break;
                }
                buffer.append(c);
            }
            while (i2 >= 0) {
                this.unread(unreadBuffer.charAt(i2));
                --i2;
            }
            buffer.append(new byte[]{32, 46, 46, 46});
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ByteList readUntil(char marker) throws IOException {
        ByteList buffer = new ByteList(20);
        int c = this.read();
        while (c != marker && c != -1) {
            buffer.append(c);
            c = this.read();
        }
        if (c == -1) {
            return null;
        }
        this.unread(c);
        return buffer;
    }

    public InputStream getRemainingAsStream() throws IOException {
        return this.bufferEntireStream(this.in);
    }

    private InputStream bufferEntireStream(InputStream stream) throws IOException {
        int bytesRead;
        byte[] allBytes = new byte[]{};
        byte[] b = new byte[1024];
        while ((bytesRead = stream.read(b)) != -1) {
            byte[] newbuf = new byte[allBytes.length + bytesRead];
            System.arraycopy(allBytes, 0, newbuf, 0, allBytes.length);
            System.arraycopy(b, 0, newbuf, allBytes.length, bytesRead);
            allBytes = newbuf;
        }
        return new ByteArrayInputStream(allBytes);
    }
}

