/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignOneArgNode;
import org.jruby.ast.AttrAssignThreeArgNode;
import org.jruby.ast.AttrAssignTwoArgNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.DefinedMessage;

public class AttrAssignNode
extends Node
implements INameNode,
IArgumentNode {
    protected final Node receiverNode;
    private String name;
    private Node argsNode;
    public CallSite variableCallAdapter;
    public CallSite normalCallAdapter;

    public AttrAssignNode(ISourcePosition position, Node receiverNode, String name2, Node argsNode) {
        super(position);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
        this.name = name2;
        this.setArgsInternal(argsNode);
        this.normalCallAdapter = MethodIndex.getCallSite(name2);
        this.variableCallAdapter = MethodIndex.getVariableCallSite(name2);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ATTRASSIGNNODE;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visitAttrAssignNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    protected Node newAttrAssignNode(ArrayNode argsNode) {
        int size2 = argsNode.size();
        switch (size2) {
            case 1: {
                return new AttrAssignOneArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
            }
            case 2: {
                return new AttrAssignTwoArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
            }
            case 3: {
                return new AttrAssignThreeArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
            }
        }
        return new AttrAssignNode(this.getPosition(), this.receiverNode, this.name, argsNode);
    }

    protected Node newMutatedAttrAssignNode(ArrayNode argsNode) {
        int size2 = argsNode.size();
        switch (size2) {
            case 1: {
                if (!(this instanceof AttrAssignOneArgNode)) {
                    return new AttrAssignOneArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
                }
                return this;
            }
            case 2: {
                if (!(this instanceof AttrAssignTwoArgNode)) {
                    return new AttrAssignTwoArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
                }
                return this;
            }
            case 3: {
                if (!(this instanceof AttrAssignThreeArgNode)) {
                    return new AttrAssignThreeArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
                }
                return this;
            }
        }
        return new AttrAssignNode(this.getPosition(), this.receiverNode, this.name, argsNode);
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        if (this.argsNode == null && argsNode instanceof ArrayNode) {
            return this.newAttrAssignNode((ArrayNode)argsNode);
        }
        if (this.argsNode == argsNode) {
            return this.newMutatedAttrAssignNode((ArrayNode)argsNode);
        }
        this.setArgsInternal(argsNode);
        return this;
    }

    private void setArgsInternal(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject receiver2 = this.receiverNode.interpret(runtime, context, self2, aBlock);
        IRubyObject[] args2 = ASTInterpreter.setupArgs(runtime, context, this.argsNode, self2, aBlock);
        assert (AttrAssignNode.hasMetaClass(receiver2)) : AttrAssignNode.receiverClassName(receiver2);
        CallSite callSite = this.selectCallSite(self2, receiver2);
        callSite.call(context, self2, receiver2, args2);
        return args2[args2.length - 1];
    }

    protected static boolean hasMetaClass(IRubyObject object) {
        return object.getMetaClass() != null;
    }

    protected static String receiverClassName(IRubyObject object) {
        return object.getClass().getName();
    }

    protected CallSite selectCallSite(IRubyObject self2, IRubyObject receiver2) {
        return receiver2 == self2 ? this.variableCallAdapter : this.normalCallAdapter;
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject value2, Block block, boolean checkArity) {
        IRubyObject receiver2 = this.receiverNode.interpret(runtime, context, self2, block);
        if (receiver2 == self2) {
            return this.selfAssign(runtime, context, self2, value2, block, checkArity);
        }
        return this.otherAssign(runtime, context, self2, value2, block, checkArity);
    }

    private IRubyObject selfAssign(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject value2, Block block, boolean checkArity) {
        IRubyObject receiver2 = this.receiverNode.interpret(runtime, context, self2, block);
        if (this.argsNode == null) {
            Helpers.invoke(context, receiver2, this.name, value2);
        } else {
            RubyArray args2 = (RubyArray)this.argsNode.interpret(runtime, context, self2, block);
            args2.append(value2);
            Helpers.invoke(context, receiver2, this.name, args2.toJavaArray());
        }
        return runtime.getNil();
    }

    private IRubyObject otherAssign(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject value2, Block block, boolean checkArity) {
        IRubyObject receiver2 = this.receiverNode.interpret(runtime, context, self2, block);
        if (this.argsNode == null) {
            Helpers.invoke(context, receiver2, this.name, value2, CallType.NORMAL, Block.NULL_BLOCK);
        } else {
            RubyArray args2 = (RubyArray)this.argsNode.interpret(runtime, context, self2, block);
            args2.append(value2);
            Helpers.invoke(context, receiver2, this.name, args2.toJavaArray(), CallType.NORMAL, Block.NULL_BLOCK);
        }
        return runtime.getNil();
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        if (this.receiverNode.definition(runtime, context, self2, aBlock) != null) {
            try {
                IRubyObject receiver2 = this.receiverNode.interpret(runtime, context, self2, aBlock);
                RubyClass metaClass = receiver2.getMetaClass();
                DynamicMethod method2 = metaClass.searchMethod(this.name);
                Visibility visibility = method2.getVisibility();
                if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self2)) && metaClass.isMethodBound(this.name, false)) {
                    return ASTInterpreter.getArgumentDefinition(runtime, context, this.argsNode, runtime.getDefinedMessage(DefinedMessage.ASSIGNMENT), self2, aBlock);
                }
            }
            catch (JumpException e) {
                // empty catch block
            }
        }
        return null;
    }
}

