/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.DefaultDecorator;
import com.github.rjeschke.txtmark.SpanEmitter;

public class Configuration {
    final boolean safeMode;
    final String encoding;
    final Decorator decorator;
    final BlockEmitter codeBlockEmitter;
    final boolean forceExtendedProfile;
    final SpanEmitter specialLinkEmitter;
    public static final Configuration DEFAULT = Configuration.builder().build();
    public static final Configuration DEFAULT_SAFE = Configuration.builder().enableSafeMode().build();

    Configuration(boolean safeMode, String encoding, Decorator decorator, BlockEmitter codeBlockEmitter, boolean forceExtendedProfile, SpanEmitter specialLinkEmitter) {
        this.safeMode = safeMode;
        this.encoding = encoding;
        this.decorator = decorator;
        this.codeBlockEmitter = codeBlockEmitter;
        this.forceExtendedProfile = forceExtendedProfile;
        this.specialLinkEmitter = specialLinkEmitter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean safeMode = false;
        private boolean forceExtendedProfile = false;
        private String encoding = "UTF-8";
        private Decorator decorator = new DefaultDecorator();
        private BlockEmitter codeBlockEmitter = null;
        private SpanEmitter specialLinkEmitter = null;

        Builder() {
        }

        public Builder enableSafeMode() {
            this.safeMode = true;
            return this;
        }

        public Builder forceExtentedProfile() {
            this.forceExtendedProfile = true;
            return this;
        }

        public Builder setSafeMode(boolean flag) {
            this.safeMode = flag;
            return this;
        }

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setDecorator(Decorator decorator) {
            this.decorator = decorator;
            return this;
        }

        public Builder setCodeBlockEmitter(BlockEmitter emitter) {
            this.codeBlockEmitter = emitter;
            return this;
        }

        public Builder setSpecialLinkEmitter(SpanEmitter emitter) {
            this.specialLinkEmitter = emitter;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.safeMode, this.encoding, this.decorator, this.codeBlockEmitter, this.forceExtendedProfile, this.specialLinkEmitter);
        }
    }
}

