/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.HTML;
import com.github.rjeschke.txtmark.LineType;
import com.github.rjeschke.txtmark.Utils;
import java.util.LinkedList;

class Line {
    public int pos;
    public int leading = 0;
    public int trailing = 0;
    public boolean isEmpty = true;
    public String value = null;
    public Line previous = null;
    public Line next = null;
    public boolean prevEmpty;
    public boolean nextEmpty;
    public Line xmlEndLine;

    public void init() {
        this.leading = 0;
        while (this.leading < this.value.length() && this.value.charAt(this.leading) == ' ') {
            ++this.leading;
        }
        if (this.leading == this.value.length()) {
            this.setEmpty();
        } else {
            this.isEmpty = false;
            this.trailing = 0;
            while (this.value.charAt(this.value.length() - this.trailing - 1) == ' ') {
                ++this.trailing;
            }
        }
    }

    public void initLeading() {
        this.leading = 0;
        while (this.leading < this.value.length() && this.value.charAt(this.leading) == ' ') {
            ++this.leading;
        }
        if (this.leading == this.value.length()) {
            this.setEmpty();
        }
    }

    public boolean skipSpaces() {
        while (this.pos < this.value.length() && this.value.charAt(this.pos) == ' ') {
            ++this.pos;
        }
        return this.pos < this.value.length();
    }

    public String readUntil(char ... end) {
        char ch;
        int pos;
        StringBuilder sb = new StringBuilder();
        for (pos = this.pos; pos < this.value.length(); ++pos) {
            ch = this.value.charAt(pos);
            if (ch == '\\' && pos + 1 < this.value.length()) {
                char c = this.value.charAt(pos + 1);
                switch (c) {
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '>': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '_': 
                    case '`': 
                    case '{': 
                    case '}': 
                    case '~': {
                        sb.append(c);
                        ++pos;
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
                continue;
            }
            boolean endReached = false;
            for (int n = 0; n < end.length; ++n) {
                if (ch != end[n]) continue;
                endReached = true;
                break;
            }
            if (endReached) break;
            sb.append(ch);
        }
        ch = pos < this.value.length() ? (char)this.value.charAt(pos) : (char)'\n';
        for (int n = 0; n < end.length; ++n) {
            if (ch != end[n]) continue;
            this.pos = pos;
            return sb.toString();
        }
        return null;
    }

    public void setEmpty() {
        this.value = "";
        this.trailing = 0;
        this.leading = 0;
        this.isEmpty = true;
        if (this.previous != null) {
            this.previous.nextEmpty = true;
        }
        if (this.next != null) {
            this.next.prevEmpty = true;
        }
    }

    private int countChars(char ch) {
        int count = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == ' ') continue;
            if (c == ch) {
                ++count;
                continue;
            }
            count = 0;
            break;
        }
        return count;
    }

    private int countCharsStart(char ch) {
        int count = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == ' ') continue;
            if (c != ch) break;
            ++count;
        }
        return count;
    }

    public LineType getLineType(boolean extendedMode) {
        if (this.isEmpty) {
            return LineType.EMPTY;
        }
        if (this.leading > 3) {
            return LineType.CODE;
        }
        if (this.value.charAt(this.leading) == '#') {
            return LineType.HEADLINE;
        }
        if (this.value.charAt(this.leading) == '>') {
            return LineType.BQUOTE;
        }
        if (extendedMode && this.value.length() - this.leading - this.trailing > 2) {
            if (this.value.charAt(this.leading) == '`' && this.countCharsStart('`') >= 3) {
                return LineType.FENCED_CODE;
            }
            if (this.value.charAt(this.leading) == '~' && this.countCharsStart('~') >= 3) {
                return LineType.FENCED_CODE;
            }
        }
        if (this.value.length() - this.leading - this.trailing > 2 && (this.value.charAt(this.leading) == '*' || this.value.charAt(this.leading) == '-' || this.value.charAt(this.leading) == '_') && this.countChars(this.value.charAt(this.leading)) >= 3) {
            return LineType.HR;
        }
        if (this.value.length() - this.leading >= 2 && this.value.charAt(this.leading + 1) == ' ') {
            switch (this.value.charAt(this.leading)) {
                case '*': 
                case '+': 
                case '-': {
                    return LineType.ULIST;
                }
            }
        }
        if (this.value.length() - this.leading >= 3 && Character.isDigit(this.value.charAt(this.leading))) {
            int i;
            for (i = this.leading + 1; i < this.value.length() && Character.isDigit(this.value.charAt(i)); ++i) {
            }
            if (i + 1 < this.value.length() && this.value.charAt(i) == '.' && this.value.charAt(i + 1) == ' ') {
                return LineType.OLIST;
            }
        }
        if (this.value.charAt(this.leading) == '<' && this.checkHTML()) {
            return LineType.XML;
        }
        if (this.next != null && !this.next.isEmpty) {
            if (this.next.value.charAt(0) == '-' && this.next.countChars('-') > 0) {
                return LineType.HEADLINE2;
            }
            if (this.next.value.charAt(0) == '=' && this.next.countChars('=') > 0) {
                return LineType.HEADLINE1;
            }
        }
        return LineType.OTHER;
    }

    private int readXMLComment(Line firstLine, int start) {
        Line line = firstLine;
        if (start + 3 < line.value.length() && line.value.charAt(2) == '-' && line.value.charAt(3) == '-') {
            int pos = start + 4;
            while (line != null) {
                while (pos < line.value.length() && line.value.charAt(pos) != '-') {
                    ++pos;
                }
                if (pos == line.value.length()) {
                    line = line.next;
                    pos = 0;
                    continue;
                }
                if (pos + 2 < line.value.length() && line.value.charAt(pos + 1) == '-' && line.value.charAt(pos + 2) == '>') {
                    this.xmlEndLine = line;
                    return pos + 3;
                }
                ++pos;
            }
        }
        return -1;
    }

    public String stripID() {
        if (this.isEmpty || this.value.charAt(this.value.length() - this.trailing - 1) != '}') {
            return null;
        }
        int p = this.leading;
        boolean found = false;
        block14: while (p < this.value.length() && !found) {
            switch (this.value.charAt(p)) {
                case '\\': {
                    if (p + 1 < this.value.length()) {
                        switch (this.value.charAt(p + 1)) {
                            case '{': {
                                ++p;
                            }
                        }
                    }
                    ++p;
                    continue block14;
                }
                case '{': {
                    found = true;
                    continue block14;
                }
            }
            ++p;
        }
        if (found && p + 1 < this.value.length() && this.value.charAt(p + 1) == '#') {
            int start;
            p = start = p + 2;
            found = false;
            block15: while (p < this.value.length() && !found) {
                switch (this.value.charAt(p)) {
                    case '\\': {
                        if (p + 1 < this.value.length()) {
                            switch (this.value.charAt(p + 1)) {
                                case '}': {
                                    ++p;
                                }
                            }
                        }
                        ++p;
                        continue block15;
                    }
                    case '}': {
                        found = true;
                        continue block15;
                    }
                }
                ++p;
            }
            if (found) {
                String id = this.value.substring(start, p).trim();
                this.value = this.leading != 0 ? this.value.substring(0, this.leading) + this.value.substring(this.leading, start - 2).trim() : this.value.substring(this.leading, start - 2).trim();
                this.trailing = 0;
                return id.length() > 0 ? id : null;
            }
        }
        return null;
    }

    private boolean checkHTML() {
        LinkedList<String> tags = new LinkedList<String>();
        StringBuilder temp = new StringBuilder();
        int pos = this.leading;
        if (this.value.charAt(this.leading + 1) == '!' && this.readXMLComment(this, this.leading) > 0) {
            return true;
        }
        pos = Utils.readXML(temp, this.value, this.leading, false);
        if (pos > -1) {
            String element = temp.toString();
            temp.setLength(0);
            Utils.getXMLTag(temp, element);
            String tag = temp.toString().toLowerCase();
            if (!HTML.isHtmlBlockElement(tag)) {
                return false;
            }
            if (tag.equals("hr")) {
                this.xmlEndLine = this;
                return true;
            }
            tags.add(tag);
            Line line = this;
            while (line != null) {
                while (pos < line.value.length() && line.value.charAt(pos) != '<') {
                    ++pos;
                }
                if (pos >= line.value.length()) {
                    line = line.next;
                    pos = 0;
                    continue;
                }
                temp.setLength(0);
                int newPos = Utils.readXML(temp, line.value, pos, false);
                if (newPos > 0) {
                    element = temp.toString();
                    temp.setLength(0);
                    Utils.getXMLTag(temp, element);
                    tag = temp.toString().toLowerCase();
                    if (HTML.isHtmlBlockElement(tag) && !tag.equals("hr")) {
                        if (element.charAt(1) == '/') {
                            if (!((String)tags.getLast()).equals(tag)) {
                                return false;
                            }
                            tags.removeLast();
                        } else {
                            tags.addLast(tag);
                        }
                    }
                    if (tags.size() == 0) {
                        this.xmlEndLine = line;
                        break;
                    }
                    pos = newPos;
                    continue;
                }
                ++pos;
            }
            return tags.size() == 0;
        }
        return false;
    }
}

