/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.util.StringTokenizer;
import sun.jvm.hotspot.oops.HeapVisitor;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.ObjectReader;
import sun.jvm.hotspot.utilities.SystemDictionaryHelper;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaFactoryImpl;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;
import sun.jvm.hotspot.utilities.soql.JSJavaScriptEngine;
import sun.jvm.hotspot.utilities.soql.ObjectVisitor;
import sun.jvm.hotspot.utilities.soql.SOQLException;
import sun.jvm.hotspot.utilities.soql.SOQLQuery;

public class SOQLEngine
extends JSJavaScriptEngine {
    private static final boolean debug = System.getProperty("sun.jvm.hotspot.utilities.soql.SOQLEngine.debug") != null;
    private ObjectReader objReader;
    private JSJavaFactory factory;
    private static SOQLEngine soleInstance;

    public static synchronized SOQLEngine getEngine() {
        if (soleInstance == null) {
            soleInstance = new SOQLEngine();
        }
        return soleInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void executeQuery(String query, ObjectVisitor visitor) throws SOQLException {
        SOQLEngine.debugPrint("query : " + query);
        StringTokenizer st = new StringTokenizer(query);
        if (!st.hasMoreTokens()) throw new SOQLException("query syntax error: no 'select' clause");
        String first = st.nextToken();
        if (!first.equals("select")) {
            throw new SOQLException("query syntax error: no 'select' clause");
        }
        int selectStart = query.indexOf("select");
        int fromStart = query.indexOf("from");
        String selectExpr = null;
        String className = null;
        boolean isInstanceOf = false;
        String whereExpr = null;
        String identifier = null;
        if (fromStart != -1) {
            selectExpr = query.substring(selectStart + "select".length(), fromStart);
            st = new StringTokenizer(query.substring(fromStart + "from".length()));
            if (!st.hasMoreTokens()) throw new SOQLException("query syntax error: class name must follow 'from'");
            String tmp = st.nextToken();
            if (tmp.equals("instanceof")) {
                isInstanceOf = true;
                if (!st.hasMoreTokens()) {
                    throw new SOQLException("no class name after 'instanceof'");
                }
                className = st.nextToken();
            } else {
                className = tmp;
            }
            if (!st.hasMoreTokens()) throw new SOQLException("query syntax error: identifier should follow class name");
            identifier = st.nextToken();
            if (identifier.equals("where")) {
                throw new SOQLException("query syntax error: identifier should follow class name");
            }
            if (st.hasMoreTokens()) {
                tmp = st.nextToken();
                if (!tmp.equals("where")) {
                    throw new SOQLException("query syntax error: 'where' clause expected after 'from' clause");
                }
                int whereEnd = query.lastIndexOf("where") + 5;
                whereExpr = query.substring(whereEnd);
            }
        } else {
            selectExpr = query.substring(selectStart + "select".length(), query.length());
        }
        this.executeQuery(new SOQLQuery(selectExpr, isInstanceOf, className, identifier, whereExpr), visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(SOQLQuery q, ObjectVisitor visitor) throws SOQLException {
        InstanceKlass kls = null;
        if (q.className != null && (kls = SystemDictionaryHelper.findInstanceKlass(q.className)) == null) {
            throw new SOQLException(q.className + " is not found!");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("function result(");
        if (q.identifier != null) {
            buf.append(q.identifier);
        }
        buf.append(") { return ");
        buf.append(q.selectExpr.replace('\n', ' '));
        buf.append("; }");
        String selectCode = buf.toString();
        SOQLEngine.debugPrint(selectCode);
        String whereCode = null;
        if (q.whereExpr != null) {
            buf = new StringBuffer();
            buf.append("function filter(");
            buf.append(q.identifier);
            buf.append(") { return ");
            buf.append(q.whereExpr.replace('\n', ' '));
            buf.append("; }");
            whereCode = buf.toString();
            SOQLEngine.debugPrint(whereCode);
        } else {
            whereCode = "filter = null;";
        }
        this.beginQuery();
        this.evalString(selectCode, "", 1);
        this.evalString(whereCode, "", 1);
        if (q.className != null) {
            try {
                this.iterateOops(kls, visitor, q.isInstanceOf);
            }
            finally {
                this.endQuery();
            }
        }
        try {
            Object select = this.call("result", new Object[0]);
            visitor.visit(select);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dispatchObject(Oop oop, ObjectVisitor visitor, boolean filterExists) {
        JSJavaObject jsObj = this.factory.newJSJavaObject(oop);
        Object[] args = new Object[]{jsObj};
        boolean b = true;
        try {
            if (filterExists) {
                Object res = this.call("filter", args);
                if (res instanceof Boolean) {
                    b = (Boolean)res;
                } else if (res instanceof Number) {
                    b = ((Number)res).intValue() != 0;
                } else {
                    boolean bl = b = res != null;
                }
            }
            if (b) {
                Object select = this.call("result", args);
                visitor.visit(select);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void iterateOops(InstanceKlass ik, final ObjectVisitor visitor, boolean includeSubtypes) {
        ObjectHeap oh = VM.getVM().getObjectHeap();
        oh.iterateObjectsOfKlass(new HeapVisitor(){
            boolean filterExists;

            public void prologue(long usedSize) {
                this.filterExists = SOQLEngine.this.getScriptEngine().get("filter") != null;
            }

            public boolean doObj(Oop obj) {
                SOQLEngine.this.dispatchObject(obj, visitor, this.filterExists);
                return false;
            }

            public void epilogue() {
            }
        }, ik, includeSubtypes);
    }

    private void beginQuery() {
        this.objReader = new ObjectReader();
        this.factory = new JSJavaFactoryImpl();
    }

    private void endQuery() {
        this.objReader = null;
        this.factory = null;
    }

    protected ObjectReader getObjectReader() {
        return this.objReader;
    }

    protected JSJavaFactory getJSJavaFactory() {
        return this.factory;
    }

    protected boolean isQuitting() {
        return false;
    }

    protected void quit() {
    }

    private static void debugPrint(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    protected SOQLEngine() {
        super(debug);
        this.start();
    }
}

