/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileEntry;
import org.mortbay.thread.QueuedThreadPool;
import org.opoo.press.Application;
import org.opoo.press.CompassConfig;
import org.opoo.press.Site;
import org.opoo.press.SiteConfig;
import org.opoo.press.SiteManager;
import org.opoo.press.impl.StaticFileImpl;
import org.opoo.press.source.NoFrontMatterException;
import org.opoo.press.source.Source;
import org.opoo.press.source.SourceEntry;
import org.opoo.press.support.Compass;
import org.opoo.press.support.DirectoryMonitor;
import org.opoo.press.support.JettyServer;
import org.opoo.util.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preview {
    private static final Logger log = LoggerFactory.getLogger(Preview.class);
    private final int port;
    private final int interval;
    private final File siteDir;
    private final SiteManager siteManager;
    private final SiteConfig siteConfig;
    private boolean showDrafts;
    private boolean skipSassCompile;
    private boolean skipGenerate;
    private CompassConfig compassConfig;
    private Site site;
    private JettyServer server;
    private DirectoryMonitor monitor;
    private List<DirectoryMonitor> sourceMonitors;
    private QueuedThreadPool threadPool;

    public Preview(SiteManager siteManager, File siteDir, Map<String, Object> extraOptions, int port, int interval) {
        this.siteDir = siteDir;
        this.port = port;
        this.interval = interval;
        this.siteManager = siteManager;
        this.initOptions(extraOptions);
        this.siteConfig = siteManager.createSiteConfig(siteDir, extraOptions);
        this.compassConfig = this.skipSassCompile ? null : siteManager.createCompassConfig(siteDir);
    }

    public Preview(SiteManager siteManager, Site site, int port, int interval) {
        this.siteDir = site.getSite();
        this.port = port;
        this.interval = interval;
        this.siteManager = siteManager;
        this.siteConfig = site.getConfig();
        Map extraOptions = this.siteConfig.getExtraConfig();
        this.initOptions(extraOptions);
        this.compassConfig = this.skipSassCompile ? null : siteManager.createCompassConfig(this.siteDir);
    }

    private void initOptions(Map<String, Object> extraOptions) {
        if (extraOptions == null) {
            this.showDrafts = false;
            this.skipGenerate = false;
            this.skipSassCompile = false;
        } else {
            this.showDrafts = MapUtils.get(extraOptions, (Object)"show_drafts", (boolean)false);
            this.skipGenerate = MapUtils.get(extraOptions, (Object)"op.generate.skip", (boolean)false);
            this.skipSassCompile = MapUtils.get(extraOptions, (Object)"op.sass.compile.skip", (boolean)false);
        }
    }

    public void start() throws Exception {
        if (this.site == null) {
            this.site = this.siteManager.createSite(this.siteConfig);
        }
        if (this.skipGenerate && this.skipSassCompile) {
            log.warn("'op.generate.skip = true' and 'op.sass.compile.skip = true', no directory monitor will be started.");
        } else {
            if (this.monitor == null) {
                this.monitor = new DirectoryMonitor(this.siteDir, this.interval, new L());
                this.monitor.start();
            }
            if (this.sourceMonitors == null && this.site.getSources() != null) {
                this.sourceMonitors = new ArrayList<DirectoryMonitor>();
                for (File source : this.site.getSources()) {
                    DirectoryMonitor dm = new DirectoryMonitor(source, this.interval, new M());
                    this.sourceMonitors.add(dm);
                    dm.start();
                }
            }
        }
        if (this.server == null) {
            this.server = new JettyServer(this.site, this.port);
            this.server.start();
        }
        if (this.threadPool == null) {
            this.threadPool = new QueuedThreadPool();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Preview.this.stop();
                    }
                    catch (Exception e) {
                        log.error("Stop thread pool exception", (Throwable)e);
                    }
                }
            });
        }
        this.threadPool.start();
        this.threadPool.join();
    }

    public void stop() throws Exception {
        if (this.monitor != null) {
            this.monitor.stop();
        }
        if (this.sourceMonitors != null) {
            for (DirectoryMonitor dm : this.sourceMonitors) {
                dm.stop();
            }
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.threadPool != null) {
            this.threadPool.stop();
        }
    }

    private void handleFileChange(File file) {
        if (this.skipGenerate && this.skipSassCompile) {
            log.warn("'op.generate.skip = true' and 'op.sass.compile.skip = true', skipping handle file changed events.");
            return;
        }
        if (!file.isFile()) {
            log.debug("'" + file + "' changed.");
            return;
        }
        if (!this.skipGenerate) {
            if (file.equals(this.siteConfig.getConfigFile())) {
                log.info("Site config file changed, recreate site.");
                this.mainConfigChanged();
                return;
            }
            if (this.isTemplateFile(file)) {
                log.info("Template file '" + file + "' changed, regenerate site.");
                this.siteManager.build(this.site);
                return;
            }
            if (this.isAssetFile(file)) {
                log.info("Copy static file: " + file);
                this.copyStaticFile(this.site.getAssets(), file);
                return;
            }
            if (this.isSourceFile(file)) {
                SourceEntry sourceEntry = Preview.loadSourceEntry(this.site.getSource(), file);
                try {
                    Source source = Application.getContext().getSourceParser().parse(sourceEntry);
                    if (!this.showDrafts && this.isDraft(source.getMeta())) {
                        log.info("showDrafts = false: Draft post file '" + file + "' changed, skip regenerate.");
                        return;
                    }
                    log.info("Source file '" + file + "' changed, regenerate site.");
                    this.siteManager.build(this.site);
                    return;
                }
                catch (NoFrontMatterException e) {
                    log.debug("Copy static file: " + file);
                    this.copyStaticFile(sourceEntry);
                    return;
                }
            }
        }
        if (!this.skipSassCompile) {
            if (file.equals(this.compassConfig.getConfigFile())) {
                log.info("SASS/SCSS config file changed, recompile...");
                this.compassConfig = this.siteManager.createCompassConfig(this.siteDir);
                this.compassCompile(this.siteDir);
                return;
            }
            if (this.isSassFile(file)) {
                log.info("SASS/SCSS file '" + file + "' changed, recompile...");
                this.compassCompile(this.siteDir);
                return;
            }
        }
        log.warn("Unkown file changed or 'op.sass.compile.skip=true' or 'op.generate.skip=true', skipping handle file change: " + file);
    }

    private void mainConfigChanged() {
        try {
            if (this.server != null) {
                this.server.stop();
                this.server = null;
            }
            this.siteConfig.reload();
            this.site = this.siteManager.createSite(this.siteConfig);
            this.siteManager.build(this.site);
            this.server = new JettyServer(this.site, this.port);
            this.server.start();
        }
        catch (Exception e) {
            log.error("Handle main config changed error", (Throwable)e);
        }
    }

    private void otherSourceFileChanged(File file) {
        SourceEntry sourceEntry = new SourceEntry(null, file);
        try {
            Source source = Application.getContext().getSourceParser().parse(sourceEntry);
            if (!this.showDrafts && this.isDraft(source.getMeta())) {
                log.info("showDrafts = false: Draft post file '" + file + "' changed, skip regenerate.");
                return;
            }
            log.info("Source file '" + file + "' changed, regenerate site.");
            this.siteManager.build(this.site);
            return;
        }
        catch (NoFrontMatterException e) {
            log.debug("Copy static file: " + file);
            this.copyStaticFile(sourceEntry);
            return;
        }
    }

    private void compassCompile(File siteDir) {
        new Compass(siteDir).compile();
    }

    static boolean directoryContains(File dir, File file) {
        try {
            return FileUtils.directoryContains((File)dir, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static SourceEntry loadSourceEntry(File dir, File file) {
        ArrayList<File> files = new ArrayList<File>();
        File parent = file.getParentFile();
        if (parent == null) {
            throw new IllegalArgumentException("Directory must contains file");
        }
        while (!parent.equals(dir)) {
            files.add(parent);
            parent = parent.getParentFile();
        }
        SourceEntry parentEntry = null;
        if (!files.isEmpty()) {
            Collections.reverse(files);
            Iterator iterator = files.iterator();
            parentEntry = new SourceEntry((File)iterator.next());
            while (iterator.hasNext()) {
                parentEntry = new SourceEntry((FileEntry)parentEntry, (File)iterator.next());
            }
        }
        return new SourceEntry(parentEntry, file);
    }

    private void copyStaticFile(File assets, File file) {
        SourceEntry sourceEntry = Preview.loadSourceEntry(assets, file);
        this.copyStaticFile(sourceEntry);
    }

    private void copyStaticFile(SourceEntry sourceEntry) {
        StaticFileImpl staticFile = new StaticFileImpl(this.site, sourceEntry);
        staticFile.write(this.site.getDestination());
    }

    private boolean isSourceFile(File file) {
        return Preview.directoryContains(this.site.getSource(), file);
    }

    private boolean isAssetFile(File file) {
        if (this.site.getAssets() != null && this.site.getAssets().exists() && this.site.getAssets().isDirectory()) {
            return Preview.directoryContains(this.site.getAssets(), file);
        }
        return false;
    }

    private boolean isTemplateFile(File file) {
        return Preview.directoryContains(this.site.getTemplates(), file);
    }

    private boolean isSassFile(File file) {
        return Preview.directoryContains(this.compassConfig.getSassDirectory(), file);
    }

    private boolean isDraft(Map<String, Object> meta) {
        if (!"post".equals(meta.get("layout"))) {
            return false;
        }
        if (!meta.containsKey("published")) {
            return false;
        }
        Boolean b = (Boolean)meta.get("published");
        return b == false;
    }

    private class M
    extends L {
        private M() {
        }

        @Override
        public void onFileChange(File file) {
            Preview.this.otherSourceFileChanged(file);
        }
    }

    private class L
    extends FileAlterationListenerAdaptor
    implements FileAlterationListener {
        private L() {
        }

        public void onFileCreate(File file) {
            this.onFileChange(file);
        }

        public void onFileDelete(File file) {
            this.onFileChange(file);
        }

        public void onFileChange(File file) {
            Preview.this.handleFileChange(file);
        }
    }
}

