/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.support;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.opoo.press.Site;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
extends Server {
    private static final int MAX_IDLE_TIME = 30000;
    private static final Logger log = LoggerFactory.getLogger(JettyServer.class);

    JettyServer(Site site, int port) {
        this.init(this, site.getDestination().getPath(), site.getRoot(), port);
    }

    JettyServer(String resourceBase, String contextPath, int port) {
        this.init(this, resourceBase, contextPath, port);
    }

    void init(Server server, String resourceBase, String contextPath, int port) {
        server.setStopAtShutdown(false);
        Connector defaultConnector = this.getDefaultConnector(null, port);
        server.setConnectors(new Connector[]{defaultConnector});
        String root = contextPath;
        if ("".equals(root)) {
            ResourceHandler resource_handler = new ResourceHandler();
            resource_handler.setWelcomeFiles(new String[]{"index.html"});
            resource_handler.setResourceBase(resourceBase);
            String base = resource_handler.getResourceBase();
            log.info("Server resource base: " + base);
            HandlerList handlers = new HandlerList();
            handlers.setHandlers(new Handler[]{resource_handler, new DefaultHandler()});
            server.setHandler((Handler)handlers);
            log.info("Starting Jetty on http://localhost:" + port + "/");
        } else {
            log.info("Using " + ContextHandler.class.getName());
            ContextHandler contextHandler = new ContextHandler();
            contextHandler.setContextPath(root);
            contextHandler.setHandler((Handler)new ResourceHandler());
            contextHandler.setResourceBase(resourceBase);
            server.setHandler((Handler)contextHandler);
            log.info("Starting Jetty on http://localhost:" + port + root);
        }
    }

    public void startAndJoin() throws Exception {
        try {
            this.start();
        }
        catch (Exception e) {
            throw new Exception("Error executing Jetty: " + e.getMessage(), e);
        }
        try {
            this.getThreadPool().join();
        }
        catch (InterruptedException e) {
            log.warn("Jetty was interrupted", (Throwable)e);
        }
    }

    RequestLogHandler createRequestLogHandler(Site site) {
        boolean showRequestLog = Boolean.getBoolean("requestLog");
        if (!showRequestLog) {
            return null;
        }
        NCSARequestLog requestLog = new NCSARequestLog();
        requestLog.setLogDateFormat(null);
        RequestLogHandler logHandler = new RequestLogHandler();
        logHandler.setRequestLog((RequestLog)requestLog);
        return logHandler;
    }

    private Connector getDefaultConnector(String host, int port) {
        SelectChannelConnector connector = new SelectChannelConnector();
        if (host != null) {
            connector.setHost(host);
        }
        connector.setPort(port);
        connector.setMaxIdleTime(30000);
        return connector;
    }
}

