/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.support;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.io.FilenameUtils;
import org.jruby.embed.ScriptingContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compass {
    private static final Logger log = LoggerFactory.getLogger(Compass.class);
    private String path;
    private String config;

    public Compass(File site) {
        File configFile = new File(site, "config.rb");
        if (!(site.exists() && site.isDirectory() && configFile.exists())) {
            throw new IllegalArgumentException("Not a valid compass project path: " + site);
        }
        this.path = FilenameUtils.separatorsToUnix((String)site.getAbsolutePath());
        this.config = FilenameUtils.separatorsToUnix((String)configFile.getAbsolutePath());
    }

    public void compile() {
        this.runScriptlet(this.buildCompileScript());
    }

    public void watch() {
        this.runScriptlet(this.buildWatchScript());
    }

    private void runScriptlet(String script) {
        log.debug(script);
        new ScriptingContainer().runScriptlet(script);
    }

    private void buildBasicScript(PrintWriter script) {
        script.println("require 'compass'");
        script.println("frameworks = Dir.new(Compass::Frameworks::DEFAULT_FRAMEWORKS_PATH).path");
        script.println("Compass::Frameworks.register_directory(File.join(frameworks, 'compass'))");
        script.println("Compass::Frameworks.register_directory(File.join(frameworks, 'blueprint'))");
        script.println("Compass.add_project_configuration '" + this.config + "'");
        script.println("Compass.configure_sass_plugin!");
    }

    private String buildCompileScript() {
        StringWriter raw = new StringWriter();
        PrintWriter script = new PrintWriter(raw);
        this.buildBasicScript(script);
        script.println("Dir.chdir('" + this.path + "') do ");
        script.println("  Compass.compiler.run");
        script.println("end");
        script.flush();
        return raw.toString();
    }

    private String buildWatchScript() {
        StringWriter raw = new StringWriter();
        PrintWriter script = new PrintWriter(raw);
        this.buildBasicScript(script);
        script.println("require 'compass/commands'");
        script.println("command = Compass::Commands::WatchProject.new('" + this.path + "', {})");
        script.println("command.perform");
        script.flush();
        return raw.toString();
    }
}

